/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonParserBase;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.DataInput;
import java.io.EOFException;
import java.io.OutputStream;
import java.io.Writer;

public class UTF8DataInputJsonParser
extends JsonParserBase {
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete;
    private int a;
    protected DataInput _inputData;
    protected int _nextByte = -1;

    public UTF8DataInputJsonParser(IOContext iOContext, int n2, DataInput dataInput, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, int n3) {
        super(iOContext, n2, objectCodec);
        this._symbols = byteQuadsCanonicalizer;
        this._inputData = dataInput;
        this._nextByte = n3;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) {
        return 0;
    }

    @Override
    public Object getInputSource() {
        return this._inputData;
    }

    @Override
    protected void _closeInput() {
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        this._symbols.release();
    }

    @Override
    public String getText() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this.d();
            }
            return this._textBuffer.contentsAsString();
        }
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        return uTF8DataInputJsonParser._getText2(uTF8DataInputJsonParser._currToken);
    }

    @Override
    public int getText(Writer writer) {
        Object object = this._currToken;
        if (object == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsToWriter(writer);
        }
        if (object == JsonToken.FIELD_NAME) {
            object = ((JsonStreamContext)this._parsingContext).getCurrentName();
            writer.write((String)object);
            return ((String)object).length();
        }
        if (object != null) {
            if (object.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            object = object.asCharArray();
            writer.write((char[])object);
            return ((JsonToken)object).length;
        }
        return 0;
    }

    @Override
    public String getValueAsString() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this.d();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this.d();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        return super.getValueAsString(string);
    }

    @Override
    public int getValueAsInt() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n2) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(n2);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return ((JsonStreamContext)this._parsingContext).getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public char[] getTextCharacters() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = ((JsonStreamContext)this._parsingContext).getCurrentName();
                        int n2 = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                        } else if (this._nameCopyBuffer.length < n2) {
                            this._nameCopyBuffer = new char[n2];
                        }
                        string.getChars(0, n2, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.size();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return ((JsonStreamContext)this._parsingContext).getCurrentName().length();
        }
        if (this._currToken != null) {
            if (this._currToken.isNumeric()) {
                return this._textBuffer.size();
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
            uTF8DataInputJsonParser._decodeBase64(((JsonParser)uTF8DataInputJsonParser).getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = ((JsonParser)this).getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n2 = this._readBinary(base64Variant, outputStream, byArray);
            return n2;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length - 3;
        int n4 = 0;
        while (true) {
            int n5;
            if ((n5 = this._inputData.readUnsignedByte()) <= 32) {
                continue;
            }
            int n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                if (n5 == 34) break;
                n6 = this._decodeBase64Escape(base64Variant, n5, 0);
                if (n6 < 0) continue;
            }
            if (n2 > n3) {
                n4 += n2;
                outputStream.write(byArray, 0, n2);
                n2 = 0;
            }
            int n7 = n6;
            n5 = this._inputData.readUnsignedByte();
            n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                n6 = this._decodeBase64Escape(base64Variant, n5, 1);
            }
            n7 = n7 << 6 | n6;
            n5 = this._inputData.readUnsignedByte();
            n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                if (n6 != -2) {
                    if (n5 == 34) {
                        byArray[n2++] = (byte)(n7 >>= 4);
                        if (!base64Variant.requiresPaddingOnRead()) break;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n6 = this._decodeBase64Escape(base64Variant, n5, 2);
                }
                if (n6 == -2) {
                    n5 = this._inputData.readUnsignedByte();
                    if (!(base64Variant.usesPaddingChar(n5) || n5 == 92 && this._decodeBase64Escape(base64Variant, n5, 3) == -2)) {
                        throw this.reportInvalidBase64Char(base64Variant, n5, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n2++] = (byte)(n7 >>= 4);
                    continue;
                }
            }
            n7 = n7 << 6 | n6;
            n5 = this._inputData.readUnsignedByte();
            n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                if (n6 != -2) {
                    if (n5 == 34) {
                        byArray[n2++] = (byte)((n7 >>= 2) >> 8);
                        byArray[n2++] = (byte)n7;
                        if (!base64Variant.requiresPaddingOnRead()) break;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n6 = this._decodeBase64Escape(base64Variant, n5, 3);
                }
                if (n6 == -2) {
                    byArray[n2++] = (byte)((n7 >>= 2) >> 8);
                    byArray[n2++] = (byte)n7;
                    continue;
                }
            }
            n7 = n7 << 6 | n6;
            byArray[n2++] = (byte)(n7 >> 16);
            byArray[n2++] = (byte)(n7 >> 8);
            byArray[n2++] = (byte)n7;
        }
        this._tokenIncomplete = false;
        if (n2 > 0) {
            n4 += n2;
            outputStream.write(byArray, 0, n2);
        }
        return n4;
    }

    @Override
    public JsonToken nextToken() {
        JsonToken jsonToken;
        int n2;
        if (this._closed) {
            return null;
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.a();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this.f()) < 0) {
            ((JsonParser)this).close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        this._tokenInputRow = this._currInputRow;
        if ((n2 | 0x20) == 125) {
            this.g(n2);
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n2 = this.e();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 | 0x20) == 125) {
                this.g(n2);
                return this._currToken;
            }
        }
        if (!this._parsingContext.inObject()) {
            return this.a(n2);
        }
        String string = this._parseName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        int n3 = this.g();
        if (n3 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n3) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    jsonToken = this._parsePosNumber();
                    break;
                }
                jsonToken = this._handleUnexpectedValue(n3);
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod(false, false);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parseUnsignedNumber(n3);
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n3);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    private final JsonToken a(int n2) {
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 91: {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildArrayContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildObjectContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this._parseNegNumber();
                return this._currToken;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    this._currToken = this._parsePosNumber();
                    return this._currToken;
                }
                this._currToken = this._handleUnexpectedValue(n2);
                return this._currToken;
            }
            case 46: {
                this._currToken = this._parseFloatThatStartsWithPeriod(false, false);
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parseUnsignedNumber(n2);
                return this._currToken;
            }
        }
        this._currToken = this._handleUnexpectedValue(n2);
        return this._currToken;
    }

    private final JsonToken a() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
            uTF8DataInputJsonParser.createChildArrayContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
            uTF8DataInputJsonParser.createChildObjectContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void finishToken() {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    @Override
    public String nextFieldName() {
        JsonToken jsonToken;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this.a();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        int n2 = this.e();
        this._binaryValue = null;
        this._tokenInputRow = this._currInputRow;
        if ((n2 | 0x20) == 125) {
            this.g(n2);
            return null;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n2 = this.e();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 | 0x20) == 125) {
                this.g(n2);
                return null;
            }
        }
        if (!this._parsingContext.inObject()) {
            this.a(n2);
            return null;
        }
        String string = this._parseName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this.g();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n2) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    jsonToken = this._parsePosNumber();
                    break;
                }
                jsonToken = this._handleUnexpectedValue(n2);
                break;
            }
            case 46: {
                this._parseFloatThatStartsWithPeriod(false, false);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parseUnsignedNumber(n2);
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    @Override
    public String nextTextValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    return this.d();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildArrayContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildObjectContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        if (((JsonParser)this).nextToken() == JsonToken.VALUE_STRING) {
            return ((JsonParser)this).getText();
        }
        return null;
    }

    @Override
    public int nextIntValue(int n2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return ((JsonParser)this).getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildArrayContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildObjectContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return n2;
        }
        if (((JsonParser)this).nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return ((JsonParser)this).getIntValue();
        }
        return n2;
    }

    @Override
    public long nextLongValue(long l2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return ((JsonParser)this).getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildArrayContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildObjectContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return l2;
        }
        if (((JsonParser)this).nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return ((JsonParser)this).getLongValue();
        }
        return l2;
    }

    @Override
    public Boolean nextBooleanValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildArrayContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser.createChildObjectContext(uTF8DataInputJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        JsonToken jsonToken = ((JsonParser)this).nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Deprecated
    protected final JsonToken _parseFloatThatStartsWithPeriod() {
        return this._parseFloatThatStartsWithPeriod(false, false);
    }

    protected final JsonToken _parseFloatThatStartsWithPeriod(boolean bl2, boolean bl3) {
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleUnexpectedValue(46);
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        if (bl2) {
            ++n2;
            cArray[0] = 45;
        }
        return this.a(cArray, n2, 46, bl2, 0);
    }

    protected JsonToken _parseUnsignedNumber(int n2) {
        int n3;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        if (n2 == 48) {
            n2 = this.b();
            if (n2 <= 57 && n2 >= 48) {
                n3 = 0;
            } else {
                if (n2 == 120 || n2 == 88) {
                    return this._handleInvalidNumberStart(n2, false);
                }
                cArray[0] = 48;
                n3 = 1;
            }
        } else {
            cArray[0] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
            n3 = 1;
        }
        int n4 = n3;
        while (n2 <= 57 && n2 >= 48) {
            ++n4;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
        }
        if (n2 == 46 || (n2 | 0x20) == 101) {
            return this.a(cArray, n3, n2, false, n4);
        }
        this._textBuffer.setCurrentLength(n3);
        this._nextByte = n2;
        if (this._parsingContext.inRoot()) {
            this.c();
        }
        return this.resetInt(false, n4);
    }

    protected final JsonToken _parsePosNumber() {
        return this.a(false);
    }

    protected final JsonToken _parseNegNumber() {
        return this.a(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final JsonToken a(boolean bl2) {
        int n2;
        int n3;
        char[] cArray;
        block10: {
            cArray = this._textBuffer.emptyAndGetCurrentSegment();
            n3 = 0;
            if (bl2) {
                cArray[0] = 45;
            }
            n2 = this._inputData.readUnsignedByte();
            int n4 = ++n3;
            ++n3;
            cArray[n4] = (char)n2;
            if (n2 <= 48) {
                if (n2 == 48) {
                    n2 = this.b();
                    break block10;
                } else {
                    if (n2 == 46) {
                        return this._parseFloatThatStartsWithPeriod(bl2, true);
                    }
                    return this._handleInvalidNumberStart(n2, bl2, true);
                }
            }
            if (n2 > 57) {
                return this._handleInvalidNumberStart(n2, bl2, true);
            }
            n2 = this._inputData.readUnsignedByte();
        }
        int n5 = 1;
        while (n2 <= 57 && n2 >= 48) {
            ++n5;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
        }
        if (n2 == 46 || (n2 | 0x20) == 101) {
            return this.a(cArray, n3, n2, bl2, n5);
        }
        this._textBuffer.setCurrentLength(n3);
        this._nextByte = n2;
        if (this._parsingContext.inRoot()) {
            this.c();
        }
        return this.resetInt(bl2, n5);
    }

    private final int b() {
        int n2 = this._inputData.readUnsignedByte();
        if (n2 < 48 || n2 > 57) {
            return n2;
        }
        if ((this._features & FEAT_MASK_LEADING_ZEROS) == 0) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        while (n2 == 48) {
            n2 = this._inputData.readUnsignedByte();
        }
        return n2;
    }

    private final JsonToken a(char[] cArray, int n2, int n3, boolean bl2, int n4) {
        int n5 = 0;
        if (n3 == 46) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
            while ((n3 = this._inputData.readUnsignedByte()) >= 48 && n3 <= 57) {
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
            }
            if (n5 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                this._reportUnexpectedNumberChar(n3, "Decimal point not followed by a digit");
            }
        }
        int n6 = 0;
        if ((n3 | 0x20) == 101) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
            n3 = this._inputData.readUnsignedByte();
            if (n3 == 45 || n3 == 43) {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                n3 = this._inputData.readUnsignedByte();
            }
            while (n3 <= 57 && n3 >= 48) {
                ++n6;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                n3 = this._inputData.readUnsignedByte();
            }
            if (n6 == 0) {
                this._reportUnexpectedNumberChar(n3, "Exponent indicator not followed by a digit");
            }
        }
        this._nextByte = n3;
        if (this._parsingContext.inRoot()) {
            this.c();
        }
        this._textBuffer.setCurrentLength(n2);
        return this.resetFloat(bl2, n4, n5, n6);
    }

    private final void c() {
        int n2 = this._nextByte;
        if (n2 <= 32) {
            this._nextByte = -1;
            if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            return;
        }
        this._reportMissingRootWS(n2);
    }

    protected final String _parseName(int n2) {
        if (n2 != 34) {
            return this._handleOddName(n2);
        }
        int[] nArray = INPUT_CODES_LATIN1;
        int n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] == 0) {
            n2 = this._inputData.readUnsignedByte();
            if (nArray[n2] == 0) {
                n3 = n3 << 8 | n2;
                n2 = this._inputData.readUnsignedByte();
                if (nArray[n2] == 0) {
                    n3 = n3 << 8 | n2;
                    n2 = this._inputData.readUnsignedByte();
                    if (nArray[n2] == 0) {
                        n3 = n3 << 8 | n2;
                        n2 = this._inputData.readUnsignedByte();
                        if (nArray[n2] == 0) {
                            this.a = n3;
                            int n4 = n2;
                            UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                            int[] nArray2 = INPUT_CODES_LATIN1;
                            int n5 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                            if (nArray2[n5] != 0) {
                                if (n5 == 34) {
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser2 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser2.b(uTF8DataInputJsonParser2.a, n4, 1);
                                }
                                UTF8DataInputJsonParser uTF8DataInputJsonParser3 = uTF8DataInputJsonParser;
                                return uTF8DataInputJsonParser3.a(uTF8DataInputJsonParser3.a, n4, n5, 1);
                            }
                            n4 = n4 << 8 | n5;
                            n5 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                            if (nArray2[n5] != 0) {
                                if (n5 == 34) {
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser4 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser4.b(uTF8DataInputJsonParser4.a, n4, 2);
                                }
                                UTF8DataInputJsonParser uTF8DataInputJsonParser5 = uTF8DataInputJsonParser;
                                return uTF8DataInputJsonParser5.a(uTF8DataInputJsonParser5.a, n4, n5, 2);
                            }
                            n4 = n4 << 8 | n5;
                            n5 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                            if (nArray2[n5] != 0) {
                                if (n5 == 34) {
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser6 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser6.b(uTF8DataInputJsonParser6.a, n4, 3);
                                }
                                UTF8DataInputJsonParser uTF8DataInputJsonParser7 = uTF8DataInputJsonParser;
                                return uTF8DataInputJsonParser7.a(uTF8DataInputJsonParser7.a, n4, n5, 3);
                            }
                            n4 = n4 << 8 | n5;
                            n5 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                            if (nArray2[n5] != 0) {
                                if (n5 == 34) {
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser8 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser8.b(uTF8DataInputJsonParser8.a, n4, 4);
                                }
                                UTF8DataInputJsonParser uTF8DataInputJsonParser9 = uTF8DataInputJsonParser;
                                return uTF8DataInputJsonParser9.a(uTF8DataInputJsonParser9.a, n4, n5, 4);
                            }
                            int n6 = n4;
                            n4 = n5;
                            int[] nArray3 = INPUT_CODES_LATIN1;
                            int n7 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                            if (nArray3[n7] != 0) {
                                if (n7 == 34) {
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser10 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser10.b(uTF8DataInputJsonParser10.a, n6, n4, 1);
                                }
                                UTF8DataInputJsonParser uTF8DataInputJsonParser11 = uTF8DataInputJsonParser;
                                return uTF8DataInputJsonParser11.a(uTF8DataInputJsonParser11.a, n6, n4, n7, 1);
                            }
                            n4 = n4 << 8 | n7;
                            n7 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                            if (nArray3[n7] != 0) {
                                if (n7 == 34) {
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser12 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser12.b(uTF8DataInputJsonParser12.a, n6, n4, 2);
                                }
                                UTF8DataInputJsonParser uTF8DataInputJsonParser13 = uTF8DataInputJsonParser;
                                return uTF8DataInputJsonParser13.a(uTF8DataInputJsonParser13.a, n6, n4, n7, 2);
                            }
                            n4 = n4 << 8 | n7;
                            n7 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                            if (nArray3[n7] != 0) {
                                if (n7 == 34) {
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser14 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser14.b(uTF8DataInputJsonParser14.a, n6, n4, 3);
                                }
                                UTF8DataInputJsonParser uTF8DataInputJsonParser15 = uTF8DataInputJsonParser;
                                return uTF8DataInputJsonParser15.a(uTF8DataInputJsonParser15.a, n6, n4, n7, 3);
                            }
                            n4 = n4 << 8 | n7;
                            n7 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                            if (nArray3[n7] != 0) {
                                if (n7 == 34) {
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser16 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser16.b(uTF8DataInputJsonParser16.a, n6, n4, 4);
                                }
                                UTF8DataInputJsonParser uTF8DataInputJsonParser17 = uTF8DataInputJsonParser;
                                return uTF8DataInputJsonParser17.a(uTF8DataInputJsonParser17.a, n6, n4, n7, 4);
                            }
                            int n8 = n4;
                            n4 = n7;
                            uTF8DataInputJsonParser._quadBuffer[0] = uTF8DataInputJsonParser.a;
                            uTF8DataInputJsonParser._quadBuffer[1] = n6;
                            uTF8DataInputJsonParser._quadBuffer[2] = n8;
                            int[] nArray4 = INPUT_CODES_LATIN1;
                            n8 = 3;
                            while (true) {
                                if (nArray4[n7 = uTF8DataInputJsonParser._inputData.readUnsignedByte()] != 0) {
                                    if (n7 == 34) {
                                        UTF8DataInputJsonParser uTF8DataInputJsonParser18 = uTF8DataInputJsonParser;
                                        return uTF8DataInputJsonParser18.a(uTF8DataInputJsonParser18._quadBuffer, n8, n4, 1);
                                    }
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser19 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser19.parseEscapedName(uTF8DataInputJsonParser19._quadBuffer, n8, n4, n7, 1);
                                }
                                n4 = n4 << 8 | n7;
                                n7 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                                if (nArray4[n7] != 0) {
                                    if (n7 == 34) {
                                        UTF8DataInputJsonParser uTF8DataInputJsonParser20 = uTF8DataInputJsonParser;
                                        return uTF8DataInputJsonParser20.a(uTF8DataInputJsonParser20._quadBuffer, n8, n4, 2);
                                    }
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser21 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser21.parseEscapedName(uTF8DataInputJsonParser21._quadBuffer, n8, n4, n7, 2);
                                }
                                n4 = n4 << 8 | n7;
                                n7 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                                if (nArray4[n7] != 0) {
                                    if (n7 == 34) {
                                        UTF8DataInputJsonParser uTF8DataInputJsonParser22 = uTF8DataInputJsonParser;
                                        return uTF8DataInputJsonParser22.a(uTF8DataInputJsonParser22._quadBuffer, n8, n4, 3);
                                    }
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser23 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser23.parseEscapedName(uTF8DataInputJsonParser23._quadBuffer, n8, n4, n7, 3);
                                }
                                n4 = n4 << 8 | n7;
                                n7 = uTF8DataInputJsonParser._inputData.readUnsignedByte();
                                if (nArray4[n7] != 0) {
                                    if (n7 == 34) {
                                        UTF8DataInputJsonParser uTF8DataInputJsonParser24 = uTF8DataInputJsonParser;
                                        return uTF8DataInputJsonParser24.a(uTF8DataInputJsonParser24._quadBuffer, n8, n4, 4);
                                    }
                                    UTF8DataInputJsonParser uTF8DataInputJsonParser25 = uTF8DataInputJsonParser;
                                    return uTF8DataInputJsonParser25.parseEscapedName(uTF8DataInputJsonParser25._quadBuffer, n8, n4, n7, 4);
                                }
                                if (n8 >= uTF8DataInputJsonParser._quadBuffer.length) {
                                    uTF8DataInputJsonParser._quadBuffer = UTF8DataInputJsonParser.growArrayBy(uTF8DataInputJsonParser._quadBuffer, n8);
                                }
                                uTF8DataInputJsonParser._quadBuffer[n8++] = n4;
                                n4 = n7;
                            }
                        }
                        if (n2 == 34) {
                            return this.a(n3, 4);
                        }
                        return this.a(n3, n2, 4);
                    }
                    if (n2 == 34) {
                        return this.a(n3, 3);
                    }
                    return this.a(n3, n2, 3);
                }
                if (n2 == 34) {
                    return this.a(n3, 2);
                }
                return this.a(n3, n2, 2);
            }
            if (n2 == 34) {
                return this.a(n3, 1);
            }
            return this.a(n3, n2, 1);
        }
        if (n3 == 34) {
            return "";
        }
        return this.a(0, n3, 0);
    }

    private final String a(int n2, int n3, int n4) {
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        return uTF8DataInputJsonParser.parseEscapedName(uTF8DataInputJsonParser._quadBuffer, 0, n2, n3, n4);
    }

    private final String a(int n2, int n3, int n4, int n5) {
        this._quadBuffer[0] = n2;
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        return uTF8DataInputJsonParser.parseEscapedName(uTF8DataInputJsonParser._quadBuffer, 1, n3, n4, n5);
    }

    private final String a(int n2, int n3, int n4, int n5, int n6) {
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        return uTF8DataInputJsonParser.parseEscapedName(uTF8DataInputJsonParser._quadBuffer, 2, n4, n5, n6);
    }

    protected final String parseEscapedName(int[] nArray, int n2, int n3, int n4, int n5) {
        String string;
        int[] nArray2 = INPUT_CODES_LATIN1;
        while (true) {
            if (nArray2[n4] != 0) {
                if (n4 == 34) break;
                if (n4 != 92) {
                    this._throwUnquotedSpace(n4, "name");
                } else {
                    n4 = this._decodeEscaped();
                }
                if (n4 > 127) {
                    if (n5 >= 4) {
                        if (n2 >= nArray.length) {
                            nArray = UTF8DataInputJsonParser.growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n5 = 0;
                    }
                    if (n4 < 2048) {
                        n3 = n3 << 8 | (0xC0 | n4 >> 6);
                        ++n5;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n4 >> 12);
                        if (++n5 >= 4) {
                            if (n2 >= nArray.length) {
                                nArray = UTF8DataInputJsonParser.growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n5 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n4 >> 6 & 0x3F);
                        ++n5;
                    }
                    n4 = 0x80 | n4 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n3 = n3 << 8 | n4;
            } else {
                if (n2 >= nArray.length) {
                    nArray = UTF8DataInputJsonParser.growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n2++] = n3;
                n3 = n4;
                n5 = 1;
            }
            n4 = this._inputData.readUnsignedByte();
        }
        if (n5 > 0) {
            if (n2 >= nArray.length) {
                nArray = UTF8DataInputJsonParser.growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n2++] = UTF8DataInputJsonParser.b(n3, n5);
        }
        if ((string = this._symbols.findName(nArray, n2)) == null) {
            string = this.a(nArray, n2, n5);
        }
        return string;
    }

    protected String _handleOddName(int n2) {
        String string;
        int[] nArray;
        if (n2 == 39 && (this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
            return this._parseAposName();
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            char c2 = (char)this._decodeCharForError(n2);
            this._reportUnexpectedChar(c2, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n2] != 0) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        do {
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
                continue;
            }
            if (n3 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8DataInputJsonParser.growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n3++] = n4;
            n4 = n2;
            n5 = 1;
        } while (nArray[n2 = this._inputData.readUnsignedByte()] == 0);
        this._nextByte = n2;
        if (n5 > 0) {
            if (n3 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8DataInputJsonParser.growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n3++] = n4;
        }
        if ((string = this._symbols.findName(nArray2, n3)) == null) {
            string = this.a(nArray2, n3, n5);
        }
        return string;
    }

    protected String _parseAposName() {
        String string;
        int n2 = this._inputData.readUnsignedByte();
        if (n2 == 39) {
            return "";
        }
        int[] nArray = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray2 = INPUT_CODES_LATIN1;
        while (n2 != 39) {
            if (n2 != 34 && nArray2[n2] != 0) {
                if (n2 != 92) {
                    this._throwUnquotedSpace(n2, "name");
                } else {
                    n2 = this._decodeEscaped();
                }
                if (n2 > 127) {
                    if (n5 >= 4) {
                        if (n3 >= nArray.length) {
                            this._quadBuffer = nArray = UTF8DataInputJsonParser.growArrayBy(nArray, nArray.length);
                        }
                        nArray[n3++] = n4;
                        n4 = 0;
                        n5 = 0;
                    }
                    if (n2 < 2048) {
                        n4 = n4 << 8 | (0xC0 | n2 >> 6);
                        ++n5;
                    } else {
                        n4 = n4 << 8 | (0xE0 | n2 >> 12);
                        if (++n5 >= 4) {
                            if (n3 >= nArray.length) {
                                this._quadBuffer = nArray = UTF8DataInputJsonParser.growArrayBy(nArray, nArray.length);
                            }
                            nArray[n3++] = n4;
                            n4 = 0;
                            n5 = 0;
                        }
                        n4 = n4 << 8 | (0x80 | n2 >> 6 & 0x3F);
                        ++n5;
                    }
                    n2 = 0x80 | n2 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
            } else {
                if (n3 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8DataInputJsonParser.growArrayBy(nArray, nArray.length);
                }
                nArray[n3++] = n4;
                n4 = n2;
                n5 = 1;
            }
            n2 = this._inputData.readUnsignedByte();
        }
        if (n5 > 0) {
            if (n3 >= nArray.length) {
                this._quadBuffer = nArray = UTF8DataInputJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n3++] = UTF8DataInputJsonParser.b(n4, n5);
        }
        if ((string = this._symbols.findName(nArray, n3)) == null) {
            string = this.a(nArray, n3, n5);
        }
        return string;
    }

    private final String a(int n2, int n3) {
        String string = this._symbols.findName(n2 = UTF8DataInputJsonParser.b(n2, n3));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n2;
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        return uTF8DataInputJsonParser.a(uTF8DataInputJsonParser._quadBuffer, 1, n3);
    }

    private final String b(int n2, int n3, int n4) {
        String string = this._symbols.findName(n2, n3 = UTF8DataInputJsonParser.b(n3, n4));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        return uTF8DataInputJsonParser.a(uTF8DataInputJsonParser._quadBuffer, 2, n4);
    }

    private final String b(int n2, int n3, int n4, int n5) {
        Object object = this._symbols.findName(n2, n3, n4 = UTF8DataInputJsonParser.b(n4, n5));
        if (object != null) {
            return object;
        }
        object = this._quadBuffer;
        this._quadBuffer[0] = n2;
        object[1] = n3;
        object[2] = UTF8DataInputJsonParser.b(n4, n5);
        return this.a((int[])object, 3, n5);
    }

    private final String a(int[] nArray, int n2, int n3, int n4) {
        if (n2 >= nArray.length) {
            nArray = UTF8DataInputJsonParser.growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n2++] = UTF8DataInputJsonParser.b(n3, n4);
        String string = this._symbols.findName(nArray, n2);
        if (string == null) {
            return this.a(nArray, n2, n4);
        }
        return string;
    }

    private final String a(int[] nArray, int n2, int n3) {
        int n4;
        int n5 = (n2 << 2) - 4 + n3;
        if (n3 < 4) {
            n4 = nArray[n2 - 1];
            nArray[n2 - 1] = n4 << (4 - n3 << 3);
        } else {
            n4 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            int n8 = nArray[n7 >> 2];
            int n9 = n7 & 3;
            n8 = n8 >> (3 - n9 << 3) & 0xFF;
            ++n7;
            if (n8 > 127) {
                int n10;
                if ((n8 & 0xE0) == 192) {
                    n8 &= 0x1F;
                    n10 = 1;
                } else if ((n8 & 0xF0) == 224) {
                    n8 &= 0xF;
                    n10 = 2;
                } else if ((n8 & 0xF8) == 240) {
                    n8 &= 7;
                    n10 = 3;
                } else {
                    this._reportInvalidInitial(n8);
                    n8 = 1;
                    n10 = 1;
                }
                if (n7 + n10 > n5) {
                    this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
                }
                int n11 = nArray[n7 >> 2];
                n9 = n7 & 3;
                ++n7;
                if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                    this.f(n11);
                }
                n8 = n8 << 6 | n11 & 0x3F;
                if (n10 > 1) {
                    n11 = nArray[n7 >> 2];
                    n9 = n7 & 3;
                    ++n7;
                    if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                        this.f(n11);
                    }
                    n8 = n8 << 6 | n11 & 0x3F;
                    if (n10 > 2) {
                        n11 = nArray[n7 >> 2];
                        n9 = n7 & 3;
                        ++n7;
                        if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                            this.f(n11 & 0xFF);
                        }
                        n8 = n8 << 6 | n11 & 0x3F;
                    }
                }
                if (n10 > 2) {
                    n8 -= 65536;
                    if (n6 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n6++] = (char)(55296 + (n8 >> 10));
                    n8 = 0xDC00 | n8 & 0x3FF;
                }
            }
            if (n6 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n6++] = (char)n8;
        }
        String string = new String(cArray, 0, n6);
        if (!this._symbols.isCanonicalizing()) {
            return string;
        }
        if (n3 < 4) {
            nArray[n2 - 1] = n4;
        }
        return this._symbols.addName(string, nArray, n2);
    }

    @Override
    protected void _finishString() {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = INPUT_CODES_UTF8;
        int n3 = cArray.length;
        do {
            int n4;
            if (nArray[n4 = this._inputData.readUnsignedByte()] != 0) {
                if (n4 == 34) {
                    this._textBuffer.setCurrentLength(n2);
                    return;
                }
                this.a(cArray, n2, n4);
                return;
            }
            cArray[n2++] = (char)n4;
        } while (n2 < n3);
        this.a(cArray, n2, this._inputData.readUnsignedByte());
    }

    private String d() {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = INPUT_CODES_UTF8;
        int n3 = cArray.length;
        do {
            int n4;
            if (nArray[n4 = this._inputData.readUnsignedByte()] != 0) {
                if (n4 == 34) {
                    return this._textBuffer.setCurrentAndReturn(n2);
                }
                this.a(cArray, n2, n4);
                return this._textBuffer.contentsAsString();
            }
            cArray[n2++] = (char)n4;
        } while (n2 < n3);
        this.a(cArray, n2, this._inputData.readUnsignedByte());
        return this._textBuffer.contentsAsString();
    }

    private final void a(char[] cArray, int n2, int n3) {
        int[] nArray = INPUT_CODES_UTF8;
        int n4 = cArray.length;
        while (true) {
            if (nArray[n3] == 0) {
                if (n2 >= n4) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                    n4 = cArray.length;
                }
                cArray[n2++] = (char)n3;
                n3 = this._inputData.readUnsignedByte();
                continue;
            }
            if (n3 == 34) break;
            switch (nArray[n3]) {
                case 1: {
                    n3 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n3 = this.c(n3);
                    break;
                }
                case 3: {
                    n3 = this.d(n3);
                    break;
                }
                case 4: {
                    n3 = this.e(n3);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                        n4 = cArray.length;
                    }
                    cArray[n2++] = (char)(0xD800 | n3 >> 10);
                    n3 = 0xDC00 | n3 & 0x3FF;
                    break;
                }
                default: {
                    if (n3 < 32) {
                        this._throwUnquotedSpace(n3, "string value");
                        break;
                    }
                    this._reportInvalidChar(n3);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
                n4 = cArray.length;
            }
            cArray[n2++] = (char)n3;
            n3 = this._inputData.readUnsignedByte();
        }
        this._textBuffer.setCurrentLength(n2);
    }

    protected void _skipString() {
        this._tokenIncomplete = false;
        int[] nArray = INPUT_CODES_UTF8;
        block6: while (true) {
            int n2;
            if (nArray[n2 = this._inputData.readUnsignedByte()] == 0) {
                continue;
            }
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this.l();
                    continue block6;
                }
                case 3: {
                    this.m();
                    continue block6;
                }
                case 4: {
                    this.n();
                    continue block6;
                }
            }
            if (n2 < 32) {
                this._throwUnquotedSpace(n2, "string value");
                continue;
            }
            this._reportInvalidChar(n2);
        }
    }

    protected JsonToken _handleUnexpectedValue(int n2) {
        switch (n2) {
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (!this._parsingContext.inRoot() && (this._features & FEAT_MASK_ALLOW_MISSING) != 0) {
                    this._nextByte = n2;
                    return JsonToken.VALUE_NULL;
                }
            }
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 39: {
                if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) == 0) break;
                return this._handleApos();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break;
            }
            case 43: {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                return uTF8DataInputJsonParser._handleInvalidNumberStart(uTF8DataInputJsonParser._inputData.readUnsignedByte(), false, true);
            }
        }
        if (Character.isJavaIdentifierStart(n2)) {
            this._reportInvalidToken(n2, "" + (char)n2, this._validJsonTokenList());
        }
        this._reportUnexpectedChar(n2, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    protected JsonToken _handleApos() {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = INPUT_CODES_UTF8;
        block6: while (true) {
            int n3;
            int n4 = cArray.length;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
                n4 = cArray.length;
            }
            while ((n3 = this._inputData.readUnsignedByte()) != 39) {
                if (nArray[n3] == 0 || n3 == 34) {
                    cArray[n2++] = (char)n3;
                    if (n2 < n4) continue;
                    continue block6;
                }
                switch (nArray[n3]) {
                    case 1: {
                        n3 = this._decodeEscaped();
                        break;
                    }
                    case 2: {
                        n3 = this.c(n3);
                        break;
                    }
                    case 3: {
                        n3 = this.d(n3);
                        break;
                    }
                    case 4: {
                        n3 = this.e(n3);
                        cArray[n2++] = (char)(0xD800 | n3 >> 10);
                        if (n2 >= cArray.length) {
                            cArray = this._textBuffer.finishCurrentSegment();
                            n2 = 0;
                        }
                        n3 = 0xDC00 | n3 & 0x3FF;
                        break;
                    }
                    default: {
                        if (n3 < 32) {
                            this._throwUnquotedSpace(n3, "string value");
                        }
                        this._reportInvalidChar(n3);
                    }
                }
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                continue block6;
            }
            break;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2) {
        return this._handleInvalidNumberStart(n2, bl2, false);
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2, boolean bl3) {
        String string;
        while (n2 == 73) {
            n2 = this._inputData.readUnsignedByte();
            if (n2 == 78) {
                string = bl2 ? "-INF" : "+INF";
            } else {
                if (n2 != 110) break;
                string = bl2 ? "-Infinity" : "+Infinity";
            }
            this._matchToken(string, 3);
            if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                return this.resetAsNaN(string, bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            this._reportError("Non-standard token '" + string + "': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
        }
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()) && bl3 && !bl2) {
            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
        }
        string = bl2 ? "expected digit (0-9) to follow minus sign, for valid numeric value" : "expected digit (0-9) for valid numeric value";
        this._reportUnexpectedNumberChar(n2, string);
        return null;
    }

    protected final void _matchToken(String object, int n2) {
        int n3;
        int n4 = ((String)object).length();
        do {
            if ((n3 = this._inputData.readUnsignedByte()) == ((String)object).charAt(n2)) continue;
            this._reportInvalidToken(n3, ((String)object).substring(0, n2));
        } while (++n2 < n4);
        n3 = this._inputData.readUnsignedByte();
        if (n3 >= 48 && n3 != 93 && n3 != 125) {
            int n5 = n3;
            n4 = n2;
            String string = object;
            object = this;
            char c2 = (char)((UTF8DataInputJsonParser)object)._decodeCharForError(n5);
            n5 = c2;
            if (Character.isJavaIdentifierPart(c2)) {
                ((UTF8DataInputJsonParser)object)._reportInvalidToken(n5, string.substring(0, n4));
            }
        }
        this._nextByte = n3;
    }

    private final int e() {
        int n2 = this._nextByte;
        if (n2 < 0) {
            n2 = this._inputData.readUnsignedByte();
        } else {
            this._nextByte = -1;
        }
        while (true) {
            if (n2 > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this.b(n2);
                }
                return n2;
            }
            if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final int f() {
        int n2 = this._nextByte;
        if (n2 < 0) {
            try {
                n2 = this._inputData.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                return this._eofAsNextChar();
            }
        } else {
            this._nextByte = -1;
        }
        while (true) {
            if (n2 > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this.b(n2);
                }
                return n2;
            }
            if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            try {
                n2 = this._inputData.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                return this._eofAsNextChar();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int b(int n2) {
        while (true) {
            if (n2 > 32) {
                if (n2 == 47) {
                    this.h();
                } else {
                    if (n2 != 35) return n2;
                    if (!this.j()) {
                        return n2;
                    }
                }
            } else if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final int g() {
        int n2 = this._nextByte;
        if (n2 < 0) {
            n2 = this._inputData.readUnsignedByte();
        } else {
            this._nextByte = -1;
        }
        if (n2 == 58) {
            n2 = this._inputData.readUnsignedByte();
            if (n2 > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this.a(n2, true);
                }
                return n2;
            }
            if ((n2 == 32 || n2 == 9) && (n2 = this._inputData.readUnsignedByte()) > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this.a(n2, true);
                }
                return n2;
            }
            return this.a(n2, true);
        }
        if (n2 == 32 || n2 == 9) {
            n2 = this._inputData.readUnsignedByte();
        }
        if (n2 == 58) {
            n2 = this._inputData.readUnsignedByte();
            if (n2 > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this.a(n2, true);
                }
                return n2;
            }
            if ((n2 == 32 || n2 == 9) && (n2 = this._inputData.readUnsignedByte()) > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this.a(n2, true);
                }
                return n2;
            }
            return this.a(n2, true);
        }
        return this.a(n2, false);
    }

    private final int a(int n2, boolean bl2) {
        while (true) {
            if (n2 > 32) {
                if (n2 == 47) {
                    this.h();
                } else if (n2 != 35 || !this.j()) {
                    if (bl2) {
                        return n2;
                    }
                    if (n2 != 58) {
                        this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
                    }
                    bl2 = true;
                }
            } else if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final void h() {
        int n2;
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if ((n2 = this._inputData.readUnsignedByte()) == 47) {
            this.k();
            return;
        }
        if (n2 == 42) {
            this.i();
            return;
        }
        this._reportUnexpectedChar(n2, "was expecting either '*' or '/' for a comment");
    }

    private final void i() {
        int[] nArray = CharTypes.getInputCodeComment();
        int n2 = this._inputData.readUnsignedByte();
        block7: while (true) {
            int n3;
            if ((n3 = nArray[n2]) != 0) {
                switch (n3) {
                    case 42: {
                        n2 = this._inputData.readUnsignedByte();
                        if (n2 != 47) continue block7;
                        return;
                    }
                    case 10: 
                    case 13: {
                        ++this._currInputRow;
                        break;
                    }
                    case 2: {
                        this.l();
                        break;
                    }
                    case 3: {
                        this.m();
                        break;
                    }
                    case 4: {
                        this.n();
                        break;
                    }
                    default: {
                        this._reportInvalidChar(n2);
                    }
                }
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final boolean j() {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            return false;
        }
        this.k();
        return true;
    }

    private final void k() {
        int[] nArray = CharTypes.getInputCodeComment();
        block7: while (true) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputData.readUnsignedByte()]) == 0) {
                continue;
            }
            switch (n3) {
                case 10: 
                case 13: {
                    ++this._currInputRow;
                    return;
                }
                case 42: {
                    continue block7;
                }
                case 2: {
                    this.l();
                    continue block7;
                }
                case 3: {
                    this.m();
                    continue block7;
                }
                case 4: {
                    this.n();
                    continue block7;
                }
            }
            if (n3 >= 0) continue;
            this._reportInvalidChar(n2);
        }
    }

    @Override
    protected char _decodeEscaped() {
        int n2 = this._inputData.readUnsignedByte();
        switch (n2) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)n2;
            }
            case 117: {
                break;
            }
            default: {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                return uTF8DataInputJsonParser._handleUnrecognizedCharacterEscape((char)uTF8DataInputJsonParser._decodeCharForError(n2));
            }
        }
        n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = this._inputData.readUnsignedByte();
            int n4 = CharTypes.charToHex(n3);
            if (n4 < 0) {
                this._reportUnexpectedChar(n3, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n4;
        }
        return (char)n2;
    }

    protected int _decodeCharForError(int n2) {
        if ((n2 &= 0xFF) > 127) {
            int n3;
            if ((n2 & 0xE0) == 192) {
                n2 &= 0x1F;
                n3 = 1;
            } else if ((n2 & 0xF0) == 224) {
                n2 &= 0xF;
                n3 = 2;
            } else if ((n2 & 0xF8) == 240) {
                n2 &= 7;
                n3 = 3;
            } else {
                this._reportInvalidInitial(n2 & 0xFF);
                n3 = 1;
            }
            int n4 = this._inputData.readUnsignedByte();
            if ((n4 & 0xC0) != 128) {
                this.f(n4 & 0xFF);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (n3 > 1) {
                n4 = this._inputData.readUnsignedByte();
                if ((n4 & 0xC0) != 128) {
                    this.f(n4 & 0xFF);
                }
                n2 = n2 << 6 | n4 & 0x3F;
                if (n3 > 2) {
                    n4 = this._inputData.readUnsignedByte();
                    if ((n4 & 0xC0) != 128) {
                        this.f(n4 & 0xFF);
                    }
                    n2 = n2 << 6 | n4 & 0x3F;
                }
            }
        }
        return n2;
    }

    private final int c(int n2) {
        int n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this.f(n3 & 0xFF);
        }
        return (n2 & 0x1F) << 6 | n3 & 0x3F;
    }

    private final int d(int n2) {
        n2 &= 0xF;
        int n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this.f(n3 & 0xFF);
        }
        n2 = n2 << 6 | n3 & 0x3F;
        n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this.f(n3 & 0xFF);
        }
        n2 = n2 << 6 | n3 & 0x3F;
        return n2;
    }

    private final int e(int n2) {
        int n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this.f(n3 & 0xFF);
        }
        n2 = (n2 & 7) << 6 | n3 & 0x3F;
        n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this.f(n3 & 0xFF);
        }
        n2 = n2 << 6 | n3 & 0x3F;
        n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this.f(n3 & 0xFF);
        }
        return (n2 << 6 | n3 & 0x3F) - 65536;
    }

    private final void l() {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this.f(n2 & 0xFF);
        }
    }

    private final void m() {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this.f(n2 & 0xFF);
        }
        if (((n2 = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this.f(n2 & 0xFF);
        }
    }

    private final void n() {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this.f(n2 & 0xFF);
        }
        if (((n2 = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this.f(n2 & 0xFF);
        }
        if (((n2 = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this.f(n2 & 0xFF);
        }
    }

    protected void _reportInvalidToken(int n2, String string) {
        this._reportInvalidToken(n2, string, this._validJsonTokenList());
    }

    protected void _reportInvalidToken(int n2, String charSequence, String string) {
        charSequence = new StringBuilder((String)charSequence);
        while (true) {
            char c2 = (char)this._decodeCharForError(n2);
            n2 = c2;
            if (!Character.isJavaIdentifierPart(c2)) break;
            ((StringBuilder)charSequence).append((char)n2);
            n2 = this._inputData.readUnsignedByte();
        }
        this._reportError("Unrecognized token '" + ((StringBuilder)charSequence).toString() + "': was expecting " + string);
    }

    protected void _reportInvalidChar(int n2) {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    protected void _reportInvalidInitial(int n2) {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    private void f(int n2) {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }

    protected final byte[] _decodeBase64(Base64Variant base64Variant) {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n2;
            if ((n2 = this._inputData.readUnsignedByte()) <= 32) {
                continue;
            }
            int n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                if (n2 == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n3 = this._decodeBase64Escape(base64Variant, n2, 0);
                if (n3 < 0) continue;
            }
            int n4 = n3;
            n2 = this._inputData.readUnsignedByte();
            n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                n3 = this._decodeBase64Escape(base64Variant, n2, 1);
            }
            n4 = n4 << 6 | n3;
            n2 = this._inputData.readUnsignedByte();
            n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                if (n3 != -2) {
                    if (n2 == 34) {
                        byteArrayBuilder.append(n4 >>= 4);
                        if (base64Variant.requiresPaddingOnRead()) {
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 2);
                }
                if (n3 == -2) {
                    n2 = this._inputData.readUnsignedByte();
                    if (!(base64Variant.usesPaddingChar(n2) || n2 == 92 && this._decodeBase64Escape(base64Variant, n2, 3) == -2)) {
                        throw this.reportInvalidBase64Char(base64Variant, n2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n4 >>= 4);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            n2 = this._inputData.readUnsignedByte();
            n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                if (n3 != -2) {
                    if (n2 == 34) {
                        byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                        if (base64Variant.requiresPaddingOnRead()) {
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 3);
                }
                if (n3 == -2) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
    }

    @Override
    public JsonLocation currentLocation() {
        return new JsonLocation(this._contentReference(), -1L, -1L, this._currInputRow, -1);
    }

    @Override
    protected JsonLocation _currentLocationMinusOne() {
        return ((JsonParser)this).currentLocation();
    }

    @Override
    public JsonLocation currentTokenLocation() {
        return new JsonLocation(this._contentReference(), -1L, -1L, this._tokenInputRow, -1);
    }

    private void g(int n2) {
        if (n2 == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n2, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        if (n2 == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n2, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
        }
    }

    private static final int b(int n2, int n3) {
        if (n3 == 4) {
            return n2;
        }
        return n2 | -1 << (n3 << 3);
    }
}

