/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberOutput;
import com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class UTF8JsonGenerator
extends JsonGeneratorImpl {
    private static final byte[] a = CharTypes.copyHexBytes(true);
    private static final byte[] b = CharTypes.copyHexBytes(false);
    private static final byte[] c = new byte[]{110, 117, 108, 108};
    private static final byte[] d = new byte[]{116, 114, 117, 101};
    private static final byte[] e = new byte[]{102, 97, 108, 115, 101};
    protected final OutputStream _outputStream;
    protected byte _quoteChar;
    protected byte[] _outputBuffer;
    protected int _outputTail;
    protected final int _outputEnd;
    protected final int _outputMaxContiguous;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected byte[] _entityBuffer;
    protected boolean _bufferRecyclable;

    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, char c2) {
        super(iOContext, n2, objectCodec);
        this._outputStream = outputStream;
        this._quoteChar = (byte)c2;
        n2 = ((JsonGenerator)this).isEnabled(JsonWriteFeature.ESCAPE_FORWARD_SLASHES.mappedFeature()) ? 1 : 0;
        if (c2 != '\"' || n2 != 0) {
            this._outputEscapes = CharTypes.get7BitOutputEscapes(c2, n2 != 0);
        }
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (((JsonGenerator)this).isEnabled(JsonGenerator.Feature.ESCAPE_NON_ASCII)) {
            ((JsonGenerator)this).setHighestNonEscapedChar(127);
        }
    }

    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, char c2, byte[] byArray, int n3, boolean bl2) {
        super(iOContext, n2, objectCodec);
        this._outputStream = outputStream;
        this._quoteChar = (byte)c2;
        n2 = ((JsonGenerator)this).isEnabled(JsonWriteFeature.ESCAPE_FORWARD_SLASHES.mappedFeature()) ? 1 : 0;
        if (c2 != '\"' || n2 != 0) {
            this._outputEscapes = CharTypes.get7BitOutputEscapes(c2, n2 != 0);
        }
        this._bufferRecyclable = bl2;
        this._outputTail = n3;
        this._outputBuffer = byArray;
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
    }

    @Deprecated
    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream) {
        this(iOContext, n2, objectCodec, outputStream, '\"');
    }

    @Deprecated
    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, byte[] byArray, int n3, boolean bl2) {
        this(iOContext, n2, objectCodec, outputStream, '\"', byArray, n3, bl2);
    }

    @Override
    public Object getOutputTarget() {
        return this._outputStream;
    }

    @Override
    public int getOutputBuffered() {
        return this._outputTail;
    }

    @Override
    public void writeFieldName(String object) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName((String)object);
            return;
        }
        int n2 = this._writeContext.writeFieldName((String)object);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this.a((String)object, false);
            return;
        }
        n2 = ((String)object).length();
        if (n2 > this._charBufferLength) {
            this.a((String)object, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this.a((String)object, 0, n2);
        } else {
            int n3;
            int n4 = n2;
            int n5 = 0;
            String string = object;
            object = this;
            do {
                if (((UTF8JsonGenerator)object)._outputTail + (n3 = Math.min(((UTF8JsonGenerator)object)._outputMaxContiguous, n4)) > ((UTF8JsonGenerator)object)._outputEnd) {
                    ((UTF8JsonGenerator)object)._flushBuffer();
                }
                super.a(string, n5, n3);
                n5 += n3;
            } while ((n4 -= n3) > 0);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeFieldName(SerializableString object) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName((SerializableString)object);
            return;
        }
        int n2 = this._writeContext.writeFieldName(object.getValue());
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            SerializableString serializableString = object;
            object = this;
            int n3 = serializableString.appendQuotedUTF8(((UTF8JsonGenerator)object)._outputBuffer, ((UTF8JsonGenerator)object)._outputTail);
            if (n3 < 0) {
                super.a(serializableString.asQuotedUTF8());
                return;
            }
            ((UTF8JsonGenerator)object)._outputTail += n3;
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        n2 = object.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this.a(object.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public final void writeStartArray() {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public final void writeStartArray(Object object) {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext(object);
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public void writeStartArray(Object object, int n2) {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext(object);
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public final void writeEndArray() {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            this._cfgPrettyPrinter.writeEndArray(uTF8JsonGenerator, uTF8JsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    @Override
    public final void writeStartObject() {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    public void writeStartObject(Object object) {
        this._verifyValueWrite("start an object");
        object = this._writeContext.createChildObjectContext(object);
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(((JsonStreamContext)object).getNestingDepth());
        this._writeContext = object;
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    public void writeStartObject(Object object, int n2) {
        ((JsonGenerator)this).writeStartObject(object);
    }

    @Override
    public final void writeEndObject() {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            this._cfgPrettyPrinter.writeEndObject(uTF8JsonGenerator, uTF8JsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    protected final void _writePPFieldName(String string) {
        int n2 = this._writeContext.writeFieldName(string);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this._cfgUnqNames) {
            this.a(string, false);
            return;
        }
        n2 = string.length();
        if (n2 > this._charBufferLength) {
            this.a(string, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        string.getChars(0, n2, this._charBuffer, 0);
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator.b(uTF8JsonGenerator._charBuffer, 0, n2);
        } else {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator.a(uTF8JsonGenerator._charBuffer, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    protected final void _writePPFieldName(SerializableString serializableString) {
        int n2;
        int n3 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n3 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n3 == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if ((n3 = !this._cfgUnqNames ? 1 : 0) != 0) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
        if ((n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail)) < 0) {
            this.a(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (n3 != 0) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    @Override
    public void writeString(String string) {
        this._verifyValueWrite("write a string");
        if (string == null) {
            this.a();
            return;
        }
        int n2 = string.length();
        if (n2 > this._outputMaxContiguous) {
            this.a(string, true);
            return;
        }
        if (this._outputTail + n2 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this.a(string, 0, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeString(Reader reader, int n2) {
        this._verifyValueWrite("write a string");
        if (reader == null) {
            this._reportError("null reader");
            return;
        }
        int n3 = n2 >= 0 ? n2 : Integer.MAX_VALUE;
        char[] cArray = this._charBuffer;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        while (n3 > 0) {
            int n4 = Math.min(n3, cArray.length);
            if ((n4 = reader.read(cArray, 0, n4)) <= 0) break;
            if (this._outputTail + n2 >= this._outputEnd) {
                this._flushBuffer();
            }
            this.a(cArray, 0, n4);
            n3 -= n4;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n3 > 0 && n2 >= 0) {
            this._reportError("Didn't read enough from reader");
        }
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n3 <= this._outputMaxContiguous) {
            if (this._outputTail + n3 > this._outputEnd) {
                this._flushBuffer();
            }
            this.b(cArray, n2, n3);
        } else {
            this.a(cArray, n2, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public final void writeString(SerializableString serializableString) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this.a(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeRawUTF8String(byte[] var1_1, int var2_2, int var3_4) {
        this._checkRangeBoundsForByteArray((byte[])var1_1, var2_2, var3_4);
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        v0 = this;
        var4_5 = var3_4;
        var3_4 = var2_2;
        var2_3 = var1_1;
        var1_1 = v0;
        if (v0._outputTail + var4_5 <= var1_1._outputEnd) ** GOTO lbl-1000
        var1_1._flushBuffer();
        if (var4_5 > 512) {
            var1_1._outputStream.write(var2_3, var3_4, var4_5);
        } else lbl-1000:
        // 2 sources

        {
            System.arraycopy(var2_3, var3_4, var1_1._outputBuffer, var1_1._outputTail, var4_5);
            var1_1._outputTail += var4_5;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeUTF8String(byte[] object, int n2, int n3) {
        this._checkRangeBoundsForByteArray((byte[])object, n2, n3);
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n3 <= this._outputMaxContiguous) {
            this.a((byte[])object, n2, n3);
        } else {
            int n4;
            int n5 = n3;
            n3 = n2;
            byte[] byArray = object;
            object = this;
            do {
                n4 = Math.min(((UTF8JsonGenerator)object)._outputMaxContiguous, n5);
                super.a(byArray, n3, n4);
                n3 += n4;
            } while ((n5 -= n4) > 0);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeRaw(String string) {
        char[] cArray;
        int n2 = string.length();
        if (n2 <= (cArray = this._charBuffer).length) {
            string.getChars(0, n2, cArray, 0);
            ((JsonGenerator)this).writeRaw(cArray, 0, n2);
            return;
        }
        ((JsonGenerator)this).writeRaw(string, 0, n2);
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        this._checkRangeBoundsForString(string, n2, n3);
        char[] cArray = this._charBuffer;
        int n4 = this._charBuffer.length;
        if (n3 <= n4) {
            int n5 = n2;
            string.getChars(n5, n5 + n3, cArray, 0);
            ((JsonGenerator)this).writeRaw(cArray, 0, n3);
            return;
        }
        n4 = Math.min(n4, (this._outputEnd >> 2) + (this._outputEnd >> 4));
        int n6 = n4 * 3;
        while (n3 > 0) {
            char c2;
            int n7 = Math.min(n4, n3);
            int n8 = n2;
            string.getChars(n8, n8 + n7, cArray, 0);
            if (this._outputTail + n6 > this._outputEnd) {
                this._flushBuffer();
            }
            if (n7 <= 1 || (c2 = cArray[n7 - 1]) < '\ud800' || c2 <= '\udbff') {
                // empty if block
            }
            int n9 = --n7;
            int n10 = 0;
            char[] cArray2 = cArray;
            UTF8JsonGenerator uTF8JsonGenerator = this;
            block1: while (n10 < n9) {
                char c3;
                while ((c3 = cArray2[n10]) <= '\u007f') {
                    uTF8JsonGenerator._outputBuffer[uTF8JsonGenerator._outputTail++] = (byte)c3;
                    if (++n10 >= n9) break block1;
                }
                if ((c3 = cArray2[n10++]) < '\u0800') {
                    uTF8JsonGenerator._outputBuffer[uTF8JsonGenerator._outputTail++] = (byte)(0xC0 | c3 >> 6);
                    uTF8JsonGenerator._outputBuffer[uTF8JsonGenerator._outputTail++] = (byte)(0x80 | c3 & 0x3F);
                    continue;
                }
                n10 = uTF8JsonGenerator.a(c3, cArray2, n10, n9);
            }
            n2 += n7;
            n3 -= n7;
        }
    }

    @Override
    public void writeRaw(SerializableString serializableString) {
        int n2 = serializableString.appendUnquotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this.a(serializableString.asUnquotedUTF8());
            return;
        }
        this._outputTail += n2;
    }

    @Override
    public void writeRawValue(SerializableString serializableString) {
        this._verifyValueWrite("write a raw (unencoded) value");
        int n2 = serializableString.appendUnquotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this.a(serializableString.asUnquotedUTF8());
            return;
        }
        this._outputTail += n2;
    }

    @Override
    public final void writeRaw(char[] object, int n2, int n3) {
        this._checkRangeBoundsForCharArray((char[])object, n2, n3);
        int n4 = n3;
        int n5 = n4 + n4 + n3;
        if (this._outputTail + n5 > this._outputEnd) {
            if (this._outputEnd < n5) {
                UTF8JsonGenerator uTF8JsonGenerator = this;
                n5 = n3;
                n3 = n2;
                char[] cArray = object;
                object = uTF8JsonGenerator;
                int n6 = uTF8JsonGenerator._outputEnd;
                byte[] byArray = ((UTF8JsonGenerator)object)._outputBuffer;
                n5 = n3 + n5;
                block0: while (n3 < n5) {
                    char c2;
                    while ((c2 = cArray[n3]) <= '\u007f') {
                        if (((UTF8JsonGenerator)object)._outputTail >= n6) {
                            ((UTF8JsonGenerator)object)._flushBuffer();
                        }
                        byArray[((UTF8JsonGenerator)object)._outputTail++] = (byte)c2;
                        if (++n3 >= n5) break block0;
                    }
                    if (((UTF8JsonGenerator)object)._outputTail + 3 >= ((UTF8JsonGenerator)object)._outputEnd) {
                        ((UTF8JsonGenerator)object)._flushBuffer();
                    }
                    if ((c2 = cArray[n3++]) < '\u0800') {
                        byArray[((UTF8JsonGenerator)object)._outputTail++] = (byte)(0xC0 | c2 >> 6);
                        byArray[((UTF8JsonGenerator)object)._outputTail++] = (byte)(0x80 | c2 & 0x3F);
                        continue;
                    }
                    n3 = super.a(c2, cArray, n3, n5);
                }
                return;
            }
            this._flushBuffer();
        }
        n3 += n2;
        block2: while (n2 < n3) {
            while ((n5 = object[n2]) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n5;
                if (++n2 >= n3) break block2;
            }
            if ((n5 = object[n2++]) < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n5 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            n2 = this.a(n5, (char[])object, n2, n3);
        }
    }

    @Override
    public void writeRaw(char c2) {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        if (c2 <= '\u007f') {
            byArray[this._outputTail++] = (byte)c2;
            return;
        }
        if (c2 < '\u0800') {
            byArray[this._outputTail++] = (byte)(0xC0 | c2 >> 6);
            byArray[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
            return;
        }
        this.a(c2, null, 0, 0);
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        this._checkRangeBoundsForByteArray(byArray, n2, n3);
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int n4 = n2;
        this._writeBinary(base64Variant, byArray, n4, n4 + n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        int n3;
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            if (n2 < 0) {
                n3 = this._writeBinary(base64Variant, inputStream, byArray);
            } else {
                n3 = this._writeBinary(base64Variant, inputStream, byArray, n2);
                if (n3 > 0) {
                    this._reportError("Too few bytes available: missing " + n3 + " bytes (out of " + n2 + ")");
                }
                n3 = n2;
            }
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return n3;
    }

    @Override
    public void writeNumber(short s2) {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 6 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            short s3 = s2;
            UTF8JsonGenerator uTF8JsonGenerator = this;
            if (uTF8JsonGenerator._outputTail + 8 >= uTF8JsonGenerator._outputEnd) {
                uTF8JsonGenerator._flushBuffer();
            }
            uTF8JsonGenerator._outputBuffer[uTF8JsonGenerator._outputTail++] = uTF8JsonGenerator._quoteChar;
            uTF8JsonGenerator._outputTail = NumberOutput.outputInt((int)s3, uTF8JsonGenerator._outputBuffer, uTF8JsonGenerator._outputTail);
            uTF8JsonGenerator._outputBuffer[uTF8JsonGenerator._outputTail++] = uTF8JsonGenerator._quoteChar;
            return;
        }
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
    }

    @Override
    public void writeNumber(int n2) {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            int n3 = n2;
            UTF8JsonGenerator uTF8JsonGenerator = this;
            if (uTF8JsonGenerator._outputTail + 13 >= uTF8JsonGenerator._outputEnd) {
                uTF8JsonGenerator._flushBuffer();
            }
            uTF8JsonGenerator._outputBuffer[uTF8JsonGenerator._outputTail++] = uTF8JsonGenerator._quoteChar;
            uTF8JsonGenerator._outputTail = NumberOutput.outputInt(n3, uTF8JsonGenerator._outputBuffer, uTF8JsonGenerator._outputTail);
            uTF8JsonGenerator._outputBuffer[uTF8JsonGenerator._outputTail++] = uTF8JsonGenerator._quoteChar;
            return;
        }
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
    }

    @Override
    public void writeNumber(long l2) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            long l3 = l2;
            UTF8JsonGenerator uTF8JsonGenerator = this;
            if (uTF8JsonGenerator._outputTail + 23 >= uTF8JsonGenerator._outputEnd) {
                uTF8JsonGenerator._flushBuffer();
            }
            uTF8JsonGenerator._outputBuffer[uTF8JsonGenerator._outputTail++] = uTF8JsonGenerator._quoteChar;
            uTF8JsonGenerator._outputTail = NumberOutput.outputLong(l3, uTF8JsonGenerator._outputBuffer, uTF8JsonGenerator._outputTail);
            uTF8JsonGenerator._outputBuffer[uTF8JsonGenerator._outputTail++] = uTF8JsonGenerator._quoteChar;
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        this._verifyValueWrite("write a number");
        if (bigInteger == null) {
            this.a();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this.a(bigInteger.toString());
            return;
        }
        ((JsonGenerator)this).writeRaw(bigInteger.toString());
    }

    @Override
    public void writeNumber(double d2) {
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(d2) && JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS.enabledIn(this._features)) {
            ((JsonGenerator)this).writeString(NumberOutput.toString(d2, ((JsonGenerator)this).isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this._verifyValueWrite("write a number");
        ((JsonGenerator)this).writeRaw(NumberOutput.toString(d2, ((JsonGenerator)this).isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(float f2) {
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(f2) && JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS.enabledIn(this._features)) {
            ((JsonGenerator)this).writeString(NumberOutput.toString(f2, ((JsonGenerator)this).isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this._verifyValueWrite("write a number");
        ((JsonGenerator)this).writeRaw(NumberOutput.toString(f2, ((JsonGenerator)this).isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) {
        this._verifyValueWrite("write a number");
        if (bigDecimal == null) {
            this.a();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator.a(uTF8JsonGenerator._asString(bigDecimal));
            return;
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        ((JsonGenerator)uTF8JsonGenerator).writeRaw(uTF8JsonGenerator._asString(bigDecimal));
    }

    @Override
    public void writeNumber(String string) {
        this._verifyValueWrite("write a number");
        if (string == null) {
            this.a();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this.a(string);
            return;
        }
        ((JsonGenerator)this).writeRaw(string);
    }

    @Override
    public void writeNumber(char[] object, int n2, int n3) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            int n4 = n3;
            n3 = n2;
            char[] cArray = object;
            object = uTF8JsonGenerator;
            if (uTF8JsonGenerator._outputTail >= ((UTF8JsonGenerator)object)._outputEnd) {
                ((UTF8JsonGenerator)object)._flushBuffer();
            }
            ((UTF8JsonGenerator)object)._outputBuffer[((UTF8JsonGenerator)object)._outputTail++] = ((UTF8JsonGenerator)object)._quoteChar;
            ((JsonGenerator)object).writeRaw(cArray, n3, n4);
            if (((UTF8JsonGenerator)object)._outputTail >= ((UTF8JsonGenerator)object)._outputEnd) {
                ((UTF8JsonGenerator)object)._flushBuffer();
            }
            ((UTF8JsonGenerator)object)._outputBuffer[((UTF8JsonGenerator)object)._outputTail++] = ((UTF8JsonGenerator)object)._quoteChar;
            return;
        }
        ((JsonGenerator)this).writeRaw((char[])object, n2, n3);
    }

    private final void a(String string) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        ((JsonGenerator)this).writeRaw(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeBoolean(boolean bl2) {
        this._verifyValueWrite("write a boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = bl2 ? d : e;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite("write a null");
        this.a();
    }

    @Override
    protected final void _verifyValueWrite(String object) {
        int n2;
        int n3 = this._writeContext.writeValue();
        if (this._cfgPrettyPrinter != null) {
            this._verifyPrettyValueWrite((String)object, n3);
            return;
        }
        switch (n3) {
            default: {
                return;
            }
            case 1: {
                n2 = 44;
                break;
            }
            case 2: {
                n2 = 58;
                break;
            }
            case 3: {
                if (this._rootValueSeparator != null) {
                    byte[] byArray = this._rootValueSeparator.asUnquotedUTF8();
                    object = byArray;
                    if (byArray.length > 0) {
                        this.a((byte[])object);
                    }
                }
                return;
            }
            case 5: {
                this._reportCantWriteValueExpectName((String)object);
                return;
            }
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = n2;
    }

    @Override
    public void flush() {
        this._flushBuffer();
        if (this._outputStream != null && ((JsonGenerator)this).isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._outputStream.flush();
        }
    }

    @Override
    public void close() {
        Object object;
        super.close();
        IOException iOException = null;
        try {
            if (this._outputBuffer != null && ((JsonGenerator)this).isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
                while (true) {
                    if (((JsonStreamContext)(object = ((JsonGenerator)this).getOutputContext())).inArray()) {
                        ((JsonGenerator)this).writeEndArray();
                        continue;
                    }
                    if (!((JsonStreamContext)object).inObject()) break;
                    ((JsonGenerator)this).writeEndObject();
                }
            }
            this._flushBuffer();
        }
        catch (IOException iOException2) {
            object = iOException2;
            iOException = iOException2;
        }
        this._outputTail = 0;
        if (this._outputStream != null) {
            try {
                if (this._ioContext.isResourceManaged() || ((JsonGenerator)this).isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                    this._outputStream.close();
                } else if (((JsonGenerator)this).isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                    this._outputStream.flush();
                }
            }
            catch (IOException | RuntimeException exception) {
                if (iOException != null) {
                    exception.addSuppressed(iOException);
                }
                throw exception;
            }
        }
        this._releaseBuffers();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    protected void _releaseBuffers() {
        Object[] objectArray = this._outputBuffer;
        if (this._outputBuffer != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer((byte[])objectArray);
        }
        objectArray = this._charBuffer;
        if (this._charBuffer != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer((char[])objectArray);
        }
    }

    private final void a(byte[] byArray) {
        int n2 = byArray.length;
        if (this._outputTail + n2 > this._outputEnd) {
            this._flushBuffer();
            if (n2 > 512) {
                this._outputStream.write(byArray, 0, n2);
                return;
            }
        }
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    private final void a(String string, boolean bl2) {
        int n2;
        if (bl2) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            n2 = Math.min(this._outputMaxContiguous, i2);
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this.a(string, n3, n2);
            n3 += n2;
        }
        if (bl2) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    private final void a(char[] cArray, int n2, int n3) {
        int n4;
        do {
            if (this._outputTail + (n4 = Math.min(this._outputMaxContiguous, n3)) > this._outputEnd) {
                this._flushBuffer();
            }
            this.b(cArray, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private final void b(char[] cArray, int n2, int n3) {
        char c2;
        n3 += n2;
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3 && (c2 = cArray[n2]) <= '\u007f' && nArray[c2] == 0) {
            byArray[n4++] = (byte)c2;
            ++n2;
        }
        this._outputTail = n4;
        if (n2 < n3) {
            if (this._characterEscapes != null) {
                this.e(cArray, n2, n3);
                return;
            }
            if (this._maximumNonEscapedChar == 0) {
                this.c(cArray, n2, n3);
                return;
            }
            this.d(cArray, n2, n3);
        }
    }

    private final void a(String string, int n2, int n3) {
        char c2;
        n3 += n2;
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3 && (c2 = string.charAt(n2)) <= '\u007f' && nArray[c2] == 0) {
            byArray[n4++] = (byte)c2;
            ++n2;
        }
        this._outputTail = n4;
        if (n2 < n3) {
            if (this._characterEscapes != null) {
                this.d(string, n2, n3);
                return;
            }
            if (this._maximumNonEscapedChar == 0) {
                this.b(string, n2, n3);
                return;
            }
            this.c(string, n2, n3);
        }
    }

    private final void c(char[] cArray, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3) {
            char c2;
            if ((c2 = cArray[n2++]) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n5 = nArray[c2];
                if (n5 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n5;
                    continue;
                }
                n4 = this.b(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this.a(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void b(String string, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n5 = nArray[c2];
                if (n5 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n5;
                    continue;
                }
                n4 = this.b(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this.a(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void d(char[] cArray, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar;
        while (n2 < n3) {
            char c2;
            if ((c2 = cArray[n2++]) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n6 = nArray[c2];
                if (n6 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                n4 = this.b(c2, n4);
                continue;
            }
            if (c2 > n5) {
                n4 = this.b(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this.a(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void c(String string, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar;
        while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n6 = nArray[c2];
                if (n6 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                n4 = this.b(c2, n4);
                continue;
            }
            if (c2 > n5) {
                n4 = this.b(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this.a(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void e(char[] cArray, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (n2 < n3) {
            int n6;
            if ((n6 = cArray[n2++]) <= 127) {
                if (nArray[n6] == 0) {
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                int n7 = nArray[n6];
                if (n7 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n7;
                    continue;
                }
                if (n7 == -2) {
                    SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
                    if (serializableString == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n6) + ", although was supposed to have one");
                    }
                    n4 = this.a(byArray, n4, serializableString, n3 - n2);
                    continue;
                }
                n4 = this.b(n6, n4);
                continue;
            }
            if (n6 > n5) {
                n4 = this.b(n6, n4);
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
            if (serializableString != null) {
                n4 = this.a(byArray, n4, serializableString, n3 - n2);
                continue;
            }
            if (n6 <= 2047) {
                byArray[n4++] = (byte)(0xC0 | n6 >> 6);
                byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            n4 = this.a(n6, n4);
        }
        this._outputTail = n4;
    }

    private final void d(String string, int n2, int n3) {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (n2 < n3) {
            int n6;
            if ((n6 = string.charAt(n2++)) <= 127) {
                if (nArray[n6] == 0) {
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                int n7 = nArray[n6];
                if (n7 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n7;
                    continue;
                }
                if (n7 == -2) {
                    SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
                    if (serializableString == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n6) + ", although was supposed to have one");
                    }
                    n4 = this.a(byArray, n4, serializableString, n3 - n2);
                    continue;
                }
                n4 = this.b(n6, n4);
                continue;
            }
            if (n6 > n5) {
                n4 = this.b(n6, n4);
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
            if (serializableString != null) {
                n4 = this.a(byArray, n4, serializableString, n3 - n2);
                continue;
            }
            if (n6 <= 2047) {
                byArray[n4++] = (byte)(0xC0 | n6 >> 6);
                byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            n4 = this.a(n6, n4);
        }
        this._outputTail = n4;
    }

    private final int a(byte[] byArray, int n2, SerializableString object, int n3) {
        byte[] byArray2 = object.asUnquotedUTF8();
        object = byArray2;
        int n4 = byArray2.length;
        if (n4 > 6) {
            return this.a(byArray, n2, this._outputEnd, (byte[])object, n3);
        }
        System.arraycopy(object, 0, byArray, n2, n4);
        return n2 + n4;
    }

    private final int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = byArray2.length;
        if (n2 + n5 > n3) {
            this._outputTail = n2;
            this._flushBuffer();
            n2 = this._outputTail;
            if (n5 > byArray.length) {
                this._outputStream.write(byArray2, 0, n5);
                return n2;
            }
        }
        System.arraycopy(byArray2, 0, byArray, n2, n5);
        if ((n2 += n5) + n4 * 6 > n3) {
            this._outputTail = n2;
            this._flushBuffer();
            return this._outputTail;
        }
        return n2;
    }

    private final void a(byte[] byArray, int n2, int n3) {
        int[] nArray = this._outputEscapes;
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5) {
            byte by;
            if ((by = byArray[n4++]) < 0 || nArray[by] == 0) continue;
            this.b(byArray, n2, n3);
            return;
        }
        if (this._outputTail + n3 > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
        this._outputTail += n3;
    }

    private final void b(byte[] byArray, int n2, int n3) {
        int n4 = this._outputTail;
        if (n4 + n3 * 6 > this._outputEnd) {
            this._flushBuffer();
            n4 = this._outputTail;
        }
        byte[] byArray2 = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        n3 += n2;
        while (n2 < n3) {
            int n5;
            int n6 = n5 = byArray[n2++];
            if (n5 < 0 || nArray[n6] == 0) {
                byArray2[n4++] = n5;
                continue;
            }
            n5 = nArray[n6];
            if (n5 > 0) {
                byArray2[n4++] = 92;
                byArray2[n4++] = (byte)n5;
                continue;
            }
            n4 = this.b(n6, n4);
        }
        this._outputTail = n4;
    }

    protected final void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n3 - 3;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n2 <= n5) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n4 = byArray[n2++] << 8;
            n4 |= byArray[n2++] & 0xFF;
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n4, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        n4 = n3 - n2;
        if (n4 > 0) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n3 = byArray[n2++] << 16;
            if (n4 == 2) {
                n3 |= (byArray[n2] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n3, n4, this._outputBuffer, this._outputTail);
        }
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = -3;
        int n7 = this._outputEnd - 6;
        int n8 = base64Variant.getMaxLineLength() >> 2;
        while (n2 > 2) {
            if (n4 > n6) {
                n5 = UTF8JsonGenerator.a(inputStream, byArray, n4, n5, n2);
                n4 = 0;
                if (n5 < 3) break;
                n6 = n5 - 3;
            }
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n3 = byArray[n4++] << 8;
            n3 |= byArray[n4++] & 0xFF;
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            n2 -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n8 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n8 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n2 > 0 && (n5 = UTF8JsonGenerator.a(inputStream, byArray, n4, n5, n2)) > 0) {
            int n9;
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n3 = byArray[0] << 16;
            if (1 < n5) {
                n3 |= (byArray[1] & 0xFF) << 8;
                n9 = 2;
            } else {
                n9 = 1;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n3, n9, this._outputBuffer, this._outputTail);
            n2 -= n9;
        }
        return n2;
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = 0;
        int n7 = this._outputEnd - 6;
        int n8 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n3 > n5) {
                n4 = UTF8JsonGenerator.a(inputStream, byArray, n3, n4, byArray.length);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n2 = byArray[n3++] << 8;
            n2 |= byArray[n3++] & 0xFF;
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            n6 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n2, this._outputBuffer, this._outputTail);
            if (--n8 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n8 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n4 > 0) {
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n2 = byArray[0] << 16;
            int n9 = 1;
            if (1 < n4) {
                n2 |= (byArray[1] & 0xFF) << 8;
                n9 = 2;
            }
            n6 += n9;
            this._outputTail = base64Variant.encodeBase64Partial(n2, n9, this._outputBuffer, this._outputTail);
        }
        return n6;
    }

    private static int a(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n2 < n3) {
            byArray[n5++] = byArray[n2++];
        }
        n3 = n5;
        n4 = Math.min(n4, byArray.length);
        while ((n2 = n4 - n3) != 0) {
            if ((n2 = inputStream.read(byArray, n3, n2)) < 0) {
                return n3;
            }
            if ((n3 += n2) < 3) continue;
        }
        return n3;
    }

    private final int a(int n2, char[] objectArray, int n3, int n4) {
        if (n2 >= 55296 && n2 <= 57343) {
            if (n3 >= n4 || objectArray == null) {
                this._reportError(String.format("Split surrogate on writeRaw() input (last character): first character 0x%4x", n2));
            } else {
                this._outputSurrogates(n2, objectArray[n3]);
            }
            return n3 + 1;
        }
        objectArray = this._outputBuffer;
        this._outputBuffer[this._outputTail++] = (byte)(0xE0 | n2 >> 12);
        objectArray[this._outputTail++] = (char)(0x80 | n2 >> 6 & 0x3F);
        objectArray[this._outputTail++] = (char)(0x80 | n2 & 0x3F);
        return n3;
    }

    protected final void _outputSurrogates(int n2, int n3) {
        n2 = this._decodeSurrogate(n2, n3);
        if (this._outputTail + 4 > this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        this._outputBuffer[this._outputTail++] = (byte)(0xF0 | n2 >> 18);
        byArray[this._outputTail++] = (byte)(0x80 | n2 >> 12 & 0x3F);
        byArray[this._outputTail++] = (byte)(0x80 | n2 >> 6 & 0x3F);
        byArray[this._outputTail++] = (byte)(0x80 | n2 & 0x3F);
    }

    private final int a(int n2, int n3) {
        byte[] byArray = this.b();
        byte[] byArray2 = this._outputBuffer;
        if (n2 >= 55296 && n2 <= 57343) {
            byArray2[n3++] = 92;
            byArray2[n3++] = 117;
            byArray2[n3++] = byArray[n2 >> 12 & 0xF];
            byArray2[n3++] = byArray[n2 >> 8 & 0xF];
            byArray2[n3++] = byArray[n2 >> 4 & 0xF];
            byArray2[n3++] = byArray[n2 & 0xF];
        } else {
            byArray2[n3++] = (byte)(0xE0 | n2 >> 12);
            byArray2[n3++] = (byte)(0x80 | n2 >> 6 & 0x3F);
            byArray2[n3++] = (byte)(0x80 | n2 & 0x3F);
        }
        return n3;
    }

    private final void a() {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(c, 0, this._outputBuffer, this._outputTail, 4);
        this._outputTail += 4;
    }

    private int b(int n2, int n3) {
        byte[] byArray = this._outputBuffer;
        byte[] byArray2 = this.b();
        byArray[n3++] = 92;
        byArray[n3++] = 117;
        if (n2 > 255) {
            int n4 = n2 >> 8 & 0xFF;
            byArray[n3++] = byArray2[n4 >> 4];
            byArray[n3++] = byArray2[n4 & 0xF];
            n2 &= 0xFF;
        } else {
            byArray[n3++] = 48;
            byArray[n3++] = 48;
        }
        byArray[n3++] = byArray2[n2 >> 4];
        byArray[n3++] = byArray2[n2 & 0xF];
        return n3;
    }

    protected final void _flushBuffer() {
        int n2 = this._outputTail;
        if (n2 > 0) {
            this._outputTail = 0;
            this._outputStream.write(this._outputBuffer, 0, n2);
        }
    }

    private byte[] b() {
        if (this._cfgWriteHexUppercase) {
            return a;
        }
        return b;
    }
}

