/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonParserBase;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.InternalJacksonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;

public class UTF8StreamJsonParser
extends JsonParserBase {
    protected static final byte BYTE_LF = 10;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete;
    private int a;
    protected int _nameStartOffset;
    protected int _nameStartRow;
    protected int _nameStartCol;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;

    @Deprecated
    public UTF8StreamJsonParser(IOContext iOContext, int n2, InputStream inputStream, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, byte[] byArray, int n3, int n4, boolean bl2) {
        this(iOContext, n2, inputStream, objectCodec, byteQuadsCanonicalizer, byArray, n3, n4, 0, bl2);
    }

    public UTF8StreamJsonParser(IOContext iOContext, int n2, InputStream inputStream, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, byte[] byArray, int n3, int n4, int n5, boolean bl2) {
        super(iOContext, n2, objectCodec);
        this._inputStream = inputStream;
        this._symbols = byteQuadsCanonicalizer;
        this._inputBuffer = byArray;
        this._inputPtr = n3;
        this._inputEnd = n4;
        this._currInputRowStart = n3 - n5;
        this._currInputProcessed = -n3 + n5;
        this._bufferRecyclable = bl2;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this._inputPtr;
        this._inputPtr += n2;
        outputStream.write(this._inputBuffer, n3, n2);
        return n2;
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    protected final boolean _loadMore() {
        if (this._inputStream != null) {
            int n2 = this._inputBuffer.length;
            if (n2 == 0) {
                return false;
            }
            int n3 = this._inputEnd;
            this._currInputProcessed += (long)n3;
            this._currInputRowStart -= n3;
            ((JsonParser)this).streamReadConstraints().validateDocumentLength(this._currInputProcessed);
            n2 = this._inputStream.read(this._inputBuffer, 0, n2);
            if (n2 > 0) {
                this._nameStartOffset -= n3;
                this._inputPtr = 0;
                this._inputEnd = n2;
                return true;
            }
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            uTF8StreamJsonParser._inputEnd = 0;
            uTF8StreamJsonParser._inputPtr = 0;
            this._closeInput();
            if (n2 == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    @Override
    protected void _closeInput() {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        this._symbols.release();
        if (this._bufferRecyclable) {
            byte[] byArray = this._inputBuffer;
            if (this._inputBuffer != null && byArray != NO_BYTES) {
                this._inputBuffer = NO_BYTES;
                this._ioContext.releaseReadIOBuffer(byArray);
            }
        }
    }

    @Override
    public String getText() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        UTF8StreamJsonParser uTF8StreamJsonParser = this;
        return uTF8StreamJsonParser._getText2(uTF8StreamJsonParser._currToken);
    }

    @Override
    public int getText(Writer writer) {
        Object object = this._currToken;
        if (object == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsToWriter(writer);
        }
        if (object == JsonToken.FIELD_NAME) {
            object = ((JsonStreamContext)this._parsingContext).getCurrentName();
            writer.write((String)object);
            return ((String)object).length();
        }
        if (object != null) {
            if (object.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            object = object.asCharArray();
            writer.write((char[])object);
            return ((JsonToken)object).length;
        }
        return 0;
    }

    @Override
    public String getValueAsString() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        return super.getValueAsString(string);
    }

    @Override
    public int getValueAsInt() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n2) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(n2);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return ((JsonStreamContext)this._parsingContext).getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public char[] getTextCharacters() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = ((JsonStreamContext)this._parsingContext).getCurrentName();
                        int n2 = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                        } else if (this._nameCopyBuffer.length < n2) {
                            this._nameCopyBuffer = new char[n2];
                        }
                        string.getChars(0, n2, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return ((JsonStreamContext)this._parsingContext).getCurrentName().length();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            uTF8StreamJsonParser._decodeBase64(((JsonParser)uTF8StreamJsonParser).getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = ((JsonParser)this).getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n2 = this._readBinary(base64Variant, outputStream, byArray);
            return n2;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length - 3;
        int n4 = 0;
        while (true) {
            int n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                if (n5 == 34) break;
                n6 = this._decodeBase64Escape(base64Variant, n5, 0);
                if (n6 < 0) continue;
            }
            if (n2 > n3) {
                n4 += n2;
                outputStream.write(byArray, 0, n2);
                n2 = 0;
            }
            int n7 = n6;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n6 = base64Variant.decodeBase64Char(n5 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n6 = this._decodeBase64Escape(base64Variant, n5, 1);
            }
            n7 = n7 << 6 | n6;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n6 = base64Variant.decodeBase64Char(n5 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n6 != -2) {
                    if (n5 == 34) {
                        byArray[n2++] = (byte)(n7 >>= 4);
                        if (!base64Variant.requiresPaddingOnRead()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n6 = this._decodeBase64Escape(base64Variant, n5, 2);
                }
                if (n6 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n5 = this._inputBuffer[this._inputPtr++] & 0xFF) && this._decodeBase64Escape(base64Variant, n5, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, n5, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n2++] = (byte)(n7 >>= 4);
                    continue;
                }
            }
            n7 = n7 << 6 | n6;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n6 = base64Variant.decodeBase64Char(n5 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n6 != -2) {
                    if (n5 == 34) {
                        byArray[n2++] = (byte)((n7 >>= 2) >> 8);
                        byArray[n2++] = (byte)n7;
                        if (!base64Variant.requiresPaddingOnRead()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n6 = this._decodeBase64Escape(base64Variant, n5, 3);
                }
                if (n6 == -2) {
                    byArray[n2++] = (byte)((n7 >>= 2) >> 8);
                    byArray[n2++] = (byte)n7;
                    continue;
                }
            }
            n7 = n7 << 6 | n6;
            byArray[n2++] = (byte)(n7 >> 16);
            byArray[n2++] = (byte)(n7 >> 8);
            byArray[n2++] = (byte)n7;
        }
        this._tokenIncomplete = false;
        if (n2 > 0) {
            n4 += n2;
            outputStream.write(byArray, 0, n2);
        }
        return n4;
    }

    @Override
    public JsonToken nextToken() {
        JsonToken jsonToken;
        int n2;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.a();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this.e()) < 0) {
            ((JsonParser)this).close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (n2 == 93) {
            this.r();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n2 == 125) {
            this.s();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n2 = this.c();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 == 93 || n2 == 125)) {
                return this.g(n2);
            }
        }
        if (!this._parsingContext.inObject()) {
            this.p();
            return this.a(n2);
        }
        this.q();
        String string = this._parseName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        int n3 = this.g();
        this.p();
        if (n3 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n3) {
            case 45: {
                jsonToken = this.a(true);
                break;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    jsonToken = this.a(false);
                    break;
                }
                jsonToken = this._handleUnexpectedValue(n3);
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod(false, false);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parseUnsignedNumber(n3);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n3);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    private final JsonToken a(int n2) {
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 91: {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildArrayContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildObjectContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchTrue();
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchFalse();
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchNull();
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this.a(true);
                return this._currToken;
            }
            case 43: {
                if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    this._currToken = this._handleUnexpectedValue(n2);
                    return this._currToken;
                }
                this._currToken = this.a(false);
                return this._currToken;
            }
            case 46: {
                this._currToken = this._parseFloatThatStartsWithPeriod(false, false);
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parseUnsignedNumber(n2);
                return this._currToken;
            }
        }
        this._currToken = this._handleUnexpectedValue(n2);
        return this._currToken;
    }

    private final JsonToken a() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            uTF8StreamJsonParser.createChildArrayContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            uTF8StreamJsonParser.createChildObjectContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void finishToken() {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean nextFieldName(SerializableString var1_1) {
        block41: {
            this._numTypesValid = 0;
            if (this._currToken == JsonToken.FIELD_NAME) {
                this.a();
                return false;
            }
            if (this._tokenIncomplete) {
                this._skipString();
            }
            if ((var2_2 = this.e()) < 0) {
                this.close();
                this._currToken = null;
                return false;
            }
            this._binaryValue = null;
            if (var2_2 == 93) {
                this.r();
                this._currToken = JsonToken.END_ARRAY;
                return false;
            }
            if (var2_2 == 125) {
                this.s();
                this._currToken = JsonToken.END_OBJECT;
                return false;
            }
            if (this._parsingContext.expectComma()) {
                if (var2_2 != 44) {
                    this._reportUnexpectedChar(var2_2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
                }
                var2_2 = this.c();
                if ((this._features & UTF8StreamJsonParser.FEAT_MASK_TRAILING_COMMA) != 0 && (var2_2 == 93 || var2_2 == 125)) {
                    this.g(var2_2);
                    return false;
                }
            }
            if (!this._parsingContext.inObject()) {
                this.p();
                this.a(var2_2);
                return false;
            }
            this.q();
            if (var2_2 != 34 || this._inputPtr + (var4_9 = ((byte[])(var3_6 = var1_1.asQuotedUTF8())).length) + 4 >= this._inputEnd || this._inputBuffer[var4_9 = this._inputPtr + var4_9] != 34) break block41;
            var5_10 = 0;
            var6_11 = this._inputPtr;
            while (true) {
                block42: {
                    block45: {
                        block46: {
                            block47: {
                                block43: {
                                    block44: {
                                        if (var6_11 != var4_9) break block42;
                                        this._parsingContext.setCurrentName(var1_1.getValue());
                                        var2_2 = var6_11 + 1;
                                        var1_1 = this;
                                        var3_7 = var1_1._inputBuffer[var2_2++];
                                        if (var3_7 != 58) break block43;
                                        if ((var3_7 = var1_1._inputBuffer[var2_2++]) <= 32) break block44;
                                        if (var3_7 == 47 || var3_7 == 35) ** GOTO lbl-1000
                                        var1_1._inputPtr = var2_2;
                                        v0 = var3_7;
                                        break block45;
                                    }
                                    if ((var3_7 == 32 || var3_7 == 9) && (var3_7 = var1_1._inputBuffer[var2_2++]) > 32 && var3_7 != 47 && var3_7 != 35) {
                                        var1_1._inputPtr = var2_2;
                                        v0 = var3_7;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        var1_1._inputPtr = var2_2 - 1;
                                        v0 = super.b(true);
                                    }
                                    break block45;
                                }
                                if (var3_7 == 32 || var3_7 == 9) {
                                    var3_7 = var1_1._inputBuffer[var2_2++];
                                }
                                if (var3_7 != 58) break block46;
                                if ((var3_7 = var1_1._inputBuffer[var2_2++]) <= 32) break block47;
                                if (var3_7 == 47 || var3_7 == 35) ** GOTO lbl-1000
                                var1_1._inputPtr = var2_2;
                                v0 = var3_7;
                                break block45;
                            }
                            if ((var3_7 == 32 || var3_7 == 9) && (var3_7 = var1_1._inputBuffer[var2_2++]) > 32 && var3_7 != 47 && var3_7 != 35) {
                                var1_1._inputPtr = var2_2;
                                v0 = var3_7;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var1_1._inputPtr = var2_2 - 1;
                                v0 = super.b(true);
                            }
                            break block45;
                        }
                        var1_1._inputPtr = var2_2 - 1;
                        v0 = super.b(false);
                    }
                    var2_2 = v0;
                    var1_1 = this;
                    this._currToken = JsonToken.FIELD_NAME;
                    super.p();
                    switch (var2_2) {
                        case 34: {
                            var1_1._tokenIncomplete = true;
                            var1_1._nextToken = JsonToken.VALUE_STRING;
                            break;
                        }
                        case 91: {
                            var1_1._nextToken = JsonToken.START_ARRAY;
                            break;
                        }
                        case 123: {
                            var1_1._nextToken = JsonToken.START_OBJECT;
                            break;
                        }
                        case 116: {
                            var1_1._matchTrue();
                            var1_1._nextToken = JsonToken.VALUE_TRUE;
                            break;
                        }
                        case 102: {
                            var1_1._matchFalse();
                            var1_1._nextToken = JsonToken.VALUE_FALSE;
                            break;
                        }
                        case 110: {
                            var1_1._matchNull();
                            var1_1._nextToken = JsonToken.VALUE_NULL;
                            break;
                        }
                        case 45: {
                            var1_1._nextToken = super.a(true);
                            break;
                        }
                        case 43: {
                            if (var1_1.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                                var1_1._nextToken = super.a(false);
                                break;
                            }
                            var1_1._nextToken = var1_1._handleUnexpectedValue(var2_2);
                            break;
                        }
                        case 46: {
                            var1_1._nextToken = var1_1._parseFloatThatStartsWithPeriod(false, false);
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            var1_1._nextToken = var1_1._parseUnsignedNumber(var2_2);
                            break;
                        }
                        default: {
                            var1_1._nextToken = var1_1._handleUnexpectedValue(var2_2);
                        }
                    }
                    return true;
                }
                if (var3_6[var5_10] != this._inputBuffer[var6_11]) break;
                ++var5_10;
                ++var6_11;
            }
        }
        var3_6 = var1_1;
        var1_1 = this;
        var2_3 = var1_1._parseName(var2_2);
        var1_1._parsingContext.setCurrentName(var2_3);
        var3_8 = var2_3.equals(var3_6.getValue());
        var1_1._currToken = JsonToken.FIELD_NAME;
        var2_4 = super.g();
        super.p();
        if (var2_4 == 34) {
            var1_1._tokenIncomplete = true;
            var1_1._nextToken = JsonToken.VALUE_STRING;
            return var3_8;
        }
        switch (var2_4) {
            case 91: {
                var2_5 = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                var2_5 = JsonToken.START_OBJECT;
                break;
            }
            case 116: {
                var1_1._matchTrue();
                var2_5 = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                var1_1._matchFalse();
                var2_5 = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                var1_1._matchNull();
                var2_5 = JsonToken.VALUE_NULL;
                break;
            }
            case 45: {
                var2_5 = super.a(true);
                break;
            }
            case 43: {
                if (var1_1.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    var2_5 = super.a(false);
                    break;
                }
                var2_5 = var1_1._handleUnexpectedValue(var2_4);
                break;
            }
            case 46: {
                var2_5 = var1_1._parseFloatThatStartsWithPeriod(false, false);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                var2_5 = var1_1._parseUnsignedNumber(var2_4);
                break;
            }
            default: {
                var2_5 = var1_1._handleUnexpectedValue(var2_4);
            }
        }
        var1_1._nextToken = var2_5;
        return var3_8;
    }

    @Override
    public String nextFieldName() {
        JsonToken jsonToken;
        int n2;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this.a();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this.e()) < 0) {
            ((JsonParser)this).close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (n2 == 93) {
            this.r();
            this._currToken = JsonToken.END_ARRAY;
            return null;
        }
        if (n2 == 125) {
            this.s();
            this._currToken = JsonToken.END_OBJECT;
            return null;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n2 = this.c();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 == 93 || n2 == 125)) {
                this.g(n2);
                return null;
            }
        }
        if (!this._parsingContext.inObject()) {
            this.p();
            this.a(n2);
            return null;
        }
        this.q();
        String string = this._parseName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this.g();
        this.p();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n2) {
            case 45: {
                jsonToken = this.a(true);
                break;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    jsonToken = this.a(false);
                    break;
                }
                jsonToken = this._handleUnexpectedValue(n2);
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod(false, false);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parseUnsignedNumber(n2);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    @Override
    public String nextTextValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    return this._finishAndReturnString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildArrayContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildObjectContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        if (((JsonParser)this).nextToken() == JsonToken.VALUE_STRING) {
            return ((JsonParser)this).getText();
        }
        return null;
    }

    @Override
    public int nextIntValue(int n2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return ((JsonParser)this).getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildArrayContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildObjectContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return n2;
        }
        if (((JsonParser)this).nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return ((JsonParser)this).getIntValue();
        }
        return n2;
    }

    @Override
    public long nextLongValue(long l2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return ((JsonParser)this).getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildArrayContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildObjectContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return l2;
        }
        if (((JsonParser)this).nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return ((JsonParser)this).getLongValue();
        }
        return l2;
    }

    @Override
    public Boolean nextBooleanValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildArrayContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                uTF8StreamJsonParser.createChildObjectContext(uTF8StreamJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        JsonToken jsonToken = ((JsonParser)this).nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Deprecated
    protected final JsonToken _parseFloatThatStartsWithPeriod() {
        return this._parseFloatThatStartsWithPeriod(false, false);
    }

    protected final JsonToken _parseFloatThatStartsWithPeriod(boolean bl2, boolean bl3) {
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleUnexpectedValue(46);
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        if (bl2) {
            ++n2;
            cArray[0] = 45;
        }
        return this.a(cArray, n2, 46, bl2, 0);
    }

    protected JsonToken _parseUnsignedNumber(int n2) {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        if (n2 == 48) {
            n2 = this.b();
        }
        cArray[0] = (char)n2;
        int n3 = 1;
        int n4 = 1;
        int n5 = Math.min(this._inputEnd, this._inputPtr + cArray.length - 1);
        while (true) {
            if (this._inputPtr >= n5) {
                return this.a(cArray, n4, false, n3);
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n2 > 57) break;
            ++n3;
            cArray[n4++] = (char)n2;
        }
        if (n2 == 46 || (n2 | 0x20) == 101) {
            return this.a(cArray, n4, n2, false, n3);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n4);
        if (this._parsingContext.inRoot()) {
            this.b(n2);
        }
        return this.resetInt(false, n3);
    }

    private final JsonToken a(boolean bl2) {
        int n2;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = 0;
        if (bl2) {
            ++n3;
            cArray[0] = 45;
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 48) {
            if (n2 != 48) {
                if (n2 == 46) {
                    return this._parseFloatThatStartsWithPeriod(bl2, true);
                }
                return this._handleInvalidNumberStart(n2, bl2, true);
            }
            n2 = this.b();
        } else if (n2 > 57) {
            return this._handleInvalidNumberStart(n2, bl2, true);
        }
        cArray[n3++] = (char)n2;
        int n4 = 1;
        int n5 = Math.min(this._inputEnd, this._inputPtr + cArray.length - n3);
        while (true) {
            if (this._inputPtr >= n5) {
                return this.a(cArray, n3, bl2, n4);
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n2 > 57) break;
            ++n4;
            cArray[n3++] = (char)n2;
        }
        if (n2 == 46 || (n2 | 0x20) == 101) {
            return this.a(cArray, n3, n2, bl2, n4);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n3);
        if (this._parsingContext.inRoot()) {
            this.b(n2);
        }
        return this.resetInt(bl2, n4);
    }

    private final JsonToken a(char[] cArray, int n2, boolean bl2, int n3) {
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._textBuffer.setCurrentLength(n2);
                return this.resetInt(bl2, n3);
            }
            if ((n4 = this._inputBuffer[this._inputPtr++] & 0xFF) > 57 || n4 < 48) {
                if (n4 != 46 && (n4 | 0x20) != 101) break;
                return this.a(cArray, n2, n4, bl2, n3);
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n4;
            ++n3;
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n2);
        if (this._parsingContext.inRoot()) {
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            uTF8StreamJsonParser.b(uTF8StreamJsonParser._inputBuffer[this._inputPtr] & 0xFF);
        }
        return this.resetInt(bl2, n3);
    }

    private final int b() {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return 48;
        }
        int n2 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n2 < 48 || n2 > 57) {
            return 48;
        }
        if ((this._features & FEAT_MASK_LEADING_ZEROS) == 0) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (n2 == 48) {
            while (this._inputPtr < this._inputEnd || this._loadMore()) {
                n2 = this._inputBuffer[this._inputPtr] & 0xFF;
                if (n2 < 48 || n2 > 57) {
                    return 48;
                }
                ++this._inputPtr;
                if (n2 == 48) continue;
            }
        }
        return n2;
    }

    private final JsonToken a(char[] cArray, int n2, int n3, boolean bl2, int n4) {
        int n5 = 0;
        boolean bl3 = false;
        if (n3 == 46) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl3 = true;
                    break;
                }
                if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n3 > 57) break;
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
            }
            if (n5 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                this._reportUnexpectedNumberChar(n3, "Decimal point not followed by a digit");
            }
        }
        int n6 = 0;
        if ((n3 | 0x20) == 101) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) == 45 || n3 == 43) {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                if (this._inputPtr >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                }
                n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            while (n3 >= 48 && n3 <= 57) {
                ++n6;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl3 = true;
                    break;
                }
                n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            if (n6 == 0) {
                this._reportUnexpectedNumberChar(n3, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl3) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this.b(n3);
            }
        }
        this._textBuffer.setCurrentLength(n2);
        return this.resetFloat(bl2, n4, n5, n6);
    }

    private final void b(int n2) {
        ++this._inputPtr;
        switch (n2) {
            case 9: 
            case 32: {
                return;
            }
            case 13: {
                --this._inputPtr;
                return;
            }
            case 10: {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
        }
        this._reportMissingRootWS(n2);
    }

    protected final String _parseName(int n2) {
        int n3;
        if (n2 != 34) {
            return this._handleOddName(n2);
        }
        if (this._inputPtr + 13 > this._inputEnd) {
            return this.slowParseName();
        }
        int[] nArray = INPUT_CODES_LATIN1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] == 0) {
            if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                n3 = n3 << 8 | n2;
                if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                    n3 = n3 << 8 | n2;
                    if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                        n3 = n3 << 8 | n2;
                        if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                            this.a = n3;
                            return this.parseMediumName(n2);
                        }
                        if (n2 == 34) {
                            return this.a(n3, 4);
                        }
                        return this.a(n3, n2, 4);
                    }
                    if (n2 == 34) {
                        return this.a(n3, 3);
                    }
                    return this.a(n3, n2, 3);
                }
                if (n2 == 34) {
                    return this.a(n3, 2);
                }
                return this.a(n3, n2, 2);
            }
            if (n2 == 34) {
                return this.a(n3, 1);
            }
            return this.a(n3, n2, 1);
        }
        if (n3 == 34) {
            return "";
        }
        return this.a(0, n3, 0);
    }

    protected final String parseMediumName(int n2) {
        int n3;
        int[] nArray = INPUT_CODES_LATIN1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.b(uTF8StreamJsonParser.a, n2, 1);
            }
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            return uTF8StreamJsonParser.a(uTF8StreamJsonParser.a, n2, n3, 1);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.b(uTF8StreamJsonParser.a, n2, 2);
            }
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            return uTF8StreamJsonParser.a(uTF8StreamJsonParser.a, n2, n3, 2);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.b(uTF8StreamJsonParser.a, n2, 3);
            }
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            return uTF8StreamJsonParser.a(uTF8StreamJsonParser.a, n2, n3, 3);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.b(uTF8StreamJsonParser.a, n2, 4);
            }
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            return uTF8StreamJsonParser.a(uTF8StreamJsonParser.a, n2, n3, 4);
        }
        return this.parseMediumName2(n3, n2);
    }

    protected final String parseMediumName2(int n2, int n3) {
        int n4;
        int[] nArray = INPUT_CODES_LATIN1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n4 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n4 == 34) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.b(uTF8StreamJsonParser.a, n3, n2, 1);
            }
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            return uTF8StreamJsonParser.a(uTF8StreamJsonParser.a, n3, n2, n4, 1);
        }
        n2 = n2 << 8 | n4;
        if (nArray[n4 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n4 == 34) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.b(uTF8StreamJsonParser.a, n3, n2, 2);
            }
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            return uTF8StreamJsonParser.a(uTF8StreamJsonParser.a, n3, n2, n4, 2);
        }
        n2 = n2 << 8 | n4;
        if (nArray[n4 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n4 == 34) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.b(uTF8StreamJsonParser.a, n3, n2, 3);
            }
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            return uTF8StreamJsonParser.a(uTF8StreamJsonParser.a, n3, n2, n4, 3);
        }
        n2 = n2 << 8 | n4;
        if (nArray[n4 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n4 == 34) {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.b(uTF8StreamJsonParser.a, n3, n2, 4);
            }
            UTF8StreamJsonParser uTF8StreamJsonParser = this;
            return uTF8StreamJsonParser.a(uTF8StreamJsonParser.a, n3, n2, n4, 4);
        }
        return this.parseLongName(n4, n3, n2);
    }

    protected final String parseLongName(int n2, int n3, int n4) {
        this._quadBuffer[0] = this.a;
        this._quadBuffer[1] = n3;
        this._quadBuffer[2] = n4;
        byte[] byArray = this._inputBuffer;
        int[] nArray = INPUT_CODES_LATIN1;
        int n5 = 3;
        while (this._inputPtr + 4 <= this._inputEnd) {
            int n6;
            if (nArray[n6 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n6 == 34) {
                    UTF8StreamJsonParser uTF8StreamJsonParser = this;
                    return uTF8StreamJsonParser.a(uTF8StreamJsonParser._quadBuffer, n5, n2, 1);
                }
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.parseEscapedName(uTF8StreamJsonParser._quadBuffer, n5, n2, n6, 1);
            }
            n2 = n2 << 8 | n6;
            if (nArray[n6 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n6 == 34) {
                    UTF8StreamJsonParser uTF8StreamJsonParser = this;
                    return uTF8StreamJsonParser.a(uTF8StreamJsonParser._quadBuffer, n5, n2, 2);
                }
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.parseEscapedName(uTF8StreamJsonParser._quadBuffer, n5, n2, n6, 2);
            }
            n2 = n2 << 8 | n6;
            if (nArray[n6 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n6 == 34) {
                    UTF8StreamJsonParser uTF8StreamJsonParser = this;
                    return uTF8StreamJsonParser.a(uTF8StreamJsonParser._quadBuffer, n5, n2, 3);
                }
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.parseEscapedName(uTF8StreamJsonParser._quadBuffer, n5, n2, n6, 3);
            }
            n2 = n2 << 8 | n6;
            if (nArray[n6 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n6 == 34) {
                    UTF8StreamJsonParser uTF8StreamJsonParser = this;
                    return uTF8StreamJsonParser.a(uTF8StreamJsonParser._quadBuffer, n5, n2, 4);
                }
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser.parseEscapedName(uTF8StreamJsonParser._quadBuffer, n5, n2, n6, 4);
            }
            if (n5 >= this._quadBuffer.length) {
                this._quadBuffer = this._growNameDecodeBuffer(this._quadBuffer, n5);
            }
            this._quadBuffer[n5++] = n2;
            n2 = n6;
        }
        UTF8StreamJsonParser uTF8StreamJsonParser = this;
        return uTF8StreamJsonParser.parseEscapedName(uTF8StreamJsonParser._quadBuffer, n5, 0, n2, 0);
    }

    protected String slowParseName() {
        int n2;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(": was expecting closing '\"' for name", JsonToken.FIELD_NAME);
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 34) {
            return "";
        }
        UTF8StreamJsonParser uTF8StreamJsonParser = this;
        return uTF8StreamJsonParser.parseEscapedName(uTF8StreamJsonParser._quadBuffer, 0, 0, n2, 0);
    }

    private final String a(int n2, int n3, int n4) {
        UTF8StreamJsonParser uTF8StreamJsonParser = this;
        return uTF8StreamJsonParser.parseEscapedName(uTF8StreamJsonParser._quadBuffer, 0, n2, n3, n4);
    }

    private final String a(int n2, int n3, int n4, int n5) {
        this._quadBuffer[0] = n2;
        UTF8StreamJsonParser uTF8StreamJsonParser = this;
        return uTF8StreamJsonParser.parseEscapedName(uTF8StreamJsonParser._quadBuffer, 1, n3, n4, n5);
    }

    private final String a(int n2, int n3, int n4, int n5, int n6) {
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        UTF8StreamJsonParser uTF8StreamJsonParser = this;
        return uTF8StreamJsonParser.parseEscapedName(uTF8StreamJsonParser._quadBuffer, 2, n4, n5, n6);
    }

    protected final String parseEscapedName(int[] nArray, int n2, int n3, int n4, int n5) {
        String string;
        int[] nArray2 = INPUT_CODES_LATIN1;
        while (true) {
            if (nArray2[n4] != 0) {
                if (n4 == 34) break;
                if (n4 != 92) {
                    this._throwUnquotedSpace(n4, "name");
                } else {
                    n4 = this._decodeEscaped();
                }
                if (n4 > 127) {
                    if (n5 >= 4) {
                        if (n2 >= nArray.length) {
                            nArray = this._growNameDecodeBuffer(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n5 = 0;
                    }
                    if (n4 < 2048) {
                        n3 = n3 << 8 | (0xC0 | n4 >> 6);
                        ++n5;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n4 >> 12);
                        if (++n5 >= 4) {
                            if (n2 >= nArray.length) {
                                nArray = this._growNameDecodeBuffer(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n5 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n4 >> 6 & 0x3F);
                        ++n5;
                    }
                    n4 = 0x80 | n4 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n3 = n3 << 8 | n4;
            } else {
                if (n2 >= nArray.length) {
                    nArray = this._growNameDecodeBuffer(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n2++] = n3;
                n3 = n4;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            n4 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n5 > 0) {
            if (n2 >= nArray.length) {
                nArray = this._growNameDecodeBuffer(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n2++] = UTF8StreamJsonParser.b(n3, n5);
        }
        if ((string = this._symbols.findName(nArray, n2)) == null) {
            string = this.a(nArray, n2, n5);
        }
        return string;
    }

    protected String _handleOddName(int n2) {
        String string;
        int[] nArray;
        if (n2 == 39 && (this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
            return this._parseAposName();
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            char c2 = (char)this._decodeCharForError(n2);
            this._reportUnexpectedChar(c2, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n2] != 0) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
            } else {
                if (n3 >= nArray2.length) {
                    this._quadBuffer = nArray2 = this._growNameDecodeBuffer(nArray2, nArray2.length);
                }
                nArray2[n3++] = n4;
                n4 = n2;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            if (nArray[n2 = this._inputBuffer[this._inputPtr] & 0xFF] != 0) break;
            ++this._inputPtr;
        }
        if (n5 > 0) {
            if (n3 >= nArray2.length) {
                this._quadBuffer = nArray2 = this._growNameDecodeBuffer(nArray2, nArray2.length);
            }
            nArray2[n3++] = n4;
        }
        if ((string = this._symbols.findName(nArray2, n3)) == null) {
            string = this.a(nArray2, n3, n5);
        }
        return string;
    }

    protected String _parseAposName() {
        String string;
        int n2;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(": was expecting closing ''' for field name", JsonToken.FIELD_NAME);
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 39) {
            return "";
        }
        int[] nArray = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray2 = INPUT_CODES_LATIN1;
        while (n2 != 39) {
            if (nArray2[n2] != 0 && n2 != 34) {
                if (n2 != 92) {
                    this._throwUnquotedSpace(n2, "name");
                } else {
                    n2 = this._decodeEscaped();
                }
                if (n2 > 127) {
                    if (n5 >= 4) {
                        if (n3 >= nArray.length) {
                            this._quadBuffer = nArray = this._growNameDecodeBuffer(nArray, nArray.length);
                        }
                        nArray[n3++] = n4;
                        n4 = 0;
                        n5 = 0;
                    }
                    if (n2 < 2048) {
                        n4 = n4 << 8 | (0xC0 | n2 >> 6);
                        ++n5;
                    } else {
                        n4 = n4 << 8 | (0xE0 | n2 >> 12);
                        if (++n5 >= 4) {
                            if (n3 >= nArray.length) {
                                this._quadBuffer = nArray = this._growNameDecodeBuffer(nArray, nArray.length);
                            }
                            nArray[n3++] = n4;
                            n4 = 0;
                            n5 = 0;
                        }
                        n4 = n4 << 8 | (0x80 | n2 >> 6 & 0x3F);
                        ++n5;
                    }
                    n2 = 0x80 | n2 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
            } else {
                if (n3 >= nArray.length) {
                    this._quadBuffer = nArray = this._growNameDecodeBuffer(nArray, nArray.length);
                }
                nArray[n3++] = n4;
                n4 = n2;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n5 > 0) {
            if (n3 >= nArray.length) {
                this._quadBuffer = nArray = this._growNameDecodeBuffer(nArray, nArray.length);
            }
            nArray[n3++] = UTF8StreamJsonParser.b(n4, n5);
        }
        if ((string = this._symbols.findName(nArray, n3)) == null) {
            string = this.a(nArray, n3, n5);
        }
        return string;
    }

    private final String a(int n2, int n3) {
        String string = this._symbols.findName(n2 = UTF8StreamJsonParser.b(n2, n3));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n2;
        UTF8StreamJsonParser uTF8StreamJsonParser = this;
        return uTF8StreamJsonParser.a(uTF8StreamJsonParser._quadBuffer, 1, n3);
    }

    private final String b(int n2, int n3, int n4) {
        String string = this._symbols.findName(n2, n3 = UTF8StreamJsonParser.b(n3, n4));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        UTF8StreamJsonParser uTF8StreamJsonParser = this;
        return uTF8StreamJsonParser.a(uTF8StreamJsonParser._quadBuffer, 2, n4);
    }

    private final String b(int n2, int n3, int n4, int n5) {
        Object object = this._symbols.findName(n2, n3, n4 = UTF8StreamJsonParser.b(n4, n5));
        if (object != null) {
            return object;
        }
        object = this._quadBuffer;
        this._quadBuffer[0] = n2;
        object[1] = n3;
        object[2] = UTF8StreamJsonParser.b(n4, n5);
        return this.a((int[])object, 3, n5);
    }

    private final String a(int[] nArray, int n2, int n3, int n4) {
        if (n2 >= nArray.length) {
            nArray = this._growNameDecodeBuffer(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n2++] = UTF8StreamJsonParser.b(n3, n4);
        String string = this._symbols.findName(nArray, n2);
        if (string == null) {
            return this.a(nArray, n2, n4);
        }
        return string;
    }

    private final String a(int[] nArray, int n2, int n3) {
        int n4;
        int n5 = (n2 << 2) - 4 + n3;
        this._streamReadConstraints.validateNameLength(n5);
        if (n3 < 4) {
            n4 = nArray[n2 - 1];
            nArray[n2 - 1] = n4 << (4 - n3 << 3);
        } else {
            n4 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            int n8 = nArray[n7 >> 2];
            int n9 = n7 & 3;
            n8 = n8 >> (3 - n9 << 3) & 0xFF;
            ++n7;
            if (n8 > 127) {
                int n10;
                if ((n8 & 0xE0) == 192) {
                    n8 &= 0x1F;
                    n10 = 1;
                } else if ((n8 & 0xF0) == 224) {
                    n8 &= 0xF;
                    n10 = 2;
                } else if ((n8 & 0xF8) == 240) {
                    n8 &= 7;
                    n10 = 3;
                } else {
                    this._reportInvalidInitial(n8);
                    n8 = 1;
                    n10 = 1;
                }
                if (n7 + n10 > n5) {
                    this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
                }
                int n11 = nArray[n7 >> 2];
                n9 = n7 & 3;
                ++n7;
                if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n11);
                }
                n8 = n8 << 6 | n11 & 0x3F;
                if (n10 > 1) {
                    n11 = nArray[n7 >> 2];
                    n9 = n7 & 3;
                    ++n7;
                    if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n11);
                    }
                    n8 = n8 << 6 | n11 & 0x3F;
                    if (n10 > 2) {
                        n11 = nArray[n7 >> 2];
                        n9 = n7 & 3;
                        ++n7;
                        if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n11 & 0xFF);
                        }
                        n8 = n8 << 6 | n11 & 0x3F;
                    }
                }
                if (n10 > 2) {
                    n8 -= 65536;
                    if (n6 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n6++] = (char)(55296 + (n8 >> 10));
                    n8 = 0xDC00 | n8 & 0x3FF;
                }
            }
            if (n6 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n6++] = (char)n8;
        }
        String string = new String(cArray, 0, n6);
        if (n3 < 4) {
            nArray[n2 - 1] = n4;
        }
        return this._symbols.addName(string, nArray, n2);
    }

    private static final int b(int n2, int n3) {
        if (n3 == 4) {
            return n2;
        }
        return n2 | -1 << (n3 << 3);
    }

    protected void _loadMoreGuaranteed() {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    @Override
    protected void _finishString() {
        int n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this._loadMoreGuaranteed();
            n2 = this._inputPtr;
        }
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = INPUT_CODES_UTF8;
        int n4 = Math.min(this._inputEnd, n2 + cArray.length);
        byte[] byArray = this._inputBuffer;
        while (n2 < n4) {
            int n5 = byArray[n2] & 0xFF;
            if (nArray[n5] != 0) {
                if (n5 != 34) break;
                this._inputPtr = n2 + 1;
                this._textBuffer.setCurrentLength(n3);
                return;
            }
            ++n2;
            cArray[n3++] = (char)n5;
        }
        this._inputPtr = n2;
        this.a(cArray, n3);
    }

    protected String _finishAndReturnString() {
        int n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this._loadMoreGuaranteed();
            n2 = this._inputPtr;
        }
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = INPUT_CODES_UTF8;
        int n4 = Math.min(this._inputEnd, n2 + cArray.length);
        byte[] byArray = this._inputBuffer;
        while (n2 < n4) {
            int n5 = byArray[n2] & 0xFF;
            if (nArray[n5] != 0) {
                if (n5 != 34) break;
                this._inputPtr = n2 + 1;
                return this._textBuffer.setCurrentAndReturn(n3);
            }
            ++n2;
            cArray[n3++] = (char)n5;
        }
        this._inputPtr = n2;
        this.a(cArray, n3);
        return this._textBuffer.contentsAsString();
    }

    private final void a(char[] cArray, int n2) {
        int[] nArray = INPUT_CODES_UTF8;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n3;
            int n4;
            block15: {
                if ((n4 = this._inputPtr) >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                    n4 = this._inputPtr;
                }
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                int n5 = Math.min(this._inputEnd, InternalJacksonUtil.addOverflowSafe(n4, cArray.length - n2));
                while (n4 < n5) {
                    if (nArray[n3 = byArray[n4++] & 0xFF] == 0) {
                        cArray[n2++] = (char)n3;
                        continue;
                    }
                    break block15;
                }
                this._inputPtr = n4;
                continue;
            }
            this._inputPtr = n4;
            if (n3 == 34) break;
            switch (nArray[n3]) {
                case 1: {
                    n3 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n3 = this.c(n3);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n3 = this.e(n3);
                        break;
                    }
                    n3 = this.d(n3);
                    break;
                }
                case 4: {
                    n3 = this.f(n3);
                    cArray[n2++] = (char)(0xD800 | n3 >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n3 = 0xDC00 | n3 & 0x3FF;
                    break;
                }
                default: {
                    if (n3 < 32) {
                        this._throwUnquotedSpace(n3, "string value");
                        break;
                    }
                    this._reportInvalidChar(n3);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    protected void _skipString() {
        this._tokenIncomplete = false;
        int[] nArray = INPUT_CODES_UTF8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n2;
            int n3;
            block10: {
                int n4;
                if ((n3 = this._inputPtr) >= (n4 = this._inputEnd)) {
                    this._loadMoreGuaranteed();
                    n3 = this._inputPtr;
                    n4 = this._inputEnd;
                }
                while (n3 < n4) {
                    if (nArray[n2 = byArray[n3++] & 0xFF] == 0) continue;
                    break block10;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this.l();
                    continue block6;
                }
                case 3: {
                    this.m();
                    continue block6;
                }
                case 4: {
                    this.n();
                    continue block6;
                }
            }
            if (n2 < 32) {
                this._throwUnquotedSpace(n2, "string value");
                continue;
            }
            this._reportInvalidChar(n2);
        }
    }

    protected JsonToken _handleUnexpectedValue(int n2) {
        switch (n2) {
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (!this._parsingContext.inRoot() && (this._features & FEAT_MASK_ALLOW_MISSING) != 0) {
                    --this._inputPtr;
                    return JsonToken.VALUE_NULL;
                }
            }
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 39: {
                if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) == 0) break;
                return this._handleApos();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
                }
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser._handleInvalidNumberStart(uTF8StreamJsonParser._inputBuffer[this._inputPtr++] & 0xFF, false, true);
            }
        }
        if (Character.isJavaIdentifierStart(n2)) {
            this._reportInvalidToken("" + (char)n2, this._validJsonTokenList());
        }
        this._reportUnexpectedChar(n2, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    protected JsonToken _handleApos() {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = INPUT_CODES_UTF8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n3 = this._inputEnd;
            int n4 = InternalJacksonUtil.addOverflowSafe(this._inputPtr, cArray.length - n2);
            if (n4 < n3) {
                n3 = n4;
            }
            while (true) {
                if (this._inputPtr >= n3) continue block6;
                if ((n4 = byArray[this._inputPtr++] & 0xFF) == 39) break block6;
                if (nArray[n4] != 0 && n4 != 34) break;
                cArray[n2++] = (char)n4;
            }
            switch (nArray[n4]) {
                case 1: {
                    n4 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n4 = this.c(n4);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n4 = this.e(n4);
                        break;
                    }
                    n4 = this.d(n4);
                    break;
                }
                case 4: {
                    n4 = this.f(n4);
                    cArray[n2++] = (char)(0xD800 | n4 >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n4 = 0xDC00 | n4 & 0x3FF;
                    break;
                }
                default: {
                    if (n4 < 32) {
                        this._throwUnquotedSpace(n4, "string value");
                    }
                    this._reportInvalidChar(n4);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n4;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2) {
        return this._handleInvalidNumberStart(n2, bl2, false);
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2, boolean bl3) {
        String string;
        while (n2 == 73) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_FLOAT);
            }
            if ((n2 = this._inputBuffer[this._inputPtr++]) == 78) {
                string = bl2 ? "-INF" : "+INF";
            } else {
                if (n2 != 110) break;
                string = bl2 ? "-Infinity" : "+Infinity";
            }
            this._matchToken(string, 3);
            if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                return this.resetAsNaN(string, bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            this._reportError("Non-standard token '%s': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow", string);
        }
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()) && bl3 && !bl2) {
            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
        }
        string = bl2 ? "expected digit (0-9) to follow minus sign, for valid numeric value" : "expected digit (0-9) for valid numeric value";
        this._reportUnexpectedNumberChar(n2, string);
        return null;
    }

    protected final void _matchTrue() {
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd) {
            int n3;
            byte[] byArray = this._inputBuffer;
            if (this._inputBuffer[n2++] == 114 && byArray[n2++] == 117 && byArray[n2++] == 101 && ((n3 = byArray[n2] & 0xFF) < 48 || (n3 | 0x20) == 125)) {
                this._inputPtr = n2;
                return;
            }
        }
        this.a("true", 1);
    }

    protected final void _matchFalse() {
        int n2 = this._inputPtr;
        if (n2 + 4 < this._inputEnd) {
            int n3;
            byte[] byArray = this._inputBuffer;
            if (this._inputBuffer[n2++] == 97 && byArray[n2++] == 108 && byArray[n2++] == 115 && byArray[n2++] == 101 && ((n3 = byArray[n2] & 0xFF) < 48 || (n3 | 0x20) == 125)) {
                this._inputPtr = n2;
                return;
            }
        }
        this.a("false", 1);
    }

    protected final void _matchNull() {
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd) {
            int n3;
            byte[] byArray = this._inputBuffer;
            if (this._inputBuffer[n2++] == 117 && byArray[n2++] == 108 && byArray[n2++] == 108 && ((n3 = byArray[n2] & 0xFF) < 48 || (n3 | 0x20) == 125)) {
                this._inputPtr = n2;
                return;
            }
        }
        this.a("null", 1);
    }

    protected final void _matchToken(String string, int n2) {
        int n3 = string.length();
        if (this._inputPtr + n3 >= this._inputEnd) {
            this.a(string, n2);
            return;
        }
        do {
            if (this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2));
            }
            ++this._inputPtr;
        } while (++n2 < n3);
        n3 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n3 >= 48 && n3 != 93 && n3 != 125) {
            this.a(string, n2, n3);
        }
    }

    private final void a(String string, int n2) {
        int n3 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this._loadMore() || this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2));
            }
            ++this._inputPtr;
        } while (++n2 < n3);
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return;
        }
        n3 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n3 >= 48 && n3 != 93 && n3 != 125) {
            this.a(string, n2, n3);
        }
    }

    private final void a(String string, int n2, int n3) {
        char c2 = (char)this._decodeCharForError(n3);
        n3 = c2;
        if (Character.isJavaIdentifierPart(c2)) {
            this._reportInvalidToken(string.substring(0, n2));
        }
    }

    private final int c() {
        while (this._inputPtr < this._inputEnd) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47 || n2 == 35) {
                    --this._inputPtr;
                    return this.d();
                }
                return n2;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this.d();
    }

    private final int d() {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47) {
                    this.h();
                    continue;
                }
                if (n2 == 35 && this.j()) continue;
                return n2;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.typeDesc() + " entries");
    }

    private final int e() {
        int n2;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextChar();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
            if (n2 == 47 || n2 == 35) {
                --this._inputPtr;
                return this.f();
            }
            return n2;
        }
        if (n2 != 32) {
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
            } else if (n2 == 13) {
                this._skipCR();
            } else if (n2 != 9) {
                this._throwInvalidSpace(n2);
            }
        }
        while (this._inputPtr < this._inputEnd) {
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47 || n2 == 35) {
                    --this._inputPtr;
                    return this.f();
                }
                return n2;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this.f();
    }

    private final int f() {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47) {
                    this.h();
                    continue;
                }
                if (n2 == 35 && this.j()) continue;
                return n2;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this._eofAsNextChar();
    }

    private final int g() {
        if (this._inputPtr + 4 >= this._inputEnd) {
            return this.b(false);
        }
        byte by = this._inputBuffer[this._inputPtr];
        if (by == 58) {
            if ((by = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by == 47 || by == 35) {
                    return this.b(true);
                }
                ++this._inputPtr;
                return by;
            }
            if ((by == 32 || by == 9) && (by = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by == 47 || by == 35) {
                    return this.b(true);
                }
                ++this._inputPtr;
                return by;
            }
            return this.b(true);
        }
        if (by == 32 || by == 9) {
            by = this._inputBuffer[++this._inputPtr];
        }
        if (by == 58) {
            if ((by = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by == 47 || by == 35) {
                    return this.b(true);
                }
                ++this._inputPtr;
                return by;
            }
            if ((by == 32 || by == 9) && (by = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by == 47 || by == 35) {
                    return this.b(true);
                }
                ++this._inputPtr;
                return by;
            }
            return this.b(true);
        }
        return this.b(false);
    }

    private final int b(boolean bl2) {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47) {
                    this.h();
                    continue;
                }
                if (n2 == 35 && this.j()) continue;
                if (bl2) {
                    return n2;
                }
                if (n2 != 58) {
                    this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
                }
                bl2 = true;
                continue;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidEOF(" within/between " + this._parsingContext.typeDesc() + " entries", null);
        return -1;
    }

    private final void h() {
        int n2;
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in a comment", null);
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 47) {
            this.k();
            return;
        }
        if (n2 == 42) {
            this.i();
            return;
        }
        this._reportUnexpectedChar(n2, "was expecting either '*' or '/' for a comment");
    }

    private final void i() {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n3) {
                case 42: {
                    if (this._inputPtr >= this._inputEnd && !this._loadMore()) break block8;
                    if (this._inputBuffer[this._inputPtr] != 47) continue block8;
                    ++this._inputPtr;
                    return;
                }
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    continue block8;
                }
                case 13: {
                    this._skipCR();
                    continue block8;
                }
                case 2: {
                    this.l();
                    continue block8;
                }
                case 3: {
                    this.m();
                    continue block8;
                }
                case 4: {
                    this.n();
                    continue block8;
                }
                default: {
                    this._reportInvalidChar(n2);
                }
            }
        }
        this._reportInvalidEOF(" in a comment", null);
    }

    private final boolean j() {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            return false;
        }
        this.k();
        return true;
    }

    private final void k() {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n3) {
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    return;
                }
                case 13: {
                    this._skipCR();
                    return;
                }
                case 42: {
                    continue block8;
                }
                case 2: {
                    this.l();
                    continue block8;
                }
                case 3: {
                    this.m();
                    continue block8;
                }
                case 4: {
                    this.n();
                    continue block8;
                }
            }
            if (n3 >= 0) continue;
            this._reportInvalidChar(n2);
        }
    }

    @Override
    protected char _decodeEscaped() {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
        }
        int n2 = this._inputBuffer[this._inputPtr++];
        switch (n2) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)n2;
            }
            case 117: {
                break;
            }
            default: {
                UTF8StreamJsonParser uTF8StreamJsonParser = this;
                return uTF8StreamJsonParser._handleUnrecognizedCharacterEscape((char)uTF8StreamJsonParser._decodeCharForError(n2));
            }
        }
        n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            byte by;
            int n3;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
            }
            if ((n3 = CharTypes.charToHex(by = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(by & 0xFF, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n3;
        }
        return (char)n2;
    }

    protected int _decodeCharForError(int n2) {
        if ((n2 &= 0xFF) > 127) {
            int n3;
            if ((n2 & 0xE0) == 192) {
                n2 &= 0x1F;
                n3 = 1;
            } else if ((n2 & 0xF0) == 224) {
                n2 &= 0xF;
                n3 = 2;
            } else if ((n2 & 0xF8) == 240) {
                n2 &= 7;
                n3 = 3;
            } else {
                this._reportInvalidInitial(n2 & 0xFF);
                n3 = 1;
            }
            int n4 = this.o();
            if ((n4 & 0xC0) != 128) {
                this._reportInvalidOther(n4 & 0xFF);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (n3 > 1) {
                n4 = this.o();
                if ((n4 & 0xC0) != 128) {
                    this._reportInvalidOther(n4 & 0xFF);
                }
                n2 = n2 << 6 | n4 & 0x3F;
                if (n3 > 2) {
                    n4 = this.o();
                    if ((n4 & 0xC0) != 128) {
                        this._reportInvalidOther(n4 & 0xFF);
                    }
                    n2 = n2 << 6 | n4 & 0x3F;
                }
            }
        }
        return n2;
    }

    private final int c(int n2) {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n2 & 0x1F) << 6 | by & 0x3F;
    }

    private final int d(int n2) {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        n2 &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int e(int n2) {
        byte by;
        n2 &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int f(int n2) {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = (n2 & 7) << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n2 << 6 | by & 0x3F) - 65536;
    }

    private final void l() {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    private final void m() {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    private final void n() {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    protected final void _skipCR() {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int o() {
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    protected void _reportInvalidToken(String string, int n2) {
        this._inputPtr = n2;
        this._reportInvalidToken(string, this._validJsonTokenList());
    }

    protected void _reportInvalidToken(String string) {
        this._reportInvalidToken(string, this._validJsonTokenList());
    }

    protected void _reportInvalidToken(String charSequence, String string) {
        charSequence = new StringBuilder((String)charSequence);
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2 = this._inputBuffer[this._inputPtr++];
            if (!Character.isJavaIdentifierPart(c2 = (char)this._decodeCharForError(c2))) break;
            ((StringBuilder)charSequence).append(c2);
            if (((StringBuilder)charSequence).length() < this._ioContext.errorReportConfiguration().getMaxErrorTokenLength()) continue;
            ((StringBuilder)charSequence).append("...");
            break;
        }
        this._reportError("Unrecognized token '%s': was expecting %s", charSequence, string);
    }

    protected void _reportInvalidChar(int n2) {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    protected void _reportInvalidInitial(int n2) {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2) {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2, int n3) {
        this._inputPtr = n3;
        this._reportInvalidOther(n2);
    }

    protected final byte[] _decodeBase64(Base64Variant base64Variant) {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                if (n2 == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n3 = this._decodeBase64Escape(base64Variant, n2, 0);
                if (n3 < 0) continue;
            }
            int n4 = n3;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n3 = base64Variant.decodeBase64Char(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n3 = this._decodeBase64Escape(base64Variant, n2, 1);
            }
            n4 = n4 << 6 | n3;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n3 = base64Variant.decodeBase64Char(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n3 != -2) {
                    if (n2 == 34) {
                        byteArrayBuilder.append(n4 >>= 4);
                        if (base64Variant.requiresPaddingOnRead()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 2);
                }
                if (n3 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n2 = this._inputBuffer[this._inputPtr++] & 0xFF) && this._decodeBase64Escape(base64Variant, n2, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, n2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n4 >>= 4);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n3 = base64Variant.decodeBase64Char(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n3 != -2) {
                    if (n2 == 34) {
                        byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                        if (base64Variant.requiresPaddingOnRead()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 3);
                }
                if (n3 == -2) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
    }

    @Override
    public JsonLocation currentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._contentReference(), this._currInputProcessed + (long)this._inputPtr, -1L, this._currInputRow, n2);
    }

    @Override
    protected JsonLocation _currentLocationMinusOne() {
        int n2 = this._inputPtr - 1;
        int n3 = n2 - this._currInputRowStart + 1;
        return new JsonLocation(this._contentReference(), this._currInputProcessed + (long)n2, -1L, this._currInputRow, n3);
    }

    @Override
    public JsonLocation currentTokenLocation() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            long l2 = this._currInputProcessed + (long)(this._nameStartOffset - 1);
            return new JsonLocation(this._contentReference(), l2, -1L, this._nameStartRow, this._nameStartCol);
        }
        return new JsonLocation(this._contentReference(), this._tokenInputTotal - 1L, -1L, this._tokenInputRow, this._tokenInputCol);
    }

    private final void p() {
        this._tokenInputRow = this._currInputRow;
        int n2 = this._inputPtr;
        this._tokenInputTotal = this._currInputProcessed + (long)n2;
        this._tokenInputCol = n2 - this._currInputRowStart;
    }

    private final void q() {
        int n2;
        this._nameStartRow = this._currInputRow;
        this._nameStartOffset = n2 = this._inputPtr;
        this._nameStartCol = n2 - this._currInputRowStart;
    }

    private final JsonToken g(int n2) {
        if (n2 == 125) {
            this.s();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        this.r();
        this._currToken = JsonToken.END_ARRAY;
        return this._currToken;
    }

    private final void r() {
        this.p();
        if (!this._parsingContext.inArray()) {
            this._reportMismatchedEndMarker(93, '}');
        }
        this._parsingContext = this._parsingContext.clearAndGetParent();
    }

    private final void s() {
        this.p();
        if (!this._parsingContext.inObject()) {
            this._reportMismatchedEndMarker(125, ']');
        }
        this._parsingContext = this._parsingContext.clearAndGetParent();
    }
}

