/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class ByteQuadsCanonicalizer {
    protected static final int MAX_ENTRIES_FOR_REUSE = 6000;
    protected final ByteQuadsCanonicalizer _parent;
    protected final AtomicReference<a> _tableInfo;
    protected final int _seed;
    protected final InternCache _interner;
    protected final boolean _failOnDoS;
    protected int[] _hashArea;
    protected int _hashSize;
    protected int _secondaryStart;
    protected int _tertiaryStart;
    protected int _tertiaryShift;
    protected int _count;
    protected String[] _names;
    protected int _spilloverEnd;
    protected int _longNameOffset;
    protected boolean _hashShared;

    private ByteQuadsCanonicalizer(int n2, int n3) {
        this._parent = null;
        this._count = 0;
        this._hashShared = true;
        this._seed = n3;
        this._interner = null;
        this._failOnDoS = true;
        this._tableInfo = new AtomicReference<a>(a.a(64));
    }

    private ByteQuadsCanonicalizer(ByteQuadsCanonicalizer byteQuadsCanonicalizer, int n2, a a2, boolean bl2, boolean bl3) {
        this._parent = byteQuadsCanonicalizer;
        this._seed = n2;
        this._interner = bl2 ? InternCache.instance : null;
        this._failOnDoS = bl3;
        this._tableInfo = null;
        this._count = a2.b;
        this._hashSize = a2.a;
        this._secondaryStart = this._hashSize << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = a2.c;
        this._hashArea = a2.d;
        this._names = a2.e;
        this._spilloverEnd = a2.f;
        this._longNameOffset = a2.g;
        this._hashShared = true;
    }

    private ByteQuadsCanonicalizer(a a2) {
        int n2;
        this._parent = null;
        this._seed = 0;
        this._interner = null;
        this._failOnDoS = true;
        this._tableInfo = null;
        this._count = -1;
        this._hashArea = a2.d;
        this._names = a2.e;
        this._hashSize = a2.a;
        this._secondaryStart = n2 = this._hashArea.length;
        this._tertiaryStart = n2;
        this._tertiaryShift = 1;
        this._spilloverEnd = n2;
        this._longNameOffset = n2;
        this._hashShared = true;
    }

    public static ByteQuadsCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        int n2 = (int)l2 + (int)(l2 >>> 32) | 1;
        return ByteQuadsCanonicalizer.createRoot(n2);
    }

    protected static ByteQuadsCanonicalizer createRoot(int n2) {
        return new ByteQuadsCanonicalizer(64, n2);
    }

    public final ByteQuadsCanonicalizer makeChild(int n2) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        return new ByteQuadsCanonicalizer(byteQuadsCanonicalizer, byteQuadsCanonicalizer._seed, this._tableInfo.get(), JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(n2), JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(n2));
    }

    public final ByteQuadsCanonicalizer makeChildOrPlaceholder(int n2) {
        if (JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n2)) {
            ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
            return new ByteQuadsCanonicalizer(byteQuadsCanonicalizer, byteQuadsCanonicalizer._seed, this._tableInfo.get(), JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(n2), JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(n2));
        }
        return new ByteQuadsCanonicalizer(this._tableInfo.get());
    }

    public final void release() {
        if (this._parent != null && this.maybeDirty()) {
            a a2 = new a(this);
            ByteQuadsCanonicalizer byteQuadsCanonicalizer = this._parent;
            int n2 = a2.b;
            a a3 = byteQuadsCanonicalizer._tableInfo.get();
            if (n2 != a3.b) {
                if (n2 > 6000) {
                    a2 = a.a(64);
                }
                byteQuadsCanonicalizer._tableInfo.compareAndSet(a3, a2);
            }
            this._hashShared = true;
        }
    }

    public final int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().b;
        }
        return this._count;
    }

    public final int bucketCount() {
        return this._hashSize;
    }

    public final boolean maybeDirty() {
        return !this._hashShared;
    }

    public final int hashSeed() {
        return this._seed;
    }

    public final boolean isCanonicalizing() {
        return this._parent != null;
    }

    public final int primaryCount() {
        int n2 = 0;
        int n3 = this._secondaryStart;
        for (int i2 = 3; i2 < n3; i2 += 4) {
            if (this._hashArea[i2] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public final int secondaryCount() {
        int n2 = 0;
        int n3 = this._tertiaryStart;
        for (int i2 = this._secondaryStart + 3; i2 < n3; i2 += 4) {
            if (this._hashArea[i2] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public final int tertiaryCount() {
        int n2;
        int n3 = 0;
        int n4 = n2 + this._hashSize;
        for (n2 = this._tertiaryStart + 3; n2 < n4; n2 += 4) {
            if (this._hashArea[n2] == 0) continue;
            ++n3;
        }
        return n3;
    }

    public final int spilloverCount() {
        return this._spilloverEnd - this.d() >> 2;
    }

    public final int totalCount() {
        int n2 = 0;
        int n3 = this._hashSize << 3;
        for (int i2 = 3; i2 < n3; i2 += 4) {
            if (this._hashArea[i2] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public final String toString() {
        int n2 = this.primaryCount();
        int n3 = this.secondaryCount();
        int n4 = this.tertiaryCount();
        int n5 = this.spilloverCount();
        int n6 = this.totalCount();
        return String.format("[%s: size=%d, hashSize=%d, %d/%d/%d/%d pri/sec/ter/spill (=%s), total:%d]", this.getClass().getName(), this._count, this._hashSize, n2, n3, n4, n5, n2 + n3 + n4 + n5, n6);
    }

    public final String findName(int n2) {
        block12: {
            int n3;
            ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
            int n4 = byteQuadsCanonicalizer.b(byteQuadsCanonicalizer.calcHash(n2));
            int[] nArray = this._hashArea;
            int n5 = this._hashArea[n4 + 3];
            if (n5 == 1) {
                if (nArray[n4] == n2) {
                    return this._names[n4 >> 2];
                }
            } else if (n5 == 0) {
                return null;
            }
            if ((n5 = nArray[(n3 = this._secondaryStart + (n4 >> 3 << 2)) + 3]) == 1) {
                if (nArray[n3] == n2) {
                    return this._names[n3 >> 2];
                }
            } else if (n5 == 0) {
                return null;
            }
            int n6 = n2;
            ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = this;
            int[] nArray2 = byteQuadsCanonicalizer2._hashArea;
            n3 = 1 << byteQuadsCanonicalizer2._tertiaryShift;
            n3 = n4 + n3;
            for (n4 = byteQuadsCanonicalizer2._tertiaryStart + (n4 >> byteQuadsCanonicalizer2._tertiaryShift + 2 << byteQuadsCanonicalizer2._tertiaryShift); n4 < n3; n4 += 4) {
                int n7 = nArray2[n4 + 3];
                if (n6 == nArray2[n4] && 1 == n7) {
                    return byteQuadsCanonicalizer2._names[n4 >> 2];
                }
                if (n7 != 0) {
                    continue;
                }
                break block12;
            }
            for (n4 = byteQuadsCanonicalizer2.d(); n4 < byteQuadsCanonicalizer2._spilloverEnd; n4 += 4) {
                if (n6 != nArray2[n4] || 1 != nArray2[n4 + 3]) continue;
                return byteQuadsCanonicalizer2._names[n4 >> 2];
            }
        }
        return null;
    }

    public final String findName(int n2, int n3) {
        block12: {
            int n4;
            ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
            int n5 = byteQuadsCanonicalizer.b(byteQuadsCanonicalizer.calcHash(n2, n3));
            int[] nArray = this._hashArea;
            int n6 = this._hashArea[n5 + 3];
            if (n6 == 2) {
                if (n2 == nArray[n5] && n3 == nArray[n5 + 1]) {
                    return this._names[n5 >> 2];
                }
            } else if (n6 == 0) {
                return null;
            }
            if ((n6 = nArray[(n4 = this._secondaryStart + (n5 >> 3 << 2)) + 3]) == 2) {
                if (n2 == nArray[n4] && n3 == nArray[n4 + 1]) {
                    return this._names[n4 >> 2];
                }
            } else if (n6 == 0) {
                return null;
            }
            int n7 = n5;
            int n8 = n3;
            n5 = n2;
            n3 = n7;
            ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = this;
            int[] nArray2 = byteQuadsCanonicalizer2._hashArea;
            n4 = 1 << byteQuadsCanonicalizer2._tertiaryShift;
            n4 = n3 + n4;
            for (n3 = byteQuadsCanonicalizer2._tertiaryStart + (n3 >> byteQuadsCanonicalizer2._tertiaryShift + 2 << byteQuadsCanonicalizer2._tertiaryShift); n3 < n4; n3 += 4) {
                int n9 = nArray2[n3 + 3];
                if (n5 == nArray2[n3] && n8 == nArray2[n3 + 1] && 2 == n9) {
                    return byteQuadsCanonicalizer2._names[n3 >> 2];
                }
                if (n9 != 0) {
                    continue;
                }
                break block12;
            }
            for (n3 = byteQuadsCanonicalizer2.d(); n3 < byteQuadsCanonicalizer2._spilloverEnd; n3 += 4) {
                if (n5 != nArray2[n3] || n8 != nArray2[n3 + 1] || 2 != nArray2[n3 + 3]) continue;
                return byteQuadsCanonicalizer2._names[n3 >> 2];
            }
        }
        return null;
    }

    public final String findName(int n2, int n3, int n4) {
        block12: {
            int n5;
            ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
            int n6 = byteQuadsCanonicalizer.b(byteQuadsCanonicalizer.calcHash(n2, n3, n4));
            int[] nArray = this._hashArea;
            int n7 = this._hashArea[n6 + 3];
            if (n7 == 3) {
                if (n2 == nArray[n6] && nArray[n6 + 1] == n3 && nArray[n6 + 2] == n4) {
                    return this._names[n6 >> 2];
                }
            } else if (n7 == 0) {
                return null;
            }
            if ((n7 = nArray[(n5 = this._secondaryStart + (n6 >> 3 << 2)) + 3]) == 3) {
                if (n2 == nArray[n5] && nArray[n5 + 1] == n3 && nArray[n5 + 2] == n4) {
                    return this._names[n5 >> 2];
                }
            } else if (n7 == 0) {
                return null;
            }
            int n8 = n6;
            int n9 = n4;
            n6 = n3;
            n4 = n2;
            n3 = n8;
            ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = this;
            int[] nArray2 = byteQuadsCanonicalizer2._hashArea;
            n5 = 1 << byteQuadsCanonicalizer2._tertiaryShift;
            n5 = n3 + n5;
            for (n3 = byteQuadsCanonicalizer2._tertiaryStart + (n3 >> byteQuadsCanonicalizer2._tertiaryShift + 2 << byteQuadsCanonicalizer2._tertiaryShift); n3 < n5; n3 += 4) {
                int n10 = nArray2[n3 + 3];
                if (n4 == nArray2[n3] && n6 == nArray2[n3 + 1] && n9 == nArray2[n3 + 2] && 3 == n10) {
                    return byteQuadsCanonicalizer2._names[n3 >> 2];
                }
                if (n10 != 0) {
                    continue;
                }
                break block12;
            }
            for (n3 = byteQuadsCanonicalizer2.d(); n3 < byteQuadsCanonicalizer2._spilloverEnd; n3 += 4) {
                if (n4 != nArray2[n3] || n6 != nArray2[n3 + 1] || n9 != nArray2[n3 + 2] || 3 != nArray2[n3 + 3]) continue;
                return byteQuadsCanonicalizer2._names[n3 >> 2];
            }
        }
        return null;
    }

    public final String findName(int[] object, int n2) {
        block13: {
            if (n2 < 4) {
                switch (n2) {
                    case 3: {
                        return this.findName(object[0], object[1], object[2]);
                    }
                    case 2: {
                        return this.findName(object[0], object[1]);
                    }
                    case 1: {
                        return this.findName(object[0]);
                    }
                }
                return "";
            }
            int n3 = this.calcHash((int[])object, n2);
            int n4 = this.b(n3);
            int[] nArray = this._hashArea;
            int n5 = this._hashArea[n4 + 3];
            if (n3 == nArray[n4] && n5 == n2 && this.a((int[])object, n2, nArray[n4 + 1])) {
                return this._names[n4 >> 2];
            }
            if (n5 == 0) {
                return null;
            }
            n5 = this._secondaryStart + (n4 >> 3 << 2);
            int n6 = nArray[n5 + 3];
            if (n3 == nArray[n5] && n6 == n2 && this.a((int[])object, n2, nArray[n5 + 1])) {
                return this._names[n5 >> 2];
            }
            int n7 = n2;
            int[] nArray2 = object;
            n2 = n4;
            object = this;
            int[] nArray3 = ((ByteQuadsCanonicalizer)object)._hashArea;
            n6 = 1 << ((ByteQuadsCanonicalizer)object)._tertiaryShift;
            n6 = n2 + n6;
            for (n2 = (v1113217)._tertiaryStart + (n2 >> ((ByteQuadsCanonicalizer)object)._tertiaryShift + 2 << ((ByteQuadsCanonicalizer)object)._tertiaryShift); n2 < n6; n2 += 4) {
                int n8 = nArray3[n2 + 3];
                if (n3 == nArray3[n2] && n7 == n8 && super.a(nArray2, n7, nArray3[n2 + 1])) {
                    return ((ByteQuadsCanonicalizer)object)._names[n2 >> 2];
                }
                if (n8 != 0) {
                    continue;
                }
                break block13;
            }
            for (n2 = super.d(); n2 < ((ByteQuadsCanonicalizer)object)._spilloverEnd; n2 += 4) {
                if (n3 != nArray3[n2] || n7 != nArray3[n2 + 3] || !super.a(nArray2, n7, nArray3[n2 + 1])) continue;
                return ((ByteQuadsCanonicalizer)object)._names[n2 >> 2];
            }
        }
        return null;
    }

    private final int b(int n2) {
        return (n2 &= this._hashSize - 1) << 2;
    }

    private boolean a(int[] nArray, int n2, int n3) {
        int[] nArray2 = this._hashArea;
        int n4 = 0;
        switch (n2) {
            default: {
                return this.b(nArray, n2, n3);
            }
            case 8: {
                ++n4;
                if (nArray[0] != nArray2[n3++]) {
                    return false;
                }
            }
            case 7: {
                if (nArray[n4++] != nArray2[n3++]) {
                    return false;
                }
            }
            case 6: {
                if (nArray[n4++] != nArray2[n3++]) {
                    return false;
                }
            }
            case 5: {
                if (nArray[n4++] == nArray2[n3++]) break;
                return false;
            }
            case 4: 
        }
        if (nArray[n4++] != nArray2[n3++]) {
            return false;
        }
        if (nArray[n4++] != nArray2[n3++]) {
            return false;
        }
        if (nArray[n4++] != nArray2[n3++]) {
            return false;
        }
        return nArray[n4] == nArray2[n3];
    }

    private boolean b(int[] nArray, int n2, int n3) {
        int n4 = 0;
        do {
            if (nArray[n4++] == this._hashArea[n3++]) continue;
            return false;
        } while (n4 < n2);
        return true;
    }

    public final String addName(String string, int n2) {
        this.a();
        if (this._interner != null) {
            string = this._interner.intern(string);
        }
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n3 = byteQuadsCanonicalizer.c(byteQuadsCanonicalizer.calcHash(n2));
        this._hashArea[n3] = n2;
        this._hashArea[n3 + 3] = 1;
        this._names[n3 >> 2] = string;
        ++this._count;
        return string;
    }

    public final String addName(String string, int n2, int n3) {
        this.a();
        if (this._interner != null) {
            string = this._interner.intern(string);
        }
        int n4 = this.calcHash(n2, n3);
        n4 = this.c(n4);
        this._hashArea[n4] = n2;
        this._hashArea[n4 + 1] = n3;
        this._hashArea[n4 + 3] = 2;
        this._names[n4 >> 2] = string;
        ++this._count;
        return string;
    }

    public final String addName(String string, int n2, int n3, int n4) {
        this.a();
        if (this._interner != null) {
            string = this._interner.intern(string);
        }
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n5 = byteQuadsCanonicalizer.c(byteQuadsCanonicalizer.calcHash(n2, n3, n4));
        this._hashArea[n5] = n2;
        this._hashArea[n5 + 1] = n3;
        this._hashArea[n5 + 2] = n4;
        this._hashArea[n5 + 3] = 3;
        this._names[n5 >> 2] = string;
        ++this._count;
        return string;
    }

    public final String addName(String string, int[] object, int n2) {
        this.a();
        if (this._interner != null) {
            string = this._interner.intern(string);
        }
        switch (n2) {
            case 1: {
                ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
                int n3 = byteQuadsCanonicalizer.c(byteQuadsCanonicalizer.calcHash(object[0]));
                this._hashArea[n3] = object[0];
                this._hashArea[n3 + 3] = 1;
                break;
            }
            case 2: {
                ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
                int n3 = byteQuadsCanonicalizer.c(byteQuadsCanonicalizer.calcHash(object[0], object[1]));
                this._hashArea[n3] = object[0];
                this._hashArea[n3 + 1] = object[1];
                this._hashArea[n3 + 3] = 2;
                break;
            }
            case 3: {
                ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
                int n3 = byteQuadsCanonicalizer.c(byteQuadsCanonicalizer.calcHash(object[0], object[1], object[2]));
                this._hashArea[n3] = object[0];
                this._hashArea[n3 + 1] = object[1];
                this._hashArea[n3 + 2] = object[2];
                this._hashArea[n3 + 3] = 3;
                break;
            }
            default: {
                int n4;
                int n5 = this.calcHash((int[])object, n2);
                int n3 = this.c(n5);
                this._hashArea[n3] = n5;
                ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
                int n6 = n2;
                int[] nArray = object;
                object = byteQuadsCanonicalizer;
                int n7 = byteQuadsCanonicalizer._longNameOffset;
                if (n7 + n6 > object._hashArea.length) {
                    int n8 = n7 + n6 - object._hashArea.length;
                    int n9 = Math.min(4096, object._hashSize);
                    n8 = object._hashArea.length + Math.max(n8, n9);
                    object._hashArea = Arrays.copyOf(object._hashArea, n8);
                }
                System.arraycopy(nArray, 0, object._hashArea, n7, n6);
                object._longNameOffset += n6;
                this._hashArea[n3 + 1] = n4 = n7;
                this._hashArea[n3 + 3] = n2;
            }
        }
        this._names[n3 >> 2] = string;
        ++this._count;
        return string;
    }

    private void a() {
        if (this._hashShared) {
            if (this._parent == null) {
                if (this._count == 0) {
                    throw new IllegalStateException("Internal error: Cannot add names to Root symbol table");
                }
                throw new IllegalStateException("Internal error: Cannot add names to Placeholder symbol table");
            }
            this._hashArea = Arrays.copyOf(this._hashArea, this._hashArea.length);
            this._names = Arrays.copyOf(this._names, this._names.length);
            this._hashShared = false;
        }
    }

    private int c(int n2) {
        int n3 = this.b(n2);
        int[] nArray = this._hashArea;
        if (this._hashArea[n3 + 3] == 0) {
            return n3;
        }
        if (this.b()) {
            return this.d(n2);
        }
        int n4 = this._secondaryStart + (n3 >> 3 << 2);
        if (nArray[n4 + 3] == 0) {
            return n4;
        }
        n4 = this._tertiaryStart + (n3 >> this._tertiaryShift + 2 << this._tertiaryShift);
        n3 = 1 << this._tertiaryShift;
        int n5 = n4 + n3;
        while (n4 < n5) {
            if (nArray[n4 + 3] == 0) {
                return n4;
            }
            n4 += 4;
        }
        n3 = this._spilloverEnd;
        this._spilloverEnd += 4;
        n5 = this._hashSize << 3;
        if (this._spilloverEnd >= n5) {
            if (this._failOnDoS) {
                this._reportTooManyCollisions();
            }
            return this.d(n2);
        }
        return n3;
    }

    private int d(int n2) {
        this.c();
        n2 = this.b(n2);
        int[] nArray = this._hashArea;
        if (this._hashArea[n2 + 3] == 0) {
            return n2;
        }
        int n3 = this._secondaryStart + (n2 >> 3 << 2);
        if (nArray[n3 + 3] == 0) {
            return n3;
        }
        n3 = this._tertiaryStart + (n2 >> this._tertiaryShift + 2 << this._tertiaryShift);
        n2 = 1 << this._tertiaryShift;
        n2 = n3 + n2;
        while (n3 < n2) {
            if (nArray[n3 + 3] == 0) {
                return n3;
            }
            n3 += 4;
        }
        n2 = this._spilloverEnd;
        this._spilloverEnd += 4;
        return n2;
    }

    private static int e(int n2) {
        return (int)((long)n2 * 0xCCCCCCCDL >>> 32);
    }

    private boolean b() {
        int n2;
        return this._count > this._hashSize >> 1 && ((n2 = this._spilloverEnd - this.d() >> 2) > 1 + this._count >> 7 || this._count > ByteQuadsCanonicalizer.e(this._hashSize));
    }

    public final int calcHash(int n2) {
        n2 ^= this._seed;
        n2 += n2 >>> 16;
        n2 ^= n2 << 3;
        n2 += n2 >>> 12;
        return n2;
    }

    public final int calcHash(int n2, int n3) {
        int n4 = n2;
        n2 = n4 + (n4 >>> 15);
        n2 ^= n2 >>> 9;
        n2 += n3 * 33;
        n2 ^= this._seed;
        n2 += n2 >>> 16;
        n2 ^= n2 >>> 4;
        n2 += n2 << 3;
        return n2;
    }

    public final int calcHash(int n2, int n3, int n4) {
        n2 ^= this._seed;
        n2 += n2 >>> 9;
        n2 *= 31;
        n2 += n3;
        n2 *= 33;
        n2 += n2 >>> 15;
        n2 ^= n4;
        n2 += n2 >>> 4;
        n2 += n2 >>> 15;
        n2 ^= n2 << 9;
        return n2;
    }

    public final int calcHash(int[] nArray, int n2) {
        if (n2 < 4) {
            throw new IllegalArgumentException("qlen is too short, needs to be at least 4");
        }
        int n3 = nArray[0] ^ this._seed;
        n3 += n3 >>> 9;
        n3 += nArray[1];
        n3 += n3 >>> 15;
        n3 *= 33;
        n3 ^= nArray[2];
        n3 += n3 >>> 4;
        for (int i2 = 3; i2 < n2; ++i2) {
            int n4 = nArray[i2];
            n4 ^= n4 >> 21;
            n3 += n4;
        }
        n3 *= 65599;
        n3 += n3 >>> 19;
        n3 ^= n3 << 5;
        return n3;
    }

    private void c() {
        this._hashShared = false;
        int[] nArray = this._hashArea;
        String[] stringArray = this._names;
        int n2 = this._hashSize;
        int n3 = this._count;
        int n4 = n2;
        int n5 = n4 + n4;
        int n6 = this._spilloverEnd;
        if (n5 > 65536) {
            this.a(true);
            return;
        }
        this._hashArea = new int[nArray.length + (n2 << 3)];
        this._hashSize = n5;
        this._secondaryStart = n5 << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = ByteQuadsCanonicalizer.a(n5);
        this._names = new String[stringArray.length << 1];
        this.a(false);
        n2 = 0;
        int[] nArray2 = new int[16];
        block5: for (int i2 = 0; i2 < n6; i2 += 4) {
            int n7 = nArray[i2 + 3];
            if (n7 == 0) continue;
            ++n2;
            String string = stringArray[i2 >> 2];
            switch (n7) {
                case 1: {
                    nArray2[0] = nArray[i2];
                    this.addName(string, nArray2, 1);
                    continue block5;
                }
                case 2: {
                    nArray2[0] = nArray[i2];
                    nArray2[1] = nArray[i2 + 1];
                    this.addName(string, nArray2, 2);
                    continue block5;
                }
                case 3: {
                    nArray2[0] = nArray[i2];
                    nArray2[1] = nArray[i2 + 1];
                    nArray2[2] = nArray[i2 + 2];
                    this.addName(string, nArray2, 3);
                    continue block5;
                }
                default: {
                    if (n7 > nArray2.length) {
                        nArray2 = new int[n7];
                    }
                    int n8 = nArray[i2 + 1];
                    System.arraycopy(nArray, n8, nArray2, 0, n7);
                    this.addName(string, nArray2, n7);
                }
            }
        }
        if (n2 != n3) {
            throw new IllegalStateException("Internal error: Failed rehash(), old count=" + n3 + ", copyCount=" + n2);
        }
    }

    private void a(boolean bl2) {
        this._count = 0;
        this._spilloverEnd = this.d();
        this._longNameOffset = this._hashSize << 3;
        if (bl2) {
            Arrays.fill(this._hashArea, 0);
            Arrays.fill(this._names, null);
        }
    }

    private final int d() {
        int n2 = this._hashSize;
        return (n2 << 3) - n2;
    }

    protected final void _reportTooManyCollisions() {
        if (this._hashSize <= 1024) {
            return;
        }
        throw new StreamConstraintsException("Spill-over slots in symbol table with " + this._count + " entries, hash area of " + this._hashSize + " slots is now full (all " + (this._hashSize >> 3) + " slots -- suspect a DoS attack based on hash collisions. You can disable the check via `JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW`");
    }

    static int a(int n2) {
        if ((n2 >>= 2) < 64) {
            return 4;
        }
        if (n2 <= 256) {
            return 5;
        }
        if (n2 <= 1024) {
            return 6;
        }
        return 7;
    }

    private static final class a {
        public final int a;
        public final int b;
        public final int c;
        public final int[] d;
        public final String[] e;
        public final int f;
        public final int g;

        private a(int n2, int n3, int n4, int[] nArray, String[] stringArray, int n5, int n6) {
            this.a = n2;
            this.b = 0;
            this.c = n4;
            this.d = nArray;
            this.e = stringArray;
            this.f = n5;
            this.g = n6;
        }

        public a(ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
            this.a = byteQuadsCanonicalizer._hashSize;
            this.b = byteQuadsCanonicalizer._count;
            this.c = byteQuadsCanonicalizer._tertiaryShift;
            this.d = byteQuadsCanonicalizer._hashArea;
            this.e = byteQuadsCanonicalizer._names;
            this.f = byteQuadsCanonicalizer._spilloverEnd;
            this.g = byteQuadsCanonicalizer._longNameOffset;
        }

        public static a a(int n2) {
            int n3 = n2 << 3;
            int n4 = ByteQuadsCanonicalizer.a(n2);
            return new a(n2, 0, n4, new int[n3], new String[n2 << 1], n3 - n2, n3);
        }
    }
}

