/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReference;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    protected final CharsToNameCanonicalizer _parent;
    protected final AtomicReference<b> _tableInfo;
    protected final StreamReadConstraints _streamReadConstraints;
    protected final int _seed;
    protected final int _factoryFeatures;
    protected boolean _canonicalize;
    protected String[] _symbols;
    protected a[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _hashShared;
    protected BitSet _overflows;

    private CharsToNameCanonicalizer(StreamReadConstraints streamReadConstraints, int n2, int n3) {
        this._parent = null;
        this._seed = n3;
        this._streamReadConstraints = streamReadConstraints;
        this._canonicalize = true;
        this._factoryFeatures = n2;
        this._hashShared = false;
        this._longestCollisionList = 0;
        this._tableInfo = new AtomicReference<b>(b.a(64));
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, StreamReadConstraints streamReadConstraints, int n2, int n3, b b2) {
        int n4;
        this._parent = charsToNameCanonicalizer;
        this._streamReadConstraints = streamReadConstraints;
        this._seed = n3;
        this._tableInfo = null;
        this._factoryFeatures = n2;
        this._canonicalize = JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n2);
        this._symbols = b2.c;
        this._buckets = b2.d;
        this._size = b2.a;
        this._longestCollisionList = b2.b;
        int n5 = n4 = this._symbols.length;
        this._sizeThreshold = n5 - (n5 >> 2);
        this._indexMask = n4 - 1;
        this._hashShared = true;
    }

    @Deprecated
    public static CharsToNameCanonicalizer createRoot() {
        return CharsToNameCanonicalizer.createRoot(null);
    }

    @Deprecated
    public static CharsToNameCanonicalizer createRoot(int n2) {
        return CharsToNameCanonicalizer.createRoot(null, n2);
    }

    public static CharsToNameCanonicalizer createRoot(TokenStreamFactory tokenStreamFactory) {
        return CharsToNameCanonicalizer.createRoot(tokenStreamFactory, 0);
    }

    public static CharsToNameCanonicalizer createRoot(TokenStreamFactory tokenStreamFactory, int n2) {
        int n3;
        StreamReadConstraints streamReadConstraints;
        if (n2 == 0) {
            n2 = System.identityHashCode(tokenStreamFactory);
        }
        if (tokenStreamFactory == null) {
            streamReadConstraints = StreamReadConstraints.defaults();
            n3 = 0;
        } else {
            streamReadConstraints = tokenStreamFactory.streamReadConstraints();
            n3 = tokenStreamFactory.getFactoryFeatures();
        }
        return new CharsToNameCanonicalizer(streamReadConstraints, n3, n2);
    }

    public final CharsToNameCanonicalizer makeChild() {
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        return new CharsToNameCanonicalizer(charsToNameCanonicalizer, charsToNameCanonicalizer._streamReadConstraints, this._factoryFeatures, this._seed, this._tableInfo.get());
    }

    @Deprecated
    public final CharsToNameCanonicalizer makeChild(int n2) {
        return this.makeChild();
    }

    public final void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null && this._canonicalize) {
            b b2 = new b(this);
            CharsToNameCanonicalizer charsToNameCanonicalizer = this._parent;
            int n2 = b2.a;
            b b3 = charsToNameCanonicalizer._tableInfo.get();
            if (n2 != b3.a) {
                if (n2 > 12000) {
                    b2 = b.a(64);
                }
                charsToNameCanonicalizer._tableInfo.compareAndSet(b3, b2);
            }
            this._hashShared = true;
        }
    }

    public final int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().a;
        }
        return this._size;
    }

    public final int bucketCount() {
        return this._symbols.length;
    }

    public final boolean maybeDirty() {
        return !this._hashShared;
    }

    public final int hashSeed() {
        return this._seed;
    }

    public final int collisionCount() {
        int n2 = 0;
        a[] aArray = this._buckets;
        int n3 = this._buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            a a2 = aArray[i2];
            if (a2 == null) continue;
            n2 += a2.c;
        }
        return n2;
    }

    public final int maxCollisionLength() {
        return this._longestCollisionList;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final String findSymbol(char[] var1_1, int var2_5, int var3_8, int var4_13) {
        block28: {
            block29: {
                block30: {
                    block27: {
                        if (var3_8 <= 0) {
                            return "";
                        }
                        if (!this._canonicalize) {
                            this._streamReadConstraints.validateNameLength(var3_8);
                            return new String(var1_1, var2_5, var3_8);
                        }
                        var5_18 = this._symbols[var4_13 = this._hashToIndex(var4_13)];
                        if (var5_18 != null) {
                            if (var5_18.length() == var3_8) {
                                var6_19 = 0;
                                while (var5_18.charAt(var6_19) == var1_1[var2_5 + var6_19]) {
                                    if (++var6_19 != var3_8) continue;
                                    return var5_18;
                                }
                            }
                            if ((var6_20 = this._buckets[var4_13 >> 1]) != null) {
                                block26: {
                                    var5_18 = var6_20.a(var1_1, var2_5, var3_8);
                                    if (var5_18 != null) {
                                        return var5_18;
                                    }
                                    var8_24 = var6_20.b;
                                    var7_26 = var3_8;
                                    var6_21 = var2_5;
                                    var5_18 = var1_1;
                                    while (var8_24 != null) {
                                        var9_27 /* !! */  = var8_24.a((char[])var5_18, var6_21, var7_26);
                                        if (var9_27 /* !! */  != null) {
                                            v0 /* !! */  = var9_27 /* !! */ ;
                                            break block26;
                                        }
                                        var8_24 = var8_24.b;
                                    }
                                    v0 /* !! */  = var5_18 = null;
                                }
                                if (v0 /* !! */  != null) {
                                    return var5_18;
                                }
                            }
                        }
                        this._streamReadConstraints.validateNameLength(var3_8);
                        var1_2 = var4_13;
                        var8_25 = var3_8;
                        var7_26 = var2_5;
                        var6_22 = var1_1;
                        var5_18 = this;
                        if (var5_18._hashShared) {
                            var3_9 = var5_18;
                            var4_14 = var3_9._symbols;
                            var3_9._symbols = Arrays.copyOf(var4_14, var4_14.length);
                            var9_27 /* !! */  = var3_9._buckets;
                            var3_9._buckets = Arrays.copyOf(var9_27 /* !! */ , var9_27 /* !! */ .length);
                            var5_18._hashShared = false;
                        } else if (var5_18._size >= var5_18._sizeThreshold) {
                            var3_10 = var5_18;
                            var4_13 = var3_10._symbols.length;
                            var9_28 = var4_13 + var4_13;
                            if (var9_28 > 65536) {
                                var3_10._size = 0;
                                var3_10._canonicalize = false;
                                var3_10._symbols = new String[64];
                                var3_10._buckets = new a[32];
                                var3_10._indexMask = 63;
                                var3_10._hashShared = false;
                            } else {
                                var1_3 = var3_10._symbols;
                                var2_6 = var3_10._buckets;
                                var3_10._symbols = new String[var9_28];
                                var3_10._buckets = new a[var9_28 >> 1];
                                var3_10._indexMask = var9_28 - 1;
                                var3_10._sizeThreshold = var9_28 - (var9_28 >> 2);
                                var9_28 = 0;
                                var10_30 = 0;
                                for (var11_31 = 0; var11_31 < var4_13; ++var11_31) {
                                    var12_32 = var1_3[var11_31];
                                    if (var12_32 == null) continue;
                                    ++var9_28;
                                    v1 = var3_10;
                                    var13_34 = v1._hashToIndex(v1.calcHash(var12_32));
                                    if (var3_10._symbols[var13_34] == null) {
                                        var3_10._symbols[var13_34] = var12_32;
                                        continue;
                                    }
                                    var14_36 = var13_34 >> 1;
                                    var3_10._buckets[var14_36] = var15_38 = new a(var12_32, var3_10._buckets[var14_36]);
                                    var10_30 = Math.max(var10_30, var15_38.c);
                                }
                                var11_31 = var4_13 >> 1;
                                for (var12_33 = 0; var12_33 < var11_31; ++var12_33) {
                                    var13_35 = var2_6[var12_33];
                                    while (var13_35 != null) {
                                        ++var9_28;
                                        var14_37 = var13_35.a;
                                        v2 = var3_10;
                                        var15_39 = v2._hashToIndex(v2.calcHash(var14_37));
                                        if (var3_10._symbols[var15_39] == null) {
                                            var3_10._symbols[var15_39] = var14_37;
                                        } else {
                                            var1_4 = var15_39 >> 1;
                                            var3_10._buckets[var1_4] = var4_15 = new a(var14_37, var3_10._buckets[var1_4]);
                                            var10_30 = Math.max(var10_30, var4_15.c);
                                        }
                                        var13_35 = var13_35.b;
                                    }
                                }
                                var3_10._longestCollisionList = var10_30;
                                var3_10._overflows = null;
                                if (var9_28 != var3_10._size) {
                                    throw new IllegalStateException(String.format("Internal error on SymbolTable.rehash(): had %d entries; now have %d", new Object[]{var3_10._size, var9_28}));
                                }
                            }
                            v3 = var5_18;
                            var1_2 = v3._hashToIndex(v3.calcHash(var6_22, var7_26, var8_25));
                        }
                        var2_7 = new String(var6_22, var7_26, var8_25);
                        if (JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(var5_18._factoryFeatures)) {
                            var2_7 = InternCache.instance.intern(var2_7);
                        }
                        ++var5_18._size;
                        if (var5_18._symbols[var1_2] != null) break block27;
                        var5_18._symbols[var1_2] = var2_7;
                        break block28;
                    }
                    var3_11 = var1_2 >> 1;
                    var4_16 = new a(var2_7, var5_18._buckets[var3_11]);
                    var6_23 = var4_16.c;
                    if (var6_23 <= 150) break block29;
                    var9_29 = var4_16;
                    var4_17 = var3_11;
                    var3_12 = var5_18;
                    if (var3_12._overflows != null) break block30;
                    var3_12._overflows = new BitSet();
                    ** GOTO lbl-1000
                }
                if (var3_12._overflows.get(var4_17)) {
                    if (JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(var3_12._factoryFeatures)) {
                        var3_12._reportTooManyCollisions(150);
                    }
                    var3_12._canonicalize = false;
                } else lbl-1000:
                // 2 sources

                {
                    var3_12._overflows.set(var4_17);
                }
                var3_12._symbols[var1_2] = var9_29.a;
                var3_12._buckets[var4_17] = null;
                var3_12._size -= var9_29.c;
                var3_12._longestCollisionList = -1;
                break block28;
            }
            var5_18._buckets[var3_11] = var4_16;
            var5_18._longestCollisionList = Math.max(var6_23, var5_18._longestCollisionList);
        }
        return var2_7;
    }

    public final int _hashToIndex(int n2) {
        int n3 = n2;
        n2 = n3 + (n3 >>> 15);
        n2 ^= n2 << 7;
        n2 += n2 >>> 3;
        return n2 & this._indexMask;
    }

    public final int calcHash(char[] cArray, int n2, int n3) {
        int n4 = this._seed;
        int n5 = n2;
        n2 += n3;
        while (n5 < n2) {
            n4 = n4 * 33 + cArray[n5];
            ++n5;
        }
        if (n4 == 0) {
            return 1;
        }
        return n4;
    }

    public final int calcHash(String string) {
        int n2 = string.length();
        int n3 = this._seed;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 33 + string.charAt(i2);
        }
        if (n3 == 0) {
            return 1;
        }
        return n3;
    }

    protected final void _reportTooManyCollisions(int n2) {
        throw new StreamConstraintsException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }

    protected final void verifyInternalConsistency() {
        int n2;
        int n3 = 0;
        for (String string : this._symbols) {
            if (string == null) continue;
            ++n3;
        }
        int n4 = n2 >> 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            a a2 = this._buckets[i2];
            while (a2 != null) {
                ++n3;
                a2 = a2.b;
            }
        }
        if (n3 != this._size) {
            throw new IllegalStateException(String.format("Internal error: expected internal size %d vs calculated count %d", this._size, n3));
        }
    }

    private static final class b {
        final int a;
        final int b;
        final String[] c;
        final a[] d;

        private b(int n2, int n3, String[] stringArray, a[] aArray) {
            this.a = 0;
            this.b = 0;
            this.c = stringArray;
            this.d = aArray;
        }

        public b(CharsToNameCanonicalizer charsToNameCanonicalizer) {
            this.a = charsToNameCanonicalizer._size;
            this.b = charsToNameCanonicalizer._longestCollisionList;
            this.c = charsToNameCanonicalizer._symbols;
            this.d = charsToNameCanonicalizer._buckets;
        }

        public static b a(int n2) {
            return new b(0, 0, new String[64], new a[32]);
        }
    }

    static final class a {
        public final String a;
        public final a b;
        public final int c;

        public a(String string, a a2) {
            this.a = string;
            this.b = a2;
            this.c = a2 == null ? 1 : a2.c + 1;
        }

        public final String a(char[] cArray, int n2, int n3) {
            if (this.a.length() != n3) {
                return null;
            }
            int n4 = 0;
            do {
                if (this.a.charAt(n4) == cArray[n2 + n4]) continue;
                return null;
            } while (++n4 < n3);
            return this.a;
        }
    }
}

