/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.OutputStream;
import java.util.LinkedList;

public final class ByteArrayBuilder
extends OutputStream
implements BufferRecycler.Gettable {
    public static final byte[] NO_BYTES = new byte[0];
    private final BufferRecycler a;
    private final LinkedList<byte[]> b = new LinkedList();
    private int c;
    private byte[] d;
    private int e;

    public ByteArrayBuilder() {
        this(null);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler) {
        this(bufferRecycler, 500);
    }

    public ByteArrayBuilder(int n2) {
        this(null, n2);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler, int n2) {
        this.a = bufferRecycler;
        if (n2 > 131072) {
            n2 = 131072;
        }
        this.d = bufferRecycler == null ? new byte[n2] : bufferRecycler.allocByteBuffer(2);
    }

    private ByteArrayBuilder(BufferRecycler bufferRecycler, byte[] byArray, int n2) {
        this.a = null;
        this.d = byArray;
        this.e = n2;
    }

    public static ByteArrayBuilder fromInitial(byte[] byArray, int n2) {
        return new ByteArrayBuilder(null, byArray, n2);
    }

    public final void reset() {
        this.c = 0;
        this.e = 0;
        if (!this.b.isEmpty()) {
            this.b.clear();
        }
    }

    public final int size() {
        return this.c + this.e;
    }

    public final void release() {
        this.reset();
        if (this.a != null && this.d != null) {
            this.a.releaseByteBuffer(2, this.d);
            this.d = null;
        }
    }

    public final void append(int n2) {
        if (this.e >= this.d.length) {
            this.a();
        }
        this.d[this.e++] = (byte)n2;
    }

    public final void appendTwoBytes(int n2) {
        if (this.e + 1 < this.d.length) {
            this.d[this.e++] = (byte)(n2 >> 8);
            this.d[this.e++] = (byte)n2;
            return;
        }
        this.append(n2 >> 8);
        this.append(n2);
    }

    public final void appendThreeBytes(int n2) {
        if (this.e + 2 < this.d.length) {
            this.d[this.e++] = (byte)(n2 >> 16);
            this.d[this.e++] = (byte)(n2 >> 8);
            this.d[this.e++] = (byte)n2;
            return;
        }
        this.append(n2 >> 16);
        this.append(n2 >> 8);
        this.append(n2);
    }

    public final void appendFourBytes(int n2) {
        if (this.e + 3 < this.d.length) {
            this.d[this.e++] = (byte)(n2 >> 24);
            this.d[this.e++] = (byte)(n2 >> 16);
            this.d[this.e++] = (byte)(n2 >> 8);
            this.d[this.e++] = (byte)n2;
            return;
        }
        this.append(n2 >> 24);
        this.append(n2 >> 16);
        this.append(n2 >> 8);
        this.append(n2);
    }

    public final byte[] toByteArray() {
        int n2 = this.c + this.e;
        if (n2 == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (byte[] byArray2 : this.b) {
            int n4 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
        }
        System.arraycopy(this.d, 0, byArray, n3, this.e);
        if ((n3 += this.e) != n2) {
            throw new RuntimeException("Internal error: total len assumed to be " + n2 + ", copied " + n3 + " bytes");
        }
        if (!this.b.isEmpty()) {
            this.reset();
        }
        return byArray;
    }

    public final byte[] getClearAndRelease() {
        byte[] byArray = this.toByteArray();
        this.release();
        return byArray;
    }

    @Override
    public final BufferRecycler bufferRecycler() {
        return this.a;
    }

    public final byte[] resetAndGetFirstSegment() {
        this.reset();
        return this.d;
    }

    public final byte[] finishCurrentSegment() {
        this.a();
        return this.d;
    }

    public final byte[] completeAndCoalesce(int n2) {
        this.e = n2;
        return this.toByteArray();
    }

    public final byte[] getCurrentSegment() {
        return this.d;
    }

    public final void setCurrentSegmentLength(int n2) {
        this.e = n2;
    }

    public final int getCurrentSegmentLength() {
        return this.e;
    }

    @Override
    public final void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public final void write(byte[] byArray, int n2, int n3) {
        while (true) {
            int n4 = this.d.length - this.e;
            if ((n4 = Math.min(n4, n3)) > 0) {
                System.arraycopy(byArray, n2, this.d, this.e, n4);
                n2 += n4;
                this.e += n4;
                n3 -= n4;
            }
            if (n3 <= 0) break;
            this.a();
        }
    }

    @Override
    public final void write(int n2) {
        this.append(n2);
    }

    @Override
    public final void close() {
    }

    @Override
    public final void flush() {
    }

    private void a() {
        int n2 = this.c + this.d.length;
        if (n2 < 0) {
            throw new IllegalStateException("Maximum Java array size (2GB) exceeded by `ByteArrayBuilder`");
        }
        this.c = n2;
        n2 = Math.max(this.c >> 1, 1000);
        if (n2 > 131072) {
            n2 = 131072;
        }
        this.b.add(this.d);
        this.d = new byte[n2];
        this.e = 0;
    }
}

