/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.StreamWriteConstraints;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonGeneratorDelegate
extends JsonGenerator {
    protected JsonGenerator delegate;
    protected boolean delegateCopyMethods;

    public JsonGeneratorDelegate(JsonGenerator jsonGenerator) {
        this(jsonGenerator, true);
    }

    public JsonGeneratorDelegate(JsonGenerator jsonGenerator, boolean bl2) {
        this.delegate = jsonGenerator;
        this.delegateCopyMethods = bl2;
    }

    @Override
    public ObjectCodec getCodec() {
        return this.delegate.getCodec();
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this.delegate.setCodec(objectCodec);
        return this;
    }

    @Override
    public void setSchema(FormatSchema formatSchema) {
        this.delegate.setSchema(formatSchema);
    }

    @Override
    public FormatSchema getSchema() {
        return this.delegate.getSchema();
    }

    @Override
    public Version version() {
        return this.delegate.version();
    }

    @Override
    public Object getOutputTarget() {
        return this.delegate.getOutputTarget();
    }

    @Override
    public int getOutputBuffered() {
        return this.delegate.getOutputBuffered();
    }

    @Override
    public void assignCurrentValue(Object object) {
        this.delegate.assignCurrentValue(object);
    }

    @Override
    public Object currentValue() {
        return this.delegate.currentValue();
    }

    @Override
    @Deprecated
    public void setCurrentValue(Object object) {
        this.delegate.setCurrentValue(object);
    }

    @Override
    @Deprecated
    public Object getCurrentValue() {
        return this.delegate.getCurrentValue();
    }

    @Override
    public boolean canUseSchema(FormatSchema formatSchema) {
        return this.delegate.canUseSchema(formatSchema);
    }

    @Override
    public boolean canWriteTypeId() {
        return this.delegate.canWriteTypeId();
    }

    @Override
    public boolean canWriteObjectId() {
        return this.delegate.canWriteObjectId();
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return this.delegate.canWriteBinaryNatively();
    }

    @Override
    public boolean canOmitFields() {
        return this.delegate.canOmitFields();
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return this.delegate.canWriteFormattedNumbers();
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return this.delegate.getWriteCapabilities();
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        this.delegate.enable(feature);
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        this.delegate.disable(feature);
        return this;
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature feature) {
        return this.delegate.isEnabled(feature);
    }

    @Override
    public int getFeatureMask() {
        return this.delegate.getFeatureMask();
    }

    @Override
    @Deprecated
    public JsonGenerator setFeatureMask(int n2) {
        this.delegate.setFeatureMask(n2);
        return this;
    }

    @Override
    public JsonGenerator overrideStdFeatures(int n2, int n3) {
        this.delegate.overrideStdFeatures(n2, n3);
        return this;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int n2, int n3) {
        this.delegate.overrideFormatFeatures(n2, n3);
        return this;
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this.delegate.setPrettyPrinter(prettyPrinter);
        return this;
    }

    @Override
    public PrettyPrinter getPrettyPrinter() {
        return this.delegate.getPrettyPrinter();
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        this.delegate.useDefaultPrettyPrinter();
        return this;
    }

    @Override
    public JsonGenerator setHighestNonEscapedChar(int n2) {
        this.delegate.setHighestNonEscapedChar(n2);
        return this;
    }

    @Override
    public int getHighestEscapedChar() {
        return this.delegate.getHighestEscapedChar();
    }

    @Override
    public CharacterEscapes getCharacterEscapes() {
        return this.delegate.getCharacterEscapes();
    }

    @Override
    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        this.delegate.setCharacterEscapes(characterEscapes);
        return this;
    }

    @Override
    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        this.delegate.setRootValueSeparator(serializableString);
        return this;
    }

    @Override
    public StreamWriteConstraints streamWriteConstraints() {
        return this.delegate.streamWriteConstraints();
    }

    @Override
    public void writeStartArray() {
        this.delegate.writeStartArray();
    }

    @Override
    public void writeStartArray(int n2) {
        this.delegate.writeStartArray(n2);
    }

    @Override
    public void writeStartArray(Object object) {
        this.delegate.writeStartArray(object);
    }

    @Override
    public void writeStartArray(Object object, int n2) {
        this.delegate.writeStartArray(object, n2);
    }

    @Override
    public void writeEndArray() {
        this.delegate.writeEndArray();
    }

    @Override
    public void writeStartObject() {
        this.delegate.writeStartObject();
    }

    @Override
    public void writeStartObject(Object object) {
        this.delegate.writeStartObject(object);
    }

    @Override
    public void writeStartObject(Object object, int n2) {
        this.delegate.writeStartObject(object, n2);
    }

    @Override
    public void writeEndObject() {
        this.delegate.writeEndObject();
    }

    @Override
    public void writeFieldName(String string) {
        this.delegate.writeFieldName(string);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        this.delegate.writeFieldName(serializableString);
    }

    @Override
    public void writeFieldId(long l2) {
        this.delegate.writeFieldId(l2);
    }

    @Override
    public void writeArray(int[] nArray, int n2, int n3) {
        this.delegate.writeArray(nArray, n2, n3);
    }

    @Override
    public void writeArray(long[] lArray, int n2, int n3) {
        this.delegate.writeArray(lArray, n2, n3);
    }

    @Override
    public void writeArray(double[] dArray, int n2, int n3) {
        this.delegate.writeArray(dArray, n2, n3);
    }

    @Override
    public void writeArray(String[] stringArray, int n2, int n3) {
        this.delegate.writeArray(stringArray, n2, n3);
    }

    @Override
    public void writeString(String string) {
        this.delegate.writeString(string);
    }

    @Override
    public void writeString(Reader reader, int n2) {
        this.delegate.writeString(reader, n2);
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        this.delegate.writeString(cArray, n2, n3);
    }

    @Override
    public void writeString(SerializableString serializableString) {
        this.delegate.writeString(serializableString);
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this.delegate.writeRawUTF8String(byArray, n2, n3);
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        this.delegate.writeUTF8String(byArray, n2, n3);
    }

    @Override
    public void writeRaw(String string) {
        this.delegate.writeRaw(string);
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        this.delegate.writeRaw(string, n2, n3);
    }

    @Override
    public void writeRaw(SerializableString serializableString) {
        this.delegate.writeRaw(serializableString);
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) {
        this.delegate.writeRaw(cArray, n2, n3);
    }

    @Override
    public void writeRaw(char c2) {
        this.delegate.writeRaw(c2);
    }

    @Override
    public void writeRawValue(String string) {
        this.delegate.writeRawValue(string);
    }

    @Override
    public void writeRawValue(String string, int n2, int n3) {
        this.delegate.writeRawValue(string, n2, n3);
    }

    @Override
    public void writeRawValue(char[] cArray, int n2, int n3) {
        this.delegate.writeRawValue(cArray, n2, n3);
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        this.delegate.writeBinary(base64Variant, byArray, n2, n3);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        return this.delegate.writeBinary(base64Variant, inputStream, n2);
    }

    @Override
    public void writeNumber(short s2) {
        this.delegate.writeNumber(s2);
    }

    @Override
    public void writeNumber(int n2) {
        this.delegate.writeNumber(n2);
    }

    @Override
    public void writeNumber(long l2) {
        this.delegate.writeNumber(l2);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        this.delegate.writeNumber(bigInteger);
    }

    @Override
    public void writeNumber(double d2) {
        this.delegate.writeNumber(d2);
    }

    @Override
    public void writeNumber(float f2) {
        this.delegate.writeNumber(f2);
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) {
        this.delegate.writeNumber(bigDecimal);
    }

    @Override
    public void writeNumber(String string) {
        this.delegate.writeNumber(string);
    }

    @Override
    public void writeNumber(char[] cArray, int n2, int n3) {
        this.delegate.writeNumber(cArray, n2, n3);
    }

    @Override
    public void writeBoolean(boolean bl2) {
        this.delegate.writeBoolean(bl2);
    }

    @Override
    public void writeNull() {
        this.delegate.writeNull();
    }

    @Override
    public void writeOmittedField(String string) {
        this.delegate.writeOmittedField(string);
    }

    @Override
    public void writeObjectId(Object object) {
        this.delegate.writeObjectId(object);
    }

    @Override
    public void writeObjectRef(Object object) {
        this.delegate.writeObjectRef(object);
    }

    @Override
    public void writeTypeId(Object object) {
        this.delegate.writeTypeId(object);
    }

    @Override
    public void writeEmbeddedObject(Object object) {
        this.delegate.writeEmbeddedObject(object);
    }

    @Override
    public void writePOJO(Object object) {
        ((JsonGenerator)this).writeObject(object);
    }

    @Override
    public void writeObject(Object object) {
        if (this.delegateCopyMethods) {
            this.delegate.writeObject(object);
            return;
        }
        if (object == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        ObjectCodec objectCodec = ((JsonGenerator)this).getCodec();
        if (objectCodec != null) {
            objectCodec.writeValue(this, object);
            return;
        }
        this._writeSimpleObject(object);
    }

    @Override
    public void writeTree(TreeNode treeNode) {
        if (this.delegateCopyMethods) {
            this.delegate.writeTree(treeNode);
            return;
        }
        if (treeNode == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        ObjectCodec objectCodec = ((JsonGenerator)this).getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined");
        }
        ((TreeCodec)objectCodec).writeTree(this, treeNode);
    }

    @Override
    public void copyCurrentEvent(JsonParser jsonParser) {
        if (this.delegateCopyMethods) {
            this.delegate.copyCurrentEvent(jsonParser);
            return;
        }
        super.copyCurrentEvent(jsonParser);
    }

    @Override
    public void copyCurrentStructure(JsonParser jsonParser) {
        if (this.delegateCopyMethods) {
            this.delegate.copyCurrentStructure(jsonParser);
            return;
        }
        super.copyCurrentStructure(jsonParser);
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this.delegate.getOutputContext();
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Deprecated
    public JsonGenerator getDelegate() {
        return this.delegate;
    }

    public JsonGenerator delegate() {
        return this.delegate;
    }
}

