/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import java.io.Serializable;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;

public interface RecyclerPool<P extends WithPool<P>>
extends Serializable {
    default public P acquireAndLinkPooled() {
        return this.acquirePooled().withPool(this);
    }

    public P acquirePooled();

    public void releasePooled(P var1);

    default public boolean clear() {
        return false;
    }

    default public int pooledCount() {
        return -1;
    }

    public static abstract class BoundedPoolBase<P extends WithPool<P>>
    extends StatefulImplBase<P> {
        public static final int DEFAULT_CAPACITY = 100;
        private final transient ArrayBlockingQueue<P> a;
        private final transient int b;

        protected BoundedPoolBase(int n2) {
            super(n2);
            this.b = n2 <= 0 ? 100 : n2;
            this.a = new ArrayBlockingQueue(this.b);
        }

        @Override
        public P acquirePooled() {
            WithPool withPool = (WithPool)this.a.poll();
            if (withPool == null) {
                withPool = this.createPooled();
            }
            return (P)withPool;
        }

        @Override
        public void releasePooled(P p2) {
            this.a.offer(p2);
        }

        @Override
        public int pooledCount() {
            return this.a.size();
        }

        @Override
        public boolean clear() {
            this.a.clear();
            return true;
        }

        public int capacity() {
            return this.b;
        }
    }

    public static abstract class LockFreePoolBase<P extends WithPool<P>>
    extends StatefulImplBase<P> {
        private final transient AtomicReference<Node<P>> a = new AtomicReference();

        protected LockFreePoolBase(int n2) {
            super(n2);
        }

        @Override
        public P acquirePooled() {
            for (int i2 = 0; i2 < 3; ++i2) {
                Node<P> node = this.a.get();
                if (node == null) {
                    return this.createPooled();
                }
                Node<P> node2 = node;
                if (!this.a.compareAndSet(node2, node2.b)) continue;
                node.b = null;
                return (P)((WithPool)node.a);
            }
            return this.createPooled();
        }

        @Override
        public void releasePooled(P object) {
            object = new Node<P>(object);
            for (int i2 = 0; i2 < 3; ++i2) {
                ((Node)object).b = this.a.get();
                if (!this.a.compareAndSet(((Node)object).b, (Node<P>)object)) continue;
                return;
            }
        }

        @Override
        public int pooledCount() {
            int n2 = 0;
            Node<P> node = this.a.get();
            while (node != null) {
                ++n2;
                node = node.b;
            }
            return n2;
        }

        @Override
        public boolean clear() {
            this.a.set(null);
            return true;
        }

        protected static class Node<P> {
            final P a;
            Node<P> b;

            Node(P p2) {
                this.a = p2;
            }
        }
    }

    public static abstract class ConcurrentDequePoolBase<P extends WithPool<P>>
    extends StatefulImplBase<P> {
        protected final transient Deque<P> pool = new ConcurrentLinkedDeque<P>();

        protected ConcurrentDequePoolBase(int n2) {
            super(n2);
        }

        @Override
        public P acquirePooled() {
            WithPool withPool = (WithPool)this.pool.pollFirst();
            if (withPool == null) {
                withPool = this.createPooled();
            }
            return (P)withPool;
        }

        @Override
        public void releasePooled(P p2) {
            this.pool.offerLast(p2);
        }

        @Override
        public int pooledCount() {
            return this.pool.size();
        }

        @Override
        public boolean clear() {
            this.pool.clear();
            return true;
        }
    }

    public static abstract class StatefulImplBase<P extends WithPool<P>>
    implements RecyclerPool<P> {
        public static final int SERIALIZATION_SHARED = -1;
        public static final int SERIALIZATION_NON_SHARED = 1;
        protected final int _serialization;

        protected StatefulImplBase(int n2) {
            this._serialization = n2;
        }

        protected Optional<StatefulImplBase<P>> _resolveToShared(StatefulImplBase<P> statefulImplBase) {
            if (this._serialization == -1) {
                return Optional.of(statefulImplBase);
            }
            return Optional.empty();
        }

        public abstract P createPooled();
    }

    public static abstract class NonRecyclingPoolBase<P extends WithPool<P>>
    implements RecyclerPool<P> {
        @Override
        public P acquireAndLinkPooled() {
            return this.acquirePooled();
        }

        @Override
        public abstract P acquirePooled();

        @Override
        public void releasePooled(P p2) {
        }

        @Override
        public int pooledCount() {
            return 0;
        }

        @Override
        public boolean clear() {
            return true;
        }
    }

    public static abstract class ThreadLocalPoolBase<P extends WithPool<P>>
    implements RecyclerPool<P> {
        protected ThreadLocalPoolBase() {
        }

        @Override
        public P acquireAndLinkPooled() {
            return this.acquirePooled();
        }

        @Override
        public abstract P acquirePooled();

        @Override
        public void releasePooled(P p2) {
        }

        @Override
        public int pooledCount() {
            return -1;
        }

        @Override
        public boolean clear() {
            return false;
        }
    }

    public static interface WithPool<P extends WithPool<P>> {
        public P withPool(RecyclerPool<P> var1);

        public void releaseToPool();
    }
}

