/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import java.io.Serializable;
import java.util.Objects;

public class Separators
implements Serializable {
    public static final String DEFAULT_ROOT_VALUE_SEPARATOR = " ";
    public static final String DEFAULT_OBJECT_EMPTY_SEPARATOR = " ";
    public static final String DEFAULT_ARRAY_EMPTY_SEPARATOR = " ";
    private final char a;
    private final Spacing b;
    private final char c;
    private final Spacing d;
    private final String e;
    private final char f;
    private final Spacing g;
    private final String h;
    private final String i;

    public static Separators createDefaultInstance() {
        return new Separators();
    }

    public Separators() {
        this(':', ',', ',');
    }

    public Separators(char c2, char c3, char c4) {
        this(" ", c2, Spacing.BOTH, c3, Spacing.NONE, " ", c4, Spacing.NONE, " ");
    }

    @Deprecated
    public Separators(String string, char c2, Spacing spacing, char c3, Spacing spacing2, char c4, Spacing spacing3) {
        this(string, c2, spacing, c3, spacing2, " ", c4, spacing3, " ");
    }

    public Separators(String string, char c2, Spacing spacing, char c3, Spacing spacing2, String string2, char c4, Spacing spacing3, String string3) {
        this.i = string;
        this.a = c2;
        this.b = spacing;
        this.c = c3;
        this.d = spacing2;
        this.e = string2;
        this.f = c4;
        this.g = spacing3;
        this.h = string3;
    }

    public Separators withRootSeparator(String string) {
        if (Objects.equals(this.i, string)) {
            return this;
        }
        return new Separators(string, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
    }

    public Separators withObjectFieldValueSeparator(char c2) {
        if (this.a == c2) {
            return this;
        }
        return new Separators(this.i, c2, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
    }

    public Separators withObjectFieldValueSpacing(Spacing spacing) {
        if (this.b == spacing) {
            return this;
        }
        return new Separators(this.i, this.a, spacing, this.c, this.d, this.e, this.f, this.g, this.h);
    }

    public Separators withObjectEntrySeparator(char c2) {
        if (this.c == c2) {
            return this;
        }
        return new Separators(this.i, this.a, this.b, c2, this.d, this.e, this.f, this.g, this.h);
    }

    public Separators withObjectEntrySpacing(Spacing spacing) {
        if (this.d == spacing) {
            return this;
        }
        return new Separators(this.i, this.a, this.b, this.c, spacing, this.e, this.f, this.g, this.h);
    }

    public Separators withObjectEmptySeparator(String string) {
        if (Objects.equals(this.e, string)) {
            return this;
        }
        return new Separators(this.i, this.a, this.b, this.c, this.d, string, this.f, this.g, this.h);
    }

    public Separators withArrayValueSeparator(char c2) {
        if (this.f == c2) {
            return this;
        }
        return new Separators(this.i, this.a, this.b, this.c, this.d, this.e, c2, this.g, this.h);
    }

    public Separators withArrayValueSpacing(Spacing spacing) {
        if (this.g == spacing) {
            return this;
        }
        return new Separators(this.i, this.a, this.b, this.c, this.d, this.e, this.f, spacing, this.h);
    }

    public Separators withArrayEmptySeparator(String string) {
        if (Objects.equals(this.h, string)) {
            return this;
        }
        return new Separators(this.i, this.a, this.b, this.c, this.d, this.e, this.f, this.g, string);
    }

    public String getRootSeparator() {
        return this.i;
    }

    public char getObjectFieldValueSeparator() {
        return this.a;
    }

    public Spacing getObjectFieldValueSpacing() {
        return this.b;
    }

    public char getObjectEntrySeparator() {
        return this.c;
    }

    public Spacing getObjectEntrySpacing() {
        return this.d;
    }

    public String getObjectEmptySeparator() {
        return this.e;
    }

    public char getArrayValueSeparator() {
        return this.f;
    }

    public Spacing getArrayValueSpacing() {
        return this.g;
    }

    public String getArrayEmptySeparator() {
        return this.h;
    }

    public static enum Spacing {
        NONE("", ""),
        BEFORE(" ", ""),
        AFTER("", " "),
        BOTH(" ", " ");

        private final String a;
        private final String b;

        private Spacing(String string2, String string3) {
            this.a = string2;
            this.b = string3;
        }

        public final String spacesBefore() {
            return this.a;
        }

        public final String spacesAfter() {
            return this.b;
        }

        public final String apply(char c2) {
            return this.a + c2 + this.b;
        }
    }
}

