/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public class TextBuffer {
    private static char[] a = new char[0];
    private final BufferRecycler b;
    private char[] c;
    private int d;
    private int e;
    private ArrayList<char[]> f;
    private boolean g;
    private int h;
    private char[] i;
    private int j;
    private String k;
    private char[] l;

    public TextBuffer(BufferRecycler bufferRecycler) {
        this.b = bufferRecycler;
    }

    protected TextBuffer(BufferRecycler bufferRecycler, char[] cArray) {
        this(bufferRecycler);
        this.i = cArray;
        this.j = cArray.length;
        this.d = -1;
    }

    public static TextBuffer fromInitial(char[] cArray) {
        return new TextBuffer(null, cArray);
    }

    public void releaseBuffers() {
        this.d = -1;
        this.j = 0;
        this.e = 0;
        this.c = null;
        this.l = null;
        if (this.g) {
            this.a();
        }
        if (this.b != null && this.i != null) {
            char[] cArray = this.i;
            this.i = null;
            this.b.releaseCharBuffer(2, cArray);
        }
    }

    public void resetWithEmpty() {
        this.d = -1;
        this.j = 0;
        this.e = 0;
        this.c = null;
        this.k = null;
        this.l = null;
        if (this.g) {
            this.a();
        }
    }

    public void resetWith(char c2) {
        this.d = -1;
        this.e = 0;
        this.k = null;
        this.l = null;
        if (this.g) {
            this.a();
        } else if (this.i == null) {
            this.i = this.a(1);
        }
        this.i[0] = c2;
        TextBuffer textBuffer = this;
        textBuffer.h = 1;
        textBuffer.j = 1;
    }

    public void resetWithShared(char[] cArray, int n2, int n3) {
        this.k = null;
        this.l = null;
        this.c = cArray;
        this.d = n2;
        this.e = n3;
        if (this.g) {
            this.a();
        }
    }

    public void resetWithCopy(char[] cArray, int n2, int n3) {
        this.c = null;
        this.d = -1;
        this.e = 0;
        this.k = null;
        this.l = null;
        if (this.g) {
            this.a();
        } else if (this.i == null) {
            this.i = this.a(n3);
        }
        TextBuffer textBuffer = this;
        textBuffer.h = 0;
        textBuffer.j = 0;
        this.append(cArray, n2, n3);
    }

    public void resetWithCopy(String string, int n2, int n3) {
        this.c = null;
        this.d = -1;
        this.e = 0;
        this.k = null;
        this.l = null;
        if (this.g) {
            this.a();
        } else if (this.i == null) {
            this.i = this.a(n3);
        }
        TextBuffer textBuffer = this;
        textBuffer.h = 0;
        textBuffer.j = 0;
        this.append(string, n2, n3);
    }

    public void resetWithString(String string) {
        this.c = null;
        this.d = -1;
        this.e = 0;
        this.validateStringLength(string.length());
        this.k = string;
        this.l = null;
        if (this.g) {
            this.a();
        }
        this.j = 0;
    }

    public char[] getBufferWithoutReset() {
        return this.i;
    }

    private char[] a(int n2) {
        if (this.b != null) {
            return this.b.allocCharBuffer(2, n2);
        }
        return new char[Math.max(n2, 500)];
    }

    private void a() {
        this.g = false;
        this.f.clear();
        TextBuffer textBuffer = this;
        textBuffer.h = 0;
        textBuffer.j = 0;
    }

    public BufferRecycler bufferRecycler() {
        return this.b;
    }

    public int size() {
        if (this.d >= 0) {
            return this.e;
        }
        if (this.l != null) {
            return this.l.length;
        }
        if (this.k != null) {
            return this.k.length();
        }
        return this.h + this.j;
    }

    public int getTextOffset() {
        if (this.d >= 0) {
            return this.d;
        }
        return 0;
    }

    public boolean hasTextAsCharacters() {
        if (this.d >= 0 || this.l != null) {
            return true;
        }
        return this.k == null;
    }

    public char[] getTextBuffer() {
        if (this.d >= 0) {
            return this.c;
        }
        if (this.l != null) {
            return this.l;
        }
        if (this.k != null) {
            this.l = this.k.toCharArray();
            return this.l;
        }
        if (!this.g) {
            if (this.i == null) {
                return a;
            }
            return this.i;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() {
        if (this.k == null) {
            if (this.l != null) {
                this.k = new String(this.l);
            } else if (this.d >= 0) {
                if (this.e <= 0) {
                    this.k = "";
                    return "";
                }
                TextBuffer textBuffer = this;
                textBuffer.validateStringLength(textBuffer.e);
                this.k = new String(this.c, this.d, this.e);
            } else {
                int n2 = this.h;
                int n3 = this.j;
                if (n2 == 0) {
                    if (n3 == 0) {
                        this.k = "";
                    } else {
                        this.validateStringLength(n3);
                        this.k = new String(this.i, 0, n3);
                    }
                } else {
                    int n4 = n2 + n3;
                    if (n4 < 0) {
                        this._reportBufferOverflow(n2, n3);
                    }
                    this.validateStringLength(n4);
                    StringBuilder stringBuilder = new StringBuilder(n4);
                    if (this.f != null) {
                        n4 = this.f.size();
                        for (n3 = 0; n3 < n4; ++n3) {
                            char[] cArray = this.f.get(n3);
                            stringBuilder.append(cArray, 0, cArray.length);
                        }
                    }
                    stringBuilder.append(this.i, 0, this.j);
                    this.k = stringBuilder.toString();
                }
            }
        }
        return this.k;
    }

    public char[] contentsAsArray() {
        Object object = this.l;
        if (this.l == null) {
            char[] cArray;
            TextBuffer textBuffer = this;
            object = textBuffer;
            if (textBuffer.k != null) {
                cArray = ((TextBuffer)object).k.toCharArray();
            } else if (((TextBuffer)object).d >= 0) {
                int n2 = ((TextBuffer)object).e;
                if (n2 <= 0) {
                    cArray = a;
                } else {
                    ((TextBuffer)object).validateStringLength(n2);
                    int n3 = ((TextBuffer)object).d;
                    if (n3 == 0) {
                        cArray = Arrays.copyOf(((TextBuffer)object).c, n2);
                    } else {
                        int n4 = n3;
                        cArray = Arrays.copyOfRange(((TextBuffer)object).c, n4, n4 + n2);
                    }
                }
            } else {
                int n5 = ((TextBuffer)object).size();
                if (n5 <= 0) {
                    if (n5 < 0) {
                        Object object2 = object;
                        ((TextBuffer)object2)._reportBufferOverflow(((TextBuffer)object2).h, ((TextBuffer)object).j);
                    }
                    cArray = a;
                } else {
                    ((TextBuffer)object).validateStringLength(n5);
                    int n6 = 0;
                    char[] cArray2 = new char[n5];
                    if (((TextBuffer)object).f != null) {
                        int n7 = ((TextBuffer)object).f.size();
                        for (int i2 = 0; i2 < n7; ++i2) {
                            char[] cArray3 = ((TextBuffer)object).f.get(i2);
                            int n8 = cArray3.length;
                            System.arraycopy(cArray3, 0, cArray2, n6, n8);
                            n6 += n8;
                        }
                    }
                    System.arraycopy(((TextBuffer)object).i, 0, cArray2, n6, ((TextBuffer)object).j);
                    cArray = cArray2;
                }
            }
            object = cArray;
            textBuffer.l = cArray;
        }
        return object;
    }

    public double contentsAsDouble(boolean bl2) {
        try {
            return NumberInput.parseDouble(this.contentsAsString(), bl2);
        }
        catch (IOException iOException) {
            throw new NumberFormatException(iOException.getMessage());
        }
    }

    @Deprecated
    public double contentsAsDouble() {
        return this.contentsAsDouble(false);
    }

    @Deprecated
    public float contentsAsFloat() {
        return this.contentsAsFloat(false);
    }

    public float contentsAsFloat(boolean bl2) {
        try {
            return NumberInput.parseFloat(this.contentsAsString(), bl2);
        }
        catch (IOException iOException) {
            throw new NumberFormatException(iOException.getMessage());
        }
    }

    @Deprecated
    public BigDecimal contentsAsDecimal() {
        try {
            return NumberInput.parseBigDecimal(this.contentsAsArray());
        }
        catch (IOException iOException) {
            throw new NumberFormatException(iOException.getMessage());
        }
    }

    public int contentsAsInt(boolean bl2) {
        if (this.d >= 0 && this.c != null) {
            if (bl2) {
                return -NumberInput.parseInt(this.c, this.d + 1, this.e - 1);
            }
            return NumberInput.parseInt(this.c, this.d, this.e);
        }
        if (bl2) {
            return -NumberInput.parseInt(this.i, 1, this.j - 1);
        }
        return NumberInput.parseInt(this.i, 0, this.j);
    }

    public long contentsAsLong(boolean bl2) {
        if (this.d >= 0 && this.c != null) {
            if (bl2) {
                return -NumberInput.parseLong(this.c, this.d + 1, this.e - 1);
            }
            return NumberInput.parseLong(this.c, this.d, this.e);
        }
        if (bl2) {
            return -NumberInput.parseLong(this.i, 1, this.j - 1);
        }
        return NumberInput.parseLong(this.i, 0, this.j);
    }

    public int contentsToWriter(Writer writer) {
        int n2;
        if (this.l != null) {
            writer.write(this.l);
            return this.l.length;
        }
        if (this.k != null) {
            writer.write(this.k);
            return this.k.length();
        }
        if (this.d >= 0) {
            int n3 = this.e;
            if (n3 > 0) {
                writer.write(this.c, this.d, n3);
            }
            return n3;
        }
        int n4 = 0;
        if (this.f != null) {
            int n5 = this.f.size();
            for (n2 = 0; n2 < n5; ++n2) {
                char[] cArray = this.f.get(n2);
                int n6 = cArray.length;
                n4 += n6;
                writer.write(cArray, 0, n6);
            }
        }
        if ((n2 = this.j) > 0) {
            n4 += n2;
            writer.write(this.i, 0, n2);
        }
        return n4;
    }

    public void ensureNotShared() {
        if (this.d >= 0) {
            this.c(16);
        }
    }

    public void append(char c2) {
        if (this.d >= 0) {
            this.c(16);
        }
        this.k = null;
        this.l = null;
        char[] cArray = this.i;
        if (this.j >= cArray.length) {
            this.b(1);
            this.b();
            cArray = this.i;
        }
        cArray[this.j++] = c2;
    }

    public void append(char[] cArray, int n2, int n3) {
        int n4;
        if (this.d >= 0) {
            this.c(n3);
        }
        this.k = null;
        this.l = null;
        char[] cArray2 = this.i;
        int n5 = this.i.length - this.j;
        if (n5 >= n3) {
            System.arraycopy(cArray, n2, cArray2, this.j, n3);
            this.j += n3;
            return;
        }
        this.b(n3);
        if (n5 > 0) {
            System.arraycopy(cArray, n2, cArray2, this.j, n5);
            n2 += n5;
            n3 -= n5;
        }
        do {
            this.b();
            n4 = Math.min(this.i.length, n3);
            System.arraycopy(cArray, n2, this.i, 0, n4);
            this.j += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public void append(String string, int n2, int n3) {
        int n4;
        if (this.d >= 0) {
            this.c(n3);
        }
        this.k = null;
        this.l = null;
        char[] cArray = this.i;
        int n5 = this.i.length - this.j;
        if (n5 >= n3) {
            int n6 = n2;
            string.getChars(n6, n6 + n3, cArray, this.j);
            this.j += n3;
            return;
        }
        this.b(n3);
        if (n5 > 0) {
            int n7 = n2;
            string.getChars(n7, n7 + n5, cArray, this.j);
            n3 -= n5;
            n2 += n5;
        }
        do {
            this.b();
            n4 = Math.min(this.i.length, n3);
            int n8 = n2;
            string.getChars(n8, n8 + n4, this.i, 0);
            this.j += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private void b(int n2) {
        if ((n2 = this.h + this.j + n2) < 0) {
            n2 = Integer.MAX_VALUE;
        }
        this.validateStringLength(n2);
    }

    public char[] getCurrentSegment() {
        if (this.d >= 0) {
            this.c(1);
        } else {
            char[] cArray = this.i;
            if (this.i == null) {
                this.i = this.a(0);
            } else if (this.j >= cArray.length) {
                this.b();
            }
        }
        return this.i;
    }

    public char[] emptyAndGetCurrentSegment() {
        this.d = -1;
        this.j = 0;
        this.e = 0;
        this.c = null;
        this.k = null;
        this.l = null;
        if (this.g) {
            this.a();
        }
        char[] cArray = this.i;
        if (this.i == null) {
            this.i = cArray = this.a(0);
        }
        return cArray;
    }

    public int getCurrentSegmentSize() {
        return this.j;
    }

    public void setCurrentLength(int n2) {
        this.j = n2;
    }

    public String setCurrentAndReturn(int n2) {
        String string;
        this.j = n2;
        if (this.h > 0) {
            return this.contentsAsString();
        }
        n2 = this.j;
        this.validateStringLength(n2);
        this.k = string = n2 == 0 ? "" : new String(this.i, 0, n2);
        return string;
    }

    public char[] finishCurrentSegment() {
        if (this.f == null) {
            this.f = new ArrayList();
        }
        this.g = true;
        this.f.add(this.i);
        int n2 = this.i.length;
        this.h += n2;
        if (this.h < 0) {
            TextBuffer textBuffer = this;
            textBuffer._reportBufferOverflow(textBuffer.h - n2, n2);
        }
        this.j = 0;
        TextBuffer textBuffer = this;
        textBuffer.validateStringLength(textBuffer.h);
        int n3 = n2;
        n2 = n3 + (n3 >> 1);
        if (n2 < 500) {
            n2 = 500;
        } else if (n2 > 65536) {
            n2 = 65536;
        }
        char[] cArray = new char[n2];
        this.i = cArray;
        return cArray;
    }

    public String finishAndReturn(int n2, boolean n3) {
        if (n3 != 0 && ((n3 = n2 - 1) < 0 || this.i[n3] <= ' ')) {
            TextBuffer textBuffer = this;
            while (true) {
                char[] cArray = textBuffer.i;
                while (--n3 >= 0) {
                    if (cArray[n3] <= ' ') continue;
                    textBuffer.j = n3 + 1;
                    return textBuffer.contentsAsString();
                }
                if (textBuffer.f == null || textBuffer.f.isEmpty()) break;
                textBuffer.i = textBuffer.f.remove(textBuffer.f.size() - 1);
                n3 = textBuffer.i.length;
            }
            textBuffer.j = 0;
            textBuffer.g = false;
            return textBuffer.contentsAsString();
        }
        this.j = n2;
        return this.contentsAsString();
    }

    public char[] expandCurrentSegment() {
        char[] cArray = this.i;
        int n2 = this.i.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 > 65536) {
            int n4 = n2;
            n3 = n4 + (n4 >> 2);
        }
        this.i = Arrays.copyOf(cArray, n3);
        return this.i;
    }

    public char[] expandCurrentSegment(int n2) {
        char[] cArray = this.i;
        if (this.i.length >= n2) {
            return cArray;
        }
        this.i = cArray = Arrays.copyOf(cArray, n2);
        return cArray;
    }

    public String toString() {
        try {
            return this.contentsAsString();
        }
        catch (IOException iOException) {
            return "TextBuffer: Exception when reading contents";
        }
    }

    private void c(int n2) {
        int n3 = this.e;
        this.e = 0;
        char[] cArray = this.c;
        this.c = null;
        int n4 = this.d;
        this.d = -1;
        n2 = n3 + n2;
        if (this.i == null || n2 > this.i.length) {
            this.i = this.a(n2);
        }
        if (n3 > 0) {
            System.arraycopy(cArray, n4, this.i, 0, n3);
        }
        this.h = 0;
        this.j = n3;
    }

    private void b() {
        if (this.f == null) {
            this.f = new ArrayList();
        }
        char[] cArray = this.i;
        this.g = true;
        this.f.add(cArray);
        this.h += cArray.length;
        if (this.h < 0) {
            TextBuffer textBuffer = this;
            textBuffer._reportBufferOverflow(textBuffer.h - cArray.length, cArray.length);
        }
        this.j = 0;
        int n2 = cArray.length;
        if ((n2 += n2 >> 1) < 500) {
            n2 = 500;
        } else if (n2 > 65536) {
            n2 = 65536;
        }
        this.i = new char[n2];
    }

    protected void _reportBufferOverflow(int n2, int n3) {
        long l2 = (long)n2 + (long)n3;
        throw new IllegalStateException("TextBuffer overrun: size reached (" + l2 + ") exceeds maximum of 2147483647");
    }

    protected void validateStringLength(int n2) {
    }
}

