/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DatabindContext {
    public abstract MapperConfig<?> getConfig();

    public abstract AnnotationIntrospector getAnnotationIntrospector();

    public abstract boolean isEnabled(MapperFeature var1);

    public abstract boolean isEnabled(DatatypeFeature var1);

    public abstract DatatypeFeatures getDatatypeFeatures();

    public abstract boolean canOverrideAccessModifiers();

    public abstract Class<?> getActiveView();

    public abstract Locale getLocale();

    public abstract TimeZone getTimeZone();

    public abstract JsonFormat.Value getDefaultPropertyFormat(Class<?> var1);

    public abstract Object getAttribute(Object var1);

    public abstract DatabindContext setAttribute(Object var1, Object var2);

    public JavaType constructType(Type type) {
        if (type == null) {
            return null;
        }
        return this.getTypeFactory().constructType(type);
    }

    public abstract JavaType constructSpecializedType(JavaType var1, Class<?> var2);

    public JavaType resolveSubType(JavaType javaType, String string) {
        if (string.indexOf(60) > 0) {
            JavaType javaType2 = this.getTypeFactory().constructFromCanonical(string);
            if (javaType2.isTypeOrSubTypeOf(((ResolvedType)javaType).getRawClass())) {
                return javaType2;
            }
        } else {
            Class<?> clazz;
            try {
                clazz = this.getTypeFactory().findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (Exception exception) {
                throw this.invalidTypeIdException(javaType, string, String.format("problem: (%s) %s", exception.getClass().getName(), ClassUtil.exceptionMessage(exception)));
            }
            if (javaType.isTypeOrSuperTypeOf(clazz)) {
                return this.getTypeFactory().constructSpecializedType(javaType, clazz);
            }
        }
        throw this.invalidTypeIdException(javaType, string, "Not a subtype");
    }

    public JavaType resolveAndValidateSubType(JavaType object, String object2, PolymorphicTypeValidator object3) {
        Type type;
        int n2 = ((String)object2).indexOf(60);
        if (n2 > 0) {
            int n3 = n2;
            PolymorphicTypeValidator polymorphicTypeValidator = object3;
            object3 = object2;
            object2 = object;
            object = this;
            MapperConfig<?> mapperConfig = ((DatabindContext)object).getConfig();
            PolymorphicTypeValidator.Validity validity = polymorphicTypeValidator.validateSubClassName(mapperConfig, (JavaType)object2, ((String)object3).substring(0, n3));
            if (validity == PolymorphicTypeValidator.Validity.DENIED) {
                return (JavaType)((DatabindContext)object)._throwSubtypeNameNotAllowed((JavaType)object2, (String)object3, polymorphicTypeValidator);
            }
            JavaType javaType = ((DatabindContext)object).getTypeFactory().constructFromCanonical((String)object3);
            if (!javaType.isTypeOrSubTypeOf(((ResolvedType)object2).getRawClass())) {
                return (JavaType)((DatabindContext)object)._throwNotASubtype((JavaType)object2, (String)object3);
            }
            if (validity != PolymorphicTypeValidator.Validity.ALLOWED && polymorphicTypeValidator.validateSubType(mapperConfig, (JavaType)object2, javaType) != PolymorphicTypeValidator.Validity.ALLOWED) {
                return (JavaType)((DatabindContext)object)._throwSubtypeClassNotAllowed((JavaType)object2, (String)object3, polymorphicTypeValidator);
            }
            return javaType;
        }
        MapperConfig<?> mapperConfig = this.getConfig();
        PolymorphicTypeValidator.Validity validity = ((PolymorphicTypeValidator)object3).validateSubClassName(mapperConfig, (JavaType)object, (String)object2);
        if (validity == PolymorphicTypeValidator.Validity.DENIED) {
            return (JavaType)this._throwSubtypeNameNotAllowed((JavaType)object, (String)object2, (PolymorphicTypeValidator)object3);
        }
        try {
            type = this.getTypeFactory().findClass((String)object2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            throw this.invalidTypeIdException((JavaType)object, (String)object2, String.format("problem: (%s) %s", exception.getClass().getName(), ClassUtil.exceptionMessage(exception)));
        }
        if (!((JavaType)object).isTypeOrSuperTypeOf((Class<?>)type)) {
            return (JavaType)this._throwNotASubtype((JavaType)object, (String)object2);
        }
        type = mapperConfig.getTypeFactory().constructSpecializedType((JavaType)object, (Class<?>)type);
        if (validity == PolymorphicTypeValidator.Validity.INDETERMINATE && (validity = ((PolymorphicTypeValidator)object3).validateSubType(mapperConfig, (JavaType)object, (JavaType)type)) != PolymorphicTypeValidator.Validity.ALLOWED) {
            return (JavaType)this._throwSubtypeClassNotAllowed((JavaType)object, (String)object2, (PolymorphicTypeValidator)object3);
        }
        return type;
    }

    protected <T> T _throwNotASubtype(JavaType javaType, String string) {
        throw this.invalidTypeIdException(javaType, string, "Not a subtype");
    }

    protected <T> T _throwSubtypeNameNotAllowed(JavaType javaType, String string, PolymorphicTypeValidator polymorphicTypeValidator) {
        throw this.invalidTypeIdException(javaType, string, "Configured `PolymorphicTypeValidator` (of type " + ClassUtil.classNameOf(polymorphicTypeValidator) + ") denied resolution");
    }

    protected <T> T _throwSubtypeClassNotAllowed(JavaType javaType, String string, PolymorphicTypeValidator polymorphicTypeValidator) {
        throw this.invalidTypeIdException(javaType, string, "Configured `PolymorphicTypeValidator` (of type " + ClassUtil.classNameOf(polymorphicTypeValidator) + ") denied resolution");
    }

    protected abstract JsonMappingException invalidTypeIdException(JavaType var1, String var2, String var3);

    public abstract TypeFactory getTypeFactory();

    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated objectIdGenerator, ObjectIdInfo objectIdInfo) {
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        objectIdGenerator = handlerInstantiator == null ? null : handlerInstantiator.objectIdGeneratorInstance(mapperConfig, (Annotated)((Object)objectIdGenerator), clazz);
        if (objectIdGenerator == null) {
            objectIdGenerator = ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return objectIdGenerator.forScope(objectIdInfo.getScope());
    }

    public ObjectIdResolver objectIdResolverInstance(Annotated object, ObjectIdInfo object2) {
        object2 = ((ObjectIdInfo)object2).getResolverType();
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        object = handlerInstantiator == null ? null : handlerInstantiator.resolverIdGeneratorInstance(mapperConfig, (Annotated)object, (Class<?>)object2);
        if (object == null) {
            object = (ObjectIdResolver)ClassUtil.createInstance(object2, mapperConfig.canOverrideAccessModifiers());
        }
        return object;
    }

    public Converter<Object, Object> converterInstance(Annotated converter, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        if ((object = (Class)object) == Converter.None.class || ClassUtil.isBogusClass(object)) {
            return null;
        }
        if (!Converter.class.isAssignableFrom((Class<?>)object)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + ((Class)object).getName() + "; expected Class<Converter>");
        }
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        converter = handlerInstantiator == null ? null : handlerInstantiator.converterInstance(mapperConfig, (Annotated)((Object)converter), (Class<?>)object);
        if (converter == null) {
            converter = (Converter)ClassUtil.createInstance(object, mapperConfig.canOverrideAccessModifiers());
        }
        return converter;
    }

    public abstract <T> T reportBadDefinition(JavaType var1, String var2);

    public <T> T reportBadDefinition(Class<?> clazz, String string) {
        DatabindContext databindContext = this;
        return databindContext.reportBadDefinition(databindContext.constructType(clazz), string);
    }

    protected final String _format(String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            return String.format(string, objectArray);
        }
        return string;
    }

    protected final String _truncate(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() <= 500) {
            return string;
        }
        String string2 = string;
        return string.substring(0, 500) + "]...[" + string2.substring(string2.length() - 500);
    }

    protected String _quotedString(String string) {
        if (string == null) {
            return "[N/A]";
        }
        return String.format("\"%s\"", this._truncate(string));
    }

    protected String _colonConcat(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        return string + ": " + string2;
    }

    protected String _desc(String string) {
        if (string == null) {
            return "[N/A]";
        }
        return this._truncate(string);
    }
}

