/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionConfigs;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.LinkedNode;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;
import java.util.Collection;

public final class DeserializationConfig
extends MapperConfigBase<DeserializationFeature, DeserializationConfig>
implements Serializable {
    private static final int a = DeserializationConfig.collectFeatureDefaults(DeserializationFeature.class);
    protected final LinkedNode<DeserializationProblemHandler> _problemHandlers;
    protected final JsonNodeFactory _nodeFactory;
    protected final CoercionConfigs _coercionConfigs;
    protected final ConstructorDetector _ctorDetector;
    protected final int _deserFeatures;
    protected final int _parserFeatures;
    protected final int _parserFeaturesToChange;
    protected final int _formatReadFeatures;
    protected final int _formatReadFeaturesToChange;

    public DeserializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides, CoercionConfigs coercionConfigs, DatatypeFeatures datatypeFeatures) {
        super(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides, datatypeFeatures);
        this._deserFeatures = a;
        this._problemHandlers = null;
        this._nodeFactory = JsonNodeFactory.instance;
        this._ctorDetector = null;
        this._coercionConfigs = coercionConfigs;
        this._parserFeatures = 0;
        this._parserFeaturesToChange = 0;
        this._formatReadFeatures = 0;
        this._formatReadFeaturesToChange = 0;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides, CoercionConfigs coercionConfigs) {
        super(deserializationConfig, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._coercionConfigs = coercionConfigs;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, long l2, int n2, int n3, int n4, int n5, int n6) {
        super(deserializationConfig, l2);
        this._deserFeatures = n2;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = n3;
        this._parserFeaturesToChange = n4;
        this._formatReadFeatures = n5;
        this._formatReadFeaturesToChange = n6;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, SubtypeResolver subtypeResolver) {
        super(deserializationConfig, subtypeResolver);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, BaseSettings baseSettings) {
        super(deserializationConfig, baseSettings);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, JsonNodeFactory jsonNodeFactory) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = jsonNodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, ConstructorDetector constructorDetector) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = constructorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, LinkedNode<DeserializationProblemHandler> linkedNode) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = linkedNode;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, PropertyName propertyName) {
        super(deserializationConfig, propertyName);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, Class<?> clazz) {
        super(deserializationConfig, clazz);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, ContextAttributes contextAttributes) {
        super(deserializationConfig, contextAttributes);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, SimpleMixInResolver simpleMixInResolver) {
        super(deserializationConfig, simpleMixInResolver);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, DatatypeFeatures datatypeFeatures) {
        super(deserializationConfig, datatypeFeatures);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected final BaseSettings getBaseSettings() {
        return this._base;
    }

    @Override
    protected final DeserializationConfig _withBase(BaseSettings baseSettings) {
        if (this._base == baseSettings) {
            return this;
        }
        return new DeserializationConfig(this, baseSettings);
    }

    @Override
    protected final DeserializationConfig _withMapperFeatures(long l2) {
        return new DeserializationConfig(this, l2, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    @Override
    protected final DeserializationConfig _with(DatatypeFeatures datatypeFeatures) {
        return new DeserializationConfig(this, datatypeFeatures);
    }

    @Override
    public final DeserializationConfig with(SubtypeResolver subtypeResolver) {
        if (this._subtypeResolver == subtypeResolver) {
            return this;
        }
        return new DeserializationConfig(this, subtypeResolver);
    }

    @Override
    public final DeserializationConfig withRootName(PropertyName propertyName) {
        if (propertyName == null ? this._rootName == null : propertyName.equals(this._rootName)) {
            return this;
        }
        return new DeserializationConfig(this, propertyName);
    }

    @Override
    public final DeserializationConfig withView(Class<?> clazz) {
        if (this._view == clazz) {
            return this;
        }
        return new DeserializationConfig(this, clazz);
    }

    @Override
    public final DeserializationConfig with(ContextAttributes contextAttributes) {
        if (contextAttributes == this._attributes) {
            return this;
        }
        return new DeserializationConfig(this, contextAttributes);
    }

    public final DeserializationConfig with(DeserializationFeature deserializationFeature) {
        int n2 = this._deserFeatures | deserializationFeature.getMask();
        if (n2 == this._deserFeatures) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig with(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures | deserializationFeature.getMask();
        for (DeserializationFeature deserializationFeature2 : deserializationFeatureArray) {
            n2 |= deserializationFeature2.getMask();
        }
        if (n2 == this._deserFeatures) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig withFeatures(DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures;
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            n2 |= deserializationFeature.getMask();
        }
        if (n2 == this._deserFeatures) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig without(DeserializationFeature deserializationFeature) {
        int n2 = this._deserFeatures & ~deserializationFeature.getMask();
        if (n2 == this._deserFeatures) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig without(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures & ~deserializationFeature.getMask();
        for (DeserializationFeature deserializationFeature2 : deserializationFeatureArray) {
            n2 &= ~deserializationFeature2.getMask();
        }
        if (n2 == this._deserFeatures) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig withoutFeatures(DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures;
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            n2 &= ~deserializationFeature.getMask();
        }
        if (n2 == this._deserFeatures) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig with(JsonParser.Feature feature) {
        int n2 = this._parserFeatures | feature.getMask();
        int n3 = this._parserFeaturesToChange | feature.getMask();
        if (this._parserFeatures == n2 && this._parserFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, n2, n3, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig withFeatures(JsonParser.Feature ... featureArray) {
        int n2 = this._parserFeatures;
        int n3 = this._parserFeaturesToChange;
        for (JsonParser.Feature feature : featureArray) {
            int n4 = feature.getMask();
            n2 |= n4;
            n3 |= n4;
        }
        if (this._parserFeatures == n2 && this._parserFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, n2, n3, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig without(JsonParser.Feature feature) {
        int n2 = this._parserFeatures & ~feature.getMask();
        int n3 = this._parserFeaturesToChange | feature.getMask();
        if (this._parserFeatures == n2 && this._parserFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, n2, n3, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig withoutFeatures(JsonParser.Feature ... featureArray) {
        int n2 = this._parserFeatures;
        int n3 = this._parserFeaturesToChange;
        for (JsonParser.Feature feature : featureArray) {
            int n4 = feature.getMask();
            n2 &= ~n4;
            n3 |= n4;
        }
        if (this._parserFeatures == n2 && this._parserFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, n2, n3, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public final DeserializationConfig with(FormatFeature formatFeature) {
        if (formatFeature instanceof JsonReadFeature) {
            return this.a(formatFeature);
        }
        int n2 = this._formatReadFeatures | formatFeature.getMask();
        int n3 = this._formatReadFeaturesToChange | formatFeature.getMask();
        if (this._formatReadFeatures == n2 && this._formatReadFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n2, n3);
    }

    public final DeserializationConfig withFeatures(FormatFeature ... formatFeatureArray) {
        if (formatFeatureArray.length > 0 && formatFeatureArray[0] instanceof JsonReadFeature) {
            return this.a(formatFeatureArray);
        }
        int n2 = this._formatReadFeatures;
        int n3 = this._formatReadFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n4 = formatFeature.getMask();
            n2 |= n4;
            n3 |= n4;
        }
        if (this._formatReadFeatures == n2 && this._formatReadFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n2, n3);
    }

    public final DeserializationConfig without(FormatFeature formatFeature) {
        if (formatFeature instanceof JsonReadFeature) {
            return this.b(formatFeature);
        }
        int n2 = this._formatReadFeatures & ~formatFeature.getMask();
        int n3 = this._formatReadFeaturesToChange | formatFeature.getMask();
        if (this._formatReadFeatures == n2 && this._formatReadFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n2, n3);
    }

    public final DeserializationConfig withoutFeatures(FormatFeature ... formatFeatureArray) {
        if (formatFeatureArray.length > 0 && formatFeatureArray[0] instanceof JsonReadFeature) {
            return this.b(formatFeatureArray);
        }
        int n2 = this._formatReadFeatures;
        int n3 = this._formatReadFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n4 = formatFeature.getMask();
            n2 &= ~n4;
            n3 |= n4;
        }
        if (this._formatReadFeatures == n2 && this._formatReadFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n2, n3);
    }

    private DeserializationConfig a(FormatFeature ... formatFeatureArray) {
        int n2 = this._parserFeatures;
        int n3 = this._parserFeaturesToChange;
        int n4 = this._formatReadFeatures;
        int n5 = this._formatReadFeaturesToChange;
        for (FormatFeature object : formatFeatureArray) {
            JsonParser.Feature n7;
            int n6 = object.getMask();
            n4 |= n6;
            n5 |= n6;
            if (!(object instanceof JsonReadFeature) || (n7 = ((JsonReadFeature)object).mappedFeature()) == null) continue;
            int n8 = n7.getMask();
            n2 |= n8;
            n3 |= n8;
        }
        if (this._formatReadFeatures == n4 && this._formatReadFeaturesToChange == n5 && this._parserFeatures == n2 && this._parserFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, n2, n3, n4, n5);
    }

    private DeserializationConfig b(FormatFeature ... formatFeatureArray) {
        int n2 = this._parserFeatures;
        int n3 = this._parserFeaturesToChange;
        int n4 = this._formatReadFeatures;
        int n5 = this._formatReadFeaturesToChange;
        for (FormatFeature object : formatFeatureArray) {
            JsonParser.Feature n7;
            int n6 = object.getMask();
            n4 &= ~n6;
            n5 |= n6;
            if (!(object instanceof JsonReadFeature) || (n7 = ((JsonReadFeature)object).mappedFeature()) == null) continue;
            int n8 = n7.getMask();
            n2 &= ~n8;
            n3 |= n8;
        }
        if (this._formatReadFeatures == n4 && this._formatReadFeaturesToChange == n5 && this._parserFeatures == n2 && this._parserFeaturesToChange == n3) {
            return this;
        }
        DeserializationConfig deserializationConfig = this;
        return new DeserializationConfig(deserializationConfig, deserializationConfig._mapperFeatures, this._deserFeatures, n2, n3, n4, n5);
    }

    public final DeserializationConfig with(JsonNodeFactory jsonNodeFactory) {
        if (this._nodeFactory == jsonNodeFactory) {
            return this;
        }
        return new DeserializationConfig(this, jsonNodeFactory);
    }

    public final DeserializationConfig with(ConstructorDetector constructorDetector) {
        if (this._ctorDetector == constructorDetector) {
            return this;
        }
        return new DeserializationConfig(this, constructorDetector);
    }

    public final DeserializationConfig withHandler(DeserializationProblemHandler deserializationProblemHandler) {
        if (LinkedNode.contains(this._problemHandlers, deserializationProblemHandler)) {
            return this;
        }
        return new DeserializationConfig(this, new LinkedNode<DeserializationProblemHandler>(deserializationProblemHandler, this._problemHandlers));
    }

    public final DeserializationConfig withNoProblemHandlers() {
        if (this._problemHandlers == null) {
            return this;
        }
        return new DeserializationConfig(this, null);
    }

    public final JsonParser initialize(JsonParser jsonParser) {
        if (this._parserFeaturesToChange != 0) {
            jsonParser.overrideStdFeatures(this._parserFeatures, this._parserFeaturesToChange);
        }
        if (this._formatReadFeaturesToChange != 0) {
            jsonParser.overrideFormatFeatures(this._formatReadFeatures, this._formatReadFeaturesToChange);
        }
        return jsonParser;
    }

    public final JsonParser initialize(JsonParser jsonParser, FormatSchema formatSchema) {
        if (this._parserFeaturesToChange != 0) {
            jsonParser.overrideStdFeatures(this._parserFeatures, this._parserFeaturesToChange);
        }
        if (this._formatReadFeaturesToChange != 0) {
            jsonParser.overrideFormatFeatures(this._formatReadFeatures, this._formatReadFeaturesToChange);
        }
        if (formatSchema != null) {
            jsonParser.setSchema(formatSchema);
        }
        return jsonParser;
    }

    @Override
    public final boolean useRootWrapping() {
        if (this._rootName != null) {
            return !this._rootName.isEmpty();
        }
        return this.isEnabled(DeserializationFeature.UNWRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._deserFeatures & deserializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(JsonParser.Feature feature, JsonFactory jsonFactory) {
        int n2 = feature.getMask();
        if ((this._parserFeaturesToChange & n2) != 0) {
            return (this._parserFeatures & feature.getMask()) != 0;
        }
        return ((TokenStreamFactory)jsonFactory).isEnabled(feature);
    }

    public final boolean hasDeserializationFeatures(int n2) {
        return (this._deserFeatures & n2) == n2;
    }

    public final boolean hasSomeOfFeatures(int n2) {
        return (this._deserFeatures & n2) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._deserFeatures;
    }

    public final boolean requiresFullValue() {
        return DeserializationFeature.FAIL_ON_TRAILING_TOKENS.enabledIn(this._deserFeatures);
    }

    @Override
    public final boolean isEnabled(DatatypeFeature datatypeFeature) {
        return this._datatypeFeatures.isEnabled(datatypeFeature);
    }

    public final LinkedNode<DeserializationProblemHandler> getProblemHandlers() {
        return this._problemHandlers;
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    public final ConstructorDetector getConstructorDetector() {
        if (this._ctorDetector == null) {
            return ConstructorDetector.DEFAULT;
        }
        return this._ctorDetector;
    }

    public final BeanDescription introspect(JavaType javaType) {
        return this.getClassIntrospector().forDeserialization(this, javaType, this);
    }

    public final BeanDescription introspectForCreation(JavaType javaType) {
        return this.getClassIntrospector().forCreation(this, javaType, this);
    }

    public final BeanDescription introspectForBuilder(JavaType javaType, BeanDescription beanDescription) {
        return this.getClassIntrospector().forDeserializationWithBuilder(this, javaType, this, beanDescription);
    }

    @Deprecated
    public final BeanDescription introspectForBuilder(JavaType javaType) {
        return this.getClassIntrospector().forDeserializationWithBuilder(this, javaType, this);
    }

    public final TypeDeserializer findTypeDeserializer(JavaType javaType) {
        Object object = this.introspectClassAnnotations(((ResolvedType)javaType).getRawClass());
        object = ((BeanDescription)object).getClassInfo();
        TypeResolverBuilder<?> typeResolverBuilder = this.getAnnotationIntrospector().findTypeResolver(this, (AnnotatedClass)object, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this.getDefaultTyper(javaType);
            if (typeResolverBuilder == null) {
                return null;
            }
        } else {
            collection = ((MapperConfig)this).getSubtypeResolver().collectAndResolveSubtypesByTypeId(this, (AnnotatedClass)object);
        }
        return typeResolverBuilder.buildTypeDeserializer(this, javaType, collection);
    }

    public final CoercionAction findCoercionAction(LogicalType logicalType, Class<?> clazz, CoercionInputShape coercionInputShape) {
        return this._coercionConfigs.findCoercion(this, logicalType, clazz, coercionInputShape);
    }

    public final CoercionAction findCoercionFromBlankString(LogicalType logicalType, Class<?> clazz, CoercionAction coercionAction) {
        return this._coercionConfigs.findCoercionFromBlankString(this, logicalType, clazz, coercionAction);
    }
}

