/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.Instantiatable;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectWriter
implements Versioned,
Serializable {
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _generatorFactory;
    protected final GeneratorSettings _generatorSettings;
    protected final Prefetch _prefetch;

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        GeneratorSettings generatorSettings = this._generatorSettings = prettyPrinter == null ? GeneratorSettings.empty : new GeneratorSettings(prettyPrinter, null, null, null);
        if (javaType == null) {
            this._prefetch = Prefetch.empty;
            return;
        }
        if (((ResolvedType)javaType).hasRawClass(Object.class)) {
            this._prefetch = Prefetch.empty.forRootType(this, javaType);
            return;
        }
        this._prefetch = Prefetch.empty.forRootType(this, javaType.withStaticTyping());
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._generatorSettings = GeneratorSettings.empty;
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._generatorSettings = formatSchema == null ? GeneratorSettings.empty : new GeneratorSettings(null, formatSchema, null, null);
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig, GeneratorSettings generatorSettings, Prefetch prefetch) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = generatorSettings;
        this._prefetch = prefetch;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = objectWriter._generatorSettings;
        this._prefetch = objectWriter._prefetch;
    }

    protected ObjectWriter(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        this._config = (SerializationConfig)objectWriter._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, ((TokenStreamFactory)jsonFactory).requiresPropertyOrdering());
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = jsonFactory;
        this._generatorSettings = objectWriter._generatorSettings;
        this._prefetch = objectWriter._prefetch;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectWriter _new(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        return new ObjectWriter(objectWriter, jsonFactory);
    }

    protected ObjectWriter _new(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        if (serializationConfig == this._config) {
            return this;
        }
        return new ObjectWriter(objectWriter, serializationConfig);
    }

    protected ObjectWriter _new(GeneratorSettings generatorSettings, Prefetch prefetch) {
        if (this._generatorSettings == generatorSettings && this._prefetch == prefetch) {
            return this;
        }
        ObjectWriter objectWriter = this;
        return new ObjectWriter(objectWriter, objectWriter._config, generatorSettings, prefetch);
    }

    protected SequenceWriter _newSequenceWriter(boolean bl2, JsonGenerator jsonGenerator, boolean bl3) {
        return new SequenceWriter(this._serializerProvider(), this._configureGenerator(jsonGenerator), bl3, this._prefetch).init(bl2);
    }

    public ObjectWriter with(SerializationFeature serializationFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(serializationFeature));
    }

    public ObjectWriter with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter withFeatures(SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withFeatures(serializationFeatureArray));
    }

    public ObjectWriter without(SerializationFeature serializationFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(serializationFeature));
    }

    public ObjectWriter without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withoutFeatures(serializationFeatureArray));
    }

    public ObjectWriter with(DatatypeFeature datatypeFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.with(datatypeFeature));
    }

    public ObjectWriter withFeatures(DatatypeFeature ... datatypeFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withFeatures(datatypeFeatureArray));
    }

    public ObjectWriter without(DatatypeFeature datatypeFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.without(datatypeFeature));
    }

    public ObjectWriter withoutFeatures(DatatypeFeature ... datatypeFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withoutFeatures(datatypeFeatureArray));
    }

    public ObjectWriter with(JsonGenerator.Feature feature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(feature));
    }

    public ObjectWriter withFeatures(JsonGenerator.Feature ... featureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withFeatures(featureArray));
    }

    public ObjectWriter without(JsonGenerator.Feature feature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(feature));
    }

    public ObjectWriter withoutFeatures(JsonGenerator.Feature ... featureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withoutFeatures(featureArray));
    }

    public ObjectWriter with(StreamWriteFeature streamWriteFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(streamWriteFeature.mappedFeature()));
    }

    public ObjectWriter without(StreamWriteFeature streamWriteFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(streamWriteFeature.mappedFeature()));
    }

    public ObjectWriter with(FormatFeature formatFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(formatFeature));
    }

    public ObjectWriter withFeatures(FormatFeature ... formatFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withFeatures(formatFeatureArray));
    }

    public ObjectWriter without(FormatFeature formatFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(formatFeature));
    }

    public ObjectWriter withoutFeatures(FormatFeature ... formatFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withoutFeatures(formatFeatureArray));
    }

    public ObjectWriter forType(JavaType javaType) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings, this._prefetch.forRootType(this, javaType));
    }

    public ObjectWriter forType(Class<?> clazz) {
        ObjectWriter objectWriter = this;
        return objectWriter.forType(objectWriter._config.constructType(clazz));
    }

    public ObjectWriter forType(TypeReference<?> typeReference) {
        ObjectWriter objectWriter = this;
        return objectWriter.forType(objectWriter._config.getTypeFactory().constructType(typeReference.getType()));
    }

    @Deprecated
    public ObjectWriter withType(JavaType javaType) {
        return this.forType(javaType);
    }

    @Deprecated
    public ObjectWriter withType(Class<?> clazz) {
        return this.forType(clazz);
    }

    @Deprecated
    public ObjectWriter withType(TypeReference<?> typeReference) {
        return this.forType(typeReference);
    }

    public ObjectWriter with(DateFormat dateFormat) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(dateFormat));
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        ObjectWriter objectWriter = this;
        return objectWriter.with(objectWriter._config.getDefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter prettyPrinter) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.with(prettyPrinter), this._prefetch);
    }

    public ObjectWriter withRootName(String string) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withRootName(string));
    }

    public ObjectWriter withRootName(PropertyName propertyName) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withRootName(propertyName));
    }

    public ObjectWriter withoutRootName() {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectWriter with(FormatSchema formatSchema) {
        this._verifySchemaType(formatSchema);
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.with(formatSchema), this._prefetch);
    }

    @Deprecated
    public ObjectWriter withSchema(FormatSchema formatSchema) {
        return this.with(formatSchema);
    }

    public ObjectWriter withView(Class<?> clazz) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withView((Class)clazz));
    }

    public ObjectWriter with(Locale locale) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.with(locale));
    }

    public ObjectWriter with(TimeZone timeZone) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.with(timeZone));
    }

    public ObjectWriter with(Base64Variant base64Variant) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.with(base64Variant));
    }

    public ObjectWriter with(CharacterEscapes characterEscapes) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.with(characterEscapes), this._prefetch);
    }

    public ObjectWriter with(JsonFactory jsonFactory) {
        if (jsonFactory == this._generatorFactory) {
            return this;
        }
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, jsonFactory);
    }

    public ObjectWriter with(ContextAttributes contextAttributes) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(contextAttributes));
    }

    public ObjectWriter withAttributes(Map<?, ?> map) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withAttributes(map));
    }

    public ObjectWriter withAttribute(Object object, Object object2) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withAttribute(object, object2));
    }

    public ObjectWriter withoutAttribute(Object object) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withoutAttribute(object));
    }

    public ObjectWriter withRootValueSeparator(String string) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.withRootValueSeparator(string), this._prefetch);
    }

    public ObjectWriter withRootValueSeparator(SerializableString serializableString) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.withRootValueSeparator(serializableString), this._prefetch);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) {
        this._assertNotNull("out", outputStream);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(outputStream, JsonEncoding.UTF8));
    }

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        this._assertNotNull("out", outputStream);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(outputStream, jsonEncoding));
    }

    public JsonGenerator createGenerator(Writer writer) {
        this._assertNotNull("w", writer);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(writer));
    }

    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) {
        this._assertNotNull("outputFile", file);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(file, jsonEncoding));
    }

    public JsonGenerator createGenerator(DataOutput dataOutput) {
        this._assertNotNull("out", dataOutput);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(dataOutput));
    }

    public SequenceWriter writeValues(File file) {
        return this._newSequenceWriter(false, this.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(JsonGenerator jsonGenerator) {
        this._assertNotNull("g", jsonGenerator);
        return this._newSequenceWriter(false, this._configureGenerator(jsonGenerator), false);
    }

    public SequenceWriter writeValues(Writer writer) {
        return this._newSequenceWriter(false, this.createGenerator(writer), true);
    }

    public SequenceWriter writeValues(OutputStream outputStream) {
        return this._newSequenceWriter(false, this.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(DataOutput dataOutput) {
        return this._newSequenceWriter(false, this.createGenerator(dataOutput), true);
    }

    public SequenceWriter writeValuesAsArray(File file) {
        return this._newSequenceWriter(true, this.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(JsonGenerator jsonGenerator) {
        this._assertNotNull("gen", jsonGenerator);
        return this._newSequenceWriter(true, jsonGenerator, false);
    }

    public SequenceWriter writeValuesAsArray(Writer writer) {
        return this._newSequenceWriter(true, this.createGenerator(writer), true);
    }

    public SequenceWriter writeValuesAsArray(OutputStream outputStream) {
        return this._newSequenceWriter(true, this.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(DataOutput dataOutput) {
        return this._newSequenceWriter(true, this.createGenerator(dataOutput), true);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(DatatypeFeature datatypeFeature) {
        return ((MapperConfig)this._config).isEnabled(datatypeFeature);
    }

    @Deprecated
    public boolean isEnabled(JsonParser.Feature feature) {
        return ((TokenStreamFactory)this._generatorFactory).isEnabled(feature);
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        return ((TokenStreamFactory)this._generatorFactory).isEnabled(feature);
    }

    public boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return ((TokenStreamFactory)this._generatorFactory).isEnabled(streamWriteFeature);
    }

    public SerializationConfig getConfig() {
        return this._config;
    }

    public JsonFactory getFactory() {
        return this._generatorFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public boolean hasPrefetchedSerializer() {
        return this._prefetch.hasSerializer();
    }

    public ContextAttributes getAttributes() {
        return ((MapperConfig)this._config).getAttributes();
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) {
        this._assertNotNull("g", jsonGenerator);
        this._configureGenerator(jsonGenerator);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            Closeable closeable = (Closeable)object;
            try {
                this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
                if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                    jsonGenerator.flush();
                }
            }
            catch (Exception exception) {
                ClassUtil.closeOnFailAndThrowAsIOE(null, closeable, exception);
                return;
            }
            closeable.close();
            return;
        }
        this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
        if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    public void writeValue(File file, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(writer), object);
    }

    public void writeValue(DataOutput dataOutput, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(dataOutput), object);
    }

    public String writeValueAsString(Object object) {
        BufferRecycler bufferRecycler = this._generatorFactory._getBufferRecycler();
        try {
            Object object2 = new SegmentedStringWriter(bufferRecycler);
            Throwable throwable = null;
            try {
                ObjectWriter objectWriter = this;
                objectWriter._writeValueAndClose(objectWriter.createGenerator((Writer)object2), object);
                object = ((SegmentedStringWriter)object2).getAndClear();
                ((SegmentedStringWriter)object2).close();
                return object;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (throwable != null) {
                            try {
                                ((SegmentedStringWriter)object2).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((SegmentedStringWriter)object2).close();
                        }
                        throw throwable3;
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    object2 = jsonProcessingException;
                    throw jsonProcessingException;
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    throw JsonMappingException.fromUnexpectedIOE(iOException);
                }
            }
        }
        finally {
            bufferRecycler.releaseToPool();
        }
    }

    public byte[] writeValueAsBytes(Object object) {
        BufferRecycler bufferRecycler = this._generatorFactory._getBufferRecycler();
        try {
            Object object2 = new ByteArrayBuilder(bufferRecycler);
            Throwable throwable = null;
            try {
                ObjectWriter objectWriter = this;
                objectWriter._writeValueAndClose(objectWriter.createGenerator((OutputStream)object2, JsonEncoding.UTF8), object);
                object = ((ByteArrayBuilder)object2).getClearAndRelease();
                ((ByteArrayBuilder)object2).close();
                return object;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (throwable != null) {
                            try {
                                ((ByteArrayBuilder)object2).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((ByteArrayBuilder)object2).close();
                        }
                        throw throwable3;
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    object2 = jsonProcessingException;
                    throw jsonProcessingException;
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    throw JsonMappingException.fromUnexpectedIOE(iOException);
                }
            }
        }
        finally {
            bufferRecycler.releaseToPool();
        }
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        this._assertNotNull("type", javaType);
        this._assertNotNull("visitor", jsonFormatVisitorWrapper);
        this._serializerProvider().acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        this._assertNotNull("type", clazz);
        this._assertNotNull("visitor", jsonFormatVisitorWrapper);
        ObjectWriter objectWriter = this;
        objectWriter.acceptJsonFormatVisitor(objectWriter._config.constructType(clazz), jsonFormatVisitorWrapper);
    }

    public boolean canSerialize(Class<?> clazz) {
        this._assertNotNull("type", clazz);
        return this._serializerProvider().hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        this._assertNotNull("type", clazz);
        return this._serializerProvider().hasSerializerFor(clazz, atomicReference);
    }

    protected DefaultSerializerProvider _serializerProvider() {
        return this._serializerProvider.createInstance(this._config, this._serializerFactory);
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !((TokenStreamFactory)this._generatorFactory).canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + ((TokenStreamFactory)this._generatorFactory).getFormatName());
        }
    }

    protected final void _writeValueAndClose(JsonGenerator object, Object object2) {
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object2 instanceof Closeable) {
            Object object3 = object2;
            object2 = object;
            object = this;
            Closeable closeable = (Closeable)object3;
            try {
                ((ObjectWriter)object)._prefetch.serialize((JsonGenerator)object2, object3, ((ObjectWriter)object)._serializerProvider());
                object = closeable;
                closeable = null;
                object.close();
            }
            catch (Exception exception) {
                ClassUtil.closeOnFailAndThrowAsIOE((JsonGenerator)object2, closeable, exception);
                return;
            }
            ((JsonGenerator)object2).close();
            return;
        }
        try {
            this._prefetch.serialize((JsonGenerator)object, object2, this._serializerProvider());
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE((JsonGenerator)object, exception);
            return;
        }
        ((JsonGenerator)object).close();
    }

    protected final JsonGenerator _configureGenerator(JsonGenerator jsonGenerator) {
        this._config.initialize(jsonGenerator);
        this._generatorSettings.initialize(jsonGenerator);
        return jsonGenerator;
    }

    protected final void _assertNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", string));
        }
    }

    public static final class Prefetch
    implements Serializable {
        public static final Prefetch empty = new Prefetch(null, null, null);
        private final JavaType a;
        private final JsonSerializer<Object> b;
        private final TypeSerializer c;

        private Prefetch(JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) {
            this.a = javaType;
            this.b = jsonSerializer;
            this.c = typeSerializer;
        }

        public final Prefetch forRootType(ObjectWriter jsonSerializer, JavaType javaType) {
            if (javaType == null) {
                if (this.a == null || this.b == null) {
                    return this;
                }
                return new Prefetch(null, null, null);
            }
            if (javaType.equals(this.a)) {
                return this;
            }
            if (javaType.isJavaLangObject()) {
                jsonSerializer = ((ObjectWriter)((Object)jsonSerializer))._serializerProvider();
                try {
                    jsonSerializer = ((SerializerProvider)((Object)jsonSerializer)).findTypeSerializer(javaType);
                }
                catch (JsonMappingException jsonMappingException) {
                    throw new RuntimeJsonMappingException(jsonMappingException);
                }
                return new Prefetch(null, null, (TypeSerializer)((Object)jsonSerializer));
            }
            if (((ObjectWriter)((Object)jsonSerializer)).isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
                jsonSerializer = ((ObjectWriter)((Object)jsonSerializer))._serializerProvider();
                try {
                    jsonSerializer = ((SerializerProvider)((Object)jsonSerializer)).findTypedValueSerializer(javaType, true, null);
                    if (jsonSerializer instanceof TypeWrappedSerializer) {
                        return new Prefetch(javaType, null, ((TypeWrappedSerializer)jsonSerializer).typeSerializer());
                    }
                    return new Prefetch(javaType, jsonSerializer, null);
                }
                catch (DatabindException databindException) {}
            }
            return new Prefetch(javaType, null, this.c);
        }

        public final JsonSerializer<Object> getValueSerializer() {
            return this.b;
        }

        public final TypeSerializer getTypeSerializer() {
            return this.c;
        }

        public final boolean hasSerializer() {
            return this.b != null || this.c != null;
        }

        public final void serialize(JsonGenerator jsonGenerator, Object object, DefaultSerializerProvider defaultSerializerProvider) {
            if (this.c != null) {
                defaultSerializerProvider.serializePolymorphic(jsonGenerator, object, this.a, this.b, this.c);
                return;
            }
            if (this.b != null) {
                defaultSerializerProvider.serializeValue(jsonGenerator, object, this.a, this.b);
                return;
            }
            if (this.a != null) {
                defaultSerializerProvider.serializeValue(jsonGenerator, object, this.a);
                return;
            }
            defaultSerializerProvider.serializeValue(jsonGenerator, object);
        }
    }

    public static final class GeneratorSettings
    implements Serializable {
        public static final GeneratorSettings empty = new GeneratorSettings(null, null, null, null);
        public final PrettyPrinter prettyPrinter;
        public final FormatSchema schema;
        public final CharacterEscapes characterEscapes;
        public final SerializableString rootValueSeparator;

        public GeneratorSettings(PrettyPrinter prettyPrinter, FormatSchema formatSchema, CharacterEscapes characterEscapes, SerializableString serializableString) {
            this.prettyPrinter = prettyPrinter;
            this.schema = formatSchema;
            this.characterEscapes = characterEscapes;
            this.rootValueSeparator = serializableString;
        }

        public final GeneratorSettings with(PrettyPrinter prettyPrinter) {
            if (prettyPrinter == null) {
                prettyPrinter = NULL_PRETTY_PRINTER;
            }
            if (prettyPrinter == this.prettyPrinter) {
                return this;
            }
            return new GeneratorSettings(prettyPrinter, this.schema, this.characterEscapes, this.rootValueSeparator);
        }

        public final GeneratorSettings with(FormatSchema formatSchema) {
            if (this.schema == formatSchema) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, formatSchema, this.characterEscapes, this.rootValueSeparator);
        }

        public final GeneratorSettings with(CharacterEscapes characterEscapes) {
            if (this.characterEscapes == characterEscapes) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, this.schema, characterEscapes, this.rootValueSeparator);
        }

        public final GeneratorSettings withRootValueSeparator(String string) {
            if (string == null) {
                if (this.rootValueSeparator == null) {
                    return this;
                }
                return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, null);
            }
            GeneratorSettings generatorSettings = this;
            if (string.equals(generatorSettings.rootValueSeparator == null ? null : generatorSettings.rootValueSeparator.getValue())) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, new SerializedString(string));
        }

        public final GeneratorSettings withRootValueSeparator(SerializableString serializableString) {
            if (serializableString == null) {
                if (this.rootValueSeparator == null) {
                    return this;
                }
                return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, null);
            }
            if (serializableString.equals(this.rootValueSeparator)) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, serializableString);
        }

        public final void initialize(JsonGenerator jsonGenerator) {
            PrettyPrinter prettyPrinter = this.prettyPrinter;
            if (this.prettyPrinter != null) {
                if (prettyPrinter == NULL_PRETTY_PRINTER) {
                    jsonGenerator.setPrettyPrinter(null);
                } else {
                    if (prettyPrinter instanceof Instantiatable) {
                        prettyPrinter = (PrettyPrinter)((Instantiatable)((Object)prettyPrinter)).createInstance();
                    }
                    jsonGenerator.setPrettyPrinter(prettyPrinter);
                }
            }
            if (this.characterEscapes != null) {
                jsonGenerator.setCharacterEscapes(this.characterEscapes);
            }
            if (this.schema != null) {
                jsonGenerator.setSchema(this.schema);
            }
            if (this.rootValueSeparator != null) {
                jsonGenerator.setRootValueSeparator(this.rootValueSeparator);
            }
        }
    }
}

