/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import java.io.Serializable;

public abstract class PropertyNamingStrategies
implements Serializable {
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = LowerCamelCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = UpperCamelCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy SNAKE_CASE = SnakeCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy UPPER_SNAKE_CASE = UpperSnakeCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy LOWER_CASE = LowerCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy KEBAB_CASE = KebabCaseStrategy.INSTANCE;
    public static final PropertyNamingStrategy LOWER_DOT_CASE = LowerDotCaseStrategy.INSTANCE;

    public static class LowerDotCaseStrategy
    extends NamingBase {
        public static final LowerDotCaseStrategy INSTANCE = new LowerDotCaseStrategy();

        @Override
        public String translate(String string) {
            return this.translateLowerCaseWithSeparator(string, '.');
        }
    }

    public static class KebabCaseStrategy
    extends NamingBase {
        public static final KebabCaseStrategy INSTANCE = new KebabCaseStrategy();

        @Override
        public String translate(String string) {
            return this.translateLowerCaseWithSeparator(string, '-');
        }
    }

    public static class LowerCaseStrategy
    extends NamingBase {
        public static final LowerCaseStrategy INSTANCE = new LowerCaseStrategy();

        @Override
        public String translate(String string) {
            if (string == null || string.isEmpty()) {
                return string;
            }
            return string.toLowerCase();
        }
    }

    public static class UpperCamelCaseStrategy
    extends NamingBase {
        public static final UpperCamelCaseStrategy INSTANCE = new UpperCamelCaseStrategy();

        @Override
        public String translate(String charSequence) {
            char c2;
            if (charSequence == null || ((String)charSequence).isEmpty()) {
                return charSequence;
            }
            char c3 = ((String)charSequence).charAt(0);
            if (c3 == (c2 = Character.toUpperCase(c3))) {
                return charSequence;
            }
            charSequence = new StringBuilder((String)charSequence);
            ((StringBuilder)charSequence).setCharAt(0, c2);
            return ((StringBuilder)charSequence).toString();
        }
    }

    public static class LowerCamelCaseStrategy
    extends NamingBase {
        public static final LowerCamelCaseStrategy INSTANCE = new LowerCamelCaseStrategy();

        @Override
        public String translate(String string) {
            return string;
        }
    }

    public static class UpperSnakeCaseStrategy
    extends SnakeCaseStrategy {
        public static final UpperSnakeCaseStrategy INSTANCE = new UpperSnakeCaseStrategy();

        @Override
        public String translate(String string) {
            if ((string = super.translate(string)) == null) {
                return null;
            }
            return string.toUpperCase();
        }
    }

    public static class SnakeCaseStrategy
    extends NamingBase {
        public static final SnakeCaseStrategy INSTANCE = new SnakeCaseStrategy();

        @Override
        public String translate(String string) {
            if (string == null) {
                return string;
            }
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2 << 1);
            int n3 = 0;
            boolean bl2 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (i2 <= 0 && c2 == '_') continue;
                if (Character.isUpperCase(c2)) {
                    if (!bl2 && n3 > 0 && stringBuilder.charAt(n3 - 1) != '_') {
                        stringBuilder.append('_');
                        ++n3;
                    }
                    c2 = Character.toLowerCase(c2);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                stringBuilder.append(c2);
                ++n3;
            }
            if (n3 > 0) {
                return stringBuilder.toString();
            }
            return string;
        }
    }

    public static abstract class NamingBase
    extends PropertyNamingStrategy {
        @Override
        public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
            return this.translate(string);
        }

        public abstract String translate(String var1);

        protected String translateLowerCaseWithSeparator(String string, char c2) {
            int n2;
            if (string == null || string.isEmpty()) {
                return string;
            }
            int n3 = n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n3 + (n3 >> 1));
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = string.charAt(i2);
                char c4 = Character.toLowerCase(c3);
                if (c4 == c3) {
                    if (n4 > 1) {
                        StringBuilder stringBuilder2 = stringBuilder;
                        stringBuilder2.insert(stringBuilder2.length() - 1, c2);
                    }
                    n4 = 0;
                } else {
                    if (n4 == 0 && i2 > 0) {
                        stringBuilder.append(c2);
                    }
                    ++n4;
                }
                stringBuilder.append(c4);
            }
            return stringBuilder.toString();
        }
    }
}

