/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.SerializerCache;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.FailingSerializer;
import com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class SerializerProvider
extends DatabindContext {
    protected static final boolean CACHE_UNKNOWN_MAPPINGS = false;
    public static final JsonSerializer<Object> DEFAULT_NULL_KEY_SERIALIZER = new FailingSerializer("Null key for a Map not allowed in JSON (use a converting NullKeySerializer?)");
    protected static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new UnknownSerializer();
    protected final SerializationConfig _config;
    protected final Class<?> _serializationView;
    protected final SerializerFactory _serializerFactory;
    protected final SerializerCache _serializerCache;
    protected transient ContextAttributes _attributes;
    protected JsonSerializer<Object> _unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _nullValueSerializer = NullSerializer.instance;
    protected JsonSerializer<Object> _nullKeySerializer = DEFAULT_NULL_KEY_SERIALIZER;
    protected final ReadOnlyClassToSerializerMap _knownSerializers;
    protected DateFormat _dateFormat;
    protected final boolean _stdNullValueSerializer;

    public SerializerProvider() {
        this._config = null;
        this._serializerFactory = null;
        this._serializerCache = new SerializerCache();
        this._knownSerializers = null;
        this._serializationView = null;
        this._attributes = null;
        this._stdNullValueSerializer = true;
    }

    protected SerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
        this._config = serializationConfig;
        this._serializerCache = serializerProvider._serializerCache;
        this._unknownTypeSerializer = serializerProvider._unknownTypeSerializer;
        this._keySerializer = serializerProvider._keySerializer;
        this._nullValueSerializer = serializerProvider._nullValueSerializer;
        this._nullKeySerializer = serializerProvider._nullKeySerializer;
        this._stdNullValueSerializer = this._nullValueSerializer == DEFAULT_NULL_KEY_SERIALIZER;
        this._serializationView = ((MapperConfig)serializationConfig).getActiveView();
        this._attributes = ((MapperConfig)serializationConfig).getAttributes();
        this._knownSerializers = this._serializerCache.getReadOnlyLookupMap();
    }

    protected SerializerProvider(SerializerProvider serializerProvider) {
        this._config = null;
        this._serializationView = null;
        this._serializerFactory = null;
        this._knownSerializers = null;
        this._serializerCache = new SerializerCache();
        this._unknownTypeSerializer = serializerProvider._unknownTypeSerializer;
        this._keySerializer = serializerProvider._keySerializer;
        this._nullValueSerializer = serializerProvider._nullValueSerializer;
        this._nullKeySerializer = serializerProvider._nullKeySerializer;
        this._stdNullValueSerializer = serializerProvider._stdNullValueSerializer;
    }

    protected SerializerProvider(SerializerProvider serializerProvider, SerializerCache serializerCache) {
        this._serializerCache = serializerCache;
        this._config = serializerProvider._config;
        this._serializationView = serializerProvider._serializationView;
        this._serializerFactory = serializerProvider._serializerFactory;
        this._attributes = serializerProvider._attributes;
        this._knownSerializers = serializerProvider._knownSerializers;
        this._unknownTypeSerializer = serializerProvider._unknownTypeSerializer;
        this._nullValueSerializer = serializerProvider._nullValueSerializer;
        this._nullKeySerializer = serializerProvider._nullKeySerializer;
        this._keySerializer = serializerProvider._keySerializer;
        this._stdNullValueSerializer = serializerProvider._stdNullValueSerializer;
    }

    public void setDefaultKeySerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer == null) {
            throw new IllegalArgumentException("Cannot pass null JsonSerializer");
        }
        this._keySerializer = jsonSerializer;
    }

    public void setNullValueSerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer == null) {
            throw new IllegalArgumentException("Cannot pass null JsonSerializer");
        }
        this._nullValueSerializer = jsonSerializer;
    }

    public void setNullKeySerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer == null) {
            throw new IllegalArgumentException("Cannot pass null JsonSerializer");
        }
        this._nullKeySerializer = jsonSerializer;
    }

    public final SerializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        if (((ResolvedType)javaType).hasRawClass(clazz)) {
            return javaType;
        }
        return this.getConfig().getTypeFactory().constructSpecializedType(javaType, clazz, true);
    }

    @Override
    public final Class<?> getActiveView() {
        return this._serializationView;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    @Override
    public final boolean isEnabled(DatatypeFeature datatypeFeature) {
        return ((MapperConfig)this._config).isEnabled(datatypeFeature);
    }

    @Override
    public final DatatypeFeatures getDatatypeFeatures() {
        return ((MapperConfig)this._config).getDatatypeFeatures();
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> clazz) {
        return ((MapperConfig)this._config).getDefaultPropertyFormat(clazz);
    }

    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> clazz) {
        return ((MapperConfig)this._config).getDefaultPropertyInclusion(clazz);
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    public Object getAttribute(Object object) {
        return this._attributes.getAttribute(object);
    }

    @Override
    public SerializerProvider setAttribute(Object object, Object object2) {
        this._attributes = this._attributes.withPerCallAttribute(object, object2);
        return this;
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public final boolean hasSerializationFeatures(int n2) {
        return this._config.hasSerializationFeatures(n2);
    }

    public final FilterProvider getFilterProvider() {
        return this._config.getFilterProvider();
    }

    public JsonGenerator getGenerator() {
        return null;
    }

    public TokenBuffer bufferForValueConversion(ObjectCodec objectCodec) {
        return new TokenBuffer(objectCodec, false);
    }

    public final TokenBuffer bufferForValueConversion() {
        return this.bufferForValueConversion(null);
    }

    public abstract WritableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public JsonSerializer<Object> findValueSerializer(Class<?> clazz, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(clazz);
            return jsonSerializer;
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findValueSerializer(JavaType javaType, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer;
        if (javaType == null) {
            this.reportMappingProblem("Null passed for `valueType` of `findValueSerializer()`", new Object[0]);
        }
        if ((jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(((ResolvedType)javaType).getRawClass());
            return jsonSerializer;
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findValueSerializer(Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(clazz);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findValueSerializer(JavaType javaType) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(((ResolvedType)javaType).getRawClass());
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(JavaType javaType, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(((ResolvedType)javaType).getRawClass());
            return jsonSerializer;
        }
        return this.handlePrimaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(Class<?> clazz, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(clazz);
            return jsonSerializer;
        }
        return this.handlePrimaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findContentValueSerializer(JavaType javaType, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(((ResolvedType)javaType).getRawClass());
            return jsonSerializer;
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findContentValueSerializer(Class<?> clazz, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(clazz);
            return jsonSerializer;
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findTypedValueSerializer(Class<?> clazz, boolean bl2, BeanProperty beanProperty) {
        JsonSerializer jsonSerializer = this._knownSerializers.typedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.typedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this.findValueSerializer(clazz, beanProperty);
        TypeSerializer typeSerializer = this._serializerFactory.createTypeSerializer(this._config, this._config.constructType(clazz));
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
            jsonSerializer = new TypeWrappedSerializer(typeSerializer, jsonSerializer);
        }
        if (bl2) {
            this._serializerCache.addTypedSerializer(clazz, jsonSerializer);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findTypedValueSerializer(JavaType javaType, boolean bl2, BeanProperty beanProperty) {
        JsonSerializer jsonSerializer = this._knownSerializers.typedValueSerializer(javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.typedValueSerializer(javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this.findValueSerializer(javaType, beanProperty);
        TypeSerializer typeSerializer = this._serializerFactory.createTypeSerializer(this._config, javaType);
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
            jsonSerializer = new TypeWrappedSerializer(typeSerializer, jsonSerializer);
        }
        if (bl2) {
            this._serializerCache.addTypedSerializer(javaType, jsonSerializer);
        }
        return jsonSerializer;
    }

    public TypeSerializer findTypeSerializer(JavaType javaType) {
        return this._serializerFactory.createTypeSerializer(this._config, javaType);
    }

    public JsonSerializer<Object> findKeySerializer(JavaType object, BeanProperty beanProperty) {
        object = this._serializerFactory.createKeySerializer(this, (JavaType)object, this._keySerializer);
        return this._handleContextualResolvable((JsonSerializer<?>)object, beanProperty);
    }

    public JsonSerializer<Object> findKeySerializer(Class<?> clazz, BeanProperty beanProperty) {
        SerializerProvider serializerProvider = this;
        return serializerProvider.findKeySerializer(serializerProvider._config.constructType(clazz), beanProperty);
    }

    public JsonSerializer<Object> getDefaultNullKeySerializer() {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> getDefaultNullValueSerializer() {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> findNullKeySerializer(JavaType javaType, BeanProperty beanProperty) {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> findNullValueSerializer(BeanProperty beanProperty) {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> clazz) {
        if (clazz == Object.class) {
            return this._unknownTypeSerializer;
        }
        return new UnknownSerializer(clazz);
    }

    public boolean isUnknownTypeSerializer(JsonSerializer<?> jsonSerializer) {
        if (jsonSerializer == this._unknownTypeSerializer || jsonSerializer == null) {
            return true;
        }
        return this.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS) && jsonSerializer.getClass() == UnknownSerializer.class;
    }

    public abstract JsonSerializer<Object> serializerInstance(Annotated var1, Object var2);

    public abstract Object includeFilterInstance(BeanPropertyDefinition var1, Class<?> var2);

    public abstract boolean includeFilterSuppressNulls(Object var1);

    public JsonSerializer<?> handlePrimaryContextualization(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) {
        if (jsonSerializer != null && jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(this, beanProperty);
        }
        return jsonSerializer;
    }

    public JsonSerializer<?> handleSecondaryContextualization(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) {
        if (jsonSerializer != null && jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(this, beanProperty);
        }
        return jsonSerializer;
    }

    public final void defaultSerializeValue(Object object, JsonGenerator jsonGenerator) {
        if (object == null) {
            if (this._stdNullValueSerializer) {
                jsonGenerator.writeNull();
                return;
            }
            this._nullValueSerializer.serialize(null, jsonGenerator, this);
            return;
        }
        Class<?> clazz = object.getClass();
        this.findTypedValueSerializer(clazz, true, null).serialize(object, jsonGenerator, this);
    }

    public final void defaultSerializeField(String object, Object object2, JsonGenerator jsonGenerator) {
        jsonGenerator.writeFieldName((String)object);
        if (object2 == null) {
            if (this._stdNullValueSerializer) {
                jsonGenerator.writeNull();
                return;
            }
            this._nullValueSerializer.serialize(null, jsonGenerator, this);
            return;
        }
        object = object2.getClass();
        this.findTypedValueSerializer((Class<?>)object, true, null).serialize(object2, jsonGenerator, this);
    }

    public final void defaultSerializeDateValue(long l2, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(l2);
            return;
        }
        jsonGenerator.writeString(this._dateFormat().format(new Date(l2)));
    }

    public final void defaultSerializeDateValue(Date date, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(date.getTime());
            return;
        }
        jsonGenerator.writeString(this._dateFormat().format(date));
    }

    public void defaultSerializeDateKey(long l2, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jsonGenerator.writeFieldName(String.valueOf(l2));
            return;
        }
        jsonGenerator.writeFieldName(this._dateFormat().format(new Date(l2)));
    }

    public void defaultSerializeDateKey(Date date, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jsonGenerator.writeFieldName(String.valueOf(date.getTime()));
            return;
        }
        jsonGenerator.writeFieldName(this._dateFormat().format(date));
    }

    public final void defaultSerializeNull(JsonGenerator jsonGenerator) {
        if (this._stdNullValueSerializer) {
            jsonGenerator.writeNull();
            return;
        }
        this._nullValueSerializer.serialize(null, jsonGenerator, this);
    }

    public void reportMappingProblem(String string, Object ... objectArray) {
        throw this.mappingException(string, objectArray);
    }

    public <T> T reportBadTypeDefinition(BeanDescription beanDescription, String string, Object ... objectArray) {
        String string2 = "N/A";
        if (beanDescription != null) {
            string2 = ClassUtil.nameOf(beanDescription.getBeanClass());
        }
        string = String.format("Invalid type definition for type %s: %s", string2, this._format(string, objectArray));
        throw InvalidDefinitionException.from(this.getGenerator(), string, beanDescription, null);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition, String string, Object ... object) {
        string = this._format(string, object);
        object = "N/A";
        if (beanPropertyDefinition != null) {
            object = this._quotedString(beanPropertyDefinition.getName());
        }
        String string2 = "N/A";
        if (beanDescription != null) {
            string2 = ClassUtil.nameOf(beanDescription.getBeanClass());
        }
        string = String.format("Invalid definition for property %s (of type %s): %s", object, string2, string);
        throw InvalidDefinitionException.from(this.getGenerator(), string, beanDescription, beanPropertyDefinition);
    }

    @Override
    public <T> T reportBadDefinition(JavaType javaType, String string) {
        throw InvalidDefinitionException.from(this.getGenerator(), string, javaType);
    }

    public <T> T reportBadDefinition(JavaType javaType, String string, Throwable throwable) {
        throw InvalidDefinitionException.from(this.getGenerator(), string, javaType).withCause(throwable);
    }

    public <T> T reportBadDefinition(Class<?> clazz, String string, Throwable throwable) {
        throw InvalidDefinitionException.from(this.getGenerator(), string, this.constructType(clazz)).withCause(throwable);
    }

    public void reportMappingProblem(Throwable throwable, String string, Object ... objectArray) {
        string = this._format(string, objectArray);
        throw JsonMappingException.from(this.getGenerator(), string, throwable);
    }

    @Override
    public JsonMappingException invalidTypeIdException(JavaType javaType, String string, String string2) {
        String string3 = String.format("Could not resolve type id '%s' as a subtype of %s", string, ClassUtil.getTypeDescription(javaType));
        return InvalidTypeIdException.from(null, this._colonConcat(string3, string2), javaType, string);
    }

    @Deprecated
    public JsonMappingException mappingException(String string, Object ... objectArray) {
        return JsonMappingException.from(this.getGenerator(), this._format(string, objectArray));
    }

    @Deprecated
    protected JsonMappingException mappingException(Throwable throwable, String string, Object ... objectArray) {
        return JsonMappingException.from(this.getGenerator(), this._format(string, objectArray), throwable);
    }

    protected void _reportIncompatibleRootType(Object object, JavaType javaType) {
        Class<?> clazz;
        if (((ResolvedType)javaType).isPrimitive() && (clazz = ClassUtil.wrapperType(((ResolvedType)javaType).getRawClass())).isAssignableFrom(object.getClass())) {
            return;
        }
        ((DatabindContext)this).reportBadDefinition(javaType, String.format("Incompatible types: declared root type (%s) vs %s", javaType, ClassUtil.classNameOf(object)));
    }

    protected JsonSerializer<Object> _findExplicitUntypedSerializer(Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null) {
            jsonSerializer = this._createAndCacheUntypedSerializer(clazz);
        }
        if (this.isUnknownTypeSerializer(jsonSerializer)) {
            return null;
        }
        return jsonSerializer;
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer;
        JavaType javaType = this._config.constructType(clazz);
        try {
            jsonSerializer = this._createUntypedSerializer(javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ((DatabindContext)this).reportBadDefinition(javaType, ClassUtil.exceptionMessage(illegalArgumentException));
            jsonSerializer = null;
        }
        if (jsonSerializer != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(clazz, javaType, jsonSerializer, this);
        }
        return jsonSerializer;
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(JavaType javaType) {
        JsonSerializer<Object> jsonSerializer;
        try {
            jsonSerializer = this._createUntypedSerializer(javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            jsonSerializer = null;
            IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
            this.reportMappingProblem(illegalArgumentException2, ClassUtil.exceptionMessage(illegalArgumentException2), new Object[0]);
        }
        if (jsonSerializer != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(javaType, jsonSerializer, this);
        }
        return jsonSerializer;
    }

    protected JsonSerializer<Object> _createUntypedSerializer(JavaType javaType) {
        return this._serializerFactory.createSerializer(this, javaType);
    }

    protected JsonSerializer<Object> _handleContextualResolvable(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) {
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(this);
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    protected JsonSerializer<Object> _handleResolvable(JsonSerializer<?> jsonSerializer) {
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(this);
        }
        return jsonSerializer;
    }

    protected final DateFormat _dateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat dateFormat = this._config.getDateFormat();
        this._dateFormat = dateFormat = (DateFormat)dateFormat.clone();
        return dateFormat;
    }
}

