/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionConfig;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.cfg.MutableCoercionConfig;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CoercionConfigs
implements Serializable {
    private static final int a = LogicalType.values().length;
    protected CoercionAction _defaultAction;
    protected final MutableCoercionConfig _defaultCoercions;
    protected MutableCoercionConfig[] _perTypeCoercions;
    protected Map<Class<?>, MutableCoercionConfig> _perClassCoercions;

    public CoercionConfigs() {
        this(CoercionAction.TryConvert, new MutableCoercionConfig(), null, null);
    }

    protected CoercionConfigs(CoercionAction coercionAction, MutableCoercionConfig mutableCoercionConfig, MutableCoercionConfig[] mutableCoercionConfigArray, Map<Class<?>, MutableCoercionConfig> map) {
        this._defaultCoercions = mutableCoercionConfig;
        this._defaultAction = coercionAction;
        this._perTypeCoercions = mutableCoercionConfigArray;
        this._perClassCoercions = map;
    }

    public CoercionConfigs copy() {
        HashMap hashMap;
        MutableCoercionConfig[] mutableCoercionConfigArray;
        if (this._perTypeCoercions == null) {
            mutableCoercionConfigArray = null;
        } else {
            int n2 = this._perTypeCoercions.length;
            mutableCoercionConfigArray = new MutableCoercionConfig[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                MutableCoercionConfig object = this._perTypeCoercions[i2];
                mutableCoercionConfigArray[i2] = object == null ? null : object.copy();
            }
        }
        if (this._perClassCoercions == null) {
            hashMap = null;
        } else {
            hashMap = new HashMap();
            for (Map.Entry<Class<?>, MutableCoercionConfig> entry : this._perClassCoercions.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().copy());
            }
        }
        return new CoercionConfigs(this._defaultAction, this._defaultCoercions.copy(), mutableCoercionConfigArray, hashMap);
    }

    public MutableCoercionConfig defaultCoercions() {
        return this._defaultCoercions;
    }

    public MutableCoercionConfig findOrCreateCoercion(LogicalType logicalType) {
        MutableCoercionConfig mutableCoercionConfig;
        if (this._perTypeCoercions == null) {
            this._perTypeCoercions = new MutableCoercionConfig[a];
        }
        if ((mutableCoercionConfig = this._perTypeCoercions[logicalType.ordinal()]) == null) {
            this._perTypeCoercions[logicalType.ordinal()] = mutableCoercionConfig = new MutableCoercionConfig();
        }
        return mutableCoercionConfig;
    }

    public MutableCoercionConfig findOrCreateCoercion(Class<?> clazz) {
        MutableCoercionConfig mutableCoercionConfig;
        if (this._perClassCoercions == null) {
            this._perClassCoercions = new HashMap();
        }
        if ((mutableCoercionConfig = this._perClassCoercions.get(clazz)) == null) {
            mutableCoercionConfig = new MutableCoercionConfig();
            this._perClassCoercions.put(clazz, mutableCoercionConfig);
        }
        return mutableCoercionConfig;
    }

    public CoercionAction findCoercion(DeserializationConfig deserializationConfig, LogicalType logicalType, Class<?> object, CoercionInputShape coercionInputShape) {
        if (this._perClassCoercions != null && object != null && (object = this._perClassCoercions.get(object)) != null && (object = ((CoercionConfig)object).findAction(coercionInputShape)) != null) {
            return object;
        }
        if (this._perTypeCoercions != null && logicalType != null && (object = this._perTypeCoercions[logicalType.ordinal()]) != null && (object = ((CoercionConfig)object).findAction(coercionInputShape)) != null) {
            return object;
        }
        object = this._defaultCoercions.findAction(coercionInputShape);
        if (object != null) {
            return object;
        }
        switch (coercionInputShape) {
            case EmptyArray: {
                if (deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
                    return CoercionAction.AsNull;
                }
                return CoercionAction.Fail;
            }
            case Float: {
                if (logicalType != LogicalType.Integer) break;
                if (deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    return CoercionAction.TryConvert;
                }
                return CoercionAction.Fail;
            }
            case Integer: {
                if (logicalType != LogicalType.Enum || !deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) break;
                return CoercionAction.Fail;
            }
        }
        boolean bl2 = this._isScalarType(logicalType);
        if (bl2 && !deserializationConfig.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS) && (logicalType != LogicalType.Float || coercionInputShape != CoercionInputShape.Integer)) {
            return CoercionAction.Fail;
        }
        if (coercionInputShape == CoercionInputShape.EmptyString) {
            if (logicalType == LogicalType.OtherScalar) {
                return CoercionAction.TryConvert;
            }
            if (bl2 || deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
                return CoercionAction.AsNull;
            }
            return CoercionAction.Fail;
        }
        return this._defaultAction;
    }

    public CoercionAction findCoercionFromBlankString(DeserializationConfig deserializationConfig, LogicalType logicalType, Class<?> serializable, CoercionAction coercionAction) {
        Boolean bl2 = null;
        CoercionAction coercionAction2 = null;
        if (this._perClassCoercions != null && serializable != null && (serializable = this._perClassCoercions.get(serializable)) != null) {
            bl2 = ((CoercionConfig)serializable).getAcceptBlankAsEmpty();
            coercionAction2 = ((CoercionConfig)serializable).findAction(CoercionInputShape.EmptyString);
        }
        if (this._perTypeCoercions != null && logicalType != null && (serializable = this._perTypeCoercions[logicalType.ordinal()]) != null) {
            if (bl2 == null) {
                bl2 = ((CoercionConfig)serializable).getAcceptBlankAsEmpty();
            }
            if (coercionAction2 == null) {
                coercionAction2 = ((CoercionConfig)serializable).findAction(CoercionInputShape.EmptyString);
            }
        }
        if (bl2 == null) {
            bl2 = this._defaultCoercions.getAcceptBlankAsEmpty();
        }
        if (coercionAction2 == null) {
            coercionAction2 = this._defaultCoercions.findAction(CoercionInputShape.EmptyString);
        }
        if (Boolean.FALSE.equals(bl2)) {
            return coercionAction;
        }
        if (coercionAction2 != null) {
            return coercionAction2;
        }
        if (this._isScalarType(logicalType)) {
            return CoercionAction.AsNull;
        }
        if (deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
            return CoercionAction.AsNull;
        }
        return coercionAction;
    }

    protected boolean _isScalarType(LogicalType logicalType) {
        return logicalType == LogicalType.Float || logicalType == LogicalType.Integer || logicalType == LogicalType.Boolean || logicalType == LogicalType.DateTime;
    }
}

