/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.CacheProvider;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.LookupCache;
import com.fasterxml.jackson.databind.util.TypeKey;

public class DefaultCacheProvider
implements CacheProvider {
    private static final DefaultCacheProvider a = new DefaultCacheProvider(2000, 4000, 200);
    protected final int _maxDeserializerCacheSize;
    protected final int _maxSerializerCacheSize;
    protected final int _maxTypeFactoryCacheSize;

    protected DefaultCacheProvider(int n2, int n3, int n4) {
        this._maxDeserializerCacheSize = n2;
        this._maxSerializerCacheSize = n3;
        this._maxTypeFactoryCacheSize = n4;
    }

    public static CacheProvider defaultInstance() {
        return a;
    }

    @Override
    public LookupCache<JavaType, JsonDeserializer<Object>> forDeserializerCache(DeserializationConfig deserializationConfig) {
        DefaultCacheProvider defaultCacheProvider = this;
        return defaultCacheProvider._buildCache(defaultCacheProvider._maxDeserializerCacheSize);
    }

    @Override
    public LookupCache<TypeKey, JsonSerializer<Object>> forSerializerCache(SerializationConfig serializationConfig) {
        DefaultCacheProvider defaultCacheProvider = this;
        return defaultCacheProvider._buildCache(defaultCacheProvider._maxSerializerCacheSize);
    }

    @Override
    public LookupCache<Object, JavaType> forTypeFactory() {
        DefaultCacheProvider defaultCacheProvider = this;
        return defaultCacheProvider._buildCache(defaultCacheProvider._maxTypeFactoryCacheSize);
    }

    protected <K, V> LookupCache<K, V> _buildCache(int n2) {
        int n3 = Math.min(64, n2 >> 2);
        return new LRUMap(n3, n2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int a;
        private int b;
        private int c;

        Builder() {
        }

        public Builder maxDeserializerCacheSize(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxDeserializerCacheSize to a negative value");
            }
            this.a = n2;
            return this;
        }

        public Builder maxSerializerCacheSize(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxSerializerCacheSize to a negative value");
            }
            this.b = n2;
            return this;
        }

        public Builder maxTypeFactoryCacheSize(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxTypeFactoryCacheSize to a negative value");
            }
            this.c = n2;
            return this;
        }

        public DefaultCacheProvider build() {
            return new DefaultCacheProvider(this.a, this.b, this.c);
        }
    }
}

