/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.CreatorCandidate;
import com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.fasterxml.jackson.databind.deser.impl.JDKValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.JavaUtilCollectionsDeserializers;
import com.fasterxml.jackson.databind.deser.std.ArrayBlockingQueueDeserializer;
import com.fasterxml.jackson.databind.deser.std.AtomicReferenceDeserializer;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapEntryDeserializer;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StringArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.deser.std.TokenBufferDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.EnumNamingStrategyFactory;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    private static final Class<?> a = Object.class;
    private static final Class<?> b = String.class;
    private static final Class<?> c = CharSequence.class;
    private static final Class<?> d = Iterable.class;
    private static final Class<?> e = Map.Entry.class;
    private static final Class<?> f = Serializable.class;
    protected static final PropertyName UNWRAPPED_CREATOR_PARAM_NAME = new PropertyName("@JsonUnwrapped");
    protected final DeserializerFactoryConfig _factoryConfig;

    protected BasicDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        this._factoryConfig = deserializerFactoryConfig;
    }

    public DeserializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    protected abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    @Override
    public final DeserializerFactory withAdditionalDeserializers(Deserializers deserializers) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAdditionalDeserializers(deserializers));
    }

    @Override
    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers keyDeserializers) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAdditionalKeyDeserializers(keyDeserializers));
    }

    @Override
    public final DeserializerFactory withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withDeserializerModifier(beanDeserializerModifier));
    }

    @Override
    public final DeserializerFactory withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAbstractTypeResolver(abstractTypeResolver));
    }

    @Override
    public final DeserializerFactory withValueInstantiators(ValueInstantiators valueInstantiators) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withValueInstantiators(valueInstantiators));
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig deserializationConfig, JavaType object) {
        while (true) {
            Object object2;
            Type type = object;
            Serializable serializable = deserializationConfig;
            Object object3 = this;
            Class<?> clazz = ((ResolvedType)((Object)type)).getRawClass();
            if (((BasicDeserializerFactory)object3)._factoryConfig.hasAbstractTypeResolvers()) {
                object3 = ((BasicDeserializerFactory)object3)._factoryConfig.abstractTypeResolvers().iterator();
                while (object3.hasNext()) {
                    Object object4 = (AbstractTypeResolver)object3.next();
                    if ((object4 = ((AbstractTypeResolver)object4).findTypeMapping((DeserializationConfig)serializable, (JavaType)type)) == null || ((ResolvedType)object4).hasRawClass(clazz)) continue;
                    object2 = object4;
                    break;
                }
            } else {
                object2 = object3 = null;
            }
            if (object2 == null) {
                return object;
            }
            serializable = ((ResolvedType)object).getRawClass();
            if (serializable == (type = ((ResolvedType)object3).getRawClass()) || !((Class)serializable).isAssignableFrom((Class<?>)type)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + object + " to " + object3 + ": latter is not a subtype of former");
            }
            object = object3;
        }
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        ValueInstantiator valueInstantiator = null;
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        Object object2 = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findValueInstantiator(annotatedClass);
        if (object2 != null) {
            valueInstantiator = this._valueInstantiatorInstance(deserializationConfig, annotatedClass, object2);
        }
        if (valueInstantiator == null && (valueInstantiator = JDKValueInstantiators.findStdValueInstantiator(deserializationConfig, beanDescription.getBeanClass())) == null) {
            valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators valueInstantiators : this._factoryConfig.valueInstantiators()) {
                valueInstantiator = valueInstantiators.findValueInstantiator(deserializationConfig, beanDescription, valueInstantiator);
                if (valueInstantiator != null) continue;
                deserializationContext.reportBadTypeDefinition(beanDescription, "Broken registered ValueInstantiators (of type %s): returned null ValueInstantiator", valueInstantiators.getClass().getName());
            }
        }
        if (valueInstantiator != null) {
            valueInstantiator = valueInstantiator.createContextual(deserializationContext, beanDescription);
        }
        return valueInstantiator;
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        boolean bl2;
        Object object = deserializationContext.getConfig();
        VisibilityChecker<?> visibilityChecker = ((MapperConfig)object).getDefaultVisibilityChecker(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        ConstructorDetector constructorDetector = ((DeserializationConfig)object).getConstructorDetector();
        Object object2 = new CreatorCollector(beanDescription, (MapperConfig<?>)object);
        object = this._findCreatorsFromProperties(deserializationContext, beanDescription);
        object2 = new CreatorCollectionState(deserializationContext, beanDescription, visibilityChecker, (CreatorCollector)object2, (Map<AnnotatedWithParams, BeanPropertyDefinition[]>)object);
        this._addExplicitFactoryCreators(deserializationContext, (CreatorCollectionState)object2, !constructorDetector.requireCtorAnnotation());
        if (((ResolvedType)beanDescription.getType()).isConcrete() && !(bl2 = beanDescription.isNonStaticInnerClass())) {
            boolean bl3 = constructorDetector.shouldIntrospectorImplicitConstructors(beanDescription.getBeanClass());
            this._addExplicitConstructorCreators(deserializationContext, (CreatorCollectionState)object2, bl3);
            if (((CreatorCollectionState)object2).hasImplicitConstructorCandidates() && !((CreatorCollectionState)object2).hasExplicitConstructors()) {
                Object object3 = object2;
                this._addImplicitConstructorCreators(deserializationContext, (CreatorCollectionState)object3, ((CreatorCollectionState)object3).implicitConstructorCandidates());
            }
        }
        if (((CreatorCollectionState)object2).hasImplicitFactoryCandidates() && !((CreatorCollectionState)object2).hasExplicitFactories() && !((CreatorCollectionState)object2).hasExplicitConstructors()) {
            Object object4 = object2;
            this._addImplicitFactoryCreators(deserializationContext, (CreatorCollectionState)object4, ((CreatorCollectionState)object4).implicitFactoryCandidates());
        }
        return ((CreatorCollectionState)object2).creators.constructValueInstantiator(deserializationContext);
    }

    protected Map<AnnotatedWithParams, BeanPropertyDefinition[]> _findCreatorsFromProperties(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = Collections.emptyMap();
        for (BeanPropertyDefinition beanPropertyDefinition : beanDescription.findProperties()) {
            Iterator<AnnotatedParameter> iterator = beanPropertyDefinition.getConstructorParameters();
            while (iterator.hasNext()) {
                AnnotatedParameter annotatedParameter = iterator.next();
                AnnotatedWithParams annotatedWithParams = annotatedParameter.getOwner();
                BeanPropertyDefinition[] beanPropertyDefinitionArray = map.get(annotatedWithParams);
                int n2 = annotatedParameter.getIndex();
                if (beanPropertyDefinitionArray == null) {
                    if (map.isEmpty()) {
                        map = new LinkedHashMap<AnnotatedWithParams, BeanPropertyDefinition[]>();
                    }
                    beanPropertyDefinitionArray = new BeanPropertyDefinition[annotatedWithParams.getParameterCount()];
                    map.put(annotatedWithParams, beanPropertyDefinitionArray);
                } else if (beanPropertyDefinitionArray[n2] != null) {
                    deserializationContext.reportBadTypeDefinition(beanDescription, "Conflict: parameter #%d of %s bound to more than one property; %s vs %s", n2, annotatedWithParams, beanPropertyDefinitionArray[n2], beanPropertyDefinition);
                }
                beanPropertyDefinitionArray[n2] = beanPropertyDefinition;
            }
        }
        return map;
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig deserializationConfig, Annotated object, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof ValueInstantiator) {
            return (ValueInstantiator)object2;
        }
        if (!(object2 instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object2.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
        }
        if (ClassUtil.isBogusClass(object2 = (Class)object2)) {
            return null;
        }
        if (!ValueInstantiator.class.isAssignableFrom((Class<?>)object2)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + ((Class)object2).getName() + "; expected Class<ValueInstantiator>");
        }
        HandlerInstantiator handlerInstantiator = deserializationConfig.getHandlerInstantiator();
        if (handlerInstantiator != null && (object = handlerInstantiator.valueInstantiatorInstance(deserializationConfig, (Annotated)object, (Class<?>)object2)) != null) {
            return object;
        }
        return (ValueInstantiator)ClassUtil.createInstance(object2, deserializationConfig.canOverrideAccessModifiers());
    }

    @Deprecated
    protected void _addRecordConstructor(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, AnnotatedConstructor annotatedConstructor, List<String> list) {
        int n2 = ((AnnotatedWithParams)annotatedConstructor).getParameterCount();
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            AnnotatedParameter annotatedParameter = annotatedConstructor.getParameter(i2);
            JacksonInject.Value value = annotationIntrospector.findInjectableValue(annotatedParameter);
            PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
            if (propertyName == null || propertyName.isEmpty()) {
                propertyName = PropertyName.construct(list.get(i2));
            }
            settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, creatorCollectionState.beanDesc, propertyName, i2, annotatedParameter, value);
        }
        creatorCollectionState.creators.addPropertyCreator(annotatedConstructor, false, settableBeanPropertyArray);
    }

    protected void _addExplicitConstructorCreators(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, boolean bl2) {
        BeanDescription beanDescription = creatorCollectionState.beanDesc;
        CreatorCollector creatorCollector = creatorCollectionState.creators;
        AnnotationIntrospector annotationIntrospector = creatorCollectionState.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = creatorCollectionState.vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = creatorCollectionState.creatorParams;
        AnnotatedConstructor annotatedConstructor = beanDescription.findDefaultConstructor();
        if (annotatedConstructor != null && (!creatorCollector.hasDefaultCreator() || this._hasCreatorAnnotation(deserializationContext, annotatedConstructor))) {
            creatorCollector.setDefaultCreator(annotatedConstructor);
        }
        for (AnnotatedConstructor annotatedConstructor2 : beanDescription.getConstructors()) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotatedConstructor2);
            if (JsonCreator.Mode.DISABLED == mode) continue;
            if (mode == null) {
                if (!bl2 || !visibilityChecker.isCreatorVisible(annotatedConstructor2)) continue;
                creatorCollectionState.addImplicitConstructorCandidate(CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)));
                continue;
            }
            switch (mode) {
                case DELEGATING: {
                    this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, null));
                    break;
                }
                case PROPERTIES: {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)));
                    break;
                }
                default: {
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)), deserializationContext.getConfig().getConstructorDetector());
                }
            }
            creatorCollectionState.increaseExplicitConstructorCount();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void _addImplicitConstructorCreators(DeserializationContext var1_1, CreatorCollectionState var2_2, List<CreatorCandidate> var3_3) {
        block21: {
            var4_4 = var1_1.getConfig();
            var5_7 = var2_2.beanDesc;
            var6_8 = var2_2.creators;
            var7_9 = var2_2.annotationIntrospector();
            var2_2 = var2_2.vchecker;
            var8_10 /* !! */  = null;
            var4_5 = var4_4.getConstructorDetector().singleArgCreatorDefaultsToProperties() != false && var5_7.isRecordType() == false;
            var3_3 = var3_3.iterator();
            while (var3_3.hasNext()) {
                var9_11 = (SettableBeanProperty[])var3_3.next();
                var10_12 = var9_11.paramCount();
                var11_16 = var9_11.creator();
                if (var10_12 == 1) {
                    var12_19 = var9_11.propertyDef(0);
                    var13_22 = var4_5 != false || BasicDeserializerFactory.a((BeanDescription)var5_7, (AnnotationIntrospector)var7_9, var11_16, (BeanPropertyDefinition)var12_19) != false ? 1 : 0;
                    if (var13_22 != 0) {
                        var14_25 = new SettableBeanProperty[1];
                        var10_13 = var9_11.injection(0);
                        var15_27 = var9_11.paramName(0);
                        if (var15_27 == null && (var15_27 = var9_11.findImplicitParamName(0)) == null && var10_13 == null) continue;
                        var14_25[0] = this.constructCreatorProperty((DeserializationContext)var1_1, (BeanDescription)var5_7, var15_27, 0, var9_11.parameter(0), var10_13);
                        var6_8.addPropertyCreator(var11_16, false, (SettableBeanProperty[])var14_25);
                        continue;
                    }
                    this._handleSingleArgumentCreator(var6_8, var11_16, false, var2_2.isCreatorVisible(var11_16));
                    if (var12_19 == null) continue;
                    ((POJOPropertyBuilder)var12_19).removeConstructors();
                    continue;
                }
                var12_20 = -1;
                var13_23 = new SettableBeanProperty[var10_12];
                var14_26 = 0;
                var15_28 = 0;
                for (var16_31 = 0; var16_31 < var10_12; ++var16_31) {
                    var17_34 = var11_16.getParameter(var16_31);
                    var18_35 = var9_11.propertyDef(var16_31);
                    var19_36 = var7_9.findInjectableValue((AnnotatedMember)var17_34);
                    v0 = var20_37 = var18_35 == null ? null : var18_35.getFullName();
                    if (var18_35 != null && (var18_35.isExplicitlyNamed() || var5_7.isRecordType())) {
                        ++var14_26;
                        var13_23[var16_31] = this.constructCreatorProperty((DeserializationContext)var1_1, (BeanDescription)var5_7, var20_37, var16_31, (AnnotatedParameter)var17_34, var19_36);
                        continue;
                    }
                    if (var19_36 != null) {
                        ++var15_28;
                        var13_23[var16_31] = this.constructCreatorProperty((DeserializationContext)var1_1, (BeanDescription)var5_7, var20_37, var16_31, (AnnotatedParameter)var17_34, var19_36);
                        continue;
                    }
                    var18_35 = var7_9.findUnwrappingNameTransformer((AnnotatedMember)var17_34);
                    if (var18_35 != null) {
                        this._reportUnwrappedCreatorProperty((DeserializationContext)var1_1, (BeanDescription)var5_7, (AnnotatedParameter)var17_34);
                        continue;
                    }
                    if (var12_20 >= 0) continue;
                    var12_20 = var16_31;
                }
                var16_31 = var14_26;
                if (var14_26 > 0 || var15_28 > 0) {
                    if (var16_31 + var15_28 == var10_12) {
                        var6_8.addPropertyCreator(var11_16, false, var13_23);
                        continue;
                    }
                    if (var14_26 == 0 && var15_28 + 1 == var10_12) {
                        var6_8.addDelegatingCreator(var11_16, false, var13_23, 0);
                        continue;
                    }
                    var17_34 = var9_11.findImplicitParamName(var12_20);
                    if (var17_34 == null || var17_34.isEmpty()) {
                        var1_1.reportBadTypeDefinition((BeanDescription)var5_7, "Argument #%d of constructor %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator", new Object[]{var12_20, var11_16});
                    }
                }
                if (var6_8.hasDefaultCreator()) continue;
                if (var8_10 /* !! */  == null) {
                    var8_10 /* !! */  = new LinkedList<AnnotatedWithParams>();
                }
                var8_10 /* !! */ .add(var11_16);
            }
            if (var8_10 /* !! */  == null || var6_8.hasDelegatingCreator() || var6_8.hasPropertyBasedCreator()) break block21;
            v1 = var5_7;
            v2 = var7_9;
            var7_9 = var8_10 /* !! */ ;
            var5_7 = v2;
            var4_6 = var2_2;
            var3_3 = v1;
            var2_2 = var1_1;
            var1_1 = this;
            var8_10 /* !! */  = null;
            var9_11 = null;
            var7_9 = var7_9.iterator();
            block2: while (var7_9.hasNext()) {
                var10_14 = (AnnotatedWithParams)var7_9.next();
                if (!var4_6.isCreatorVisible(var10_14)) continue;
                var11_17 = var10_14.getParameterCount();
                var12_19 = new SettableBeanProperty[var11_17];
                for (var13_22 = 0; var13_22 < var11_17; ++var13_22) {
                    var14_25 = var10_14.getParameter(var13_22);
                    var16_33 = var5_7;
                    var15_29 = var14_25;
                    if (var16_33 == null) ** GOTO lbl-1000
                    var17_34 = var16_33.findNameForDeserialization((Annotated)var15_29);
                    if (var17_34 != null && !var17_34.isEmpty()) {
                        v3 = var17_34;
                    } else if ((var15_29 = var16_33.findImplicitPropertyName((AnnotatedMember)var15_29)) != null && !var15_29.isEmpty()) {
                        v3 = PropertyName.construct((String)var15_29);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = var15_29 = null;
                    }
                    if (v3 == null || var15_29.isEmpty()) continue block2;
                    var12_19[var13_22] = var1_1.constructCreatorProperty((DeserializationContext)var2_2, (BeanDescription)var3_3, (PropertyName)var15_29, var14_25.getIndex(), (AnnotatedParameter)var14_25, null);
                }
                if (var8_10 /* !! */  != null) {
                    var8_10 /* !! */  = null;
                    break;
                }
                var8_10 /* !! */  = var10_14;
                var9_11 = var12_19;
            }
            if (var8_10 /* !! */  != null) {
                var6_8.addPropertyCreator((AnnotatedWithParams)var8_10 /* !! */ , false, var9_11);
                var7_9 = (BasicBeanDescription)var3_3;
                var10_15 = var9_11;
                var11_18 = var9_11.length;
                for (var12_21 = 0; var12_21 < var11_18; ++var12_21) {
                    var13_24 = var10_15[var12_21];
                    var14_25 = var13_24.getFullName();
                    if (var7_9.hasProperty((PropertyName)var14_25)) continue;
                    var15_30 = SimpleBeanPropertyDefinition.construct(var2_2.getConfig(), var13_24.getMember(), (PropertyName)var14_25);
                    var7_9.addProperty(var15_30);
                }
            }
        }
    }

    protected void _addExplicitFactoryCreators(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, boolean bl2) {
        BeanDescription beanDescription = creatorCollectionState.beanDesc;
        CreatorCollector creatorCollector = creatorCollectionState.creators;
        AnnotationIntrospector annotationIntrospector = creatorCollectionState.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = creatorCollectionState.vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = creatorCollectionState.creatorParams;
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotatedMethod);
            int n2 = ((AnnotatedWithParams)annotatedMethod).getParameterCount();
            if (mode == null) {
                if (!bl2 || n2 != 1 || !visibilityChecker.isCreatorVisible(annotatedMethod)) continue;
                creatorCollectionState.addImplicitFactoryCandidate(CreatorCandidate.construct(annotationIntrospector, annotatedMethod, null));
                continue;
            }
            if (mode == JsonCreator.Mode.DISABLED) continue;
            if (n2 == 0) {
                creatorCollector.setDefaultCreator(annotatedMethod);
                continue;
            }
            switch (mode) {
                case DELEGATING: {
                    this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, null));
                    break;
                }
                case PROPERTIES: {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, map.get(annotatedMethod)));
                    break;
                }
                default: {
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, map.get(annotatedMethod)), ConstructorDetector.DEFAULT);
                }
            }
            creatorCollectionState.increaseExplicitFactoryCount();
        }
    }

    protected void _addImplicitFactoryCreators(DeserializationContext deserializationContext, CreatorCollectionState object, List<CreatorCandidate> object2) {
        BeanDescription beanDescription = ((CreatorCollectionState)object).beanDesc;
        CreatorCollector creatorCollector = ((CreatorCollectionState)object).creators;
        AnnotationIntrospector annotationIntrospector = ((CreatorCollectionState)object).annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = ((CreatorCollectionState)object).vchecker;
        object = ((CreatorCollectionState)object).creatorParams;
        object2 = object2.iterator();
        while (object2.hasNext()) {
            int n2;
            Object object3 = (CreatorCandidate)object2.next();
            int n3 = ((CreatorCandidate)object3).paramCount();
            AnnotatedWithParams annotatedWithParams = ((CreatorCandidate)object3).creator();
            BeanPropertyDefinition[] beanPropertyDefinitionArray = (BeanPropertyDefinition[])object.get(annotatedWithParams);
            if (n3 != 1) continue;
            boolean bl2 = BasicDeserializerFactory.a(beanDescription, annotationIntrospector, annotatedWithParams, (BeanPropertyDefinition)(object3 = ((CreatorCandidate)object3).propertyDef(0)));
            if (!bl2) {
                this._handleSingleArgumentCreator(creatorCollector, annotatedWithParams, false, visibilityChecker.isCreatorVisible(annotatedWithParams));
                if (object3 == null) continue;
                ((POJOPropertyBuilder)object3).removeConstructors();
                continue;
            }
            object3 = null;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n3];
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                PropertyName propertyName;
                AnnotatedParameter annotatedParameter = annotatedWithParams.getParameter(n2);
                Object object4 = beanPropertyDefinitionArray == null ? null : beanPropertyDefinitionArray[n2];
                JacksonInject.Value value = annotationIntrospector.findInjectableValue(annotatedParameter);
                PropertyName propertyName2 = propertyName = object4 == null ? null : ((BeanPropertyDefinition)object4).getFullName();
                if (object4 != null && ((BeanPropertyDefinition)object4).isExplicitlyNamed()) {
                    ++n4;
                    settableBeanPropertyArray[n2] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n2, annotatedParameter, value);
                    continue;
                }
                if (value != null) {
                    ++n5;
                    settableBeanPropertyArray[n2] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n2, annotatedParameter, value);
                    continue;
                }
                object4 = annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter);
                if (object4 != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, annotatedParameter);
                    continue;
                }
                if (object3 != null) continue;
                object3 = annotatedParameter;
            }
            n2 = n4;
            if (n4 <= 0 && n5 <= 0) continue;
            if (n2 + n5 == n3) {
                creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                continue;
            }
            if (n4 == 0 && n5 + 1 == n3) {
                creatorCollector.addDelegatingCreator(annotatedWithParams, false, settableBeanPropertyArray, 0);
                continue;
            }
            deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of factory method %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator", object3 == null ? -1 : ((AnnotatedParameter)object3).getIndex(), annotatedWithParams);
        }
    }

    protected void _addExplicitDelegatingCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) {
        int n2 = -1;
        int n3 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i2);
            JacksonInject.Value value = creatorCandidate.injection(i2);
            if (value != null) {
                settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, null, i2, annotatedParameter, value);
                continue;
            }
            if (n2 < 0) {
                n2 = i2;
                continue;
            }
            deserializationContext.reportBadTypeDefinition(beanDescription, "More than one argument (#%d and #%d) left as delegating for Creator %s: only one allowed", n2, i2, creatorCandidate);
        }
        if (n2 < 0) {
            deserializationContext.reportBadTypeDefinition(beanDescription, "No argument left as delegating for Creator %s: exactly one required", creatorCandidate);
        }
        if (n3 == 1) {
            this._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
            BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
            if (beanPropertyDefinition != null) {
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
            }
            return;
        }
        creatorCollector.addDelegatingCreator(creatorCandidate.creator(), true, settableBeanPropertyArray, n2);
    }

    protected void _addExplicitPropertyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) {
        int n2 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            JacksonInject.Value value = creatorCandidate.injection(i2);
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i2);
            Object object = creatorCandidate.paramName(i2);
            if (object == null) {
                object = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findUnwrappingNameTransformer(annotatedParameter);
                if (object != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, annotatedParameter);
                }
                object = creatorCandidate.findImplicitParamName(i2);
                this._validateNamedPropertyParameter(deserializationContext, beanDescription, creatorCandidate, i2, (PropertyName)object, value);
            }
            settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, (PropertyName)object, i2, annotatedParameter, value);
        }
        creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
    }

    @Deprecated
    protected void _addExplicitAnyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) {
        this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate, deserializationContext.getConfig().getConstructorDetector());
    }

    protected void _addExplicitAnyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate, ConstructorDetector constructorDetector) {
        SettableBeanProperty[] settableBeanPropertyArray;
        boolean bl2;
        if (1 != creatorCandidate.paramCount()) {
            int n2;
            if (!constructorDetector.singleArgCreatorDefaultsToProperties() && (n2 = creatorCandidate.findOnlyParamWithoutInjection()) >= 0 && (constructorDetector.singleArgCreatorDefaultsToDelegating() || creatorCandidate.paramName(n2) == null)) {
                this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
                return;
            }
            this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
            return;
        }
        AnnotatedParameter annotatedParameter = creatorCandidate.parameter(0);
        JacksonInject.Value value = creatorCandidate.injection(0);
        PropertyName propertyName = null;
        switch (constructorDetector.singleArgMode()) {
            case DELEGATING: {
                boolean bl3 = false;
                break;
            }
            case PROPERTIES: {
                bl2 = true;
                propertyName = creatorCandidate.paramName(0);
                if (propertyName != null) break;
                this._validateNamedPropertyParameter(deserializationContext, beanDescription, creatorCandidate, 0, propertyName, value);
                break;
            }
            case REQUIRE_MODE: {
                deserializationContext.reportBadTypeDefinition(beanDescription, "Single-argument constructor (%s) is annotated but no 'mode' defined; `CreatorDetector`configured with `SingleArgConstructor.REQUIRE_MODE`", creatorCandidate.creator());
                return;
            }
            default: {
                boolean bl3;
                settableBeanPropertyArray = creatorCandidate.propertyDef(0);
                propertyName = creatorCandidate.explicitParamName(0);
                bl2 = propertyName != null;
                if (bl2 || beanDescription.findJsonValueAccessor() != null) break;
                if (value != null) {
                    bl3 = true;
                    break;
                }
                if (settableBeanPropertyArray == null) break;
                propertyName = creatorCandidate.paramName(0);
                bl3 = bl2 = propertyName != null && settableBeanPropertyArray.couldSerialize();
            }
        }
        if (bl2) {
            settableBeanPropertyArray = new SettableBeanProperty[]{this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, 0, annotatedParameter, value)};
            creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
            return;
        }
        this._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
        settableBeanPropertyArray = creatorCandidate.propertyDef(0);
        if (settableBeanPropertyArray != null) {
            ((POJOPropertyBuilder)settableBeanPropertyArray).removeConstructors();
        }
    }

    private static boolean a(BeanDescription beanDescription, AnnotationIntrospector object, AnnotatedWithParams annotatedWithParams, BeanPropertyDefinition beanPropertyDefinition) {
        if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed()) {
            return true;
        }
        if (beanDescription.findJsonValueAccessor() != null) {
            return false;
        }
        if (((AnnotationIntrospector)object).findInjectableValue(annotatedWithParams.getParameter(0)) != null) {
            return true;
        }
        if (beanPropertyDefinition != null) {
            object = beanPropertyDefinition.getName();
            if (object != null && !((String)object).isEmpty() && beanPropertyDefinition.couldSerialize()) {
                return true;
            }
            if (!beanPropertyDefinition.isExplicitlyNamed() && beanDescription.isRecordType()) {
                return true;
            }
        }
        return false;
    }

    protected boolean _handleSingleArgumentCreator(CreatorCollector creatorCollector, AnnotatedWithParams annotatedWithParams, boolean bl2, boolean bl3) {
        Class<?> clazz = annotatedWithParams.getRawParameterType(0);
        if (clazz == String.class || clazz == c) {
            if (bl2 || bl3) {
                creatorCollector.addStringCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl2 || bl3) {
                creatorCollector.addIntCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl2 || bl3) {
                creatorCollector.addLongCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl2 || bl3) {
                creatorCollector.addDoubleCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (bl2 || bl3) {
                creatorCollector.addBooleanCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == BigInteger.class && (bl2 || bl3)) {
            creatorCollector.addBigIntegerCreator(annotatedWithParams, bl2);
        }
        if (clazz == BigDecimal.class && (bl2 || bl3)) {
            creatorCollector.addBigDecimalCreator(annotatedWithParams, bl2);
        }
        if (bl2) {
            creatorCollector.addDelegatingCreator(annotatedWithParams, bl2, null, 0);
            return true;
        }
        return false;
    }

    protected void _validateNamedPropertyParameter(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCandidate creatorCandidate, int n2, PropertyName propertyName, JacksonInject.Value value) {
        if (propertyName == null && value == null) {
            deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of constructor %s has no property name (and is not Injectable): can not use as property-based Creator", n2, creatorCandidate);
        }
    }

    protected void _reportUnwrappedCreatorProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, AnnotatedParameter annotatedParameter) {
        deserializationContext.reportBadTypeDefinition(beanDescription, "Cannot define Creator parameter %d as `@JsonUnwrapped`: combination not yet supported", annotatedParameter.getIndex());
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationContext deserializationContext, BeanDescription jsonDeserializer, PropertyName propertyName, int n2, AnnotatedParameter annotatedParameter, JacksonInject.Value value) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Serializable serializable2 = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (serializable2 == null) {
            object3 = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
            serializable2 = null;
        } else {
            serializable = serializable2.hasRequiredMarker(annotatedParameter);
            object2 = serializable2.findPropertyDescription(annotatedParameter);
            object = serializable2.findPropertyIndex(annotatedParameter);
            object3 = serializable2.findPropertyDefaultValue(annotatedParameter);
            object3 = PropertyMetadata.construct((Boolean)serializable, (String)object2, (Integer)object, (String)object3);
            serializable2 = serializable2.findWrapperName(annotatedParameter);
        }
        AnnotatedParameter annotatedParameter2 = annotatedParameter;
        serializable = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedParameter2, ((Annotated)annotatedParameter2).getType());
        object2 = new BeanProperty.Std(propertyName, (JavaType)serializable, (PropertyName)serializable2, annotatedParameter, (PropertyMetadata)object3);
        object = (TypeDeserializer)((JavaType)serializable).getTypeHandler();
        if (object == null) {
            object = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, (JavaType)serializable);
        }
        object3 = this._getSetterInfo(deserializationContext, (BeanProperty)object2, (PropertyMetadata)object3);
        object3 = CreatorProperty.construct(propertyName, (JavaType)serializable, ((BeanProperty.Std)object2).getWrapperName(), (TypeDeserializer)object, ((BeanDescription)((Object)jsonDeserializer)).getClassAnnotations(), annotatedParameter, n2, value, (PropertyMetadata)object3);
        jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedParameter);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer)((JavaType)serializable).getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, (BeanProperty)object3, (JavaType)serializable);
            object3 = ((SettableBeanProperty)object3).withValueDeserializer(jsonDeserializer);
        }
        return object3;
    }

    protected PropertyMetadata _getSetterInfo(DeserializationContext serializable, BeanProperty object, PropertyMetadata propertyMetadata) {
        Object object2 = ((DatabindContext)((Object)serializable)).getAnnotationIntrospector();
        serializable = ((DeserializationContext)serializable).getConfig();
        Nulls nulls = null;
        Nulls nulls2 = null;
        AnnotatedMember annotatedMember = object.getMember();
        if (annotatedMember != null) {
            if (object2 != null && (object2 = ((AnnotationIntrospector)object2).findSetterInfo(annotatedMember)) != null) {
                nulls = ((JsonSetter.Value)object2).nonDefaultValueNulls();
                nulls2 = ((JsonSetter.Value)object2).nonDefaultContentNulls();
            }
            if ((object = ((ConfigOverride)(object2 = ((MapperConfig)serializable).getConfigOverride(((ResolvedType)object.getType()).getRawClass()))).getSetterInfo()) != null) {
                if (nulls == null) {
                    nulls = ((JsonSetter.Value)object).nonDefaultValueNulls();
                }
                if (nulls2 == null) {
                    nulls2 = ((JsonSetter.Value)object).nonDefaultContentNulls();
                }
            }
        }
        object2 = ((MapperConfig)serializable).getDefaultSetterInfo();
        if (nulls == null) {
            nulls = ((JsonSetter.Value)object2).nonDefaultValueNulls();
        }
        if (nulls2 == null) {
            nulls2 = ((JsonSetter.Value)object2).nonDefaultContentNulls();
        }
        if (nulls != null || nulls2 != null) {
            propertyMetadata = propertyMetadata.withNulls(nulls, nulls2);
        }
        return propertyMetadata;
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext serializable, ArrayType arrayType, BeanDescription beanDescription) {
        JsonDeserializer jsonDeserializer;
        serializable = ((DeserializationContext)serializable).getConfig();
        JavaType javaType = ((JavaType)arrayType).getContentType();
        JsonDeserializer object2 = (JsonDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer((DeserializationConfig)serializable, javaType);
        }
        if ((jsonDeserializer = this._findCustomArrayDeserializer(arrayType, (DeserializationConfig)serializable, beanDescription, typeDeserializer, object2)) == null) {
            if (object2 == null) {
                if (((ResolvedType)javaType).isPrimitive()) {
                    jsonDeserializer = PrimitiveArrayDeserializers.forType(((ResolvedType)javaType).getRawClass());
                } else if (((ResolvedType)javaType).hasRawClass(String.class)) {
                    jsonDeserializer = StringArrayDeserializer.instance;
                }
            }
            if (jsonDeserializer == null) {
                jsonDeserializer = new ObjectArrayDeserializer((JavaType)arrayType, object2, typeDeserializer);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyArrayDeserializer((DeserializationConfig)serializable, arrayType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext serializable2, CollectionType object, BeanDescription beanDescription) {
        Object object2;
        BeanDescription beanDescription2;
        JsonDeserializer jsonDeserializer;
        Object object3;
        JavaType javaType = ((JavaType)object3).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = ((DeserializationContext)serializable2).getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionDeserializer((CollectionType)object3, deserializationConfig, beanDescription2, typeDeserializer, jsonDeserializer2)) == null) {
            object2 = ((ResolvedType)object3).getRawClass();
            if (jsonDeserializer2 == null && EnumSet.class.isAssignableFrom((Class<?>)object2)) {
                jsonDeserializer = new EnumSetDeserializer(javaType, null, typeDeserializer);
            }
        }
        if (jsonDeserializer == null) {
            if (((ResolvedType)object3).isInterface() || ((ResolvedType)object3).isAbstract()) {
                object2 = this._mapAbstractCollectionType((JavaType)object3, deserializationConfig);
                if (object2 == null) {
                    if (((JavaType)object3).getTypeHandler() == null) {
                        throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Collection type " + object3);
                    }
                    jsonDeserializer = AbstractDeserializer.constructForNonPOJO(beanDescription2);
                } else {
                    object3 = object2;
                    beanDescription2 = deserializationConfig.introspectForCreation((JavaType)object3);
                }
            }
            if (jsonDeserializer == null) {
                object2 = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)serializable2, beanDescription2);
                if (!((ValueInstantiator)object2).canCreateUsingDefault()) {
                    if (((ResolvedType)object3).hasRawClass(ArrayBlockingQueue.class)) {
                        return new ArrayBlockingQueueDeserializer((JavaType)object3, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
                    }
                    jsonDeserializer = JavaUtilCollectionsDeserializers.findForCollection((DeserializationContext)serializable2, (JavaType)object3);
                    if (jsonDeserializer != null) {
                        return jsonDeserializer;
                    }
                }
                jsonDeserializer = ((ResolvedType)javaType).hasRawClass(String.class) ? new StringCollectionDeserializer((JavaType)object3, jsonDeserializer2, (ValueInstantiator)object2) : new CollectionDeserializer((JavaType)object3, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionDeserializer(deserializationConfig, (CollectionType)object3, beanDescription2, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected CollectionType _mapAbstractCollectionType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<?> clazz = ContainerDefaultMappings.findCollectionFallback(javaType);
        if (clazz != null) {
            return (CollectionType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, clazz, true);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext serializable, CollectionLikeType collectionLikeType, BeanDescription beanDescription) {
        void var6_8;
        JsonDeserializer<?> jsonDeserializer = ((JavaType)collectionLikeType).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        serializable = ((DeserializationContext)serializable).getConfig();
        TypeDeserializer object2 = (TypeDeserializer)((JavaType)((Object)jsonDeserializer)).getTypeHandler();
        if (object2 == null) {
            TypeDeserializer typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer((DeserializationConfig)serializable, (JavaType)((Object)jsonDeserializer));
        }
        if ((jsonDeserializer = this._findCustomCollectionLikeDeserializer(collectionLikeType, (DeserializationConfig)serializable, beanDescription, (TypeDeserializer)var6_8, jsonDeserializer2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionLikeDeserializer((DeserializationConfig)serializable, collectionLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationContext serializable, MapType object, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = ((DeserializationContext)serializable).getConfig();
        Object object2 = ((JavaType)object).getKeyType();
        Serializable serializable2 = ((JavaType)object).getContentType();
        JsonDeserializer jsonDeserializer = (JsonDeserializer)((JavaType)serializable2).getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)((JavaType)object2).getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)((JavaType)serializable2).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, (JavaType)serializable2);
        }
        if ((serializable2 = this._findCustomMapDeserializer((MapType)object, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer)) == null) {
            Class<?> clazz = ((ResolvedType)object).getRawClass();
            if (EnumMap.class.isAssignableFrom(clazz)) {
                void var11_13;
                if (clazz == EnumMap.class) {
                    Object object3 = null;
                } else {
                    ValueInstantiator valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)serializable, beanDescription);
                }
                if (!((JavaType)object2).isEnumImplType()) {
                    throw new IllegalArgumentException("Cannot construct EnumMap; generic (key) type not available");
                }
                serializable2 = new EnumMapDeserializer((JavaType)object, (ValueInstantiator)var11_13, null, jsonDeserializer, typeDeserializer, null);
            }
            if (serializable2 == null) {
                if (((ResolvedType)object).isInterface() || ((ResolvedType)object).isAbstract()) {
                    MapType mapType = this._mapAbstractMapType((JavaType)object, deserializationConfig);
                    if (mapType != null) {
                        object = mapType;
                        ((ResolvedType)object).getRawClass();
                        beanDescription = deserializationConfig.introspectForCreation((JavaType)object);
                    } else {
                        if (((JavaType)object).getTypeHandler() == null) {
                            throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Map type " + object);
                        }
                        serializable2 = AbstractDeserializer.constructForNonPOJO(beanDescription);
                    }
                } else {
                    serializable2 = JavaUtilCollectionsDeserializers.findForMap((DeserializationContext)serializable, (JavaType)object);
                    if (serializable2 != null) {
                        return serializable2;
                    }
                }
                if (serializable2 == null) {
                    ValueInstantiator valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)serializable, beanDescription);
                    serializable = new MapDeserializer((JavaType)object, valueInstantiator, keyDeserializer, jsonDeserializer, typeDeserializer);
                    object2 = ((MapperConfig)deserializationConfig).getDefaultPropertyIgnorals(Map.class, beanDescription.getClassInfo());
                    object2 = object2 == null ? null : ((JsonIgnoreProperties.Value)object2).findIgnoredForDeserialization();
                    ((MapDeserializer)serializable).setIgnorableProperties((Set<String>)object2);
                    object2 = ((MapperConfig)deserializationConfig).getDefaultPropertyInclusions(Map.class, beanDescription.getClassInfo());
                    object2 = object2 == null ? null : ((JsonIncludeProperties.Value)object2).getIncluded();
                    ((MapDeserializer)serializable).setIncludableProperties((Set<String>)object2);
                    serializable2 = serializable;
                }
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                serializable2 = beanDeserializerModifier.modifyMapDeserializer(deserializationConfig, (MapType)object, beanDescription, (JsonDeserializer<?>)((Object)serializable2));
            }
        }
        return serializable2;
    }

    protected MapType _mapAbstractMapType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<?> clazz = ContainerDefaultMappings.findMapFallback(javaType);
        if (clazz != null) {
            return (MapType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, clazz, true);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext serializable, MapLikeType mapLikeType, BeanDescription beanDescription) {
        JsonDeserializer<?> jsonDeserializer = ((JavaType)mapLikeType).getKeyType();
        JavaType javaType = ((JavaType)mapLikeType).getContentType();
        serializable = ((DeserializationContext)serializable).getConfig();
        JsonDeserializer object2 = (JsonDeserializer)javaType.getValueHandler();
        jsonDeserializer = (KeyDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer((DeserializationConfig)serializable, javaType);
        }
        if ((jsonDeserializer = this._findCustomMapLikeDeserializer(mapLikeType, (DeserializationConfig)serializable, beanDescription, (KeyDeserializer)((Object)jsonDeserializer), typeDeserializer, object2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyMapLikeDeserializer((DeserializationConfig)serializable, mapLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        Object object = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (object == null) {
            if (clazz == Enum.class) {
                return AbstractDeserializer.constructForNonPOJO(beanDescription);
            }
            ValueInstantiator valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
            SettableBeanProperty[] settableBeanPropertyArray = valueInstantiator == null ? null : valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
                if (!this._hasCreatorAnnotation(deserializationContext, annotatedMethod)) continue;
                if (((AnnotatedWithParams)annotatedMethod).getParameterCount() == 0) {
                    object = EnumDeserializer.deserializerForNoArgsCreator(deserializationConfig, clazz, annotatedMethod);
                    break;
                }
                object = annotatedMethod.getRawReturnType();
                if (!((Class)object).isAssignableFrom(clazz)) {
                    ((DatabindContext)deserializationContext).reportBadDefinition(javaType, String.format("Invalid `@JsonCreator` annotated Enum factory method [%s]: needs to return compatible type", ((Annotated)annotatedMethod).toString()));
                }
                object = EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, valueInstantiator, settableBeanPropertyArray);
                break;
            }
            if (object == null) {
                object = new EnumDeserializer(this.constructEnumResolver(clazz, deserializationConfig, beanDescription), deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS), this.constructEnumNamingStrategyResolver(deserializationConfig, beanDescription.getClassInfo()), EnumResolver.constructUsingToString(deserializationConfig, beanDescription.getClassInfo()));
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                object = beanDeserializerModifier.modifyEnumDeserializer(deserializationConfig, javaType, beanDescription, (JsonDeserializer<?>)object);
            }
        }
        return object;
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig jsonDeserializer, JavaType type, BeanDescription beanDescription) {
        jsonDeserializer = this._findCustomTreeNodeDeserializer((Class<? extends JsonNode>)(type = ((ResolvedType)((Object)type)).getRawClass()), (DeserializationConfig)((Object)jsonDeserializer), beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JsonNodeDeserializer.getDeserializer(type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createReferenceDeserializer(DeserializationContext object2, ReferenceType referenceType, BeanDescription beanDescription) {
        void var3_8;
        void var2_7;
        JsonDeserializer<?> jsonDeserializer = var2_7.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        DeserializationConfig deserializationConfig = ((DeserializationContext)object2).getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)((JavaType)((Object)jsonDeserializer)).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, (JavaType)((Object)jsonDeserializer));
        }
        if ((jsonDeserializer = this._findCustomReferenceDeserializer((ReferenceType)var2_7, deserializationConfig, (BeanDescription)var3_8, typeDeserializer, jsonDeserializer2)) == null && var2_7.isTypeOrSubTypeOf(AtomicReference.class)) {
            void var1_4;
            Class<?> clazz = var2_7.getRawClass();
            if (clazz == AtomicReference.class) {
                Object var1_2 = null;
            } else {
                ValueInstantiator valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)object2, (BeanDescription)var3_8);
            }
            return new AtomicReferenceDeserializer((JavaType)var2_7, (ValueInstantiator)var1_4, typeDeserializer, jsonDeserializer2);
        }
        if (jsonDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyReferenceDeserializer(deserializationConfig, (ReferenceType)var2_7, (BeanDescription)var3_8, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) {
        JavaType javaType2;
        Collection<NamedType> collection = deserializationConfig.introspectClassAnnotations(((ResolvedType)javaType).getRawClass());
        collection = ((BeanDescription)((Object)collection)).getClassInfo();
        TypeResolverBuilder<?> typeResolverBuilder = deserializationConfig.getAnnotationIntrospector();
        if ((typeResolverBuilder = ((AnnotationIntrospector)((Object)typeResolverBuilder)).findTypeResolver(deserializationConfig, (AnnotatedClass)((Object)collection), javaType)) == null && (typeResolverBuilder = deserializationConfig.getDefaultTyper(javaType)) == null) {
            return null;
        }
        collection = ((MapperConfig)deserializationConfig).getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedClass)((Object)collection));
        if (typeResolverBuilder.getDefaultImpl() == null && ((ResolvedType)javaType).isAbstract() && (javaType2 = ((DeserializerFactory)this).mapAbstractType(deserializationConfig, javaType)) != null && !((ResolvedType)javaType2).hasRawClass(((ResolvedType)javaType).getRawClass())) {
            typeResolverBuilder = typeResolverBuilder.withDefaultImpl(((ResolvedType)javaType2).getRawClass());
        }
        try {
            return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            throw InvalidDefinitionException.from(null, ClassUtil.exceptionMessage(runtimeException), javaType).withCause(runtimeException);
        }
    }

    protected JsonDeserializer<?> findOptionalStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        return OptionalHandlerFactory.instance.findDeserializer(javaType, deserializationContext.getConfig(), beanDescription);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext serializable, JavaType javaType) {
        Object object;
        DeserializationConfig deserializationConfig = ((DeserializationContext)serializable).getConfig();
        Object object2 = null;
        Object object3 = null;
        if (this._factoryConfig.hasKeyDeserializers()) {
            KeyDeserializers clazz3;
            object2 = deserializationConfig.introspectClassAnnotations(javaType);
            object = this._factoryConfig.keyDeserializers().iterator();
            while (object.hasNext() && (object3 = (clazz3 = object.next()).findKeyDeserializer(javaType, deserializationConfig, (BeanDescription)object2)) == null) {
            }
        }
        if (object3 == null) {
            if (object2 == null) {
                object2 = deserializationConfig.introspectClassAnnotations(((ResolvedType)javaType).getRawClass());
            }
            if ((object3 = this.findKeyDeserializerFromAnnotation((DeserializationContext)serializable, ((BeanDescription)object2).getClassInfo())) == null) {
                if (((ResolvedType)javaType).isEnumType()) {
                    KeyDeserializer keyDeserializer;
                    block18: {
                        object3 = javaType;
                        object2 = serializable;
                        serializable = this;
                        object = ((DeserializationContext)object2).getConfig();
                        Class<?> clazz = ((ResolvedType)object3).getRawClass();
                        BeanDescription beanDescription = ((DeserializationConfig)object).introspect((JavaType)object3);
                        JsonDeserializer<?> jsonDeserializer = ((BasicDeserializerFactory)serializable).findKeyDeserializerFromAnnotation((DeserializationContext)object2, beanDescription.getClassInfo());
                        if (jsonDeserializer != null) {
                            keyDeserializer = jsonDeserializer;
                        } else {
                            jsonDeserializer = ((BasicDeserializerFactory)serializable)._findCustomEnumDeserializer(clazz, (DeserializationConfig)object, beanDescription);
                            if (jsonDeserializer != null) {
                                keyDeserializer = StdKeyDeserializers.constructDelegatingKeyDeserializer((DeserializationConfig)object, (JavaType)object3, jsonDeserializer);
                            } else {
                                JsonDeserializer<Object> jsonDeserializer2 = ((BasicDeserializerFactory)serializable).findDeserializerFromAnnotation((DeserializationContext)object2, beanDescription.getClassInfo());
                                if (jsonDeserializer2 != null) {
                                    keyDeserializer = StdKeyDeserializers.constructDelegatingKeyDeserializer((DeserializationConfig)object, (JavaType)object3, jsonDeserializer2);
                                } else {
                                    jsonDeserializer = ((BasicDeserializerFactory)serializable).constructEnumResolver(clazz, (DeserializationConfig)object, beanDescription);
                                    jsonDeserializer2 = ((BasicDeserializerFactory)serializable).constructEnumNamingStrategyResolver((DeserializationConfig)object, beanDescription.getClassInfo());
                                    object3 = EnumResolver.constructUsingToString((DeserializationConfig)object, beanDescription.getClassInfo());
                                    EnumResolver enumResolver = EnumResolver.constructUsingIndex((DeserializationConfig)object, beanDescription.getClassInfo());
                                    for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
                                        Class<?> clazz2;
                                        if (!((BasicDeserializerFactory)serializable)._hasCreatorAnnotation((DeserializationContext)object2, annotatedMethod)) continue;
                                        int n2 = ((AnnotatedWithParams)annotatedMethod).getParameterCount();
                                        if (n2 == 1 && (clazz2 = annotatedMethod.getRawReturnType()).isAssignableFrom(clazz)) {
                                            if (((AnnotatedWithParams)annotatedMethod).getRawParameterType(0) != String.class) continue;
                                            if (((MapperConfig)object).canOverrideAccessModifiers()) {
                                                ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), ((DatabindContext)object2).isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                                            }
                                            keyDeserializer = StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer), annotatedMethod, (EnumResolver)((Object)jsonDeserializer2), (EnumResolver)object3, enumResolver);
                                            break block18;
                                        }
                                        throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
                                    }
                                    keyDeserializer = StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer), (EnumResolver)((Object)jsonDeserializer2), (EnumResolver)object3, enumResolver);
                                }
                            }
                        }
                    }
                    object3 = keyDeserializer;
                } else {
                    object3 = StdKeyDeserializers.findStringBasedKeyDeserializer(deserializationConfig, javaType);
                }
            }
        }
        if (object3 != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                object3 = beanDeserializerModifier.modifyKeyDeserializer(deserializationConfig, javaType, (KeyDeserializer)object3);
            }
        }
        return object3;
    }

    @Override
    public boolean hasExplicitDeserializerFor(DeserializationConfig object, Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return true;
        }
        object = clazz.getName();
        if (((String)object).startsWith("java.")) {
            if (Collection.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return NumberDeserializers.find(clazz, (String)object) != null;
            }
            if (JdkDeserializers.hasDeserializerFor(clazz) || clazz == b || clazz == Boolean.class || clazz == EnumMap.class || clazz == AtomicReference.class) {
                return true;
            }
            return DateDeserializers.hasDeserializerFor(clazz);
        }
        if (((String)object).startsWith("com.fasterxml.")) {
            return JsonNode.class.isAssignableFrom(clazz) || clazz == TokenBuffer.class;
        }
        return OptionalHandlerFactory.instance.hasDeserializerFor(clazz);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember object) {
        Object object2 = deserializationConfig.getAnnotationIntrospector();
        if ((object2 = ((AnnotationIntrospector)object2).findPropertyTypeResolver(deserializationConfig, (AnnotatedMember)object, javaType)) == null) {
            return ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, javaType);
        }
        object = ((MapperConfig)deserializationConfig).getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedMember)object, javaType);
        try {
            return object2.buildTypeDeserializer(deserializationConfig, javaType, (Collection<NamedType>)object);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            throw InvalidDefinitionException.from(null, ClassUtil.exceptionMessage(runtimeException), javaType).withCause(runtimeException);
        }
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember object) {
        Object object2 = deserializationConfig.getAnnotationIntrospector();
        object2 = ((AnnotationIntrospector)object2).findPropertyContentTypeResolver(deserializationConfig, (AnnotatedMember)object, javaType);
        javaType = javaType.getContentType();
        if (object2 == null) {
            return ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, javaType);
        }
        object = ((MapperConfig)deserializationConfig).getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedMember)object, javaType);
        return object2.buildTypeDeserializer(deserializationConfig, javaType, (Collection<NamedType>)object);
    }

    public JsonDeserializer<?> findDefaultDeserializer(DeserializationContext object, JavaType javaType, BeanDescription beanDescription) {
        JsonDeserializer<?> jsonDeserializer;
        Object object2 = ((ResolvedType)javaType).getRawClass();
        if (object2 == a || object2 == f) {
            JavaType javaType2;
            DeserializationConfig deserializationConfig = ((DeserializationContext)object).getConfig();
            if (this._factoryConfig.hasAbstractTypeResolvers()) {
                javaType2 = this._findRemappedType(deserializationConfig, List.class);
                object2 = this._findRemappedType(deserializationConfig, Map.class);
            } else {
                object2 = null;
                javaType2 = null;
            }
            return new UntypedObjectDeserializer(javaType2, (JavaType)object2);
        }
        if (object2 == b || object2 == c) {
            return StringDeserializer.instance;
        }
        if (object2 == d) {
            TypeFactory typeFactory = ((DatabindContext)object).getTypeFactory();
            Object object3 = typeFactory.findTypeParameters(javaType, d);
            object2 = object3 == null || ((JavaType[])object3).length != 1 ? TypeFactory.unknownType() : object3[0];
            object3 = typeFactory.constructCollectionType(Collection.class, (JavaType)object2);
            return ((DeserializerFactory)this).createCollectionDeserializer((DeserializationContext)object, (CollectionType)object3, beanDescription);
        }
        if (object2 == e) {
            JavaType javaType3 = javaType.containedTypeOrUnknown(0);
            Object object4 = javaType.containedTypeOrUnknown(1);
            object2 = (TypeDeserializer)((JavaType)object4).getTypeHandler();
            if (object2 == null) {
                object2 = ((DeserializerFactory)this).findTypeDeserializer(((DeserializationContext)object).getConfig(), (JavaType)object4);
            }
            object4 = (JsonDeserializer)((JavaType)object4).getValueHandler();
            object = (KeyDeserializer)javaType3.getValueHandler();
            return new MapEntryDeserializer(javaType, (KeyDeserializer)object, (JsonDeserializer<Object>)object4, (TypeDeserializer)object2);
        }
        String string = ((Class)object2).getName();
        if (((Class)object2).isPrimitive() || string.startsWith("java.")) {
            jsonDeserializer = NumberDeserializers.find(object2, string);
            if (jsonDeserializer == null) {
                jsonDeserializer = DateDeserializers.find(object2, string);
            }
            if (jsonDeserializer != null) {
                return jsonDeserializer;
            }
        }
        if (object2 == TokenBuffer.class) {
            return new TokenBufferDeserializer();
        }
        jsonDeserializer = this.findOptionalStdDeserializer((DeserializationContext)object, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JdkDeserializers.find((DeserializationContext)object, object2, string);
    }

    protected JavaType _findRemappedType(DeserializationConfig serializable, Class<?> clazz) {
        DeserializationConfig deserializationConfig = serializable;
        serializable = ((DeserializerFactory)this).mapAbstractType(deserializationConfig, deserializationConfig.constructType(clazz));
        if (serializable == null || ((ResolvedType)((Object)serializable)).hasRawClass(clazz)) {
            return null;
        }
        return serializable;
    }

    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> object = deserializers.findBeanDeserializer(javaType, deserializationConfig, beanDescription);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findCollectionDeserializer(collectionType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findEnumDeserializer(clazz, deserializationConfig, beanDescription);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected KeyDeserializer findKeyDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findKeyDeserializer(annotated)) != null) {
            return deserializationContext.keyDeserializerInstance(annotated, object);
        }
        return null;
    }

    protected JsonDeserializer<Object> findContentDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findContentDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected JavaType resolveMemberAndTypeAnnotations(DeserializationContext deserializationContext, AnnotatedMember annotatedMember, JavaType javaType) {
        Object object;
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        if (((ResolvedType)javaType).isMapLikeType() && (object = javaType.getKeyType()) != null) {
            object = annotationIntrospector.findKeyDeserializer(annotatedMember);
            if ((object = deserializationContext.keyDeserializerInstance(annotatedMember, object)) != null) {
                javaType = ((MapLikeType)javaType).withKeyValueHandler(object);
                javaType.getKeyType();
            }
        }
        if (javaType.hasContentType()) {
            object = annotationIntrospector.findContentDeserializer(annotatedMember);
            if ((object = deserializationContext.deserializerInstance(annotatedMember, object)) != null) {
                javaType = javaType.withContentValueHandler(object);
            }
            if ((object = this.findPropertyContentTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
                javaType = javaType.withContentTypeHandler(object);
            }
        }
        if ((object = this.findPropertyTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
            javaType = javaType.withTypeHandler(object);
        }
        javaType = annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotatedMember, javaType);
        return javaType;
    }

    protected EnumResolver constructEnumResolver(Class<?> serializable, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        serializable = beanDescription.findJsonValueAccessor();
        if (serializable != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(((AnnotatedMember)serializable).getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return EnumResolver.constructUsingMethod(deserializationConfig, beanDescription.getClassInfo(), (AnnotatedMember)serializable);
        }
        return EnumResolver.constructFor(deserializationConfig, beanDescription.getClassInfo());
    }

    protected EnumResolver constructEnumNamingStrategyResolver(DeserializationConfig deserializationConfig, AnnotatedClass annotatedClass) {
        Object object = deserializationConfig.getAnnotationIntrospector().findEnumNamingStrategy(deserializationConfig, annotatedClass);
        if ((object = EnumNamingStrategyFactory.createEnumNamingStrategyInstance(object, deserializationConfig.canOverrideAccessModifiers())) == null) {
            return null;
        }
        return EnumResolver.constructUsingEnumNamingStrategy(deserializationConfig, annotatedClass, (EnumNamingStrategy)object);
    }

    @Deprecated
    protected EnumResolver constructEnumNamingStrategyResolver(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedClass object) {
        object = deserializationConfig.getAnnotationIntrospector().findEnumNamingStrategy(deserializationConfig, (AnnotatedClass)object);
        if ((object = EnumNamingStrategyFactory.createEnumNamingStrategyInstance(object, deserializationConfig.canOverrideAccessModifiers())) == null) {
            return null;
        }
        return EnumResolver.constructUsingEnumNamingStrategy(deserializationConfig, clazz, (EnumNamingStrategy)object);
    }

    protected boolean _hasCreatorAnnotation(DeserializationContext object, Annotated annotated) {
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)object).getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            return (object = annotationIntrospector.findCreatorAnnotation(object.getConfig(), annotated)) != null && object != JsonCreator.Mode.DISABLED;
        }
        return false;
    }

    @Deprecated
    protected JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) {
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        return annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotated, javaType);
    }

    @Deprecated
    protected JavaType resolveType(DeserializationContext deserializationContext, BeanDescription beanDescription, JavaType javaType, AnnotatedMember annotatedMember) {
        return this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
    }

    @Deprecated
    protected AnnotatedMethod _findJsonValueFor(DeserializationConfig object, JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        object = ((DeserializationConfig)object).introspect(javaType);
        return ((BeanDescription)object).findJsonValueMethod();
    }

    protected static class CreatorCollectionState {
        public final DeserializationContext context;
        public final BeanDescription beanDesc;
        public final VisibilityChecker<?> vchecker;
        public final CreatorCollector creators;
        public final Map<AnnotatedWithParams, BeanPropertyDefinition[]> creatorParams;
        private List<CreatorCandidate> a;
        private int b;
        private List<CreatorCandidate> c;
        private int d;

        public CreatorCollectionState(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, CreatorCollector creatorCollector, Map<AnnotatedWithParams, BeanPropertyDefinition[]> map) {
            this.context = deserializationContext;
            this.beanDesc = beanDescription;
            this.vchecker = visibilityChecker;
            this.creators = creatorCollector;
            this.creatorParams = map;
        }

        public AnnotationIntrospector annotationIntrospector() {
            return ((DatabindContext)this.context).getAnnotationIntrospector();
        }

        public void addImplicitFactoryCandidate(CreatorCandidate creatorCandidate) {
            if (this.a == null) {
                this.a = new LinkedList<CreatorCandidate>();
            }
            this.a.add(creatorCandidate);
        }

        public void increaseExplicitFactoryCount() {
            ++this.b;
        }

        public boolean hasExplicitFactories() {
            return this.b > 0;
        }

        public boolean hasImplicitFactoryCandidates() {
            return this.a != null;
        }

        public List<CreatorCandidate> implicitFactoryCandidates() {
            return this.a;
        }

        public void addImplicitConstructorCandidate(CreatorCandidate creatorCandidate) {
            if (this.c == null) {
                this.c = new LinkedList<CreatorCandidate>();
            }
            this.c.add(creatorCandidate);
        }

        public void increaseExplicitConstructorCount() {
            ++this.d;
        }

        public boolean hasExplicitConstructors() {
            return this.d > 0;
        }

        public boolean hasImplicitConstructorCandidates() {
            return this.c != null;
        }

        public List<CreatorCandidate> implicitConstructorCandidates() {
            return this.c;
        }
    }

    protected static class ContainerDefaultMappings {
        private static HashMap<String, Class<? extends Collection>> a;
        private static HashMap<String, Class<? extends Map>> b;

        protected ContainerDefaultMappings() {
        }

        public static Class<?> findCollectionFallback(JavaType javaType) {
            return a.get(((ResolvedType)javaType).getRawClass().getName());
        }

        public static Class<?> findMapFallback(JavaType javaType) {
            return b.get(((ResolvedType)javaType).getRawClass().getName());
        }

        static {
            HashMap<String, Class<LinkedHashMap>> hashMap = new HashMap<String, Class<LinkedHashMap>>();
            Class clazz = ArrayList.class;
            Class<HashSet> clazz2 = HashSet.class;
            hashMap.put(Collection.class.getName(), clazz);
            hashMap.put(List.class.getName(), clazz);
            hashMap.put(Set.class.getName(), clazz2);
            hashMap.put(SortedSet.class.getName(), TreeSet.class);
            hashMap.put(Queue.class.getName(), LinkedList.class);
            hashMap.put(AbstractList.class.getName(), clazz);
            hashMap.put(AbstractSet.class.getName(), clazz2);
            hashMap.put(Deque.class.getName(), LinkedList.class);
            hashMap.put(NavigableSet.class.getName(), TreeSet.class);
            hashMap.put("java.util.SequencedCollection", clazz);
            hashMap.put("java.util.SequencedSet", LinkedHashSet.class);
            a = hashMap;
            hashMap = new HashMap();
            clazz = LinkedHashMap.class;
            hashMap.put(Map.class.getName(), clazz);
            hashMap.put(AbstractMap.class.getName(), clazz);
            hashMap.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
            hashMap.put(SortedMap.class.getName(), TreeMap.class);
            hashMap.put(NavigableMap.class.getName(), TreeMap.class);
            hashMap.put(ConcurrentNavigableMap.class.getName(), ConcurrentSkipListMap.class);
            hashMap.put("java.util.SequencedMap", LinkedHashMap.class);
            b = hashMap;
        }
    }
}

