/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.InnerClassProperty;
import com.fasterxml.jackson.databind.deser.impl.ManagedReferenceProperty;
import com.fasterxml.jackson.databind.deser.impl.MergingSettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReferenceProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.impl.SetterlessProperty;
import com.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.IgnoredPropertyException;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.ConcreteBeanPropertyBase;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.NativeImageUtil;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class BeanDeserializerBase
extends StdDeserializer<Object>
implements ContextualDeserializer,
ResolvableDeserializer,
ValueInstantiator.Gettable,
Serializable {
    protected static final PropertyName TEMP_PROPERTY_NAME = new PropertyName("#temporary-name");
    protected final JavaType _beanType;
    protected final JsonFormat.Shape _serializationShape;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected JsonDeserializer<Object> _arrayDelegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected boolean _nonStandardCreation;
    protected boolean _vanillaProcessing;
    protected final BeanPropertyMap _beanProperties;
    protected final ValueInjector[] _injectables;
    protected SettableAnyProperty _anySetter;
    protected final Set<String> _ignorableProps;
    protected final Set<String> _includableProps;
    protected final boolean _ignoreAllUnknown;
    protected final boolean _needViewProcesing;
    protected final Map<String, SettableBeanProperty> _backRefs;
    protected transient HashMap<ClassKey, JsonDeserializer<Object>> _subDeserializers;
    protected UnwrappedPropertyHandler _unwrappedPropertyHandler;
    protected ExternalTypeHandler _externalTypeIdHandler;
    protected final ObjectIdReader _objectIdReader;

    protected BeanDeserializerBase(BeanDeserializerBuilder object, BeanDescription beanDescription, BeanPropertyMap iterable, Map<String, SettableBeanProperty> map, Set<String> set, boolean bl2, Set<String> set2, boolean bl3) {
        super(beanDescription.getType());
        ValueInjector[] valueInjectorArray;
        this._beanType = beanDescription.getType();
        this._valueInstantiator = ((BeanDeserializerBuilder)object).getValueInstantiator();
        this._delegateDeserializer = null;
        this._arrayDelegateDeserializer = null;
        this._propertyBasedCreator = null;
        this._beanProperties = iterable;
        this._backRefs = map;
        this._ignorableProps = set;
        this._ignoreAllUnknown = bl2;
        this._includableProps = set2;
        this._anySetter = ((BeanDeserializerBuilder)object).getAnySetter();
        iterable = ((BeanDeserializerBuilder)object).getInjectables();
        if (iterable == null || iterable.isEmpty()) {
            valueInjectorArray = null;
        } else {
            Iterable<SettableBeanProperty> iterable2 = iterable;
            valueInjectorArray = iterable2.toArray((ValueInjector[])new ValueInjector[iterable2.size()]);
        }
        this._injectables = valueInjectorArray;
        this._objectIdReader = ((BeanDeserializerBuilder)object).getObjectIdReader();
        this._nonStandardCreation = this._unwrappedPropertyHandler != null || this._valueInstantiator.canCreateUsingDelegate() || this._valueInstantiator.canCreateFromObjectWith() || !this._valueInstantiator.canCreateUsingDefault();
        object = beanDescription.findExpectedFormat();
        this._serializationShape = ((JsonFormat.Value)object).getShape();
        this._needViewProcesing = bl3;
        this._vanillaProcessing = !this._nonStandardCreation && this._injectables == null && !this._needViewProcesing && this._objectIdReader == null;
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase) {
        BeanDeserializerBase beanDeserializerBase2 = beanDeserializerBase;
        this(beanDeserializerBase2, beanDeserializerBase2._ignoreAllUnknown);
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, boolean bl2) {
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._beanProperties = beanDeserializerBase._beanProperties;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = bl2;
        this._includableProps = beanDeserializerBase._includableProps;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
        this._externalTypeIdHandler = beanDeserializerBase._externalTypeIdHandler;
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, NameTransformer nameTransformer) {
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = nameTransformer != null || beanDeserializerBase._ignoreAllUnknown;
        this._includableProps = beanDeserializerBase._includableProps;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        UnwrappedPropertyHandler unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        if (nameTransformer != null) {
            if (unwrappedPropertyHandler != null) {
                unwrappedPropertyHandler = unwrappedPropertyHandler.renameAll(nameTransformer);
            }
            this._beanProperties = beanDeserializerBase._beanProperties.renameAll(nameTransformer);
        } else {
            this._beanProperties = beanDeserializerBase._beanProperties;
        }
        this._unwrappedPropertyHandler = unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = false;
        this._externalTypeIdHandler = beanDeserializerBase._externalTypeIdHandler;
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, ObjectIdReader serializable) {
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._includableProps = beanDeserializerBase._includableProps;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._objectIdReader = serializable;
        if (serializable == null) {
            this._beanProperties = beanDeserializerBase._beanProperties;
            this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
        } else {
            serializable = new ObjectIdValueProperty((ObjectIdReader)serializable, PropertyMetadata.STD_REQUIRED);
            this._beanProperties = beanDeserializerBase._beanProperties.withProperty((SettableBeanProperty)serializable);
            this._vanillaProcessing = false;
        }
        this._externalTypeIdHandler = beanDeserializerBase._externalTypeIdHandler;
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, Set<String> set, Set<String> set2) {
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = set;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._includableProps = set2;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._beanProperties = beanDeserializerBase._beanProperties.withoutProperties(set, set2);
        this._externalTypeIdHandler = beanDeserializerBase._externalTypeIdHandler;
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, BeanPropertyMap beanPropertyMap) {
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._beanProperties = beanPropertyMap;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._includableProps = beanDeserializerBase._includableProps;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
        this._externalTypeIdHandler = beanDeserializerBase._externalTypeIdHandler;
    }

    @Deprecated
    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, Set<String> set) {
        this(beanDeserializerBase, set, beanDeserializerBase._includableProps);
    }

    @Override
    public abstract JsonDeserializer<Object> unwrappingDeserializer(NameTransformer var1);

    public abstract BeanDeserializerBase withObjectIdReader(ObjectIdReader var1);

    public abstract BeanDeserializerBase withByNameInclusion(Set<String> var1, Set<String> var2);

    public abstract BeanDeserializerBase withIgnoreAllUnknown(boolean var1);

    public BeanDeserializerBase withBeanProperties(BeanPropertyMap beanPropertyMap) {
        throw new UnsupportedOperationException("Class " + this.getClass().getName() + " does not override `withBeanProperties()`, needs to");
    }

    protected abstract BeanDeserializerBase asArrayDeserializer();

    @Deprecated
    public BeanDeserializerBase withIgnorableProperties(Set<String> set) {
        return this.withByNameInclusion(set, this._includableProps);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) {
        Object object;
        Object object2;
        JsonDeserializer<Object> jsonDeserializer;
        SettableBeanProperty[] settableBeanPropertyArray;
        ExternalTypeHandler.Builder builder = null;
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            settableBeanPropertyArray = this._valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            if (this._ignorableProps != null || this._includableProps != null) {
                int n2 = settableBeanPropertyArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i2];
                    if (!IgnorePropertiesUtil.shouldIgnore(settableBeanProperty.getName(), this._ignorableProps, this._includableProps)) continue;
                    settableBeanPropertyArray[i2].markAsIgnorable();
                }
            }
        } else {
            settableBeanPropertyArray = null;
        }
        UnwrappedPropertyHandler unwrappedPropertyHandler = null;
        for (SettableBeanProperty settableBeanProperty : this._beanProperties) {
            if (settableBeanProperty.hasValueDeserializer()) continue;
            jsonDeserializer = this.findConvertingDeserializer(deserializationContext, settableBeanProperty);
            if (jsonDeserializer == null) {
                jsonDeserializer = deserializationContext.findNonContextualValueDeserializer(settableBeanProperty.getType());
            }
            object2 = settableBeanProperty.withValueDeserializer(jsonDeserializer);
            BeanDeserializerBase beanDeserializerBase = this;
            beanDeserializerBase._replaceProperty(beanDeserializerBase._beanProperties, settableBeanPropertyArray, settableBeanProperty, (SettableBeanProperty)object2);
        }
        for (SettableBeanProperty settableBeanProperty : this._beanProperties) {
            Object object3;
            jsonDeserializer = settableBeanProperty;
            object2 = settableBeanProperty.getValueDeserializer();
            JsonDeserializer<Object> jsonDeserializer2 = jsonDeserializer;
            object2 = deserializationContext.handlePrimaryContextualization((JsonDeserializer<?>)object2, (BeanProperty)((Object)jsonDeserializer2), ((SettableBeanProperty)((Object)jsonDeserializer2)).getType());
            jsonDeserializer = ((SettableBeanProperty)((Object)jsonDeserializer)).withValueDeserializer((JsonDeserializer<?>)object2);
            if (!((jsonDeserializer = this._resolveManagedReferenceProperty(deserializationContext, (SettableBeanProperty)((Object)jsonDeserializer))) instanceof ManagedReferenceProperty)) {
                jsonDeserializer = this._resolvedObjectIdProperty(deserializationContext, (SettableBeanProperty)((Object)jsonDeserializer));
            }
            if ((object2 = this._findPropertyUnwrapper(deserializationContext, (SettableBeanProperty)((Object)jsonDeserializer))) != null && (object2 = ((JsonDeserializer)(object3 = ((SettableBeanProperty)((Object)jsonDeserializer)).getValueDeserializer())).unwrappingDeserializer((NameTransformer)object2)) != object3 && object2 != null) {
                jsonDeserializer = ((SettableBeanProperty)((Object)jsonDeserializer)).withValueDeserializer((JsonDeserializer<?>)object2);
                if (unwrappedPropertyHandler == null) {
                    unwrappedPropertyHandler = new UnwrappedPropertyHandler();
                }
                unwrappedPropertyHandler.addProperty((SettableBeanProperty)((Object)jsonDeserializer));
                this._beanProperties.remove((SettableBeanProperty)((Object)jsonDeserializer));
                continue;
            }
            object3 = ((ConcreteBeanPropertyBase)((Object)jsonDeserializer)).getMetadata();
            jsonDeserializer = this._resolveMergeAndNullSettings(deserializationContext, (SettableBeanProperty)((Object)jsonDeserializer), (PropertyMetadata)object3);
            if ((jsonDeserializer = this._resolveInnerClassValuedProperty(deserializationContext, (SettableBeanProperty)((Object)jsonDeserializer))) != settableBeanProperty) {
                BeanDeserializerBase beanDeserializerBase = this;
                beanDeserializerBase._replaceProperty(beanDeserializerBase._beanProperties, settableBeanPropertyArray, settableBeanProperty, (SettableBeanProperty)((Object)jsonDeserializer));
            }
            if (!((SettableBeanProperty)((Object)jsonDeserializer)).hasValueTypeDeserializer() || ((TypeDeserializer)(object2 = ((SettableBeanProperty)((Object)jsonDeserializer)).getValueTypeDeserializer())).getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
            if (builder == null) {
                builder = ExternalTypeHandler.builder(this._beanType);
            }
            builder.addExternal((SettableBeanProperty)((Object)jsonDeserializer), (TypeDeserializer)object2);
            this._beanProperties.remove((SettableBeanProperty)((Object)jsonDeserializer));
        }
        if (this._anySetter != null && !this._anySetter.hasValueDeserializer()) {
            this._anySetter = this._anySetter.withValueDeserializer(this.findDeserializer(deserializationContext, this._anySetter.getType(), this._anySetter.getProperty()));
        }
        if (this._valueInstantiator.canCreateUsingDelegate()) {
            object = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            if (object == null) {
                ((DatabindContext)deserializationContext).reportBadDefinition(this._beanType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", ClassUtil.getTypeDescription(this._beanType), ClassUtil.classNameOf(this._valueInstantiator)));
            }
            this._delegateDeserializer = this.a(deserializationContext, (JavaType)object, this._valueInstantiator.getDelegateCreator());
        }
        if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
            object = this._valueInstantiator.getArrayDelegateType(deserializationContext.getConfig());
            if (object == null) {
                ((DatabindContext)deserializationContext).reportBadDefinition(this._beanType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", ClassUtil.getTypeDescription(this._beanType), ClassUtil.classNameOf(this._valueInstantiator)));
            }
            this._arrayDelegateDeserializer = this.a(deserializationContext, (JavaType)object, this._valueInstantiator.getArrayDelegateCreator());
        }
        if (settableBeanPropertyArray != null) {
            this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, settableBeanPropertyArray, this._beanProperties);
        }
        if (builder != null) {
            this._externalTypeIdHandler = builder.build(this._beanProperties);
            this._nonStandardCreation = true;
        }
        this._unwrappedPropertyHandler = unwrappedPropertyHandler;
        if (unwrappedPropertyHandler != null) {
            this._nonStandardCreation = true;
        }
        this._vanillaProcessing = this._vanillaProcessing && !this._nonStandardCreation;
    }

    protected void _replaceProperty(BeanPropertyMap beanPropertyMap, SettableBeanProperty[] settableBeanPropertyArray, SettableBeanProperty settableBeanProperty, SettableBeanProperty settableBeanProperty2) {
        beanPropertyMap.replace(settableBeanProperty, settableBeanProperty2);
        if (settableBeanPropertyArray != null) {
            int n2 = settableBeanPropertyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (settableBeanPropertyArray[i2] != settableBeanProperty) continue;
                settableBeanPropertyArray[i2] = settableBeanProperty2;
                return;
            }
        }
    }

    private JsonDeserializer<Object> a(DeserializationContext deserializationContext, JavaType javaType, AnnotatedWithParams serializable) {
        JsonDeserializer<Object> jsonDeserializer;
        Object object;
        if (serializable != null && serializable.getParameterCount() == 1) {
            object = serializable.getParameter(0);
            jsonDeserializer = this._getSetterInfo(deserializationContext, (AnnotatedMember)object, javaType);
            serializable = new BeanProperty.Std(TEMP_PROPERTY_NAME, javaType, null, (AnnotatedMember)object, (PropertyMetadata)((Object)jsonDeserializer));
        } else {
            serializable = new BeanProperty.Std(TEMP_PROPERTY_NAME, javaType, null, (AnnotatedMember)serializable, PropertyMetadata.STD_OPTIONAL);
        }
        object = (TypeDeserializer)javaType.getTypeHandler();
        if (object == null) {
            object = deserializationContext.getConfig().findTypeDeserializer(javaType);
        }
        jsonDeserializer = (jsonDeserializer = (JsonDeserializer)javaType.getValueHandler()) == null ? this.findDeserializer(deserializationContext, javaType, (BeanProperty)((Object)serializable)) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, (BeanProperty)((Object)serializable), javaType);
        if (object != null) {
            object = ((TypeDeserializer)object).forProperty((BeanProperty)((Object)serializable));
            return new TypeWrappedDeserializer((TypeDeserializer)object, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected PropertyMetadata _getSetterInfo(DeserializationContext serializable, AnnotatedMember object, JavaType javaType) {
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)((Object)serializable)).getAnnotationIntrospector();
        serializable = ((DeserializationContext)serializable).getConfig();
        PropertyMetadata propertyMetadata = PropertyMetadata.STD_OPTIONAL;
        Nulls nulls = null;
        Nulls nulls2 = null;
        if (annotationIntrospector != null && (object = annotationIntrospector.findSetterInfo((Annotated)object)) != null) {
            nulls = ((JsonSetter.Value)object).nonDefaultValueNulls();
            nulls2 = ((JsonSetter.Value)object).nonDefaultContentNulls();
        }
        object = ((MapperConfig)serializable).getConfigOverride(((ResolvedType)javaType).getRawClass());
        if ((object = ((ConfigOverride)object).getSetterInfo()) != null) {
            if (nulls == null) {
                nulls = ((JsonSetter.Value)object).nonDefaultValueNulls();
            }
            if (nulls2 == null) {
                nulls2 = ((JsonSetter.Value)object).nonDefaultContentNulls();
            }
        }
        object = ((MapperConfig)serializable).getDefaultSetterInfo();
        if (nulls == null) {
            nulls = ((JsonSetter.Value)object).nonDefaultValueNulls();
        }
        if (nulls2 == null) {
            nulls2 = ((JsonSetter.Value)object).nonDefaultContentNulls();
        }
        if (nulls != null || nulls2 != null) {
            propertyMetadata = propertyMetadata.withNulls(nulls, nulls2);
        }
        return propertyMetadata;
    }

    protected JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext object, SettableBeanProperty object2) {
        Object object3 = ((DatabindContext)object).getAnnotationIntrospector();
        if (object3 != null && (object3 = ((AnnotationIntrospector)object3).findDeserializationConverter(((SettableBeanProperty)object2).getMember())) != null) {
            object2 = ((DatabindContext)object).converterInstance(((SettableBeanProperty)object2).getMember(), object3);
            object3 = object2.getInputType(((DatabindContext)object).getTypeFactory());
            object = ((DeserializationContext)object).findNonContextualValueDeserializer((JavaType)object3);
            return new StdDelegatingDeserializer<Object>((Converter<Object, Object>)object2, (JavaType)object3, (JsonDeserializer<?>)object);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Serializable serializable2 = this._objectIdReader;
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        AnnotatedMember annotatedMember = BeanDeserializerBase._neitherNull(beanProperty, annotationIntrospector) ? beanProperty.getMember() : null;
        if (annotatedMember != null && (object3 = annotationIntrospector.findObjectIdInfo(annotatedMember)) != null) {
            Object object4;
            object3 = annotationIntrospector.findObjectReferenceInfo(annotatedMember, (ObjectIdInfo)object3);
            serializable2 = ((ObjectIdInfo)object3).getGeneratorType();
            object2 = deserializationContext.objectIdResolverInstance(annotatedMember, (ObjectIdInfo)object3);
            if (serializable2 == ObjectIdGenerators.PropertyGenerator.class) {
                object4 = ((ObjectIdInfo)object3).getPropertyName();
                serializable2 = this.findProperty((PropertyName)object4);
                if (serializable2 == null) {
                    return (JsonDeserializer)((DatabindContext)deserializationContext).reportBadDefinition(this._beanType, String.format("Invalid Object Id definition for %s: cannot find property with name %s", ClassUtil.nameOf(((JsonDeserializer)this).handledType()), ClassUtil.name((PropertyName)object4)));
                }
                object = ((SettableBeanProperty)serializable2).getType();
                serializable = new PropertyBasedObjectIdGenerator(((ObjectIdInfo)object3).getScope());
            } else {
                object4 = deserializationContext.constructType((Class<?>)serializable2);
                object = ((DatabindContext)deserializationContext).getTypeFactory().findTypeParameters((JavaType)object4, ObjectIdGenerator.class)[0];
                serializable2 = null;
                serializable = deserializationContext.objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object3);
            }
            object4 = deserializationContext.findRootValueDeserializer((JavaType)object);
            serializable2 = ObjectIdReader.construct((JavaType)object, ((ObjectIdInfo)object3).getPropertyName(), serializable, object4, (SettableBeanProperty)serializable2, (ObjectIdResolver)object2);
        }
        object3 = this;
        if (serializable2 != null && serializable2 != this._objectIdReader) {
            object3 = ((BeanDeserializerBase)object3).withObjectIdReader((ObjectIdReader)serializable2);
        }
        if (annotatedMember != null) {
            object3 = this._handleByNameInclusion(deserializationContext, annotationIntrospector, (BeanDeserializerBase)object3, annotatedMember);
        }
        serializable2 = this.findFormatOverrides(deserializationContext, beanProperty, ((JsonDeserializer)this).handledType());
        object = null;
        if (serializable2 != null) {
            if (((JsonFormat.Value)serializable2).hasShape()) {
                object = ((JsonFormat.Value)serializable2).getShape();
            }
            if ((serializable2 = ((JsonFormat.Value)serializable2).getFeature(JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)) != null && (object2 = (serializable = this._beanProperties).withCaseInsensitivity((Boolean)serializable2)) != serializable) {
                object3 = ((BeanDeserializerBase)object3).withBeanProperties((BeanPropertyMap)object2);
            }
        }
        if (object == null) {
            object = this._serializationShape;
        }
        if (object == JsonFormat.Shape.ARRAY) {
            object3 = ((BeanDeserializerBase)object3).asArrayDeserializer();
        }
        return object3;
    }

    protected BeanDeserializerBase _handleByNameInclusion(DeserializationContext object, AnnotationIntrospector annotationIntrospector, BeanDeserializerBase beanDeserializerBase, AnnotatedMember annotatedMember) {
        HashSet<String> hashSet;
        Object object2 = annotationIntrospector.findPropertyIgnoralByName((MapperConfig<?>)(object = ((DeserializationContext)object).getConfig()), annotatedMember);
        if (((JsonIgnoreProperties.Value)object2).getIgnoreUnknown() && !this._ignoreAllUnknown) {
            beanDeserializerBase = beanDeserializerBase.withIgnoreAllUnknown(true);
        }
        object2 = ((JsonIgnoreProperties.Value)object2).findIgnoredForDeserialization();
        Set<String> set = beanDeserializerBase._ignorableProps;
        if (object2.isEmpty()) {
            hashSet = set;
        } else if (set == null || set.isEmpty()) {
            hashSet = object2;
        } else {
            hashSet = new HashSet<String>(set);
            hashSet.addAll((Collection<String>)object2);
        }
        object2 = beanDeserializerBase._includableProps;
        object = IgnorePropertiesUtil.combineNamesToInclude(object2, annotationIntrospector.findPropertyInclusionByName((MapperConfig<?>)object, annotatedMember).getIncluded());
        if (hashSet != set || object != object2) {
            beanDeserializerBase = beanDeserializerBase.withByNameInclusion(hashSet, (Set<String>)object);
        }
        return beanDeserializerBase;
    }

    protected SettableBeanProperty _resolveManagedReferenceProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        String string = settableBeanProperty.getManagedReferenceName();
        if (string == null) {
            return settableBeanProperty;
        }
        Object object = settableBeanProperty.getValueDeserializer();
        if ((object = ((JsonDeserializer)object).findBackReference(string)) == null) {
            return (SettableBeanProperty)((DatabindContext)deserializationContext).reportBadDefinition(this._beanType, String.format("Cannot handle managed/back reference %s: no back reference property found from type %s", ClassUtil.name(string), ClassUtil.getTypeDescription(settableBeanProperty.getType())));
        }
        JavaType javaType = this._beanType;
        JavaType javaType2 = ((SettableBeanProperty)object).getType();
        boolean bl2 = ((ResolvedType)settableBeanProperty.getType()).isContainerType();
        if (!((ResolvedType)javaType2).getRawClass().isAssignableFrom(((ResolvedType)javaType).getRawClass())) {
            ((DatabindContext)deserializationContext).reportBadDefinition(this._beanType, String.format("Cannot handle managed/back reference %s: back reference type (%s) not compatible with managed type (%s)", ClassUtil.name(string), ClassUtil.getTypeDescription(javaType2), ((ResolvedType)javaType).getRawClass().getName()));
        }
        return new ManagedReferenceProperty(settableBeanProperty, string, (SettableBeanProperty)object, bl2);
    }

    protected SettableBeanProperty _resolvedObjectIdProperty(DeserializationContext object, SettableBeanProperty settableBeanProperty) {
        object = settableBeanProperty.getObjectIdInfo();
        JsonDeserializer<Object> jsonDeserializer = settableBeanProperty.getValueDeserializer();
        JsonDeserializer<Object> jsonDeserializer2 = jsonDeserializer = jsonDeserializer == null ? null : jsonDeserializer.getObjectIdReader();
        if (object == null && jsonDeserializer == null) {
            return settableBeanProperty;
        }
        return new ObjectIdReferenceProperty(settableBeanProperty, (ObjectIdInfo)object);
    }

    protected NameTransformer _findPropertyUnwrapper(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        Object object = settableBeanProperty.getMember();
        if (object != null && (object = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findUnwrappingNameTransformer((AnnotatedMember)object)) != null) {
            if (settableBeanProperty instanceof CreatorProperty) {
                ((DatabindContext)deserializationContext).reportBadDefinition(((StdDeserializer)this).getValueType(), String.format("Cannot define Creator property \"%s\" as `@JsonUnwrapped`: combination not yet supported", settableBeanProperty.getName()));
            }
            return object;
        }
        return null;
    }

    protected SettableBeanProperty _resolveInnerClassValuedProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        Class<?> clazz;
        Class<?> clazz2;
        BeanDeserializerBase beanDeserializerBase;
        ValueInstantiator valueInstantiator;
        JsonDeserializer<Object> object = settableBeanProperty.getValueDeserializer();
        if (object instanceof BeanDeserializerBase && !(valueInstantiator = ((StdDeserializer)(beanDeserializerBase = (BeanDeserializerBase)object)).getValueInstantiator()).canCreateUsingDefault() && (clazz2 = ClassUtil.getOuterClass(clazz = ((ResolvedType)settableBeanProperty.getType()).getRawClass())) != null && clazz2 == ((ResolvedType)this._beanType).getRawClass()) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                Class<?>[] classArray;
                if (constructor.getParameterCount() != 1 || !clazz2.equals((classArray = constructor.getParameterTypes())[0])) continue;
                if (((DatabindContext)deserializationContext).canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(constructor, ((DatabindContext)deserializationContext).isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                return new InnerClassProperty(settableBeanProperty, constructor);
            }
        }
        return settableBeanProperty;
    }

    protected SettableBeanProperty _resolveMergeAndNullSettings(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty, PropertyMetadata propertyMetadata) {
        NullValueProvider nullValueProvider;
        Object object = propertyMetadata.getMergeInfo();
        if (object != null) {
            nullValueProvider = settableBeanProperty.getValueDeserializer();
            Boolean bl2 = nullValueProvider.supportsUpdate(deserializationContext.getConfig());
            if (bl2 == null) {
                if (((PropertyMetadata.MergeInfo)object).fromDefaults) {
                    return settableBeanProperty;
                }
            } else if (!bl2.booleanValue()) {
                if (!((PropertyMetadata.MergeInfo)object).fromDefaults) {
                    deserializationContext.handleBadMerge((JsonDeserializer<?>)nullValueProvider);
                }
                return settableBeanProperty;
            }
            object = ((PropertyMetadata.MergeInfo)object).getter;
            ((AnnotatedMember)object).fixAccess(((DatabindContext)deserializationContext).isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            if (!(settableBeanProperty instanceof SetterlessProperty)) {
                settableBeanProperty = MergingSettableBeanProperty.construct(settableBeanProperty, (AnnotatedMember)object);
            }
        }
        if ((nullValueProvider = this.findValueNullProvider(deserializationContext, settableBeanProperty, propertyMetadata)) != null) {
            settableBeanProperty = settableBeanProperty.withNullProvider(nullValueProvider);
        }
        return settableBeanProperty;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.ALWAYS_NULL;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        try {
            return this._valueInstantiator.createUsingDefaultOrWithoutArguments(deserializationContext);
        }
        catch (IOException iOException) {
            return ClassUtil.throwAsMappingException(deserializationContext, iOException);
        }
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    public boolean isCaseInsensitive() {
        return this._beanProperties.isCaseInsensitive();
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public Class<?> handledType() {
        return ((ResolvedType)this._beanType).getRawClass();
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public boolean hasProperty(String string) {
        return this._beanProperties.find(string) != null;
    }

    public boolean hasViews() {
        return this._needViewProcesing;
    }

    public int getPropertyCount() {
        return this._beanProperties.size();
    }

    @Override
    public Collection<Object> getKnownPropertyNames() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (SettableBeanProperty settableBeanProperty : this._beanProperties) {
            arrayList.add(settableBeanProperty.getName());
        }
        return arrayList;
    }

    @Deprecated
    public final Class<?> getBeanClass() {
        return ((ResolvedType)this._beanType).getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._beanType;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.POJO;
    }

    public Iterator<SettableBeanProperty> properties() {
        if (this._beanProperties == null) {
            throw new IllegalStateException("Can only call after BeanDeserializer has been resolved");
        }
        return this._beanProperties.iterator();
    }

    public Iterator<SettableBeanProperty> creatorProperties() {
        if (this._propertyBasedCreator == null) {
            return Collections.emptyList().iterator();
        }
        return this._propertyBasedCreator.properties().iterator();
    }

    public SettableBeanProperty findProperty(PropertyName propertyName) {
        return this.findProperty(propertyName.getSimpleName());
    }

    public SettableBeanProperty findProperty(String string) {
        SettableBeanProperty settableBeanProperty = this._beanProperties == null ? null : this._beanProperties.find(string);
        if (settableBeanProperty == null && this._propertyBasedCreator != null) {
            settableBeanProperty = this._propertyBasedCreator.findCreatorProperty(string);
        }
        return settableBeanProperty;
    }

    public SettableBeanProperty findProperty(int n2) {
        SettableBeanProperty settableBeanProperty = this._beanProperties == null ? null : this._beanProperties.find(n2);
        if (settableBeanProperty == null && this._propertyBasedCreator != null) {
            settableBeanProperty = this._propertyBasedCreator.findCreatorProperty(n2);
        }
        return settableBeanProperty;
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        if (this._backRefs == null) {
            return null;
        }
        return this._backRefs.get(string);
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public void replaceProperty(SettableBeanProperty settableBeanProperty, SettableBeanProperty settableBeanProperty2) {
        this._beanProperties.replace(settableBeanProperty, settableBeanProperty2);
    }

    public abstract Object deserializeFromObject(JsonParser var1, DeserializationContext var2);

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer object) {
        if (this._objectIdReader != null) {
            Object object2;
            if (jsonParser.canReadObjectId() && (object2 = jsonParser.getObjectId()) != null) {
                object = ((TypeDeserializer)object).deserializeTypedFromObject(jsonParser, deserializationContext);
                return this._handleTypedObjectId(jsonParser, deserializationContext, object, object2);
            }
            object2 = jsonParser.currentToken();
            if (object2 != null) {
                if (((JsonToken)((Object)object2)).isScalarValue()) {
                    return this.deserializeFromObjectId(jsonParser, deserializationContext);
                }
                if (object2 == JsonToken.START_OBJECT) {
                    object2 = jsonParser.nextToken();
                }
                if (object2 == JsonToken.FIELD_NAME && this._objectIdReader.maySerializeAsObject() && this._objectIdReader.isValidReferencePropertyName(jsonParser.currentName(), jsonParser)) {
                    return this.deserializeFromObjectId(jsonParser, deserializationContext);
                }
            }
        }
        return ((TypeDeserializer)object).deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    protected Object _handleTypedObjectId(JsonParser object, DeserializationContext object2, Object object3, Object object4) {
        JsonDeserializer<Object> jsonDeserializer = this._objectIdReader.getDeserializer();
        object = jsonDeserializer.handledType() == object4.getClass() ? object4 : this._convertObjectId((JsonParser)object, (DeserializationContext)object2, object4, jsonDeserializer);
        object2 = ((DeserializationContext)object2).findObjectId(object, this._objectIdReader.generator, this._objectIdReader.resolver);
        ((ReadableObjectId)object2).bindItem(object3);
        object2 = this._objectIdReader.idProperty;
        if (object2 != null) {
            return ((SettableBeanProperty)object2).setAndReturn(object3, object);
        }
        return object3;
    }

    protected Object _convertObjectId(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, JsonDeserializer<Object> jsonDeserializer) {
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        if (object instanceof String) {
            ((JsonGenerator)tokenBuffer).writeString((String)object);
        } else if (object instanceof Long) {
            ((JsonGenerator)tokenBuffer).writeNumber((Long)object);
        } else if (object instanceof Integer) {
            ((JsonGenerator)tokenBuffer).writeNumber((Integer)object);
        } else {
            ((JsonGenerator)tokenBuffer).writeObject(object);
        }
        jsonParser = tokenBuffer.asParser(jsonParser.streamReadConstraints());
        jsonParser.nextToken();
        return jsonDeserializer.deserialize(jsonParser, deserializationContext);
    }

    protected Object deserializeWithObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this.deserializeFromObject(jsonParser, deserializationContext);
    }

    protected Object deserializeFromObjectId(JsonParser jsonParser, DeserializationContext object) {
        Object object2 = this._objectIdReader.readObjectReference(jsonParser, (DeserializationContext)object);
        Object object3 = ((ReadableObjectId)(object = ((DeserializationContext)object).findObjectId(object2, this._objectIdReader.generator, this._objectIdReader.resolver))).resolve();
        if (object3 == null) {
            throw new UnresolvedForwardReference(jsonParser, "Could not resolve Object Id [" + object2 + "] (for " + this._beanType + ").", jsonParser.currentLocation(), (ReadableObjectId)object);
        }
        return object3;
    }

    protected Object deserializeFromObjectUsingNonDefault(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object = this._delegateDeserializer();
        if (object != null) {
            object = this._valueInstantiator.createUsingDelegate(deserializationContext, ((JsonDeserializer)object).deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jsonParser, deserializationContext);
        }
        object = ((ResolvedType)this._beanType).getRawClass();
        if (ClassUtil.isNonStaticInnerClass(object)) {
            return deserializationContext.handleMissingInstantiator((Class<?>)object, null, jsonParser, "non-static inner classes like this can only by instantiated using default, no-argument constructor", new Object[0]);
        }
        if (NativeImageUtil.needsReflectionConfiguration(object)) {
            return deserializationContext.handleMissingInstantiator((Class<?>)object, null, jsonParser, "cannot deserialize from Object value (no delegate- or property-based Creator): this appears to be a native image, in which case you may need to configure reflection for the class that is to be deserialized", new Object[0]);
        }
        return deserializationContext.handleMissingInstantiator((Class<?>)object, ((StdDeserializer)this).getValueInstantiator(), jsonParser, "cannot deserialize from Object value (no delegate- or property-based Creator)", new Object[0]);
    }

    protected abstract Object _deserializeUsingPropertyBased(JsonParser var1, DeserializationContext var2);

    public Object deserializeFromNumber(JsonParser object, DeserializationContext deserializationContext) {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId((JsonParser)object, deserializationContext);
        }
        JsonDeserializer<Object> jsonDeserializer = this._delegateDeserializer();
        JsonParser.NumberType numberType = ((JsonParser)object).getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            if (jsonDeserializer != null && !this._valueInstantiator.canCreateFromInt()) {
                object = this._valueInstantiator.createUsingDelegate(deserializationContext, jsonDeserializer.deserialize((JsonParser)object, deserializationContext));
                if (this._injectables != null) {
                    this.injectValues(deserializationContext, object);
                }
                return object;
            }
            return this._valueInstantiator.createFromInt(deserializationContext, ((JsonParser)object).getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            if (jsonDeserializer != null && !this._valueInstantiator.canCreateFromInt()) {
                object = this._valueInstantiator.createUsingDelegate(deserializationContext, jsonDeserializer.deserialize((JsonParser)object, deserializationContext));
                if (this._injectables != null) {
                    this.injectValues(deserializationContext, object);
                }
                return object;
            }
            return this._valueInstantiator.createFromLong(deserializationContext, ((JsonParser)object).getLongValue());
        }
        if (numberType == JsonParser.NumberType.BIG_INTEGER) {
            if (jsonDeserializer != null && !this._valueInstantiator.canCreateFromBigInteger()) {
                object = this._valueInstantiator.createUsingDelegate(deserializationContext, jsonDeserializer.deserialize((JsonParser)object, deserializationContext));
                if (this._injectables != null) {
                    this.injectValues(deserializationContext, object);
                }
                return object;
            }
            return this._valueInstantiator.createFromBigInteger(deserializationContext, ((JsonParser)object).getBigIntegerValue());
        }
        return deserializationContext.handleMissingInstantiator(((JsonDeserializer)this).handledType(), ((StdDeserializer)this).getValueInstantiator(), (JsonParser)object, "no suitable creator method found to deserialize from Number value (%s)", ((JsonParser)object).getNumberValue());
    }

    public Object deserializeFromString(JsonParser object, DeserializationContext deserializationContext) {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId((JsonParser)object, deserializationContext);
        }
        JsonDeserializer<Object> jsonDeserializer = this._delegateDeserializer();
        if (jsonDeserializer != null && !this._valueInstantiator.canCreateFromString()) {
            object = this._valueInstantiator.createUsingDelegate(deserializationContext, jsonDeserializer.deserialize((JsonParser)object, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        return this._deserializeFromString((JsonParser)object, deserializationContext);
    }

    public Object deserializeFromDouble(JsonParser object, DeserializationContext deserializationContext) {
        Object object2 = ((JsonParser)object).getNumberType();
        if (object2 == JsonParser.NumberType.DOUBLE || object2 == JsonParser.NumberType.FLOAT) {
            object2 = this._delegateDeserializer();
            if (object2 != null && !this._valueInstantiator.canCreateFromDouble()) {
                object = this._valueInstantiator.createUsingDelegate(deserializationContext, ((JsonDeserializer)object2).deserialize((JsonParser)object, deserializationContext));
                if (this._injectables != null) {
                    this.injectValues(deserializationContext, object);
                }
                return object;
            }
            return this._valueInstantiator.createFromDouble(deserializationContext, ((JsonParser)object).getDoubleValue());
        }
        if (object2 == JsonParser.NumberType.BIG_DECIMAL) {
            object2 = this._delegateDeserializer();
            if (object2 != null && !this._valueInstantiator.canCreateFromBigDecimal()) {
                object = this._valueInstantiator.createUsingDelegate(deserializationContext, ((JsonDeserializer)object2).deserialize((JsonParser)object, deserializationContext));
                if (this._injectables != null) {
                    this.injectValues(deserializationContext, object);
                }
                return object;
            }
            return this._valueInstantiator.createFromBigDecimal(deserializationContext, ((JsonParser)object).getDecimalValue());
        }
        return deserializationContext.handleMissingInstantiator(((JsonDeserializer)this).handledType(), ((StdDeserializer)this).getValueInstantiator(), (JsonParser)object, "no suitable creator method found to deserialize from Number value (%s)", ((JsonParser)object).getNumberValue());
    }

    public Object deserializeFromBoolean(JsonParser object, DeserializationContext deserializationContext) {
        JsonDeserializer<Object> jsonDeserializer = this._delegateDeserializer();
        if (jsonDeserializer != null && !this._valueInstantiator.canCreateFromBoolean()) {
            object = this._valueInstantiator.createUsingDelegate(deserializationContext, jsonDeserializer.deserialize((JsonParser)object, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        boolean bl2 = ((JsonParser)object).currentToken() == JsonToken.VALUE_TRUE;
        return this._valueInstantiator.createFromBoolean(deserializationContext, bl2);
    }

    @Deprecated
    public Object deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this._deserializeFromArray(jsonParser, deserializationContext);
    }

    public Object deserializeFromEmbedded(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId(jsonParser, deserializationContext);
        }
        Object object = this._delegateDeserializer();
        if (object != null && !this._valueInstantiator.canCreateFromString()) {
            object = this._valueInstantiator.createUsingDelegate(deserializationContext, ((JsonDeserializer)object).deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        object = jsonParser.getEmbeddedObject();
        if (object != null && !this._beanType.isTypeOrSuperTypeOf(object.getClass())) {
            object = deserializationContext.handleWeirdNativeValue(this._beanType, object, jsonParser);
        }
        return object;
    }

    protected final JsonDeserializer<Object> _delegateDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = this._delegateDeserializer;
        if (jsonDeserializer == null) {
            jsonDeserializer = this._arrayDelegateDeserializer;
        }
        return jsonDeserializer;
    }

    protected void injectValues(DeserializationContext deserializationContext, Object object) {
        ValueInjector[] valueInjectorArray = this._injectables;
        int n2 = this._injectables.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueInjector valueInjector = valueInjectorArray[i2];
            valueInjector.inject(deserializationContext, object);
        }
    }

    protected Object handleUnknownProperties(DeserializationContext deserializationContext, Object object, TokenBuffer closeable) {
        ((JsonGenerator)closeable).writeEndObject();
        closeable = ((TokenBuffer)closeable).asParser();
        while (((JsonParser)closeable).nextToken() != JsonToken.END_OBJECT) {
            String string = ((JsonParser)closeable).currentName();
            ((JsonParser)closeable).nextToken();
            this.handleUnknownProperty((JsonParser)closeable, deserializationContext, object, string);
        }
        return object;
    }

    protected void handleUnknownVanilla(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        if (IgnorePropertiesUtil.shouldIgnore(string, this._ignorableProps, this._includableProps)) {
            this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
            return;
        }
        if (this._anySetter != null) {
            try {
                this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                return;
            }
            catch (Exception exception) {
                this.wrapAndThrow(exception, object, string, deserializationContext);
                return;
            }
        }
        this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
    }

    @Override
    protected void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        if (this._ignoreAllUnknown) {
            jsonParser.skipChildren();
            return;
        }
        if (IgnorePropertiesUtil.shouldIgnore(string, this._ignorableProps, this._includableProps)) {
            this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
        }
        super.handleUnknownProperty(jsonParser, deserializationContext, object, string);
    }

    protected void handleIgnoredProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES)) {
            throw IgnoredPropertyException.from(jsonParser, object, string, ((JsonDeserializer)this).getKnownPropertyNames());
        }
        jsonParser.skipChildren();
    }

    @Deprecated
    protected Object handlePolymorphic(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) {
        StreamReadConstraints streamReadConstraints = jsonParser == null ? StreamReadConstraints.defaults() : jsonParser.streamReadConstraints();
        return this.handlePolymorphic(jsonParser, deserializationContext, streamReadConstraints, object, tokenBuffer);
    }

    protected Object handlePolymorphic(JsonParser jsonParser, DeserializationContext deserializationContext, StreamReadConstraints object, Object object2, TokenBuffer tokenBuffer) {
        JsonDeserializer<Object> jsonDeserializer = this._findSubclassDeserializer(deserializationContext, object2, tokenBuffer);
        if (jsonDeserializer != null) {
            if (tokenBuffer != null) {
                ((JsonGenerator)tokenBuffer).writeEndObject();
                object = tokenBuffer.asParser((StreamReadConstraints)object);
                ((JsonParser)object).nextToken();
                object2 = jsonDeserializer.deserialize((JsonParser)object, deserializationContext, object2);
            }
            if (jsonParser != null) {
                object2 = jsonDeserializer.deserialize(jsonParser, deserializationContext, object2);
            }
            return object2;
        }
        if (tokenBuffer != null) {
            object2 = this.handleUnknownProperties(deserializationContext, object2, tokenBuffer);
        }
        if (jsonParser != null) {
            object2 = this.deserialize(jsonParser, deserializationContext, object2);
        }
        return object2;
    }

    protected JsonDeserializer<Object> _findSubclassDeserializer(DeserializationContext serializable, Object object, TokenBuffer jsonDeserializer) {
        Serializable serializable2 = this;
        synchronized (serializable2) {
            jsonDeserializer = this._subDeserializers == null ? null : this._subDeserializers.get(new ClassKey(object.getClass()));
        }
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        serializable2 = serializable.constructType(object.getClass());
        jsonDeserializer = serializable.findRootValueDeserializer((JavaType)serializable2);
        if (jsonDeserializer != null) {
            serializable = this;
            synchronized (serializable) {
                if (this._subDeserializers == null) {
                    this._subDeserializers = new HashMap();
                }
                this._subDeserializers.put(new ClassKey(object.getClass()), jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    public <T> T wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) {
        boolean bl2;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        boolean bl3 = bl2 = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl2 || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl2) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    protected <T> T wrapInstantiationProblem(Throwable throwable, DeserializationContext deserializationContext) {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (deserializationContext == null) {
            throw new IllegalArgumentException(throwable.getMessage(), throwable);
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(throwable);
        }
        return (T)deserializationContext.handleInstantiationProblem(((ResolvedType)this._beanType).getRawClass(), null, throwable);
    }
}

