/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BasicDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.ErrorThrowingDeserializer;
import com.fasterxml.jackson.databind.deser.impl.FieldProperty;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.deser.impl.SetterlessProperty;
import com.fasterxml.jackson.databind.deser.impl.UnsupportedTypeDeserializer;
import com.fasterxml.jackson.databind.deser.std.ThrowableDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.SubTypeValidator;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanDeserializerFactory
extends BasicDeserializerFactory
implements Serializable {
    private static final Class<?>[] a = new Class[]{Throwable.class};
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory(new DeserializerFactoryConfig());

    public BeanDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        super(deserializerFactoryConfig);
    }

    @Override
    public DeserializerFactory withConfig(DeserializerFactoryConfig deserializerFactoryConfig) {
        if (this._factoryConfig == deserializerFactoryConfig) {
            return this;
        }
        ClassUtil.verifyMustOverride(BeanDeserializerFactory.class, this, "withConfig");
        return new BeanDeserializerFactory(deserializerFactoryConfig);
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationContext deserializationContext, JavaType serializable2, BeanDescription beanDescription) {
        JavaType javaType;
        BeanDescription beanDescription2;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JsonDeserializer<Object> jsonDeserializer = this._findCustomBeanDeserializer((JavaType)serializable2, deserializationConfig, beanDescription2);
        if (jsonDeserializer != null) {
            if (this._factoryConfig.hasDeserializerModifiers()) {
                for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                    jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationContext.getConfig(), beanDescription2, jsonDeserializer);
                }
            }
            return jsonDeserializer;
        }
        if (((ResolvedType)((Object)serializable2)).isThrowable()) {
            return this.buildThrowableDeserializer(deserializationContext, (JavaType)serializable2, beanDescription2);
        }
        if (((ResolvedType)((Object)serializable2)).isAbstract() && !((ResolvedType)((Object)serializable2)).isPrimitive() && !((ResolvedType)((Object)serializable2)).isEnumType() && (javaType = this.materializeAbstractType(deserializationContext, (JavaType)serializable2, beanDescription2)) != null) {
            beanDescription2 = deserializationConfig.introspect(javaType);
            return this.buildBeanDeserializer(deserializationContext, javaType, beanDescription2);
        }
        jsonDeserializer = this.findStdDeserializer(deserializationContext, (JavaType)serializable2, beanDescription2);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        if (!this.isPotentialBeanType(((ResolvedType)((Object)serializable2)).getRawClass())) {
            return null;
        }
        this._validateSubType(deserializationContext, (JavaType)serializable2, beanDescription2);
        jsonDeserializer = this._findUnsupportedTypeDeserializer(deserializationContext, (JavaType)serializable2, beanDescription2);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return this.buildBeanDeserializer(deserializationContext, (JavaType)serializable2, beanDescription2);
    }

    @Override
    public JsonDeserializer<Object> createBuilderBasedDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription, Class<?> type) {
        type = ((DatabindContext)deserializationContext).isEnabled(MapperFeature.INFER_BUILDER_TYPE_BINDINGS) ? ((DatabindContext)deserializationContext).getTypeFactory().constructParametricType((Class<?>)type, javaType.getBindings()) : deserializationContext.constructType((Class<?>)type);
        beanDescription = deserializationContext.getConfig().introspectForBuilder((JavaType)type, beanDescription);
        return this.buildBuilderBasedDeserializer(deserializationContext, javaType, beanDescription);
    }

    protected JsonDeserializer<?> findStdDeserializer(DeserializationContext deserializationContext, JavaType jsonDeserializer, BeanDescription beanDescription) {
        if ((jsonDeserializer = this.findDefaultDeserializer(deserializationContext, (JavaType)((Object)jsonDeserializer), beanDescription)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationContext.getConfig(), beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> _findUnsupportedTypeDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription object) {
        object = BeanUtil.checkUnsupportedType(javaType);
        if (object != null && deserializationContext.getConfig().findMixInClassFor(((ResolvedType)javaType).getRawClass()) == null) {
            return new UnsupportedTypeDeserializer(javaType, (String)object);
        }
        return null;
    }

    protected JavaType materializeAbstractType(DeserializationContext deserializationContext, JavaType object, BeanDescription beanDescription) {
        for (AbstractTypeResolver abstractTypeResolver : this._factoryConfig.abstractTypeResolvers()) {
            JavaType object2 = abstractTypeResolver.resolveAbstractType(deserializationContext.getConfig(), beanDescription);
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationContext serializable, JavaType serializable22, BeanDescription beanDescription) {
        ValueInstantiator valueInstantiator;
        void var3_5;
        try {
            valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)serializable, (BeanDescription)var3_5);
        }
        catch (NoClassDefFoundError beanDeserializerBuilder) {
            return new ErrorThrowingDeserializer(beanDeserializerBuilder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw InvalidDefinitionException.from(((DeserializationContext)serializable).getParser(), ClassUtil.exceptionMessage(illegalArgumentException), (BeanDescription)var3_5, null).withCause(illegalArgumentException);
        }
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder((DeserializationContext)serializable, (BeanDescription)var3_5);
        beanDeserializerBuilder.setValueInstantiator(valueInstantiator);
        this.addBeanProps((DeserializationContext)serializable, (BeanDescription)var3_5, beanDeserializerBuilder);
        this.addObjectIdReader((DeserializationContext)serializable, (BeanDescription)var3_5, beanDeserializerBuilder);
        this.addBackReferenceProperties((DeserializationContext)serializable, (BeanDescription)var3_5, beanDeserializerBuilder);
        this.addInjectables((DeserializationContext)serializable, (BeanDescription)var3_5, beanDeserializerBuilder);
        serializable = ((DeserializationContext)serializable).getConfig();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                beanDeserializerBuilder = beanDeserializerModifier.updateBuilder((DeserializationConfig)serializable, (BeanDescription)var3_5, beanDeserializerBuilder);
            }
        }
        JsonDeserializer jsonDeserializer = ((ResolvedType)((Object)serializable22)).isAbstract() && !valueInstantiator.canInstantiate() ? beanDeserializerBuilder.buildAbstract() : beanDeserializerBuilder.build();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer((DeserializationConfig)serializable, (BeanDescription)var3_5, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - void declaration
     */
    protected JsonDeserializer<Object> buildBuilderBasedDeserializer(DeserializationContext jsonDeserializer, JavaType serializable2, BeanDescription beanDescription) {
        Object object;
        void var3_5;
        try {
            object = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)((Object)jsonDeserializer), (BeanDescription)var3_5);
        }
        catch (NoClassDefFoundError deserializationConfig) {
            return new ErrorThrowingDeserializer(deserializationConfig);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw InvalidDefinitionException.from(((DeserializationContext)((Object)jsonDeserializer)).getParser(), ClassUtil.exceptionMessage(illegalArgumentException), (BeanDescription)var3_5, null);
        }
        DeserializationConfig deserializationConfig = ((DeserializationContext)((Object)jsonDeserializer)).getConfig();
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder((DeserializationContext)((Object)jsonDeserializer), (BeanDescription)var3_5);
        beanDeserializerBuilder.setValueInstantiator((ValueInstantiator)object);
        this.addBeanProps((DeserializationContext)((Object)jsonDeserializer), (BeanDescription)var3_5, beanDeserializerBuilder);
        this.addObjectIdReader((DeserializationContext)((Object)jsonDeserializer), (BeanDescription)var3_5, beanDeserializerBuilder);
        this.addBackReferenceProperties((DeserializationContext)((Object)jsonDeserializer), (BeanDescription)var3_5, beanDeserializerBuilder);
        this.addInjectables((DeserializationContext)((Object)jsonDeserializer), (BeanDescription)var3_5, beanDeserializerBuilder);
        jsonDeserializer = var3_5.findPOJOBuilderConfig();
        object = jsonDeserializer == null ? "build" : ((JsonPOJOBuilder.Value)((Object)jsonDeserializer)).buildMethodName;
        AnnotatedMethod annotatedMethod = var3_5.findMethod((String)object, null);
        if (annotatedMethod != null && deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        beanDeserializerBuilder.setPOJOBuilder(annotatedMethod, (JsonPOJOBuilder.Value)((Object)jsonDeserializer));
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                beanDeserializerBuilder = beanDeserializerModifier.updateBuilder(deserializationConfig, (BeanDescription)var3_5, beanDeserializerBuilder);
            }
        }
        jsonDeserializer = beanDeserializerBuilder.buildBuilderBased((JavaType)serializable2, (String)object);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationConfig, (BeanDescription)var3_5, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected void addObjectIdReader(DeserializationContext deserializationContext, BeanDescription objectIdGenerator, BeanDeserializerBuilder beanDeserializerBuilder) {
        SettableBeanProperty settableBeanProperty;
        Object object;
        ObjectIdInfo objectIdInfo = ((BeanDescription)((Object)objectIdGenerator)).getObjectIdInfo();
        if (objectIdInfo == null) {
            return;
        }
        Type type = objectIdInfo.getGeneratorType();
        ObjectIdResolver objectIdResolver = deserializationContext.objectIdResolverInstance(((BeanDescription)((Object)objectIdGenerator)).getClassInfo(), objectIdInfo);
        if (type == ObjectIdGenerators.PropertyGenerator.class) {
            object = objectIdInfo.getPropertyName();
            settableBeanProperty = beanDeserializerBuilder.findProperty((PropertyName)object);
            if (settableBeanProperty == null) {
                throw new IllegalArgumentException(String.format("Invalid Object Id definition for %s: cannot find property with name %s", ClassUtil.getTypeDescription(((BeanDescription)((Object)objectIdGenerator)).getType()), ClassUtil.name((PropertyName)object)));
            }
            type = settableBeanProperty.getType();
            objectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo.getScope());
        } else {
            object = deserializationContext.constructType((Class<?>)type);
            type = ((DatabindContext)deserializationContext).getTypeFactory().findTypeParameters((JavaType)object, ObjectIdGenerator.class)[0];
            settableBeanProperty = null;
            objectIdGenerator = deserializationContext.objectIdGeneratorInstance(((BeanDescription)((Object)objectIdGenerator)).getClassInfo(), objectIdInfo);
        }
        object = deserializationContext.findRootValueDeserializer((JavaType)type);
        beanDeserializerBuilder.setObjectIdReader(ObjectIdReader.construct(type, objectIdInfo.getPropertyName(), objectIdGenerator, object, settableBeanProperty, objectIdResolver));
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationContext deserializationContext, JavaType serializable, BeanDescription beanDescription) {
        Object object;
        Serializable serializable2;
        serializable = deserializationContext.getConfig();
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder(deserializationContext, beanDescription);
        beanDeserializerBuilder.setValueInstantiator(((DeserializerFactory)this).findValueInstantiator(deserializationContext, beanDescription));
        this.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        JsonDeserializer<?> jsonDeserializer = beanDeserializerBuilder.getProperties();
        while (jsonDeserializer.hasNext()) {
            serializable2 = jsonDeserializer.next();
            if (!"setCause".equals(((SettableBeanProperty)serializable2).getMember().getName())) continue;
            jsonDeserializer.remove();
            break;
        }
        if ((serializable2 = beanDescription.findMethod("initCause", a)) != null) {
            SimpleBeanPropertyDefinition object2;
            jsonDeserializer = "cause";
            object = ((MapperConfig)serializable).getPropertyNamingStrategy();
            if (object != null) {
                jsonDeserializer = ((PropertyNamingStrategy)object).nameForSetterMethod((MapperConfig<?>)serializable, (AnnotatedMethod)serializable2, "cause");
            }
            if ((jsonDeserializer = this.constructSettableProperty(deserializationContext, beanDescription, object2 = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), (AnnotatedMember)serializable2, new PropertyName((String)((Object)jsonDeserializer))), ((AnnotatedWithParams)serializable2).getParameterType(0))) != null) {
                beanDeserializerBuilder.addOrReplaceProperty((SettableBeanProperty)((Object)jsonDeserializer), true);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            jsonDeserializer = this._factoryConfig.deserializerModifiers().iterator();
            while (jsonDeserializer.hasNext()) {
                object = (BeanDeserializerModifier)jsonDeserializer.next();
                beanDeserializerBuilder = ((BeanDeserializerModifier)object).updateBuilder((DeserializationConfig)serializable, beanDescription, beanDeserializerBuilder);
            }
        }
        if ((jsonDeserializer = beanDeserializerBuilder.build()) instanceof BeanDeserializer) {
            jsonDeserializer = ThrowableDeserializer.construct(deserializationContext, (BeanDeserializer)jsonDeserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer((DeserializationConfig)serializable, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        return new BeanDeserializerBuilder(beanDescription, deserializationContext);
    }

    /*
     * WARNING - void declaration
     */
    protected void addBeanProps(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
        void var6_10;
        Set<String> set;
        boolean bl2 = !((ResolvedType)beanDescription.getType()).isAbstract();
        SettableBeanProperty[] settableBeanPropertyArray = bl2 ? beanDeserializerBuilder.getValueInstantiator().getFromObjectArguments(deserializationContext.getConfig()) : null;
        boolean bl3 = settableBeanPropertyArray != null;
        JsonIgnoreProperties.Value object22 = ((MapperConfig)deserializationContext.getConfig()).getDefaultPropertyIgnorals(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        if (object22 != null) {
            boolean bl4 = object22.getIgnoreUnknown();
            beanDeserializerBuilder.setIgnoreUnknownProperties(bl4);
            Set<String> set2 = object22.findIgnoredForDeserialization();
            for (String string : set2) {
                beanDeserializerBuilder.addIgnorable(string);
            }
        } else {
            Set set3 = Collections.emptySet();
        }
        Object object = ((MapperConfig)deserializationContext.getConfig()).getDefaultPropertyInclusions(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        Object object2 = null;
        if (object != null && (object2 = ((JsonIncludeProperties.Value)object).getIncluded()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                set = (String)object.next();
                beanDeserializerBuilder.addIncludable((String)((Object)set));
            }
        }
        if ((object = beanDescription.findAnySetterAccessor()) != null) {
            beanDeserializerBuilder.setAnySetter(this.constructAnySetter(deserializationContext, beanDescription, (AnnotatedMember)object));
        } else {
            set = beanDescription.getIgnoredPropertyNames();
            if (set != null) {
                for (String string : set) {
                    beanDeserializerBuilder.addIgnorable(string);
                }
            }
        }
        boolean bl5 = ((DatabindContext)deserializationContext).isEnabled(MapperFeature.USE_GETTERS_AS_SETTERS) && ((DatabindContext)deserializationContext).isEnabled(MapperFeature.AUTO_DETECT_GETTERS);
        object = this.filterBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder, beanDescription.findProperties(), (Set<String>)var6_10, (Set<String>)object2);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                object = beanDeserializerModifier.updateProperties(deserializationContext.getConfig(), beanDescription, (List<BeanPropertyDefinition>)object);
            }
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            BeanPropertyDefinition beanPropertyDefinition = (BeanPropertyDefinition)iterator.next();
            object = null;
            if (beanPropertyDefinition.hasSetter()) {
                object2 = beanPropertyDefinition.getSetter();
                serializable = object2.getParameterType(0);
                object = this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition, (JavaType)serializable);
            } else if (beanPropertyDefinition.hasField()) {
                object2 = beanPropertyDefinition.getField();
                serializable = object2.getType();
                object = this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition, (JavaType)serializable);
            } else {
                object2 = beanPropertyDefinition.getGetter();
                if (object2 != null) {
                    if (bl5 && (Collection.class.isAssignableFrom((Class<?>)(object2 = object2.getRawType())) || Map.class.isAssignableFrom((Class<?>)object2))) {
                        if (!beanDeserializerBuilder.hasIgnorable(beanPropertyDefinition.getName())) {
                            object = this.constructSetterlessProperty(deserializationContext, beanDescription, beanPropertyDefinition);
                        }
                    } else if (!beanPropertyDefinition.hasConstructorParameter() && ((PropertyMetadata)(serializable = beanPropertyDefinition.getMetadata())).getMergeInfo() != null) {
                        object = this.constructSetterlessProperty(deserializationContext, beanDescription, beanPropertyDefinition);
                    }
                }
            }
            if (bl3 && beanPropertyDefinition.hasConstructorParameter()) {
                int n2;
                object2 = beanPropertyDefinition.getName();
                serializable = null;
                Object object3 = settableBeanPropertyArray;
                int n3 = settableBeanPropertyArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    SettableBeanProperty settableBeanProperty = object3[n2];
                    if (!object2.equals(settableBeanProperty.getName()) || !(settableBeanProperty instanceof CreatorProperty)) continue;
                    serializable = (CreatorProperty)settableBeanProperty;
                    break;
                }
                if (serializable == null) {
                    object3 = new ArrayList();
                    SettableBeanProperty[] settableBeanPropertyArray2 = settableBeanPropertyArray;
                    n2 = settableBeanPropertyArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        object = settableBeanPropertyArray2[i2];
                        object3.add(((SettableBeanProperty)object).getName());
                    }
                    deserializationContext.reportBadPropertyDefinition(beanDescription, beanPropertyDefinition, "Could not find creator property with name %s (known Creator properties: %s)", ClassUtil.name(object2), object3);
                    continue;
                }
                if (object != null) {
                    ((CreatorProperty)serializable).setFallbackSetter((SettableBeanProperty)object);
                }
                if ((object3 = beanPropertyDefinition.findViews()) == null) {
                    object3 = beanDescription.findDefaultViews();
                }
                ((SettableBeanProperty)serializable).setViews((Class<?>[])object3);
                beanDeserializerBuilder.addCreatorProperty((SettableBeanProperty)serializable);
                continue;
            }
            if (object == null) continue;
            object2 = beanPropertyDefinition.findViews();
            if (object2 == null) {
                object2 = beanDescription.findDefaultViews();
            }
            ((SettableBeanProperty)object).setViews((Class<?>[])object2);
            beanDeserializerBuilder.addProperty((SettableBeanProperty)object);
        }
    }

    @Deprecated
    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder, List<BeanPropertyDefinition> list, Set<String> set) {
        return this.filterBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder, list, set, null);
    }

    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext deserializationContext, BeanDescription object, BeanDeserializerBuilder beanDeserializerBuilder, List<BeanPropertyDefinition> object2, Set<String> set, Set<String> set2) {
        object = new ArrayList(Math.max(4, object2.size()));
        HashMap hashMap = new HashMap();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Class<?> clazz;
            BeanPropertyDefinition beanPropertyDefinition = (BeanPropertyDefinition)object2.next();
            String string = beanPropertyDefinition.getName();
            if (IgnorePropertiesUtil.shouldIgnore(string, set, set2)) continue;
            if (!beanPropertyDefinition.hasConstructorParameter() && (clazz = beanPropertyDefinition.getRawPrimaryType()) != null && this.isIgnorableType(deserializationContext.getConfig(), beanPropertyDefinition, clazz, hashMap)) {
                beanDeserializerBuilder.addIgnorable(string);
                continue;
            }
            ((ArrayList)object).add(beanPropertyDefinition);
        }
        return object;
    }

    protected void addBackReferenceProperties(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
        List<BeanPropertyDefinition> list = beanDescription.findBackReferences();
        if (list != null) {
            for (BeanPropertyDefinition beanPropertyDefinition : list) {
                String string = beanPropertyDefinition.findReferenceName();
                BeanPropertyDefinition beanPropertyDefinition2 = beanPropertyDefinition;
                beanDeserializerBuilder.addBackReferenceProperty(string, this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition2, beanPropertyDefinition2.getPrimaryType()));
            }
        }
    }

    @Deprecated
    protected void addReferenceProperties(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
        this.addBackReferenceProperties(deserializationContext, beanDescription, beanDeserializerBuilder);
    }

    protected void addInjectables(DeserializationContext object, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
        object = beanDescription.findInjectables();
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                AnnotatedMember annotatedMember = (AnnotatedMember)entry.getValue();
                beanDeserializerBuilder.addInjectable(PropertyName.construct(annotatedMember.getName()), annotatedMember.getType(), beanDescription.getClassAnnotations(), annotatedMember, entry.getKey());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SettableAnyProperty constructAnySetter(DeserializationContext deserializationContext, BeanDescription object, AnnotatedMember annotatedMember) {
        Object object2;
        JavaType javaType;
        Object object3;
        Object object4;
        boolean bl2 = annotatedMember instanceof AnnotatedField;
        if (annotatedMember instanceof AnnotatedMethod) {
            object4 = (AnnotatedMethod)annotatedMember;
            object3 = ((AnnotatedWithParams)object4).getParameterType(0);
            javaType = ((AnnotatedWithParams)object4).getParameterType(1);
            javaType = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
            object = new BeanProperty.Std(PropertyName.construct(annotatedMember.getName()), javaType, null, annotatedMember, PropertyMetadata.STD_OPTIONAL);
        } else {
            if (!bl2) return (SettableAnyProperty)((DatabindContext)deserializationContext).reportBadDefinition(((BeanDescription)object).getType(), String.format("Unrecognized mutator type for any-setter: %s", ClassUtil.nameOf(annotatedMember.getClass())));
            object4 = (AnnotatedField)annotatedMember;
            object2 = ((Annotated)object4).getType();
            if (((ResolvedType)object2).isMapLikeType()) {
                object2 = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, (JavaType)object2);
                object3 = ((JavaType)object2).getKeyType();
                javaType = ((JavaType)object2).getContentType();
                object = new BeanProperty.Std(PropertyName.construct(annotatedMember.getName()), (JavaType)object2, null, annotatedMember, PropertyMetadata.STD_OPTIONAL);
            } else {
                if (!((ResolvedType)object2).hasRawClass(JsonNode.class) && !((ResolvedType)object2).hasRawClass(ObjectNode.class)) return (SettableAnyProperty)((DatabindContext)deserializationContext).reportBadDefinition(((BeanDescription)object).getType(), String.format("Unsupported type for any-setter: %s -- only support `Map`s, `JsonNode` and `ObjectNode` ", ClassUtil.getTypeDescription((JavaType)object2)));
                object2 = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, (JavaType)object2);
                JavaType javaType2 = deserializationContext.constructType(JsonNode.class);
                object = new BeanProperty.Std(PropertyName.construct(annotatedMember.getName()), (JavaType)object2, null, annotatedMember, PropertyMetadata.STD_OPTIONAL);
                return SettableAnyProperty.constructForJsonNodeField(deserializationContext, (BeanProperty)object, annotatedMember, javaType2, deserializationContext.findRootValueDeserializer(javaType2));
            }
        }
        object4 = this.findKeyDeserializerFromAnnotation(deserializationContext, annotatedMember);
        if (object4 == null) {
            object4 = (KeyDeserializer)((JavaType)object3).getValueHandler();
        }
        if (object4 == null) {
            object4 = deserializationContext.findKeyDeserializer((JavaType)object3, (BeanProperty)object);
        } else if (object4 instanceof ContextualKeyDeserializer) {
            object4 = ((ContextualKeyDeserializer)object4).createContextual(deserializationContext, (BeanProperty)object);
        }
        object2 = this.findContentDeserializerFromAnnotation(deserializationContext, annotatedMember);
        if (object2 == null) {
            object2 = (JsonDeserializer)javaType.getValueHandler();
        }
        if (object2 != null) {
            object2 = deserializationContext.handlePrimaryContextualization((JsonDeserializer<?>)object2, (BeanProperty)object, javaType);
        }
        object3 = (TypeDeserializer)javaType.getTypeHandler();
        if (!bl2) return SettableAnyProperty.constructForMethod(deserializationContext, (BeanProperty)object, annotatedMember, javaType, (KeyDeserializer)object4, object2, (TypeDeserializer)object3);
        return SettableAnyProperty.constructForMapField(deserializationContext, (BeanProperty)object, annotatedMember, javaType, (KeyDeserializer)object4, object2, (TypeDeserializer)object3);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationContext object, BeanDescription object2, BeanPropertyDefinition beanPropertyDefinition, JavaType javaType) {
        Object object3 = beanPropertyDefinition.getNonConstructorMutator();
        if (object3 == null) {
            ((DeserializationContext)object).reportBadPropertyDefinition((BeanDescription)object2, beanPropertyDefinition, "No non-constructor mutator available", new Object[0]);
        }
        javaType = this.resolveMemberAndTypeAnnotations((DeserializationContext)object, (AnnotatedMember)object3, javaType);
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        object2 = object3 instanceof AnnotatedMethod ? new MethodProperty(beanPropertyDefinition, javaType, typeDeserializer, ((BeanDescription)object2).getClassAnnotations(), (AnnotatedMethod)object3) : new FieldProperty(beanPropertyDefinition, javaType, typeDeserializer, ((BeanDescription)object2).getClassAnnotations(), (AnnotatedField)object3);
        if ((object3 = this.findDeserializerFromAnnotation((DeserializationContext)object, (Annotated)object3)) == null) {
            object3 = (JsonDeserializer)javaType.getValueHandler();
        }
        if (object3 != null) {
            object3 = ((DeserializationContext)object).handlePrimaryContextualization((JsonDeserializer<?>)object3, (BeanProperty)object2, javaType);
            object2 = ((SettableBeanProperty)object2).withValueDeserializer((JsonDeserializer<?>)object3);
        }
        if ((object = beanPropertyDefinition.findReferenceType()) != null && ((AnnotationIntrospector.ReferenceProperty)object).isManagedReference()) {
            ((SettableBeanProperty)object2).setManagedReferenceName(((AnnotationIntrospector.ReferenceProperty)object).getName());
        }
        if ((object = beanPropertyDefinition.findObjectIdInfo()) != null) {
            ((SettableBeanProperty)object2).setObjectIdInfo((ObjectIdInfo)object);
        }
        return object2;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationContext deserializationContext, BeanDescription object, BeanPropertyDefinition jsonDeserializer) {
        AnnotatedMethod annotatedMethod;
        AnnotatedMethod annotatedMethod2 = annotatedMethod = ((BeanPropertyDefinition)((Object)jsonDeserializer)).getGetter();
        JavaType javaType = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMethod2, ((Annotated)annotatedMethod2).getType());
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        object = new SetterlessProperty((BeanPropertyDefinition)((Object)jsonDeserializer), javaType, typeDeserializer, ((BeanDescription)object).getClassAnnotations(), annotatedMethod);
        jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedMethod);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer)javaType.getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, (BeanProperty)object, javaType);
            object = ((SettableBeanProperty)object).withValueDeserializer(jsonDeserializer);
        }
        return object;
    }

    protected boolean isPotentialBeanType(Class<?> clazz) {
        String string = ClassUtil.canBeABeanType(clazz);
        if (string != null) {
            throw new IllegalArgumentException("Cannot deserialize Class " + clazz.getName() + " (of type " + string + ") as a Bean");
        }
        if (ClassUtil.isProxyType(clazz)) {
            throw new IllegalArgumentException("Cannot deserialize Proxy class " + clazz.getName() + " as a Bean");
        }
        string = ClassUtil.isLocalType(clazz, true);
        if (string != null) {
            throw new IllegalArgumentException("Cannot deserialize Class " + clazz.getName() + " (of type " + string + ") as a Bean");
        }
        return true;
    }

    protected boolean isIgnorableType(DeserializationConfig deserializationConfig, BeanPropertyDefinition object, Class<?> clazz, Map<Class<?>, Boolean> map) {
        object = map.get(clazz);
        if (object != null) {
            return (Boolean)object;
        }
        if (clazz == String.class || clazz.isPrimitive()) {
            object = Boolean.FALSE;
        } else {
            object = ((MapperConfig)deserializationConfig).getConfigOverride(clazz).getIsIgnoredType();
            if (object == null) {
                object = deserializationConfig.introspectClassAnnotations(clazz);
                object = deserializationConfig.getAnnotationIntrospector().isIgnorableType(((BeanDescription)object).getClassInfo());
                if (object == null) {
                    object = Boolean.FALSE;
                }
            }
        }
        map.put(clazz, (Boolean)object);
        return (Boolean)object;
    }

    protected void _validateSubType(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        SubTypeValidator.instance().validateSubType(deserializationContext, javaType, beanDescription);
    }
}

