/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.LookupCache;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class DeserializerCache
implements Serializable {
    public static final int DEFAULT_MAX_CACHE_SIZE = 2000;
    protected final LookupCache<JavaType, JsonDeserializer<Object>> _cachedDeserializers;
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);
    private final ReentrantLock a = new ReentrantLock();

    public DeserializerCache() {
        this(2000);
    }

    public DeserializerCache(int n2) {
        this(new LRUMap<JavaType, JsonDeserializer<Object>>(Math.min(64, n2 >> 2), n2));
    }

    public DeserializerCache(LookupCache<JavaType, JsonDeserializer<Object>> lookupCache) {
        this._cachedDeserializers = lookupCache;
    }

    public final DeserializerCache emptyCopy() {
        return new DeserializerCache(this._cachedDeserializers.emptyCopy());
    }

    public final int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public final void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    public final JsonDeserializer<Object> findValueDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType);
        if (jsonDeserializer == null && (jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType)) == null) {
            jsonDeserializer = this._handleUnknownValueDeserializer(deserializationContext, javaType);
        }
        return jsonDeserializer;
    }

    public final KeyDeserializer findKeyDeserializer(DeserializationContext deserializationContext, DeserializerFactory object, JavaType javaType) {
        if ((object = ((DeserializerFactory)object).createKeyDeserializer(deserializationContext, javaType)) == null) {
            return this._handleUnknownKeyDeserializer(deserializationContext, javaType);
        }
        if (object instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)object).resolve(deserializationContext);
        }
        return object;
    }

    public final boolean hasValueDeserializerFor(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType);
        if (jsonDeserializer == null) {
            jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType);
        }
        return jsonDeserializer != null;
    }

    protected final JsonDeserializer<Object> _findCachedDeserializer(JavaType javaType) {
        if (javaType == null) {
            throw new IllegalArgumentException("Null JavaType passed");
        }
        if (DeserializerCache.a(javaType)) {
            return null;
        }
        return this._cachedDeserializers.get(javaType);
    }

    protected final JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext jsonDeserializer, DeserializerFactory deserializerFactory, JavaType javaType) {
        this.a.lock();
        try {
            JsonDeserializer<Object> jsonDeserializer2 = this._findCachedDeserializer(javaType);
            if (jsonDeserializer2 != null) {
                JsonDeserializer<Object> jsonDeserializer3 = jsonDeserializer2;
                return jsonDeserializer3;
            }
            int n2 = this._incompleteDeserializers.size();
            if (n2 > 0 && (jsonDeserializer2 = this._incompleteDeserializers.get(javaType)) != null) {
                jsonDeserializer = jsonDeserializer2;
                return jsonDeserializer;
            }
            try {
                jsonDeserializer = this._createAndCache2((DeserializationContext)((Object)jsonDeserializer), deserializerFactory, javaType);
                if (n2 == 0 && this._incompleteDeserializers.size() > 0) {
                    this._incompleteDeserializers.clear();
                }
                return jsonDeserializer;
            }
            catch (Throwable throwable) {
                if (n2 == 0 && this._incompleteDeserializers.size() > 0) {
                    this._incompleteDeserializers.clear();
                }
                throw throwable;
            }
        }
        finally {
            this.a.unlock();
        }
    }

    protected final JsonDeserializer<Object> _createAndCache2(DeserializationContext deserializationContext, DeserializerFactory object, JavaType javaType) {
        boolean bl2;
        try {
            object = this._createDeserializer(deserializationContext, (DeserializerFactory)object, javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ((DatabindContext)deserializationContext).reportBadDefinition(javaType, ClassUtil.exceptionMessage(illegalArgumentException));
            object = null;
        }
        if (object == null) {
            return null;
        }
        boolean bl3 = bl2 = !DeserializerCache.a(javaType) && ((JsonDeserializer)object).isCachable();
        if (object instanceof ResolvableDeserializer) {
            this._incompleteDeserializers.put(javaType, (JsonDeserializer<Object>)object);
            try {
                ((ResolvableDeserializer)object).resolve(deserializationContext);
            }
            finally {
                this._incompleteDeserializers.remove(javaType);
            }
        }
        if (bl2) {
            this._cachedDeserializers.put(javaType, (JsonDeserializer<Object>)object);
        }
        return object;
    }

    protected final JsonDeserializer<Object> _createDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType object) {
        Object object2;
        BeanDescription beanDescription;
        Converter<Object, Object> converter;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (((ResolvedType)object).isAbstract() || ((ResolvedType)object).isMapLikeType() || ((ResolvedType)object).isCollectionLikeType()) {
            object = deserializerFactory.mapAbstractType(deserializationConfig, (JavaType)object);
        }
        if ((converter = this.findDeserializerFromAnnotation(deserializationContext, (beanDescription = deserializationConfig.introspect((JavaType)object)).getClassInfo())) != null) {
            return converter;
        }
        JavaType javaType = object;
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        Serializable serializable = deserializationContext;
        converter = this;
        converter = ((DatabindContext)((Object)serializable)).getAnnotationIntrospector();
        if (converter == null) {
            object2 = javaType;
        } else {
            JsonDeserializer<Object> jsonDeserializer;
            Object object3;
            if (((ResolvedType)javaType).isMapLikeType() && (object3 = javaType.getKeyType()) != null && ((JavaType)object3).getValueHandler() == null && (object3 = ((AnnotationIntrospector)((Object)converter)).findKeyDeserializer(annotatedClass)) != null && (jsonDeserializer = ((DeserializationContext)serializable).keyDeserializerInstance(annotatedClass, object3)) != null) {
                javaType = ((MapLikeType)javaType).withKeyValueHandler(jsonDeserializer);
            }
            if ((object3 = javaType.getContentType()) != null && ((JavaType)object3).getValueHandler() == null && (object3 = ((AnnotationIntrospector)((Object)converter)).findContentDeserializer(annotatedClass)) != null) {
                jsonDeserializer = null;
                if (object3 instanceof JsonDeserializer) {
                    jsonDeserializer = (JsonDeserializer)object3;
                } else {
                    Object object4;
                    Class<JsonDeserializer.None> clazz = JsonDeserializer.None.class;
                    String string = "findContentDeserializer";
                    if (object3 == null) {
                        object4 = null;
                    } else {
                        if (!(object3 instanceof Class)) {
                            throw new IllegalStateException("AnnotationIntrospector." + string + "() returned value of type " + object3.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
                        }
                        object4 = object3 = (object3 = (Class)object3) == clazz || ClassUtil.isBogusClass(object3) ? null : object3;
                    }
                    if (object4 != null) {
                        jsonDeserializer = ((DeserializationContext)serializable).deserializerInstance(annotatedClass, object3);
                    }
                }
                if (jsonDeserializer != null) {
                    javaType = javaType.withContentValueHandler(jsonDeserializer);
                }
            }
            object2 = converter = (javaType = ((AnnotationIntrospector)((Object)converter)).refineDeserializationType(((DeserializationContext)serializable).getConfig(), annotatedClass, javaType));
        }
        if (object2 != object) {
            object = converter;
            beanDescription = deserializationConfig.introspect((JavaType)((Object)converter));
        }
        if ((converter = beanDescription.findPOJOBuilder()) != null) {
            return deserializerFactory.createBuilderBasedDeserializer(deserializationContext, (JavaType)object, beanDescription, (Class<?>)((Object)converter));
        }
        converter = beanDescription.findDeserializationConverter();
        if (converter != null) {
            serializable = converter.getInputType(((DatabindContext)deserializationContext).getTypeFactory());
            if (!((ResolvedType)((Object)serializable)).hasRawClass(((ResolvedType)object).getRawClass())) {
                beanDescription = deserializationConfig.introspect((JavaType)serializable);
            }
            return new StdDelegatingDeserializer<Object>(converter, (JavaType)serializable, this._createDeserializer2(deserializationContext, deserializerFactory, (JavaType)serializable, beanDescription));
        }
        return this._createDeserializer2(deserializationContext, deserializerFactory, (JavaType)object, beanDescription);
    }

    protected final JsonDeserializer<?> _createDeserializer2(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (((ResolvedType)javaType).isEnumType()) {
            return deserializerFactory.createEnumDeserializer(deserializationContext, javaType, beanDescription);
        }
        if (((ResolvedType)javaType).isContainerType()) {
            JsonFormat.Value value;
            if (((ResolvedType)javaType).isArrayType()) {
                return deserializerFactory.createArrayDeserializer(deserializationContext, (ArrayType)javaType, beanDescription);
            }
            if (((ResolvedType)javaType).isMapLikeType() && (value = beanDescription.findExpectedFormat()).getShape() != JsonFormat.Shape.OBJECT) {
                if ((javaType = (MapLikeType)javaType) instanceof MapType) {
                    return deserializerFactory.createMapDeserializer(deserializationContext, (MapType)javaType, beanDescription);
                }
                return deserializerFactory.createMapLikeDeserializer(deserializationContext, (MapLikeType)javaType, beanDescription);
            }
            if (((ResolvedType)javaType).isCollectionLikeType() && (value = beanDescription.findExpectedFormat()).getShape() != JsonFormat.Shape.OBJECT) {
                if ((javaType = (CollectionLikeType)javaType) instanceof CollectionType) {
                    return deserializerFactory.createCollectionDeserializer(deserializationContext, (CollectionType)javaType, beanDescription);
                }
                return deserializerFactory.createCollectionLikeDeserializer(deserializationContext, (CollectionLikeType)javaType, beanDescription);
            }
        }
        if (javaType.isReferenceType()) {
            return deserializerFactory.createReferenceDeserializer(deserializationContext, (ReferenceType)javaType, beanDescription);
        }
        if (JsonNode.class.isAssignableFrom(((ResolvedType)javaType).getRawClass())) {
            return deserializerFactory.createTreeDeserializer(deserializationConfig, javaType, beanDescription);
        }
        return deserializerFactory.createBeanDeserializer(deserializationContext, javaType, beanDescription);
    }

    protected final JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        JsonDeserializer<Object> jsonDeserializer = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findDeserializer(annotated);
        if (jsonDeserializer == null) {
            return null;
        }
        jsonDeserializer = deserializationContext.deserializerInstance(annotated, jsonDeserializer);
        return this.findConvertingDeserializer(deserializationContext, annotated, jsonDeserializer);
    }

    protected final JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext serializable, Annotated object, JsonDeserializer<Object> jsonDeserializer) {
        if ((object = this.findConverter((DeserializationContext)serializable, (Annotated)object)) == null) {
            return jsonDeserializer;
        }
        serializable = object.getInputType(((DatabindContext)((Object)serializable)).getTypeFactory());
        return new StdDelegatingDeserializer<Object>((Converter<Object, Object>)object, (JavaType)serializable, jsonDeserializer);
    }

    protected final Converter<Object, Object> findConverter(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findDeserializationConverter(annotated);
        if (object == null) {
            return null;
        }
        return deserializationContext.converterInstance(annotated, object);
    }

    private static boolean a(JavaType javaType) {
        if (((ResolvedType)javaType).isContainerType()) {
            JavaType javaType2 = javaType.getContentType();
            if (javaType2 != null && (javaType2.getValueHandler() != null || javaType2.getTypeHandler() != null)) {
                return true;
            }
            if (((ResolvedType)javaType).isMapLikeType() && (javaType = javaType.getKeyType()).getValueHandler() != null) {
                return true;
            }
        }
        return false;
    }

    protected final JsonDeserializer<Object> _handleUnknownValueDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        if (!ClassUtil.isConcrete(clazz)) {
            return (JsonDeserializer)((DatabindContext)deserializationContext).reportBadDefinition(javaType, "Cannot find a Value deserializer for abstract type " + javaType);
        }
        return (JsonDeserializer)((DatabindContext)deserializationContext).reportBadDefinition(javaType, "Cannot find a Value deserializer for type " + javaType);
    }

    protected final KeyDeserializer _handleUnknownKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        return (KeyDeserializer)((DatabindContext)deserializationContext).reportBadDefinition(javaType, "Cannot find a (Map) Key deserializer for type " + javaType);
    }
}

