/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;

public class BeanPropertyMap
implements Serializable,
Iterable<SettableBeanProperty> {
    protected final boolean _caseInsensitive;
    private int a;
    private int b;
    private int c;
    private Object[] d;
    private final SettableBeanProperty[] e;
    private final Map<String, List<PropertyName>> f;
    private final Map<String, String> g;
    private final Locale h;

    public BeanPropertyMap(boolean bl2, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map, Locale locale) {
        Map map2;
        this._caseInsensitive = bl2;
        Collection<SettableBeanProperty> collection2 = collection;
        this.e = collection2.toArray(new SettableBeanProperty[collection2.size()]);
        this.f = map;
        this.h = locale;
        boolean bl3 = bl2;
        Map<String, List<PropertyName>> map3 = map;
        if (map3 == null || map3.isEmpty()) {
            map2 = Collections.emptyMap();
        } else {
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            for (Map.Entry entry : map3.entrySet()) {
                String string = (String)entry.getKey();
                if (bl3) {
                    string = string.toLowerCase(locale);
                }
                for (Object object : (List)entry.getValue()) {
                    object = ((PropertyName)object).getSimpleName();
                    if (bl3) {
                        object = ((String)object).toLowerCase(locale);
                    }
                    hashMap.put(object, string);
                }
            }
            map2 = hashMap;
        }
        this.g = map2;
        this.init(collection);
    }

    @Deprecated
    public BeanPropertyMap(boolean bl2, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map) {
        this(bl2, collection, map, Locale.getDefault());
    }

    private BeanPropertyMap(BeanPropertyMap beanPropertyMap, SettableBeanProperty settableBeanProperty, int n2, int n3) {
        this._caseInsensitive = beanPropertyMap._caseInsensitive;
        this.h = beanPropertyMap.h;
        this.a = beanPropertyMap.a;
        this.b = beanPropertyMap.b;
        this.c = beanPropertyMap.c;
        this.f = beanPropertyMap.f;
        this.g = beanPropertyMap.g;
        this.d = Arrays.copyOf(beanPropertyMap.d, beanPropertyMap.d.length);
        this.e = Arrays.copyOf(beanPropertyMap.e, beanPropertyMap.e.length);
        this.d[n2] = settableBeanProperty;
        this.e[n3] = settableBeanProperty;
    }

    private BeanPropertyMap(BeanPropertyMap beanPropertyMap, SettableBeanProperty settableBeanProperty, String string, int n2) {
        this._caseInsensitive = beanPropertyMap._caseInsensitive;
        this.h = beanPropertyMap.h;
        this.a = beanPropertyMap.a;
        this.b = beanPropertyMap.b;
        this.c = beanPropertyMap.c;
        this.f = beanPropertyMap.f;
        this.g = beanPropertyMap.g;
        this.d = Arrays.copyOf(beanPropertyMap.d, beanPropertyMap.d.length);
        int n3 = beanPropertyMap.e.length;
        this.e = Arrays.copyOf(beanPropertyMap.e, n3 + 1);
        this.e[n3] = settableBeanProperty;
        int n4 = this.a + 1;
        n3 = n2 << 1;
        if (this.d[n3] != null && this.d[n3 = n4 + (n2 >> 1) << 1] != null) {
            int n5 = n4;
            n3 = (n5 + (n5 >> 1) << 1) + this.c;
            this.c += 2;
            if (n3 >= this.d.length) {
                this.d = Arrays.copyOf(this.d, this.d.length + 4);
            }
        }
        this.d[n3] = string;
        this.d[n3 + 1] = settableBeanProperty;
    }

    protected BeanPropertyMap(BeanPropertyMap beanPropertyMap, boolean bl2) {
        this._caseInsensitive = bl2;
        this.h = beanPropertyMap.h;
        this.f = beanPropertyMap.f;
        this.g = beanPropertyMap.g;
        this.e = Arrays.copyOf(beanPropertyMap.e, beanPropertyMap.e.length);
        BeanPropertyMap beanPropertyMap2 = this;
        beanPropertyMap2.init(Arrays.asList(beanPropertyMap2.e));
    }

    public BeanPropertyMap withCaseInsensitivity(boolean bl2) {
        if (this._caseInsensitive == bl2) {
            return this;
        }
        return new BeanPropertyMap(this, bl2);
    }

    protected void init(Collection<SettableBeanProperty> object) {
        int n2;
        int n3;
        this.b = object.size();
        int n4 = this.b;
        if (n4 <= 5) {
            n3 = 8;
        } else if (n4 <= 12) {
            n3 = 16;
        } else {
            int n5 = n4;
            n4 = n5 + (n5 >> 2);
            n2 = 32;
            while (n2 < n4) {
                int n6 = n2;
                n2 = n6 + n6;
            }
            n3 = n2;
        }
        n4 = n3;
        this.a = n4 - 1;
        int n7 = n4;
        n2 = n7 + (n7 >> 1) << 1;
        Object[] objectArray = new Object[n2];
        int n8 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)object.next();
            if (settableBeanProperty == null) continue;
            String string = this.getPropertyName(settableBeanProperty);
            int n9 = this.b(string);
            int n10 = n9 << 1;
            if (objectArray[n10] != null && objectArray[n10 = n4 + (n9 >> 1) << 1] != null) {
                int n11 = n4;
                n10 = (n11 + (n11 >> 1) << 1) + n8;
                n8 += 2;
                if (n10 >= objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, objectArray.length + 4);
                }
            }
            objectArray[n10] = string;
            objectArray[n10 + 1] = settableBeanProperty;
        }
        this.d = objectArray;
        this.c = n8;
    }

    public static BeanPropertyMap construct(MapperConfig<?> mapperConfig, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map, boolean bl2) {
        return new BeanPropertyMap(bl2, collection, map, mapperConfig.getLocale());
    }

    @Deprecated
    public static BeanPropertyMap construct(MapperConfig<?> mapperConfig, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map) {
        return new BeanPropertyMap(mapperConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES), collection, map, mapperConfig.getLocale());
    }

    @Deprecated
    public static BeanPropertyMap construct(Collection<SettableBeanProperty> collection, boolean bl2, Map<String, List<PropertyName>> map) {
        return new BeanPropertyMap(bl2, collection, map);
    }

    public BeanPropertyMap withProperty(SettableBeanProperty settableBeanProperty) {
        int n2;
        String string = this.getPropertyName(settableBeanProperty);
        int n3 = this.d.length;
        for (n2 = 1; n2 < n3; n2 += 2) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this.d[n2];
            if (settableBeanProperty2 == null || !settableBeanProperty2.getName().equals(string)) continue;
            return new BeanPropertyMap(this, settableBeanProperty, n2, this.a(settableBeanProperty2));
        }
        n2 = this.b(string);
        return new BeanPropertyMap(this, settableBeanProperty, string, n2);
    }

    public BeanPropertyMap assignIndexes() {
        int n2 = 0;
        int n3 = this.d.length;
        for (int i2 = 1; i2 < n3; i2 += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this.d[i2];
            if (settableBeanProperty == null) continue;
            settableBeanProperty.assignIndex(n2++);
        }
        return this;
    }

    public BeanPropertyMap renameAll(NameTransformer nameTransformer) {
        if (nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return this;
        }
        int n2 = this.e.length;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            SettableBeanProperty settableBeanProperty = this.e[i2];
            if (settableBeanProperty == null) {
                arrayList.add(settableBeanProperty);
                continue;
            }
            arrayList.add(this._rename(settableBeanProperty, nameTransformer));
        }
        return new BeanPropertyMap(this._caseInsensitive, arrayList, this.f, this.h);
    }

    public BeanPropertyMap withoutProperties(Collection<String> collection) {
        return this.withoutProperties(collection, null);
    }

    public BeanPropertyMap withoutProperties(Collection<String> collection, Collection<String> collection2) {
        if ((collection == null || collection.isEmpty()) && collection2 == null) {
            return this;
        }
        int n2 = this.e.length;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            SettableBeanProperty settableBeanProperty = this.e[i2];
            if (settableBeanProperty == null || IgnorePropertiesUtil.shouldIgnore(settableBeanProperty.getName(), collection, collection2)) continue;
            arrayList.add(settableBeanProperty);
        }
        return new BeanPropertyMap(this._caseInsensitive, arrayList, this.f, this.h);
    }

    public void replace(SettableBeanProperty settableBeanProperty, SettableBeanProperty settableBeanProperty2) {
        int n2 = 1;
        int n3 = this.d.length;
        while (true) {
            if (n2 >= n3) {
                throw new NoSuchElementException("No entry '" + settableBeanProperty.getName() + "' found, can't replace");
            }
            if (this.d[n2] == settableBeanProperty) break;
            n2 += 2;
        }
        this.d[n2] = settableBeanProperty2;
        this.e[this.a((SettableBeanProperty)settableBeanProperty)] = settableBeanProperty2;
    }

    public void remove(SettableBeanProperty settableBeanProperty) {
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(this.b);
        String string = this.getPropertyName(settableBeanProperty);
        boolean bl2 = false;
        int n2 = this.d.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this.d[i2];
            if (settableBeanProperty2 == null) continue;
            if (!bl2 && (bl2 = string.equals(this.d[i2 - 1]))) {
                this.e[this.a((SettableBeanProperty)settableBeanProperty2)] = null;
                continue;
            }
            arrayList.add(settableBeanProperty2);
        }
        if (!bl2) {
            throw new NoSuchElementException("No entry '" + settableBeanProperty.getName() + "' found, can't remove");
        }
        this.init(arrayList);
    }

    public int size() {
        return this.b;
    }

    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }

    public boolean hasAliases() {
        return !this.f.isEmpty();
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        BeanPropertyMap beanPropertyMap = this;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(beanPropertyMap.b);
        int n2 = beanPropertyMap.d.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)beanPropertyMap.d[i2];
            if (settableBeanProperty == null) continue;
            arrayList.add(settableBeanProperty);
        }
        return arrayList.iterator();
    }

    public SettableBeanProperty[] getPropertiesInInsertionOrder() {
        return this.e;
    }

    protected final String getPropertyName(SettableBeanProperty settableBeanProperty) {
        if (this._caseInsensitive) {
            return settableBeanProperty.getName().toLowerCase(this.h);
        }
        return settableBeanProperty.getName();
    }

    public SettableBeanProperty find(int n2) {
        int n3 = this.d.length;
        for (int i2 = 1; i2 < n3; i2 += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this.d[i2];
            if (settableBeanProperty == null || n2 != settableBeanProperty.getPropertyIndex()) continue;
            return settableBeanProperty;
        }
        return null;
    }

    public SettableBeanProperty find(String object) {
        int n2;
        int n3;
        Object object2;
        if (object == null) {
            throw new IllegalArgumentException("Cannot pass null property name");
        }
        if (this._caseInsensitive) {
            object = ((String)object).toLowerCase(this.h);
        }
        if ((object2 = this.d[n3 = (n2 = ((String)object).hashCode() & this.a) << 1]) == object || ((String)object).equals(object2)) {
            return (SettableBeanProperty)this.d[n3 + 1];
        }
        n3 = n2;
        String string = object;
        object = this;
        if (object2 != null) {
            int n4 = ((BeanPropertyMap)object).a + 1;
            object2 = ((BeanPropertyMap)object).d[n3 = n4 + (n3 >> 1) << 1];
            if (string.equals(object2)) {
                return (SettableBeanProperty)((BeanPropertyMap)object).d[n3 + 1];
            }
            if (object2 != null) {
                int n5 = n4;
                n4 = n3 + ((BeanPropertyMap)object).c;
                for (n3 = (v1168890) + ((v1168890) >> 1) << 1; n3 < n4; n3 += 2) {
                    object2 = ((BeanPropertyMap)object).d[n3];
                    if (object2 != string && !string.equals(object2)) continue;
                    return (SettableBeanProperty)((BeanPropertyMap)object).d[n3 + 1];
                }
            }
        }
        Object object3 = object;
        return super.a(((BeanPropertyMap)object3).g.get(string));
    }

    private SettableBeanProperty a(String string) {
        if (string == null) {
            return null;
        }
        int n2 = this.b(string);
        int n3 = n2 << 1;
        Object object = this.d[n3];
        if (string.equals(object)) {
            return (SettableBeanProperty)this.d[n3 + 1];
        }
        if (object == null) {
            return null;
        }
        return this.a(string, n2);
    }

    private SettableBeanProperty a(String string, int n2) {
        int n3 = this.a + 1;
        int n4 = n3 + (n2 >> 1) << 1;
        Object object = this.d[n4];
        if (string.equals(object)) {
            return (SettableBeanProperty)this.d[n4 + 1];
        }
        if (object != null) {
            int n5 = n3;
            n4 = n3 + this.c;
            for (n3 = (v1168992) + ((v1168992) >> 1) << 1; n3 < n4; n3 += 2) {
                object = this.d[n3];
                if (object != string && !string.equals(object)) continue;
                return (SettableBeanProperty)this.d[n3 + 1];
            }
        }
        return null;
    }

    public boolean findDeserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        SettableBeanProperty settableBeanProperty = this.find(string);
        if (settableBeanProperty == null) {
            return false;
        }
        try {
            settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
        }
        catch (Exception exception) {
            this.wrapAndThrow(exception, object, string, deserializationContext);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Properties=[");
        int n2 = 0;
        for (SettableBeanProperty settableBeanProperty : this) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(settableBeanProperty.getName());
            stringBuilder.append('(');
            stringBuilder.append(settableBeanProperty.getType());
            stringBuilder.append(')');
        }
        stringBuilder.append(']');
        if (!this.f.isEmpty()) {
            stringBuilder.append("(aliases: ");
            stringBuilder.append(this.f);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    protected SettableBeanProperty _rename(SettableBeanProperty settableBeanProperty, NameTransformer object) {
        if (settableBeanProperty == null) {
            return settableBeanProperty;
        }
        Object object2 = ((NameTransformer)object).transform(settableBeanProperty.getName());
        if ((object2 = (settableBeanProperty = settableBeanProperty.withSimpleName((String)object2)).getValueDeserializer()) != null && (object = ((JsonDeserializer)object2).unwrappingDeserializer((NameTransformer)object)) != object2) {
            settableBeanProperty = settableBeanProperty.withValueDeserializer((JsonDeserializer<?>)object);
        }
        return settableBeanProperty;
    }

    protected void wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) {
        boolean bl2;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        boolean bl3 = bl2 = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl2 || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl2) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    private final int a(SettableBeanProperty settableBeanProperty) {
        int n2 = this.e.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.e[i2] != settableBeanProperty) continue;
            return i2;
        }
        throw new IllegalStateException("Illegal state: property '" + settableBeanProperty.getName() + "' missing from _propsInOrder");
    }

    private final int b(String string) {
        return string.hashCode() & this.a;
    }
}

