/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.HashMap;

public class CreatorCollector {
    protected static final int C_DEFAULT = 0;
    protected static final int C_STRING = 1;
    protected static final int C_INT = 2;
    protected static final int C_LONG = 3;
    protected static final int C_BIG_INTEGER = 4;
    protected static final int C_DOUBLE = 5;
    protected static final int C_BIG_DECIMAL = 6;
    protected static final int C_BOOLEAN = 7;
    protected static final int C_DELEGATE = 8;
    protected static final int C_PROPS = 9;
    protected static final int C_ARRAY_DELEGATE = 10;
    protected static final String[] TYPE_DESCS = new String[]{"default", "from-String", "from-int", "from-long", "from-big-integer", "from-double", "from-big-decimal", "from-boolean", "delegate", "property-based", "array-delegate"};
    protected final BeanDescription _beanDesc;
    protected final boolean _canFixAccess;
    protected final boolean _forceAccess;
    protected final AnnotatedWithParams[] _creators = new AnnotatedWithParams[11];
    protected int _explicitCreators = 0;
    protected boolean _hasNonDefaultCreator = false;
    protected SettableBeanProperty[] _delegateArgs;
    protected SettableBeanProperty[] _arrayDelegateArgs;
    protected SettableBeanProperty[] _propertyBasedArgs;

    public CreatorCollector(BeanDescription beanDescription, MapperConfig<?> mapperConfig) {
        this._beanDesc = beanDescription;
        this._canFixAccess = mapperConfig.canOverrideAccessModifiers();
        this._forceAccess = mapperConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
    }

    public ValueInstantiator constructValueInstantiator(DeserializationContext serializable) {
        Serializable serializable2 = serializable.getConfig();
        JavaType javaType = this.a((DeserializationContext)serializable, this._creators[8], this._delegateArgs);
        serializable = this.a((DeserializationContext)serializable, this._creators[10], this._arrayDelegateArgs);
        JavaType javaType2 = this._beanDesc.getType();
        serializable2 = new StdValueInstantiator((DeserializationConfig)serializable2, javaType2);
        ((StdValueInstantiator)serializable2).configureFromObjectSettings(this._creators[0], this._creators[8], javaType, this._delegateArgs, this._creators[9], this._propertyBasedArgs);
        ((StdValueInstantiator)serializable2).configureFromArraySettings(this._creators[10], (JavaType)serializable, this._arrayDelegateArgs);
        ((StdValueInstantiator)serializable2).configureFromStringCreator(this._creators[1]);
        ((StdValueInstantiator)serializable2).configureFromIntCreator(this._creators[2]);
        ((StdValueInstantiator)serializable2).configureFromLongCreator(this._creators[3]);
        ((StdValueInstantiator)serializable2).configureFromBigIntegerCreator(this._creators[4]);
        ((StdValueInstantiator)serializable2).configureFromDoubleCreator(this._creators[5]);
        ((StdValueInstantiator)serializable2).configureFromBigDecimalCreator(this._creators[6]);
        ((StdValueInstantiator)serializable2).configureFromBooleanCreator(this._creators[7]);
        return serializable2;
    }

    public void setDefaultCreator(AnnotatedWithParams annotatedWithParams) {
        this._creators[0] = this.a(annotatedWithParams);
    }

    public void addStringCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 1, bl2);
    }

    public void addIntCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 2, bl2);
    }

    public void addLongCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 3, bl2);
    }

    public void addBigIntegerCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 4, bl2);
    }

    public void addDoubleCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 5, bl2);
    }

    public void addBigDecimalCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 6, bl2);
    }

    public void addBooleanCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 7, bl2);
    }

    public void addDelegatingCreator(AnnotatedWithParams annotatedWithParams, boolean bl2, SettableBeanProperty[] settableBeanPropertyArray, int n2) {
        if (((ResolvedType)annotatedWithParams.getParameterType(n2)).isCollectionLikeType()) {
            if (this.verifyNonDup(annotatedWithParams, 10, bl2)) {
                this._arrayDelegateArgs = settableBeanPropertyArray;
                return;
            }
        } else if (this.verifyNonDup(annotatedWithParams, 8, bl2)) {
            this._delegateArgs = settableBeanPropertyArray;
        }
    }

    public void addPropertyCreator(AnnotatedWithParams serializable, boolean n2, SettableBeanProperty[] settableBeanPropertyArray) {
        if (this.verifyNonDup((AnnotatedWithParams)serializable, 9, n2 != 0)) {
            if (settableBeanPropertyArray.length > 1) {
                serializable = new HashMap();
                int n3 = settableBeanPropertyArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Integer n4;
                    String string = settableBeanPropertyArray[n2].getName();
                    if (string.isEmpty() && settableBeanPropertyArray[n2].getInjectableValueId() != null || (n4 = ((HashMap)serializable).put(string, n2)) == null) continue;
                    throw new IllegalArgumentException(String.format("Duplicate creator property \"%s\" (index %s vs %d) for type %s ", string, n4, n2, ClassUtil.nameOf(this._beanDesc.getBeanClass())));
                }
            }
            this._propertyBasedArgs = settableBeanPropertyArray;
        }
    }

    public boolean hasDefaultCreator() {
        return this._creators[0] != null;
    }

    public boolean hasDelegatingCreator() {
        return this._creators[8] != null;
    }

    public boolean hasPropertyBasedCreator() {
        return this._creators[9] != null;
    }

    private JavaType a(DeserializationContext object, AnnotatedWithParams annotatedMember, SettableBeanProperty[] object2) {
        if (!this._hasNonDefaultCreator || annotatedMember == null) {
            return null;
        }
        int n2 = 0;
        if (object2 != null) {
            int n3 = ((SettableBeanProperty[])object2).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (object2[i2] != null) continue;
                n2 = i2;
                break;
            }
        }
        DeserializationConfig deserializationConfig = ((DeserializationContext)object).getConfig();
        JavaType javaType = annotatedMember.getParameterType(n2);
        object2 = deserializationConfig.getAnnotationIntrospector();
        if (object2 != null) {
            Object object3 = ((AnnotationIntrospector)object2).findDeserializer(annotatedMember = annotatedMember.getParameter(n2));
            if (object3 != null) {
                object = ((DeserializationContext)object).deserializerInstance(annotatedMember, object3);
                javaType = javaType.withValueHandler(object);
            } else {
                javaType = ((AnnotationIntrospector)object2).refineDeserializationType(deserializationConfig, annotatedMember, javaType);
            }
        }
        return javaType;
    }

    private <T extends AnnotatedMember> T a(T t2) {
        if (t2 != null && this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)t2.getAnnotated()), this._forceAccess);
        }
        return t2;
    }

    protected boolean verifyNonDup(AnnotatedWithParams annotatedWithParams, int n2, boolean bl2) {
        int n3 = 1 << n2;
        this._hasNonDefaultCreator = true;
        AnnotatedWithParams annotatedWithParams2 = this._creators[n2];
        if (annotatedWithParams2 != null) {
            boolean bl3;
            if ((this._explicitCreators & n3) != 0) {
                if (!bl2) {
                    return false;
                }
                bl3 = true;
            } else {
                boolean bl4;
                bl3 = bl4 = !bl2;
            }
            if (bl3 && annotatedWithParams2.getClass() == annotatedWithParams.getClass()) {
                Class<?> clazz;
                Class<?> clazz2 = annotatedWithParams2.getRawParameterType(0);
                if (clazz2 == (clazz = annotatedWithParams.getRawParameterType(0))) {
                    if (this._isEnumValueOf(annotatedWithParams)) {
                        return false;
                    }
                    if (!this._isEnumValueOf(annotatedWithParams2)) {
                        this._reportDuplicateCreator(n2, bl2, annotatedWithParams2, annotatedWithParams);
                    }
                } else {
                    if (clazz.isAssignableFrom(clazz2)) {
                        return false;
                    }
                    if (!clazz2.isAssignableFrom(clazz)) {
                        if (clazz2.isPrimitive() != clazz.isPrimitive()) {
                            if (clazz2.isPrimitive()) {
                                return false;
                            }
                        } else {
                            this._reportDuplicateCreator(n2, bl2, annotatedWithParams2, annotatedWithParams);
                        }
                    }
                }
            }
        }
        if (bl2) {
            this._explicitCreators |= n3;
        }
        this._creators[n2] = this.a(annotatedWithParams);
        return true;
    }

    protected void _reportDuplicateCreator(int n2, boolean bl2, AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2) {
        throw new IllegalArgumentException(String.format("Conflicting %s creators: already had %s creator %s, encountered another: %s", TYPE_DESCS[n2], bl2 ? "explicitly marked" : "implicitly discovered", annotatedWithParams, annotatedWithParams2));
    }

    protected boolean _isEnumValueOf(AnnotatedWithParams annotatedWithParams) {
        return ClassUtil.isEnumType(annotatedWithParams.getDeclaringClass()) && "valueOf".equals(annotatedWithParams.getName());
    }
}

