/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class MethodProperty
extends SettableBeanProperty {
    protected final AnnotatedMethod _annotated;
    protected final transient Method _setter;
    protected final boolean _skipNulls;

    public MethodProperty(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedMethod annotatedMethod) {
        super(beanPropertyDefinition, javaType, typeDeserializer, annotations);
        this._annotated = annotatedMethod;
        this._setter = annotatedMethod.getAnnotated();
        this._skipNulls = NullsConstantProvider.isSkipper(this._nullProvider);
    }

    protected MethodProperty(MethodProperty methodProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider) {
        super(methodProperty, jsonDeserializer, nullValueProvider);
        this._annotated = methodProperty._annotated;
        this._setter = methodProperty._setter;
        this._skipNulls = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    protected MethodProperty(MethodProperty methodProperty, PropertyName propertyName) {
        super(methodProperty, propertyName);
        this._annotated = methodProperty._annotated;
        this._setter = methodProperty._setter;
        this._skipNulls = methodProperty._skipNulls;
    }

    protected MethodProperty(MethodProperty methodProperty, Method method) {
        super(methodProperty);
        this._annotated = methodProperty._annotated;
        this._setter = method;
        this._skipNulls = methodProperty._skipNulls;
    }

    @Override
    public final SettableBeanProperty withName(PropertyName propertyName) {
        return new MethodProperty(this, propertyName);
    }

    @Override
    public final SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        if (this._valueDeserializer == jsonDeserializer) {
            return this;
        }
        NullValueProvider nullValueProvider = this._valueDeserializer == this._nullProvider ? jsonDeserializer : this._nullProvider;
        return new MethodProperty(this, jsonDeserializer, nullValueProvider);
    }

    @Override
    public final SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
        MethodProperty methodProperty = this;
        return new MethodProperty(methodProperty, methodProperty._valueDeserializer, nullValueProvider);
    }

    @Override
    public final void fixAccess(DeserializationConfig deserializationConfig) {
        this._annotated.fixAccess(deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    @Override
    public final <A extends Annotation> A getAnnotation(Class<A> clazz) {
        if (this._annotated == null) {
            return null;
        }
        return ((Annotated)this._annotated).getAnnotation(clazz);
    }

    @Override
    public final AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public final void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        Object object2;
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            object2 = this._nullProvider.getNullValue(deserializationContext);
        } else if (this._valueTypeDeserializer == null) {
            object2 = this._valueDeserializer.deserialize(jsonParser, deserializationContext);
            if (object2 == null) {
                if (this._skipNulls) {
                    return;
                }
                object2 = this._nullProvider.getNullValue(deserializationContext);
            }
        } else {
            object2 = this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        try {
            this._setter.invoke(object, object2);
            return;
        }
        catch (Exception exception) {
            this._throwAsIOE(jsonParser, exception, object2);
            return;
        }
    }

    @Override
    public final Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext object, Object object2) {
        Object object3;
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return object2;
            }
            object3 = this._nullProvider.getNullValue((DeserializationContext)object);
        } else if (this._valueTypeDeserializer == null) {
            object3 = this._valueDeserializer.deserialize(jsonParser, (DeserializationContext)object);
            if (object3 == null) {
                if (this._skipNulls) {
                    return object2;
                }
                object3 = this._nullProvider.getNullValue((DeserializationContext)object);
            }
        } else {
            object3 = this._valueDeserializer.deserializeWithType(jsonParser, (DeserializationContext)object, this._valueTypeDeserializer);
        }
        try {
            object = this._setter.invoke(object2, object3);
            if (object == null) {
                return object2;
            }
            return object;
        }
        catch (Exception exception) {
            this._throwAsIOE(jsonParser, exception, object3);
            return null;
        }
    }

    @Override
    public final void set(Object object, Object object2) {
        if (object2 == null && this._skipNulls) {
            return;
        }
        try {
            this._setter.invoke(object, object2);
            return;
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
            return;
        }
    }

    @Override
    public final Object setAndReturn(Object object, Object object2) {
        if (object2 == null && this._skipNulls) {
            return object;
        }
        try {
            Object object3 = this._setter.invoke(object, object2);
            if (object3 == null) {
                return object;
            }
            return object3;
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
            return null;
        }
    }
}

