/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class ReadableObjectId {
    protected Object _item;
    protected final ObjectIdGenerator.IdKey _key;
    protected LinkedList<Referring> _referringProperties;
    protected ObjectIdResolver _resolver;

    public ReadableObjectId(ObjectIdGenerator.IdKey idKey) {
        this._key = idKey;
    }

    public void setResolver(ObjectIdResolver objectIdResolver) {
        this._resolver = objectIdResolver;
    }

    public ObjectIdGenerator.IdKey getKey() {
        return this._key;
    }

    public void appendReferring(Referring referring) {
        if (this._referringProperties == null) {
            this._referringProperties = new LinkedList();
        }
        this._referringProperties.add(referring);
    }

    public void bindItem(Object object) {
        this._resolver.bindItem(this._key, object);
        this._item = object;
        Object object2 = this._key.key;
        if (this._referringProperties != null) {
            Iterator iterator = this._referringProperties.iterator();
            this._referringProperties = null;
            while (iterator.hasNext()) {
                ((Referring)iterator.next()).handleResolvedForwardReference(object2, object);
            }
        }
    }

    public Object resolve() {
        this._item = this._resolver.resolveId(this._key);
        return this._item;
    }

    public boolean hasReferringProperties() {
        return this._referringProperties != null && !this._referringProperties.isEmpty();
    }

    public Iterator<Referring> referringProperties() {
        if (this._referringProperties == null) {
            return Collections.emptyList().iterator();
        }
        return this._referringProperties.iterator();
    }

    public boolean tryToResolveUnresolved(DeserializationContext deserializationContext) {
        return false;
    }

    public ObjectIdResolver getResolver() {
        return this._resolver;
    }

    public String toString() {
        return String.valueOf(this._key);
    }

    public static abstract class Referring {
        private final UnresolvedForwardReference a;
        private final Class<?> b;

        public Referring(UnresolvedForwardReference unresolvedForwardReference, Class<?> clazz) {
            this.a = unresolvedForwardReference;
            this.b = clazz;
        }

        public Referring(UnresolvedForwardReference unresolvedForwardReference, JavaType javaType) {
            this.a = unresolvedForwardReference;
            this.b = ((ResolvedType)javaType).getRawClass();
        }

        public JsonLocation getLocation() {
            return ((JacksonException)this.a).getLocation();
        }

        public Class<?> getBeanType() {
            return this.b;
        }

        public abstract void handleResolvedForwardReference(Object var1, Object var2);

        public boolean hasId(Object object) {
            return object.equals(this.a.getUnresolvedId());
        }
    }
}

