/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.util.concurrent.atomic.AtomicBoolean;

public class AtomicBooleanDeserializer
extends StdScalarDeserializer<AtomicBoolean> {
    public AtomicBooleanDeserializer() {
        super(AtomicBoolean.class);
    }

    @Override
    public AtomicBoolean deserialize(JsonParser object, DeserializationContext deserializationContext) {
        JsonToken jsonToken = ((JsonParser)object).currentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return new AtomicBoolean(true);
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return new AtomicBoolean(false);
        }
        if ((object = this._parseBoolean((JsonParser)object, deserializationContext, AtomicBoolean.class)) == null) {
            return null;
        }
        return new AtomicBoolean((Boolean)object);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Boolean;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return new AtomicBoolean(false);
    }
}

