/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

public class DateDeserializers {
    private static final HashSet<String> a = new HashSet<String>();

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (a.contains(string)) {
            if (clazz == Calendar.class) {
                return new CalendarDeserializer();
            }
            if (clazz == java.util.Date.class) {
                return DateDeserializer.instance;
            }
            if (clazz == GregorianCalendar.class) {
                return new CalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class);
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> clazz) {
        return a.contains(clazz.getName());
    }

    static {
        a.add("java.util.Calendar");
        a.add("java.util.GregorianCalendar");
        a.add("java.util.Date");
    }

    public static class TimestampDeserializer
    extends DateBasedDeserializer<Timestamp> {
        public TimestampDeserializer() {
            super(Timestamp.class);
        }

        public TimestampDeserializer(TimestampDeserializer timestampDeserializer, DateFormat dateFormat, String string) {
            super(timestampDeserializer, dateFormat, string);
        }

        protected TimestampDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new TimestampDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return new Timestamp(0L);
        }

        @Override
        public Timestamp deserialize(JsonParser object, DeserializationContext deserializationContext) {
            if ((object = this._parseDate((JsonParser)object, deserializationContext)) == null) {
                return null;
            }
            return new Timestamp(((java.util.Date)object).getTime());
        }
    }

    public static class SqlDateDeserializer
    extends DateBasedDeserializer<Date> {
        public SqlDateDeserializer() {
            super(Date.class);
        }

        public SqlDateDeserializer(SqlDateDeserializer sqlDateDeserializer, DateFormat dateFormat, String string) {
            super(sqlDateDeserializer, dateFormat, string);
        }

        protected SqlDateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new SqlDateDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return new Date(0L);
        }

        @Override
        public Date deserialize(JsonParser object, DeserializationContext deserializationContext) {
            if ((object = this._parseDate((JsonParser)object, deserializationContext)) == null) {
                return null;
            }
            return new Date(((java.util.Date)object).getTime());
        }
    }

    @JacksonStdImpl
    public static class DateDeserializer
    extends DateBasedDeserializer<java.util.Date> {
        public static final DateDeserializer instance = new DateDeserializer();

        public DateDeserializer() {
            super(java.util.Date.class);
        }

        public DateDeserializer(DateDeserializer dateDeserializer, DateFormat dateFormat, String string) {
            super(dateDeserializer, dateFormat, string);
        }

        protected DateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new DateDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return new java.util.Date(0L);
        }

        @Override
        public java.util.Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this._parseDate(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class CalendarDeserializer
    extends DateBasedDeserializer<Calendar> {
        protected final Constructor<Calendar> _defaultCtor;

        public CalendarDeserializer() {
            super(Calendar.class);
            this._defaultCtor = null;
        }

        public CalendarDeserializer(Class<? extends Calendar> clazz) {
            super(clazz);
            this._defaultCtor = ClassUtil.findConstructor(clazz, false);
        }

        public CalendarDeserializer(CalendarDeserializer calendarDeserializer, DateFormat dateFormat, String string) {
            super(calendarDeserializer, dateFormat, string);
            this._defaultCtor = calendarDeserializer._defaultCtor;
        }

        protected CalendarDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new CalendarDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext serializable) {
            serializable = new GregorianCalendar();
            ((Calendar)serializable).setTimeInMillis(0L);
            return serializable;
        }

        @Override
        public Calendar deserialize(JsonParser object, DeserializationContext deserializationContext) {
            if ((object = this._parseDate((JsonParser)object, deserializationContext)) == null) {
                return null;
            }
            if (this._defaultCtor == null) {
                return deserializationContext.constructCalendar((java.util.Date)object);
            }
            try {
                Calendar calendar = this._defaultCtor.newInstance(new Object[0]);
                calendar.setTimeInMillis(((java.util.Date)object).getTime());
                TimeZone timeZone = ((DatabindContext)deserializationContext).getTimeZone();
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                }
                return calendar;
            }
            catch (Exception exception) {
                return (Calendar)deserializationContext.handleInstantiationProblem(((JsonDeserializer)this).handledType(), object, exception);
            }
        }
    }

    protected static abstract class DateBasedDeserializer<T>
    extends StdScalarDeserializer<T>
    implements ContextualDeserializer {
        protected final DateFormat _customFormat;
        protected final String _formatString;

        protected DateBasedDeserializer(Class<?> clazz) {
            super(clazz);
            this._customFormat = null;
            this._formatString = null;
        }

        protected DateBasedDeserializer(DateBasedDeserializer<T> dateBasedDeserializer, DateFormat dateFormat, String string) {
            super(dateBasedDeserializer._valueClass);
            this._customFormat = dateFormat;
            this._formatString = string;
        }

        protected abstract DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

        @Override
        public LogicalType logicalType() {
            return LogicalType.DateTime;
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty object) {
            if ((object = this.findFormatOverrides(deserializationContext, (BeanProperty)object, ((JsonDeserializer)this).handledType())) != null) {
                TimeZone timeZone = ((JsonFormat.Value)object).getTimeZone();
                Boolean bl2 = ((JsonFormat.Value)object).getLenient();
                if (((JsonFormat.Value)object).hasPattern()) {
                    String string = ((JsonFormat.Value)object).getPattern();
                    object = ((JsonFormat.Value)object).hasLocale() ? ((JsonFormat.Value)object).getLocale() : ((DatabindContext)deserializationContext).getLocale();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, (Locale)object);
                    if (timeZone == null) {
                        timeZone = ((DatabindContext)deserializationContext).getTimeZone();
                    }
                    simpleDateFormat.setTimeZone(timeZone);
                    if (bl2 != null) {
                        simpleDateFormat.setLenient(bl2);
                    }
                    return this.withDateFormat(simpleDateFormat, string);
                }
                if (timeZone != null) {
                    DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                    if (dateFormat.getClass() == StdDateFormat.class) {
                        object = ((JsonFormat.Value)object).hasLocale() ? ((JsonFormat.Value)object).getLocale() : ((DatabindContext)deserializationContext).getLocale();
                        StdDateFormat stdDateFormat = (StdDateFormat)dateFormat;
                        stdDateFormat = stdDateFormat.withTimeZone(timeZone);
                        stdDateFormat = stdDateFormat.withLocale((Locale)object);
                        if (bl2 != null) {
                            stdDateFormat = stdDateFormat.withLenient(bl2);
                        }
                        dateFormat = stdDateFormat;
                    } else {
                        dateFormat = (DateFormat)dateFormat.clone();
                        dateFormat.setTimeZone(timeZone);
                        if (bl2 != null) {
                            dateFormat.setLenient(bl2);
                        }
                    }
                    return this.withDateFormat(dateFormat, this._formatString);
                }
                if (bl2 != null) {
                    DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                    object = this._formatString;
                    if (dateFormat.getClass() == StdDateFormat.class) {
                        StdDateFormat stdDateFormat = (StdDateFormat)dateFormat;
                        stdDateFormat = stdDateFormat.withLenient(bl2);
                        dateFormat = stdDateFormat;
                        object = stdDateFormat.toPattern();
                    } else {
                        dateFormat = (DateFormat)dateFormat.clone();
                        dateFormat.setLenient(bl2);
                        if (dateFormat instanceof SimpleDateFormat) {
                            ((SimpleDateFormat)dateFormat).toPattern();
                        }
                    }
                    if (object == null) {
                        object = "[unknown]";
                    }
                    return this.withDateFormat(dateFormat, (String)object);
                }
            }
            return this;
        }

        @Override
        protected java.util.Date _parseDate(JsonParser object, DeserializationContext deserializationContext) {
            if (this._customFormat != null && ((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
                if (((String)(object = ((JsonParser)object).getText().trim())).isEmpty()) {
                    CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
                    switch (coercionAction) {
                        case AsEmpty: {
                            return new java.util.Date(0L);
                        }
                    }
                    return null;
                }
                DateFormat dateFormat = this._customFormat;
                synchronized (dateFormat) {
                    try {
                        return this._customFormat.parse((String)object);
                    }
                    catch (ParseException parseException) {
                        return (java.util.Date)deserializationContext.handleWeirdStringValue(((JsonDeserializer)this).handledType(), (String)object, "expected format \"%s\"", this._formatString);
                    }
                }
            }
            return super._parseDate((JsonParser)object, deserializationContext);
        }
    }
}

