/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import java.util.EnumSet;
import java.util.Objects;

public class EnumSetDeserializer
extends StdDeserializer<EnumSet<?>>
implements ContextualDeserializer {
    protected final JavaType _enumType;
    protected JsonDeserializer<Enum<?>> _enumDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final NullValueProvider _nullProvider;
    protected final boolean _skipNullValues;
    protected final Boolean _unwrapSingle;

    public EnumSetDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(EnumSet.class);
        this._enumType = javaType;
        if (!((ResolvedType)javaType).isEnumType()) {
            throw new IllegalArgumentException("Type " + javaType + " not Java Enum type");
        }
        this._enumDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._unwrapSingle = null;
        this._nullProvider = null;
        this._skipNullValues = false;
    }

    @Deprecated
    public EnumSetDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        this(javaType, jsonDeserializer, null);
    }

    @Deprecated
    protected EnumSetDeserializer(EnumSetDeserializer enumSetDeserializer, JsonDeserializer<?> jsonDeserializer, Boolean bl2) {
        this(enumSetDeserializer, jsonDeserializer, enumSetDeserializer._nullProvider, bl2);
    }

    protected EnumSetDeserializer(EnumSetDeserializer enumSetDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        super(enumSetDeserializer);
        this._enumType = enumSetDeserializer._enumType;
        this._enumDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = enumSetDeserializer._valueTypeDeserializer;
        this._nullProvider = nullValueProvider;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
        this._unwrapSingle = bl2;
    }

    public EnumSetDeserializer withDeserializer(JsonDeserializer<?> jsonDeserializer) {
        if (this._enumDeserializer == jsonDeserializer) {
            return this;
        }
        return new EnumSetDeserializer(this, jsonDeserializer, this._nullProvider, this._unwrapSingle);
    }

    public EnumSetDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        if (Objects.equals(this._unwrapSingle, bl2) && this._enumDeserializer == jsonDeserializer && this._valueTypeDeserializer == typeDeserializer && this._nullProvider == jsonDeserializer) {
            return this;
        }
        return new EnumSetDeserializer(this, jsonDeserializer, nullValueProvider, bl2);
    }

    @Deprecated
    public EnumSetDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        return this.withResolved(jsonDeserializer, this._valueTypeDeserializer, nullValueProvider, bl2);
    }

    @Override
    public boolean isCachable() {
        return this._enumType.getValueHandler() == null && this._valueTypeDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return this.a();
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        Boolean bl2 = this.findFormatFeature(deserializationContext, beanProperty, EnumSet.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        JsonDeserializer<Object> jsonDeserializer = this._enumDeserializer;
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer(this._enumType, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, this._enumType);
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        return this.withResolved(jsonDeserializer, typeDeserializer, this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer), bl2);
    }

    @Override
    public EnumSet<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        EnumSet enumSet = this.a();
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, enumSet);
        }
        return this._deserialize(jsonParser, deserializationContext, enumSet);
    }

    @Override
    public EnumSet<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, EnumSet<?> enumSet) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, enumSet);
        }
        return this._deserialize(jsonParser, deserializationContext, enumSet);
    }

    protected final EnumSet<?> _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, EnumSet enumSet) {
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        try {
            Enum enum_;
            while ((enum_ = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (enum_ == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    enum_ = (Enum)this._nullProvider.getNullValue(deserializationContext);
                } else {
                    enum_ = typeDeserializer == null ? this._enumDeserializer.deserialize(jsonParser, deserializationContext) : (Enum)this._enumDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                }
                if (enum_ == null) continue;
                enumSet.add(enum_);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            EnumSet enumSet2 = enumSet;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)enumSet2, enumSet2.size());
        }
        return enumSet;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    private EnumSet a() {
        return EnumSet.noneOf(((ResolvedType)this._enumType).getRawClass());
    }

    protected EnumSet<?> handleNonArray(JsonParser enum_, DeserializationContext deserializationContext, EnumSet enumSet) {
        boolean bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl2) {
            return (EnumSet)deserializationContext.handleUnexpectedToken(EnumSet.class, (JsonParser)((Object)enum_));
        }
        if (((JsonParser)((Object)enum_)).hasToken(JsonToken.VALUE_NULL)) {
            return (EnumSet)deserializationContext.handleUnexpectedToken(this._enumType, (JsonParser)((Object)enum_));
        }
        try {
            enum_ = this._enumDeserializer.deserialize((JsonParser)((Object)enum_), deserializationContext);
            if (enum_ != null) {
                enumSet.add(enum_);
            }
        }
        catch (Exception exception) {
            enum_ = exception;
            EnumSet enumSet2 = enumSet;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)enumSet2, enumSet2.size());
        }
        return enumSet;
    }
}

