/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    public static Class<?>[] types() {
        return new Class[]{File.class, URL.class, URI.class, Class.class, JavaType.class, Currency.class, Pattern.class, Locale.class, Charset.class, TimeZone.class, InetAddress.class, InetSocketAddress.class, StringBuilder.class, StringBuffer.class};
    }

    protected FromStringDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public static FromStringDeserializer<?> findDeserializer(Class<?> clazz) {
        int n2;
        if (clazz == File.class) {
            n2 = 1;
        } else if (clazz == URL.class) {
            n2 = 2;
        } else if (clazz == URI.class) {
            n2 = 3;
        } else if (clazz == Class.class) {
            n2 = 4;
        } else if (clazz == JavaType.class) {
            n2 = 5;
        } else if (clazz == Currency.class) {
            n2 = 6;
        } else if (clazz == Pattern.class) {
            n2 = 7;
        } else if (clazz == Locale.class) {
            n2 = 8;
        } else if (clazz == Charset.class) {
            n2 = 9;
        } else if (clazz == TimeZone.class) {
            n2 = 10;
        } else if (clazz == InetAddress.class) {
            n2 = 11;
        } else if (clazz == InetSocketAddress.class) {
            n2 = 12;
        } else {
            if (clazz == StringBuilder.class) {
                return new b();
            }
            if (clazz == StringBuffer.class) {
                return new a();
            }
            return null;
        }
        return new Std(clazz, n2);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public T deserialize(JsonParser object, DeserializationContext deserializationContext) {
        Object object2;
        String string = ((JsonParser)object).getValueAsString();
        if (string == null) {
            object2 = ((JsonParser)object).currentToken();
            if (object2 != JsonToken.START_OBJECT) {
                return (T)this._deserializeFromOther((JsonParser)object, deserializationContext, (JsonToken)((Object)object2));
            }
            FromStringDeserializer fromStringDeserializer = this;
            string = deserializationContext.extractScalarFromObject((JsonParser)object, fromStringDeserializer, fromStringDeserializer._valueClass);
        }
        if (string.isEmpty()) {
            return (T)this._deserializeFromEmptyString(deserializationContext);
        }
        if (this._shouldTrim()) {
            object2 = string;
            if ((string = string.trim()) != object2 && string.isEmpty()) {
                return (T)this._deserializeFromEmptyString(deserializationContext);
            }
        }
        try {
            return this._deserialize(string, deserializationContext);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            object = exception;
            object2 = exception;
            object = "not a valid textual representation";
            String string2 = ((Throwable)object2).getMessage();
            if (string2 != null) {
                object = (String)object + ", problem: " + string2;
            }
            throw deserializationContext.weirdStringException(string, this._valueClass, (String)object).withCause((Throwable)object2);
        }
    }

    protected abstract T _deserialize(String var1, DeserializationContext var2);

    protected boolean _shouldTrim() {
        return true;
    }

    protected Object _deserializeFromOther(JsonParser object, DeserializationContext deserializationContext, JsonToken jsonToken) {
        if (jsonToken == JsonToken.START_ARRAY) {
            return this._deserializeFromArray((JsonParser)object, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            if ((object = ((JsonParser)object).getEmbeddedObject()) == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(object.getClass())) {
                return object;
            }
            return this._deserializeEmbedded(object, deserializationContext);
        }
        return deserializationContext.handleUnexpectedToken(this._valueClass, (JsonParser)object);
    }

    protected T _deserializeEmbedded(Object object, DeserializationContext deserializationContext) {
        deserializationContext.reportInputMismatch(this, "Don't know how to convert embedded Object of type %s into %s", object.getClass().getName(), this._valueClass.getName());
        return null;
    }

    @Deprecated
    protected final T _deserializeFromEmptyString() {
        return null;
    }

    protected Object _deserializeFromEmptyString(DeserializationContext deserializationContext) {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(((JsonDeserializer)this).logicalType(), this._valueClass, CoercionInputShape.EmptyString);
        if (coercionAction == CoercionAction.Fail) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce empty String (\"\") to %s (but could if enabling coercion using `CoercionConfig`)", this._coercedTypeDesc());
        }
        if (coercionAction == CoercionAction.AsNull) {
            return this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return this.getEmptyValue(deserializationContext);
        }
        return this._deserializeFromEmptyStringDefault(deserializationContext);
    }

    protected Object _deserializeFromEmptyStringDefault(DeserializationContext deserializationContext) {
        return this.getNullValue(deserializationContext);
    }

    static final class a
    extends FromStringDeserializer<Object> {
        public a() {
            super(StringBuffer.class);
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Textual;
        }

        @Override
        public final Object getEmptyValue(DeserializationContext deserializationContext) {
            return new StringBuffer();
        }

        @Override
        public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            String string = jsonParser.getValueAsString();
            if (string != null) {
                return this._deserialize(string, deserializationContext);
            }
            return super.deserialize(jsonParser, deserializationContext);
        }

        @Override
        protected final Object _deserialize(String string, DeserializationContext deserializationContext) {
            return new StringBuffer(string);
        }
    }

    static final class b
    extends FromStringDeserializer<Object> {
        public b() {
            super(StringBuilder.class);
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Textual;
        }

        @Override
        public final Object getEmptyValue(DeserializationContext deserializationContext) {
            return new StringBuilder();
        }

        @Override
        public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            String string = jsonParser.getValueAsString();
            if (string != null) {
                return this._deserialize(string, deserializationContext);
            }
            return super.deserialize(jsonParser, deserializationContext);
        }

        @Override
        protected final Object _deserialize(String string, DeserializationContext deserializationContext) {
            return new StringBuilder(string);
        }
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        public static final int STD_FILE = 1;
        public static final int STD_URL = 2;
        public static final int STD_URI = 3;
        public static final int STD_CLASS = 4;
        public static final int STD_JAVA_TYPE = 5;
        public static final int STD_CURRENCY = 6;
        public static final int STD_PATTERN = 7;
        public static final int STD_LOCALE = 8;
        public static final int STD_CHARSET = 9;
        public static final int STD_TIME_ZONE = 10;
        public static final int STD_INET_ADDRESS = 11;
        public static final int STD_INET_SOCKET_ADDRESS = 12;
        protected static final String LOCALE_EXT_MARKER = "_#";
        protected final int _kind;

        protected Std(Class<?> clazz, int n2) {
            super(clazz);
            this._kind = n2;
        }

        @Override
        protected Object _deserialize(String object, DeserializationContext object2) {
            switch (this._kind) {
                case 1: {
                    return new File((String)object);
                }
                case 2: {
                    return new URL((String)object);
                }
                case 3: {
                    return URI.create((String)object);
                }
                case 4: {
                    try {
                        return ((DeserializationContext)object2).findClass((String)object);
                    }
                    catch (Exception exception) {
                        return ((DeserializationContext)object2).handleInstantiationProblem(this._valueClass, object, ClassUtil.getRootCause(exception));
                    }
                }
                case 5: {
                    return ((DatabindContext)object2).getTypeFactory().constructFromCanonical((String)object);
                }
                case 6: {
                    try {
                        return Currency.getInstance((String)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return ((DeserializationContext)object2).handleWeirdStringValue(this._valueClass, (String)object, "Unrecognized currency", new Object[0]);
                    }
                }
                case 7: {
                    try {
                        return Pattern.compile((String)object);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        return ((DeserializationContext)object2).handleWeirdStringValue(this._valueClass, (String)object, "Invalid Pattern, problem: " + patternSyntaxException.getDescription(), new Object[0]);
                    }
                }
                case 8: {
                    object2 = object;
                    object = this;
                    int n2 = ((Std)object)._firstHyphenOrUnderscore((String)object2);
                    if (n2 < 0) {
                        return new Locale((String)object2);
                    }
                    String string = ((String)object2).substring(0, n2);
                    if ((n2 = ((Std)object)._firstHyphenOrUnderscore((String)(object2 = ((String)object2).substring(n2 + 1)))) < 0) {
                        return new Locale(string, (String)object2);
                    }
                    object = ((String)object2).substring(0, n2);
                    int n3 = ((String)object2).indexOf(LOCALE_EXT_MARKER);
                    if (n3 < 0) {
                        return new Locale(string, (String)object, ((String)object2).substring(n2 + 1));
                    }
                    return Std.a((String)object2, n2, string, (String)object, n3);
                }
                case 9: {
                    return Charset.forName((String)object);
                }
                case 10: {
                    return TimeZone.getTimeZone((String)object);
                }
                case 11: {
                    return InetAddress.getByName((String)object);
                }
                case 12: {
                    if (((String)object).startsWith("[")) {
                        int n4 = ((String)object).lastIndexOf(93);
                        if (n4 == -1) {
                            throw new InvalidFormatException(((DeserializationContext)object2).getParser(), "Bracketed IPv6 address must contain closing bracket", object, InetSocketAddress.class);
                        }
                        int n5 = ((String)object).indexOf(58, n4);
                        n5 = n5 >= 0 ? Integer.parseInt(((String)object).substring(n5 + 1)) : 0;
                        return new InetSocketAddress(((String)object).substring(0, n4 + 1), n5);
                    }
                    int n6 = ((String)object).indexOf(58);
                    if (n6 >= 0 && ((String)object).indexOf(58, n6 + 1) < 0) {
                        int n7 = Integer.parseInt(((String)object).substring(n6 + 1));
                        return new InetSocketAddress(((String)object).substring(0, n6), n7);
                    }
                    return new InetSocketAddress((String)object, 0);
                }
            }
            VersionUtil.throwInternal();
            return null;
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            switch (this._kind) {
                case 3: {
                    return URI.create("");
                }
                case 8: {
                    return Locale.ROOT;
                }
            }
            return super.getEmptyValue(deserializationContext);
        }

        @Override
        protected Object _deserializeFromEmptyStringDefault(DeserializationContext deserializationContext) {
            return ((JsonDeserializer)this).getEmptyValue(deserializationContext);
        }

        @Override
        protected boolean _shouldTrim() {
            return this._kind != 7;
        }

        protected int _firstHyphenOrUnderscore(String string) {
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 != '_' && c2 != '-') continue;
                return i2;
            }
            return -1;
        }

        private static Locale a(String string, int n2, String string2, String string3, int n3) {
            String string4 = "";
            try {
                if (n3 > 0 && n3 > n2) {
                    string4 = string.substring(n2 + 1, n3);
                }
                if ((n2 = (string = string.substring(n3 + 2)).indexOf(95)) < 0) {
                    n3 = string.indexOf(45);
                    if (n3 < 0) {
                        return new Locale.Builder().setLanguage(string2).setRegion(string3).setVariant(string4).setScript(string).build();
                    }
                    return new Locale.Builder().setLanguage(string2).setRegion(string3).setVariant(string4).setExtension(string.charAt(0), string.substring(n3 + 1)).build();
                }
                n3 = string.length();
                Locale.Builder builder = new Locale.Builder().setLanguage(string2).setRegion(string3).setVariant(string4).setScript(string.substring(0, n2));
                if (n2 + 1 < n3) {
                    builder = builder.setExtension(string.charAt(n2 + 1), string.substring(Math.min(n3, n2 + 3)));
                }
                return builder.build();
            }
            catch (IllformedLocaleException illformedLocaleException) {
                return new Locale(string2, string3, string4);
            }
        }
    }
}

