/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.util.AbstractMap;
import java.util.Map;

@JacksonStdImpl
public class MapEntryDeserializer
extends ContainerDeserializerBase<Map.Entry<Object, Object>>
implements ContextualDeserializer {
    protected final KeyDeserializer _keyDeserializer;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public MapEntryDeserializer(JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType);
        if (((ResolvedType)javaType).containedTypeCount() != 2) {
            throw new IllegalArgumentException("Missing generic type information for " + javaType);
        }
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
    }

    protected MapEntryDeserializer(MapEntryDeserializer mapEntryDeserializer) {
        super(mapEntryDeserializer);
        this._keyDeserializer = mapEntryDeserializer._keyDeserializer;
        this._valueDeserializer = mapEntryDeserializer._valueDeserializer;
        this._valueTypeDeserializer = mapEntryDeserializer._valueTypeDeserializer;
    }

    protected MapEntryDeserializer(MapEntryDeserializer mapEntryDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(mapEntryDeserializer);
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
    }

    protected MapEntryDeserializer withResolved(KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        if (this._keyDeserializer == keyDeserializer && this._valueDeserializer == jsonDeserializer && this._valueTypeDeserializer == typeDeserializer) {
            return this;
        }
        return new MapEntryDeserializer(this, keyDeserializer, jsonDeserializer, typeDeserializer);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext object, BeanProperty beanProperty) {
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        if (keyDeserializer == null) {
            keyDeserializer = ((DeserializationContext)object).findKeyDeserializer(this._containerType.containedType(0), beanProperty);
        } else if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual((DeserializationContext)object, beanProperty);
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        jsonDeserializer = this.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, jsonDeserializer);
        JavaType javaType = this._containerType.containedType(1);
        jsonDeserializer = jsonDeserializer == null ? ((DeserializationContext)object).findContextualValueDeserializer(javaType, beanProperty) : ((DeserializationContext)object).handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        object = this._valueTypeDeserializer;
        if (object != null) {
            object = ((TypeDeserializer)object).forProperty(beanProperty);
        }
        return this.withResolved(keyDeserializer, (TypeDeserializer)object, jsonDeserializer);
    }

    @Override
    public JavaType getContentType() {
        return this._containerType.containedType(1);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public Map.Entry<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object = jsonParser.currentToken();
        if (object == JsonToken.START_OBJECT) {
            object = jsonParser.nextToken();
        } else if (object != JsonToken.FIELD_NAME && object != JsonToken.END_OBJECT) {
            if (object == JsonToken.START_ARRAY) {
                return (Map.Entry)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            return (Map.Entry)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
        }
        if (object != JsonToken.FIELD_NAME) {
            if (object == JsonToken.END_OBJECT) {
                return (Map.Entry)deserializationContext.reportInputMismatch(this, "Cannot deserialize a Map.Entry out of empty JSON Object", new Object[0]);
            }
            return (Map.Entry)deserializationContext.handleUnexpectedToken(((JsonDeserializer)this).handledType(), jsonParser);
        }
        object = this._keyDeserializer;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        String string = jsonParser.currentName();
        Object object2 = ((KeyDeserializer)object).deserializeKey(string, deserializationContext);
        Object object3 = null;
        object = jsonParser.nextToken();
        try {
            object3 = object == JsonToken.VALUE_NULL ? jsonDeserializer.getNullValue(deserializationContext) : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
        }
        catch (Exception exception) {
            this.wrapAndThrow(deserializationContext, exception, Map.Entry.class, string);
        }
        object = jsonParser.nextToken();
        if (object != JsonToken.END_OBJECT) {
            if (object == JsonToken.FIELD_NAME) {
                deserializationContext.reportInputMismatch(this, "Problem binding JSON into Map.Entry: more than one entry in JSON (second field: '%s')", jsonParser.currentName());
            } else {
                deserializationContext.reportInputMismatch(this, "Problem binding JSON into Map.Entry: unexpected content after JSON Object entry: " + (Object)object, new Object[0]);
            }
            return null;
        }
        return new AbstractMap.SimpleEntry<Object, Object>(object2, object3);
    }

    @Override
    public Map.Entry<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Map.Entry<Object, Object> entry) {
        throw new IllegalStateException("Cannot update Map.Entry values");
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }
}

