/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;

public class NumberDeserializers {
    private static final HashSet<String> a = new HashSet();

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return IntegerDeserializer.a;
            }
            if (clazz == Boolean.TYPE) {
                return BooleanDeserializer.a;
            }
            if (clazz == Long.TYPE) {
                return LongDeserializer.a;
            }
            if (clazz == Double.TYPE) {
                return DoubleDeserializer.a;
            }
            if (clazz == Character.TYPE) {
                return CharacterDeserializer.a;
            }
            if (clazz == Byte.TYPE) {
                return ByteDeserializer.a;
            }
            if (clazz == Short.TYPE) {
                return ShortDeserializer.a;
            }
            if (clazz == Float.TYPE) {
                return FloatDeserializer.a;
            }
            if (clazz == Void.TYPE) {
                return NullifyingDeserializer.instance;
            }
        } else if (a.contains(string)) {
            if (clazz == Integer.class) {
                return IntegerDeserializer.b;
            }
            if (clazz == Boolean.class) {
                return BooleanDeserializer.b;
            }
            if (clazz == Long.class) {
                return LongDeserializer.b;
            }
            if (clazz == Double.class) {
                return DoubleDeserializer.b;
            }
            if (clazz == Character.class) {
                return CharacterDeserializer.b;
            }
            if (clazz == Byte.class) {
                return ByteDeserializer.b;
            }
            if (clazz == Short.class) {
                return ShortDeserializer.b;
            }
            if (clazz == Float.class) {
                return FloatDeserializer.b;
            }
            if (clazz == Number.class) {
                return NumberDeserializer.instance;
            }
            if (clazz == BigDecimal.class) {
                return BigDecimalDeserializer.instance;
            }
            if (clazz == BigInteger.class) {
                return BigIntegerDeserializer.instance;
            }
        } else {
            return null;
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + clazz.getName());
    }

    static {
        Class[] classArray = new Class[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, Number.class, BigDecimal.class, BigInteger.class};
        Class[] classArray2 = classArray;
        classArray2 = classArray;
        int cfr_ignored_0 = classArray.length;
        for (int i2 = 0; i2 < 11; ++i2) {
            Class clazz = classArray2[i2];
            a.add(clazz.getName());
        }
    }

    @JacksonStdImpl
    public static class BigDecimalDeserializer
    extends StdScalarDeserializer<BigDecimal> {
        public static final BigDecimalDeserializer instance = new BigDecimalDeserializer();

        public BigDecimalDeserializer() {
            super(BigDecimal.class);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return BigDecimal.ZERO;
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Float;
        }

        @Override
        public BigDecimal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            String string;
            switch (jsonParser.currentTokenId()) {
                case 7: {
                    CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (BigDecimal)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (BigDecimal)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                    }
                }
                case 8: {
                    return jsonParser.getDecimalValue();
                }
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 1: {
                    BigDecimalDeserializer bigDecimalDeserializer = this;
                    string = deserializationContext.extractScalarFromObject(jsonParser, bigDecimalDeserializer, bigDecimalDeserializer._valueClass);
                    break;
                }
                case 3: {
                    return (BigDecimal)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return (BigDecimal)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
            if (coercionAction == CoercionAction.AsNull) {
                return (BigDecimal)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (BigDecimal)((JsonDeserializer)this).getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull(string = string.trim())) {
                return (BigDecimal)this.getNullValue(deserializationContext);
            }
            if (NumberInput.looksLikeValidNumber(string)) {
                jsonParser.streamReadConstraints().validateFPLength(string.length());
                try {
                    return NumberInput.parseBigDecimal(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return (BigDecimal)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
        }
    }

    @JacksonStdImpl
    public static class BigIntegerDeserializer
    extends StdScalarDeserializer<BigInteger> {
        public static final BigIntegerDeserializer instance = new BigIntegerDeserializer();

        public BigIntegerDeserializer() {
            super(BigInteger.class);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return BigInteger.ZERO;
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Integer;
        }

        @Override
        public BigInteger deserialize(JsonParser jsonParser, DeserializationContext serializable) {
            String string;
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getBigIntegerValue();
            }
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 8: {
                    CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, (DeserializationContext)serializable, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (BigInteger)this.getNullValue((DeserializationContext)serializable);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (BigInteger)((JsonDeserializer)this).getEmptyValue((DeserializationContext)serializable);
                    }
                    serializable = jsonParser.getDecimalValue();
                    jsonParser.streamReadConstraints().validateBigIntegerScale(((BigDecimal)serializable).scale());
                    return ((BigDecimal)serializable).toBigInteger();
                }
                case 1: {
                    BigIntegerDeserializer bigIntegerDeserializer = this;
                    string = ((DeserializationContext)serializable).extractScalarFromObject(jsonParser, bigIntegerDeserializer, bigIntegerDeserializer._valueClass);
                    break;
                }
                case 3: {
                    return (BigInteger)this._deserializeFromArray(jsonParser, (DeserializationContext)serializable);
                }
                default: {
                    return (BigInteger)((DeserializationContext)serializable).handleUnexpectedToken(this.getValueType((DeserializationContext)serializable), jsonParser);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion((DeserializationContext)serializable, string);
            if (coercionAction == CoercionAction.AsNull) {
                return (BigInteger)this.getNullValue((DeserializationContext)serializable);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (BigInteger)((JsonDeserializer)this).getEmptyValue((DeserializationContext)serializable);
            }
            if (this._hasTextualNull(string = string.trim())) {
                return (BigInteger)this.getNullValue((DeserializationContext)serializable);
            }
            if (this._isIntNumber(string)) {
                jsonParser.streamReadConstraints().validateIntegerLength(string.length());
                try {
                    return NumberInput.parseBigInteger(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return (BigInteger)((DeserializationContext)serializable).handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
        }
    }

    @JacksonStdImpl
    public static class NumberDeserializer
    extends StdScalarDeserializer<Object> {
        public static final NumberDeserializer instance = new NumberDeserializer();

        public NumberDeserializer() {
            super(Number.class);
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Integer;
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            String string;
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 7: {
                    if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                        return this._coerceIntegral(jsonParser, deserializationContext);
                    }
                    return jsonParser.getNumberValue();
                }
                case 8: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS) && !jsonParser.isNaN()) {
                        return jsonParser.getDecimalValue();
                    }
                    return jsonParser.getNumberValue();
                }
                case 1: {
                    NumberDeserializer numberDeserializer = this;
                    string = deserializationContext.extractScalarFromObject(jsonParser, numberDeserializer, numberDeserializer._valueClass);
                    break;
                }
                case 3: {
                    return this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
            if (coercionAction == CoercionAction.AsNull) {
                return this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull(string = string.trim())) {
                return this.getNullValue(deserializationContext);
            }
            if (this._isPosInf(string)) {
                return Double.POSITIVE_INFINITY;
            }
            if (this._isNegInf(string)) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this._isNaN(string)) {
                return Double.NaN;
            }
            try {
                if (this._isIntNumber(string)) {
                    jsonParser.streamReadConstraints().validateIntegerLength(string.length());
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                        return NumberInput.parseBigInteger(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                    }
                    long l2 = NumberInput.parseLong(string);
                    if (!deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS) && l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
                        return (int)l2;
                    }
                    return l2;
                }
                if (NumberInput.looksLikeValidNumber(string)) {
                    jsonParser.streamReadConstraints().validateFPLength(string.length());
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        return NumberInput.parseBigDecimal(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                    }
                    return NumberInput.parseDouble(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid number", new Object[0]);
        }

        @Override
        public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
            switch (jsonParser.currentTokenId()) {
                case 6: 
                case 7: 
                case 8: {
                    return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
                }
            }
            return typeDeserializer.deserializeTypedFromScalar(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class DoubleDeserializer
    extends PrimitiveOrWrapperDeserializer<Double> {
        static final DoubleDeserializer a = new DoubleDeserializer(Double.TYPE, 0.0);
        static final DoubleDeserializer b = new DoubleDeserializer(Double.class, null);

        public DoubleDeserializer(Class<Double> clazz, Double d2) {
            super(clazz, LogicalType.Float, d2, 0.0);
        }

        @Override
        public Double deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
                return jsonParser.getDoubleValue();
            }
            if (this._primitive) {
                return this._parseDoublePrimitive(jsonParser, deserializationContext);
            }
            return this._parseDouble(jsonParser, deserializationContext);
        }

        @Override
        public Double deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
                return jsonParser.getDoubleValue();
            }
            if (this._primitive) {
                return this._parseDoublePrimitive(jsonParser, deserializationContext);
            }
            return this._parseDouble(jsonParser, deserializationContext);
        }

        protected final Double _parseDouble(JsonParser jsonParser, DeserializationContext deserializationContext) {
            String string;
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 11: {
                    return (Double)((JsonDeserializer)this).getNullValue(deserializationContext);
                }
                case 7: {
                    CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Double)((JsonDeserializer)this).getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (Double)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                    }
                }
                case 8: {
                    return jsonParser.getDoubleValue();
                }
                case 1: {
                    DoubleDeserializer doubleDeserializer = this;
                    string = deserializationContext.extractScalarFromObject(jsonParser, doubleDeserializer, doubleDeserializer._valueClass);
                    break;
                }
                case 3: {
                    return (Double)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return (Double)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            Object object = this._checkDoubleSpecialValue(string);
            if (object != null) {
                return object;
            }
            object = this._checkFromStringCoercion(deserializationContext, string);
            if (object == CoercionAction.AsNull) {
                return (Double)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            if (object == CoercionAction.AsEmpty) {
                return (Double)((JsonDeserializer)this).getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, string = string.trim())) {
                return (Double)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            if (NumberInput.looksLikeValidNumber(string)) {
                jsonParser.streamReadConstraints().validateFPLength(string.length());
                try {
                    return DoubleDeserializer._parseDouble(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return (Double)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid `Double` value", new Object[0]);
        }
    }

    @JacksonStdImpl
    public static class FloatDeserializer
    extends PrimitiveOrWrapperDeserializer<Float> {
        static final FloatDeserializer a = new FloatDeserializer(Float.TYPE, Float.valueOf(0.0f));
        static final FloatDeserializer b = new FloatDeserializer(Float.class, null);

        public FloatDeserializer(Class<Float> clazz, Float f2) {
            super(clazz, LogicalType.Float, f2, Float.valueOf(0.0f));
        }

        @Override
        public Float deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
                return Float.valueOf(jsonParser.getFloatValue());
            }
            if (this._primitive) {
                return Float.valueOf(this._parseFloatPrimitive(jsonParser, deserializationContext));
            }
            return this._parseFloat(jsonParser, deserializationContext);
        }

        protected final Float _parseFloat(JsonParser jsonParser, DeserializationContext deserializationContext) {
            String string;
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 11: {
                    return (Float)((JsonDeserializer)this).getNullValue(deserializationContext);
                }
                case 7: {
                    CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Float)((JsonDeserializer)this).getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (Float)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                    }
                }
                case 8: {
                    return Float.valueOf(jsonParser.getFloatValue());
                }
                case 1: {
                    FloatDeserializer floatDeserializer = this;
                    string = deserializationContext.extractScalarFromObject(jsonParser, floatDeserializer, floatDeserializer._valueClass);
                    break;
                }
                case 3: {
                    return (Float)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return (Float)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            Object object = this._checkFloatSpecialValue(string);
            if (object != null) {
                return object;
            }
            object = this._checkFromStringCoercion(deserializationContext, string);
            if (object == CoercionAction.AsNull) {
                return (Float)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            if (object == CoercionAction.AsEmpty) {
                return (Float)((JsonDeserializer)this).getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, string = string.trim())) {
                return (Float)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            if (NumberInput.looksLikeValidNumber(string)) {
                jsonParser.streamReadConstraints().validateFPLength(string.length());
                try {
                    return Float.valueOf(NumberInput.parseFloat(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER)));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return (Float)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid `Float` value", new Object[0]);
        }
    }

    @JacksonStdImpl
    public static final class LongDeserializer
    extends PrimitiveOrWrapperDeserializer<Long> {
        static final LongDeserializer a = new LongDeserializer(Long.TYPE, 0L);
        static final LongDeserializer b = new LongDeserializer(Long.class, null);

        public LongDeserializer(Class<Long> clazz, Long l2) {
            super(clazz, LogicalType.Integer, l2, 0L);
        }

        @Override
        public final boolean isCachable() {
            return true;
        }

        @Override
        public final Long deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getLongValue();
            }
            if (this._primitive) {
                return this._parseLongPrimitive(jsonParser, deserializationContext);
            }
            return this._parseLong(jsonParser, deserializationContext, Long.class);
        }
    }

    @JacksonStdImpl
    public static final class IntegerDeserializer
    extends PrimitiveOrWrapperDeserializer<Integer> {
        static final IntegerDeserializer a = new IntegerDeserializer(Integer.TYPE, 0);
        static final IntegerDeserializer b = new IntegerDeserializer(Integer.class, null);

        public IntegerDeserializer(Class<Integer> clazz, Integer n2) {
            super(clazz, LogicalType.Integer, n2, 0);
        }

        @Override
        public final boolean isCachable() {
            return true;
        }

        @Override
        public final Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getIntValue();
            }
            if (this._primitive) {
                return this._parseIntPrimitive(jsonParser, deserializationContext);
            }
            return this._parseInteger(jsonParser, deserializationContext, Integer.class);
        }

        @Override
        public final Integer deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getIntValue();
            }
            if (this._primitive) {
                return this._parseIntPrimitive(jsonParser, deserializationContext);
            }
            return this._parseInteger(jsonParser, deserializationContext, Integer.class);
        }
    }

    @JacksonStdImpl
    public static class CharacterDeserializer
    extends PrimitiveOrWrapperDeserializer<Character> {
        static final CharacterDeserializer a = new CharacterDeserializer(Character.TYPE, Character.valueOf('\u0000'));
        static final CharacterDeserializer b = new CharacterDeserializer(Character.class, null);

        public CharacterDeserializer(Class<Character> clazz, Character c2) {
            super(clazz, LogicalType.Integer, c2, Character.valueOf('\u0000'));
        }

        @Override
        public Character deserialize(JsonParser object, DeserializationContext deserializationContext) {
            switch (((JsonParser)object).currentTokenId()) {
                case 6: {
                    object = ((JsonParser)object).getText();
                    break;
                }
                case 7: {
                    CoercionAction coercionAction = deserializationContext.findCoercionAction(((JsonDeserializer)this).logicalType(), this._valueClass, CoercionInputShape.Integer);
                    switch (coercionAction) {
                        case Fail: {
                            this._checkCoercionFail(deserializationContext, coercionAction, this._valueClass, ((JsonParser)object).getNumberValue(), "Integer value (" + ((JsonParser)object).getText() + ")");
                        }
                        case AsNull: {
                            return (Character)((JsonDeserializer)this).getNullValue(deserializationContext);
                        }
                        case AsEmpty: {
                            return (Character)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                        }
                    }
                    int n2 = ((JsonParser)object).getIntValue();
                    if (n2 >= 0 && n2 <= 65535) {
                        return Character.valueOf((char)n2);
                    }
                    return (Character)deserializationContext.handleWeirdNumberValue(((JsonDeserializer)this).handledType(), n2, "value outside valid Character range (0x0000 - 0xFFFF)", new Object[0]);
                }
                case 11: {
                    if (this._primitive) {
                        this._verifyNullForPrimitive(deserializationContext);
                    }
                    return (Character)((JsonDeserializer)this).getNullValue(deserializationContext);
                }
                case 1: {
                    CharacterDeserializer characterDeserializer = this;
                    object = deserializationContext.extractScalarFromObject((JsonParser)object, characterDeserializer, characterDeserializer._valueClass);
                    break;
                }
                case 3: {
                    return (Character)this._deserializeFromArray((JsonParser)object, deserializationContext);
                }
                default: {
                    return (Character)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
                }
            }
            if (((String)object).length() == 1) {
                return Character.valueOf(((String)object).charAt(0));
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (Character)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Character)((JsonDeserializer)this).getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
                return (Character)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            return (Character)deserializationContext.handleWeirdStringValue(((JsonDeserializer)this).handledType(), (String)object, "Expected either Integer value code or 1-character String", new Object[0]);
        }
    }

    @JacksonStdImpl
    public static class ShortDeserializer
    extends PrimitiveOrWrapperDeserializer<Short> {
        static final ShortDeserializer a = new ShortDeserializer(Short.TYPE, (short)0);
        static final ShortDeserializer b = new ShortDeserializer(Short.class, null);

        public ShortDeserializer(Class<Short> clazz, Short s2) {
            super(clazz, LogicalType.Integer, s2, (short)0);
        }

        @Override
        public Short deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getShortValue();
            }
            if (this._primitive) {
                return this._parseShortPrimitive(jsonParser, deserializationContext);
            }
            return this._parseShort(jsonParser, deserializationContext);
        }

        protected Short _parseShort(JsonParser object, DeserializationContext deserializationContext) {
            int n2;
            switch (((JsonParser)object).currentTokenId()) {
                case 6: {
                    object = ((JsonParser)object).getText();
                    break;
                }
                case 8: {
                    CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Short)((JsonDeserializer)this).getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (Short)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                    }
                    return ((JsonParser)object).getShortValue();
                }
                case 11: {
                    return (Short)((JsonDeserializer)this).getNullValue(deserializationContext);
                }
                case 7: {
                    return ((JsonParser)object).getShortValue();
                }
                case 1: {
                    ShortDeserializer shortDeserializer = this;
                    object = deserializationContext.extractScalarFromObject((JsonParser)object, shortDeserializer, shortDeserializer._valueClass);
                    break;
                }
                case 3: {
                    return (Short)this._deserializeFromArray((JsonParser)object, deserializationContext);
                }
                default: {
                    return (Short)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (Short)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Short)((JsonDeserializer)this).getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
                return (Short)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            try {
                n2 = NumberInput.parseInt((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid Short value", new Object[0]);
            }
            if (this._shortOverflow(n2)) {
                return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "overflow, value cannot be represented as 16-bit value", new Object[0]);
            }
            return (short)n2;
        }
    }

    @JacksonStdImpl
    public static class ByteDeserializer
    extends PrimitiveOrWrapperDeserializer<Byte> {
        static final ByteDeserializer a = new ByteDeserializer(Byte.TYPE, (byte)0);
        static final ByteDeserializer b = new ByteDeserializer(Byte.class, null);

        public ByteDeserializer(Class<Byte> clazz, Byte by) {
            super(clazz, LogicalType.Integer, by, (byte)0);
        }

        @Override
        public Byte deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getByteValue();
            }
            if (this._primitive) {
                return this._parseBytePrimitive(jsonParser, deserializationContext);
            }
            return this._parseByte(jsonParser, deserializationContext);
        }

        protected Byte _parseByte(JsonParser object, DeserializationContext deserializationContext) {
            int n2;
            switch (((JsonParser)object).currentTokenId()) {
                case 6: {
                    object = ((JsonParser)object).getText();
                    break;
                }
                case 8: {
                    CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Byte)((JsonDeserializer)this).getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (Byte)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                    }
                    return ((JsonParser)object).getByteValue();
                }
                case 11: {
                    return (Byte)((JsonDeserializer)this).getNullValue(deserializationContext);
                }
                case 7: {
                    return ((JsonParser)object).getByteValue();
                }
                case 3: {
                    return (Byte)this._deserializeFromArray((JsonParser)object, deserializationContext);
                }
                case 1: {
                    ByteDeserializer byteDeserializer = this;
                    object = deserializationContext.extractScalarFromObject((JsonParser)object, byteDeserializer, byteDeserializer._valueClass);
                    break;
                }
                default: {
                    return (Byte)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
            if (coercionAction == CoercionAction.AsNull) {
                return (Byte)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Byte)((JsonDeserializer)this).getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
                return (Byte)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            try {
                n2 = NumberInput.parseInt((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid Byte value", new Object[0]);
            }
            if (this._byteOverflow(n2)) {
                return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "overflow, value cannot be represented as 8-bit value", new Object[0]);
            }
            return (byte)n2;
        }
    }

    @JacksonStdImpl
    public static final class BooleanDeserializer
    extends PrimitiveOrWrapperDeserializer<Boolean> {
        static final BooleanDeserializer a = new BooleanDeserializer(Boolean.TYPE, Boolean.FALSE);
        static final BooleanDeserializer b = new BooleanDeserializer(Boolean.class, null);

        public BooleanDeserializer(Class<Boolean> clazz, Boolean bl2) {
            super(clazz, LogicalType.Boolean, bl2, Boolean.FALSE);
        }

        @Override
        public final Boolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            JsonToken jsonToken = jsonParser.currentToken();
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (this._primitive) {
                return this._parseBooleanPrimitive(jsonParser, deserializationContext);
            }
            return this._parseBoolean(jsonParser, deserializationContext, this._valueClass);
        }

        @Override
        public final Boolean deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer object) {
            object = jsonParser.currentToken();
            if (object == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (object == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (this._primitive) {
                return this._parseBooleanPrimitive(jsonParser, deserializationContext);
            }
            return this._parseBoolean(jsonParser, deserializationContext, this._valueClass);
        }
    }

    protected static abstract class PrimitiveOrWrapperDeserializer<T>
    extends StdScalarDeserializer<T> {
        protected final LogicalType _logicalType;
        protected final T _nullValue;
        protected final T _emptyValue;
        protected final boolean _primitive;

        protected PrimitiveOrWrapperDeserializer(Class<T> clazz, LogicalType logicalType, T t2, T t3) {
            super(clazz);
            this._logicalType = logicalType;
            this._nullValue = t2;
            this._emptyValue = t3;
            this._primitive = clazz.isPrimitive();
        }

        @Deprecated
        protected PrimitiveOrWrapperDeserializer(Class<T> clazz, T t2, T t3) {
            this(clazz, LogicalType.OtherScalar, t2, t3);
        }

        @Override
        public AccessPattern getNullAccessPattern() {
            if (this._primitive) {
                return AccessPattern.DYNAMIC;
            }
            if (this._nullValue == null) {
                return AccessPattern.ALWAYS_NULL;
            }
            return AccessPattern.CONSTANT;
        }

        @Override
        public final T getNullValue(DeserializationContext deserializationContext) {
            if (this._primitive && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                deserializationContext.reportInputMismatch(this, "Cannot map `null` into type %s (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)", ClassUtil.classNameOf(((JsonDeserializer)this).handledType()));
            }
            return this._nullValue;
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return this._emptyValue;
        }

        @Override
        public final LogicalType logicalType() {
            return this._logicalType;
        }
    }
}

