/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsFailProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidNullException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public abstract class PrimitiveArrayDeserializers<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    protected final Boolean _unwrapSingle;
    private transient Object a;
    protected final NullValueProvider _nuller;

    protected PrimitiveArrayDeserializers(Class<T> clazz) {
        super(clazz);
        this._unwrapSingle = null;
        this._nuller = null;
    }

    protected PrimitiveArrayDeserializers(PrimitiveArrayDeserializers<?> primitiveArrayDeserializers, NullValueProvider nullValueProvider, Boolean bl2) {
        super(primitiveArrayDeserializers._valueClass);
        this._unwrapSingle = bl2;
        this._nuller = nullValueProvider;
    }

    public static JsonDeserializer<?> forType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return f.a;
        }
        if (clazz == Long.TYPE) {
            return g.a;
        }
        if (clazz == Byte.TYPE) {
            return new b();
        }
        if (clazz == Short.TYPE) {
            return new h();
        }
        if (clazz == Float.TYPE) {
            return new e();
        }
        if (clazz == Double.TYPE) {
            return new d();
        }
        if (clazz == Boolean.TYPE) {
            return new a();
        }
        if (clazz == Character.TYPE) {
            return new c();
        }
        throw new IllegalArgumentException("Unknown primitive array element type: " + clazz);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        Boolean bl2 = this.findFormatFeature(deserializationContext, beanProperty, this._valueClass, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        NullValueProvider nullValueProvider = null;
        Nulls nulls = this.findContentNullStyle(deserializationContext, beanProperty);
        if (nulls == Nulls.SKIP) {
            nullValueProvider = NullsConstantProvider.skipper();
        } else if (nulls == Nulls.FAIL) {
            if (beanProperty == null) {
                nullValueProvider = NullsFailProvider.constructForRootValue(deserializationContext.constructType(this._valueClass.getComponentType()));
            } else {
                BeanProperty beanProperty2 = beanProperty;
                nullValueProvider = NullsFailProvider.constructForProperty(beanProperty2, beanProperty2.getType().getContentType());
            }
        }
        if (Objects.equals(bl2, this._unwrapSingle) && nullValueProvider == this._nuller) {
            return this;
        }
        return this.withResolved(nullValueProvider, bl2);
    }

    protected abstract T _concat(T var1, T var2);

    protected abstract T handleSingleElementUnwrapped(JsonParser var1, DeserializationContext var2);

    protected abstract PrimitiveArrayDeserializers<?> withResolved(NullValueProvider var1, Boolean var2);

    protected abstract T _constructEmpty();

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext object) {
        object = this.a;
        if (object == null) {
            this.a = object = this._constructEmpty();
        }
        return object;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, T t2) {
        jsonParser = this.deserialize(jsonParser, deserializationContext);
        if (t2 == null) {
            return (T)jsonParser;
        }
        int n2 = Array.getLength(t2);
        if (n2 == 0) {
            return (T)jsonParser;
        }
        return (T)this._concat(t2, jsonParser);
    }

    protected T handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._deserializeFromString(jsonParser, deserializationContext);
        }
        boolean bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (bl2) {
            return this.handleSingleElementUnwrapped(jsonParser, deserializationContext);
        }
        return (T)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected void _failOnNull(DeserializationContext deserializationContext) {
        throw InvalidNullException.from(deserializationContext, null, deserializationContext.constructType(this._valueClass));
    }

    @JacksonStdImpl
    static final class d
    extends PrimitiveArrayDeserializers<double[]> {
        public d() {
            super(double[].class);
        }

        private d(d d2, NullValueProvider nullValueProvider, Boolean bl2) {
            super(d2, nullValueProvider, bl2);
        }

        @Override
        protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new d(this, nullValueProvider, bl2);
        }

        private double[] a(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (double[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.DoubleBuilder doubleBuilder = deserializationContext.getArrayBuilders().getDoubleBuilder();
            double[] dArray = (double[])doubleBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    if (jsonToken == JsonToken.VALUE_NULL && this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        continue;
                    }
                    double d2 = this._parseDoublePrimitive(jsonParser, deserializationContext);
                    if (n2 >= dArray.length) {
                        dArray = doubleBuilder.appendCompletedChunk(dArray, n2);
                        n2 = 0;
                    }
                    dArray[n2++] = d2;
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)dArray, doubleBuilder.bufferedSize() + n2);
            }
            return doubleBuilder.completeAndClearBuffer(dArray, n2);
        }

        @Override
        protected final /* synthetic */ Object handleSingleElementUnwrapped(JsonParser object, DeserializationContext object2) {
            DeserializationContext deserializationContext = object2;
            object2 = object;
            object = this;
            return new double[]{((StdDeserializer)object)._parseDoublePrimitive((JsonParser)object2, deserializationContext)};
        }

        @Override
        protected final /* synthetic */ Object _concat(Object object, Object object2) {
            double[] dArray = (double[])object;
            object2 = (double[])object2;
            object = dArray;
            int n2 = dArray.length;
            int n3 = ((Object)object2).length;
            object = Arrays.copyOf((double[])object, n2 + n3);
            System.arraycopy(object2, 0, object, n2, n3);
            return object;
        }

        @Override
        public final /* synthetic */ Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this.a(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    static final class e
    extends PrimitiveArrayDeserializers<float[]> {
        public e() {
            super(float[].class);
        }

        private e(e e2, NullValueProvider nullValueProvider, Boolean bl2) {
            super(e2, nullValueProvider, bl2);
        }

        @Override
        protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new e(this, nullValueProvider, bl2);
        }

        private float[] a(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (float[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.FloatBuilder floatBuilder = deserializationContext.getArrayBuilders().getFloatBuilder();
            float[] fArray = (float[])floatBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    if (jsonToken == JsonToken.VALUE_NULL && this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        continue;
                    }
                    float f2 = this._parseFloatPrimitive(jsonParser, deserializationContext);
                    if (n2 >= fArray.length) {
                        fArray = floatBuilder.appendCompletedChunk(fArray, n2);
                        n2 = 0;
                    }
                    fArray[n2++] = f2;
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)fArray, floatBuilder.bufferedSize() + n2);
            }
            return floatBuilder.completeAndClearBuffer(fArray, n2);
        }

        @Override
        protected final /* synthetic */ Object handleSingleElementUnwrapped(JsonParser object, DeserializationContext object2) {
            DeserializationContext deserializationContext = object2;
            object2 = object;
            object = this;
            return new float[]{((StdDeserializer)object)._parseFloatPrimitive((JsonParser)object2, deserializationContext)};
        }

        @Override
        protected final /* synthetic */ Object _concat(Object object, Object object2) {
            float[] fArray = (float[])object;
            object2 = (float[])object2;
            object = fArray;
            int n2 = fArray.length;
            int n3 = ((Object)object2).length;
            object = Arrays.copyOf((float[])object, n2 + n3);
            System.arraycopy(object2, 0, object, n2, n3);
            return object;
        }

        @Override
        public final /* synthetic */ Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this.a(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    static final class g
    extends PrimitiveArrayDeserializers<long[]> {
        public static final g a = new g();

        public g() {
            super(long[].class);
        }

        private g(g g2, NullValueProvider nullValueProvider, Boolean bl2) {
            super(g2, nullValueProvider, bl2);
        }

        @Override
        protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new g(this, nullValueProvider, bl2);
        }

        private long[] a(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (long[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.LongBuilder longBuilder = deserializationContext.getArrayBuilders().getLongBuilder();
            long[] lArray = (long[])longBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    long l2;
                    if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                        l2 = jsonParser.getLongValue();
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        l2 = 0L;
                    } else {
                        l2 = this._parseLongPrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= lArray.length) {
                        lArray = longBuilder.appendCompletedChunk(lArray, n2);
                        n2 = 0;
                    }
                    lArray[n2++] = l2;
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)lArray, longBuilder.bufferedSize() + n2);
            }
            return longBuilder.completeAndClearBuffer(lArray, n2);
        }

        @Override
        protected final /* synthetic */ Object handleSingleElementUnwrapped(JsonParser object, DeserializationContext object2) {
            DeserializationContext deserializationContext = object2;
            object2 = object;
            object = this;
            return new long[]{((StdDeserializer)object)._parseLongPrimitive((JsonParser)object2, deserializationContext)};
        }

        @Override
        protected final /* synthetic */ Object _concat(Object object, Object object2) {
            long[] lArray = (long[])object;
            object2 = (long[])object2;
            object = lArray;
            int n2 = lArray.length;
            int n3 = ((Object)object2).length;
            object = Arrays.copyOf((long[])object, n2 + n3);
            System.arraycopy(object2, 0, object, n2, n3);
            return object;
        }

        @Override
        public final /* synthetic */ Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this.a(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    static final class f
    extends PrimitiveArrayDeserializers<int[]> {
        public static final f a = new f();

        public f() {
            super(int[].class);
        }

        private f(f f2, NullValueProvider nullValueProvider, Boolean bl2) {
            super(f2, nullValueProvider, bl2);
        }

        @Override
        protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new f(this, nullValueProvider, bl2);
        }

        private int[] a(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (int[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.IntBuilder intBuilder = deserializationContext.getArrayBuilders().getIntBuilder();
            int[] nArray = (int[])intBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    int n3;
                    if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                        n3 = jsonParser.getIntValue();
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        n3 = 0;
                    } else {
                        n3 = this._parseIntPrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= nArray.length) {
                        nArray = intBuilder.appendCompletedChunk(nArray, n2);
                        n2 = 0;
                    }
                    nArray[n2++] = n3;
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)nArray, intBuilder.bufferedSize() + n2);
            }
            return intBuilder.completeAndClearBuffer(nArray, n2);
        }

        @Override
        protected final /* synthetic */ Object handleSingleElementUnwrapped(JsonParser object, DeserializationContext object2) {
            DeserializationContext deserializationContext = object2;
            object2 = object;
            object = this;
            return new int[]{((StdDeserializer)object)._parseIntPrimitive((JsonParser)object2, deserializationContext)};
        }

        @Override
        protected final /* synthetic */ Object _concat(Object object, Object object2) {
            int[] nArray = (int[])object;
            object2 = (int[])object2;
            object = nArray;
            int n2 = nArray.length;
            int n3 = ((Object)object2).length;
            object = Arrays.copyOf((int[])object, n2 + n3);
            System.arraycopy(object2, 0, object, n2, n3);
            return object;
        }

        @Override
        public final /* synthetic */ Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this.a(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    static final class h
    extends PrimitiveArrayDeserializers<short[]> {
        public h() {
            super(short[].class);
        }

        private h(h h2, NullValueProvider nullValueProvider, Boolean bl2) {
            super(h2, nullValueProvider, bl2);
        }

        @Override
        protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new h(this, nullValueProvider, bl2);
        }

        private short[] a(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (short[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.ShortBuilder shortBuilder = deserializationContext.getArrayBuilders().getShortBuilder();
            short[] sArray = (short[])shortBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    short s2;
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        s2 = 0;
                    } else {
                        s2 = this._parseShortPrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= sArray.length) {
                        sArray = shortBuilder.appendCompletedChunk(sArray, n2);
                        n2 = 0;
                    }
                    sArray[n2++] = s2;
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)sArray, shortBuilder.bufferedSize() + n2);
            }
            return shortBuilder.completeAndClearBuffer(sArray, n2);
        }

        @Override
        protected final /* synthetic */ Object handleSingleElementUnwrapped(JsonParser object, DeserializationContext object2) {
            DeserializationContext deserializationContext = object2;
            object2 = object;
            object = this;
            return new short[]{((StdDeserializer)object)._parseShortPrimitive((JsonParser)object2, deserializationContext)};
        }

        @Override
        protected final /* synthetic */ Object _concat(Object object, Object object2) {
            short[] sArray = (short[])object;
            object2 = (short[])object2;
            object = sArray;
            int n2 = sArray.length;
            int n3 = ((Object)object2).length;
            object = Arrays.copyOf((short[])object, n2 + n3);
            System.arraycopy(object2, 0, object, n2, n3);
            return object;
        }

        @Override
        public final /* synthetic */ Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this.a(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    static final class b
    extends PrimitiveArrayDeserializers<byte[]> {
        public b() {
            super(byte[].class);
        }

        private b(b b2, NullValueProvider nullValueProvider, Boolean bl2) {
            super(b2, nullValueProvider, bl2);
        }

        @Override
        protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new b(this, nullValueProvider, bl2);
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Binary;
        }

        private byte[] a(JsonParser jsonParser, DeserializationContext deserializationContext) {
            Object object;
            Object object2;
            Object object3;
            block16: {
                object3 = jsonParser.currentToken();
                if (object3 == JsonToken.VALUE_STRING) {
                    try {
                        return jsonParser.getBinaryValue(deserializationContext.getBase64Variant());
                    }
                    catch (StreamReadException | DatabindException jsonProcessingException) {
                        object2 = jsonProcessingException;
                        object = ((JacksonException)jsonProcessingException).getOriginalMessage();
                        if (!((String)object).contains("base64")) break block16;
                        return (byte[])deserializationContext.handleWeirdStringValue(byte[].class, jsonParser.getText(), (String)object, new Object[0]);
                    }
                }
            }
            if (object3 == JsonToken.VALUE_EMBEDDED_OBJECT) {
                object2 = jsonParser.getEmbeddedObject();
                if (object2 == null) {
                    return null;
                }
                if (object2 instanceof byte[]) {
                    return (byte[])object2;
                }
            }
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (byte[])this.handleNonArray(jsonParser, deserializationContext);
            }
            object2 = deserializationContext.getArrayBuilders().getByteBuilder();
            object = (byte[])((PrimitiveArrayBuilder)object2).resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    byte by;
                    if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                        by = jsonParser.getByteValue();
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        by = 0;
                    } else {
                        by = this._parseBytePrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= ((Object)object).length) {
                        object = (byte[])((PrimitiveArrayBuilder)object2).appendCompletedChunk(object, n2);
                        n2 = 0;
                    }
                    object[n2++] = by;
                }
            }
            catch (Exception exception) {
                object3 = exception;
                throw JsonMappingException.wrapWithPath((Throwable)exception, object, ((PrimitiveArrayBuilder)object2).bufferedSize() + n2);
            }
            return (byte[])((PrimitiveArrayBuilder)object2).completeAndClearBuffer(object, n2);
        }

        @Override
        protected final /* synthetic */ Object handleSingleElementUnwrapped(JsonParser object, DeserializationContext object2) {
            byte by;
            DeserializationContext deserializationContext = object2;
            object2 = object;
            object = this;
            JsonToken jsonToken = ((JsonParser)object2).currentToken();
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                by = ((JsonParser)object2).getByteValue();
            } else {
                if (jsonToken == JsonToken.VALUE_NULL) {
                    if (((PrimitiveArrayDeserializers)object)._nuller != null) {
                        ((PrimitiveArrayDeserializers)object)._nuller.getNullValue(deserializationContext);
                        return (byte[])((JsonDeserializer)object).getEmptyValue(deserializationContext);
                    }
                    ((StdDeserializer)object)._verifyNullForPrimitive(deserializationContext);
                    return null;
                }
                object = (Number)deserializationContext.handleUnexpectedToken(((StdDeserializer)object)._valueClass.getComponentType(), (JsonParser)object2);
                by = ((Number)object).byteValue();
            }
            return new byte[]{by};
        }

        @Override
        protected final /* synthetic */ Object _concat(Object object, Object object2) {
            byte[] byArray = (byte[])object;
            object2 = (byte[])object2;
            object = byArray;
            int n2 = byArray.length;
            int n3 = ((Object)object2).length;
            object = Arrays.copyOf((byte[])object, n2 + n3);
            System.arraycopy(object2, 0, object, n2, n3);
            return object;
        }

        @Override
        public final /* synthetic */ Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this.a(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    static final class a
    extends PrimitiveArrayDeserializers<boolean[]> {
        public a() {
            super(boolean[].class);
        }

        private a(a a2, NullValueProvider nullValueProvider, Boolean bl2) {
            super(a2, nullValueProvider, bl2);
        }

        @Override
        protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new a(this, nullValueProvider, bl2);
        }

        private boolean[] a(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (boolean[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.BooleanBuilder booleanBuilder = deserializationContext.getArrayBuilders().getBooleanBuilder();
            boolean[] blArray = (boolean[])booleanBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    boolean bl2;
                    if (jsonToken == JsonToken.VALUE_TRUE) {
                        bl2 = true;
                    } else if (jsonToken == JsonToken.VALUE_FALSE) {
                        bl2 = false;
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        bl2 = false;
                    } else {
                        bl2 = this._parseBooleanPrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= blArray.length) {
                        blArray = booleanBuilder.appendCompletedChunk(blArray, n2);
                        n2 = 0;
                    }
                    blArray[n2++] = bl2;
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)blArray, booleanBuilder.bufferedSize() + n2);
            }
            return booleanBuilder.completeAndClearBuffer(blArray, n2);
        }

        @Override
        protected final /* synthetic */ Object handleSingleElementUnwrapped(JsonParser object, DeserializationContext object2) {
            DeserializationContext deserializationContext = object2;
            object2 = object;
            object = this;
            return new boolean[]{((StdDeserializer)object)._parseBooleanPrimitive((JsonParser)object2, deserializationContext)};
        }

        @Override
        protected final /* synthetic */ Object _concat(Object object, Object object2) {
            boolean[] blArray = (boolean[])object;
            object2 = (boolean[])object2;
            object = blArray;
            int n2 = blArray.length;
            int n3 = ((Object)object2).length;
            object = Arrays.copyOf((boolean[])object, n2 + n3);
            System.arraycopy(object2, 0, object, n2, n3);
            return object;
        }

        @Override
        public final /* synthetic */ Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this.a(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    static final class c
    extends PrimitiveArrayDeserializers<char[]> {
        public c() {
            super(char[].class);
        }

        @Override
        protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return this;
        }

        @Override
        protected final /* synthetic */ Object handleSingleElementUnwrapped(JsonParser object, DeserializationContext object2) {
            DeserializationContext deserializationContext = object2;
            object2 = object;
            object = this;
            return (char[])deserializationContext.handleUnexpectedToken(((StdDeserializer)object)._valueClass, (JsonParser)object2);
        }

        @Override
        protected final /* synthetic */ Object _concat(Object object, Object object2) {
            char[] cArray = (char[])object;
            object2 = (char[])object2;
            object = cArray;
            int n2 = cArray.length;
            int n3 = ((Object)object2).length;
            object = Arrays.copyOf((char[])object, n2 + n3);
            System.arraycopy(object2, 0, object, n2, n3);
            return object;
        }

        @Override
        public final /* synthetic */ Object deserialize(JsonParser object, DeserializationContext object2) {
            DeserializationContext deserializationContext = object2;
            object2 = object;
            object = this;
            if (((JsonParser)object2).hasToken(JsonToken.VALUE_STRING)) {
                char[] cArray = ((JsonParser)object2).getTextCharacters();
                int n2 = ((JsonParser)object2).getTextOffset();
                int n3 = ((JsonParser)object2).getTextLength();
                char[] cArray2 = new char[n3];
                System.arraycopy(cArray, n2, cArray2, 0, n3);
                return cArray2;
            }
            if (((JsonParser)object2).isExpectedStartArrayToken()) {
                JsonToken jsonToken;
                StringBuilder stringBuilder = new StringBuilder(64);
                while ((jsonToken = ((JsonParser)object2).nextToken()) != JsonToken.END_ARRAY) {
                    String string;
                    if (jsonToken == JsonToken.VALUE_STRING) {
                        string = ((JsonParser)object2).getText();
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (((PrimitiveArrayDeserializers)object)._nuller != null) {
                            ((PrimitiveArrayDeserializers)object)._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        ((StdDeserializer)object)._verifyNullForPrimitive(deserializationContext);
                        string = "\u0000";
                    } else {
                        CharSequence charSequence = (CharSequence)deserializationContext.handleUnexpectedToken(Character.TYPE, (JsonParser)object2);
                        string = charSequence.toString();
                    }
                    if (string.length() != 1) {
                        deserializationContext.reportInputMismatch((JsonDeserializer<?>)object, "Cannot convert a JSON String of length %d into a char element of char array", string.length());
                    }
                    stringBuilder.append(string.charAt(0));
                }
                return stringBuilder.toString().toCharArray();
            }
            if (((JsonParser)object2).hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
                Object object3 = ((JsonParser)object2).getEmbeddedObject();
                if (object3 == null) {
                    return null;
                }
                if (object3 instanceof char[]) {
                    return (char[])object3;
                }
                if (object3 instanceof String) {
                    return ((String)object3).toCharArray();
                }
                if (object3 instanceof byte[]) {
                    return Base64Variants.getDefaultVariant().encode((byte[])object3, false).toCharArray();
                }
            }
            return (char[])deserializationContext.handleUnexpectedToken(((StdDeserializer)object)._valueClass, (JsonParser)object2);
        }
    }
}

