/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;

public abstract class ReferenceTypeDeserializer<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    protected final JavaType _fullType;
    protected final ValueInstantiator _valueInstantiator;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final JsonDeserializer<Object> _valueDeserializer;

    public ReferenceTypeDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        super(javaType);
        this._valueInstantiator = valueInstantiator;
        this._fullType = javaType;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
    }

    @Deprecated
    public ReferenceTypeDeserializer(JavaType javaType, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        this(javaType, null, typeDeserializer, jsonDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext object, BeanProperty beanProperty) {
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        jsonDeserializer = (jsonDeserializer = this.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, jsonDeserializer)) == null ? ((DeserializationContext)object).findContextualValueDeserializer(this._fullType.getReferencedType(), beanProperty) : ((DeserializationContext)object).handleSecondaryContextualization(jsonDeserializer, beanProperty, this._fullType.getReferencedType());
        object = this._valueTypeDeserializer;
        if (object != null) {
            object = ((TypeDeserializer)object).forProperty(beanProperty);
        }
        if (jsonDeserializer == this._valueDeserializer && object == this._valueTypeDeserializer) {
            return this;
        }
        return this.withResolved((TypeDeserializer)object, jsonDeserializer);
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    protected abstract ReferenceTypeDeserializer<T> withResolved(TypeDeserializer var1, JsonDeserializer<?> var2);

    @Override
    public abstract T getNullValue(DeserializationContext var1);

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return ((JsonDeserializer)this).getNullValue(deserializationContext);
    }

    public abstract T referenceValue(Object var1);

    public abstract T updateReference(T var1, Object var2);

    public abstract Object getReferenced(T var1);

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public JavaType getValueType() {
        return this._fullType;
    }

    @Override
    public LogicalType logicalType() {
        if (this._valueDeserializer != null) {
            return this._valueDeserializer.logicalType();
        }
        return super.logicalType();
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        if (this._valueDeserializer == null) {
            return null;
        }
        return this._valueDeserializer.supportsUpdate(deserializationConfig);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._valueInstantiator != null) {
            Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
            return (T)((JsonDeserializer)this).deserialize(jsonParser, deserializationContext, object);
        }
        Object object = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(jsonParser, deserializationContext) : this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        return this.referenceValue(object);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, T t2) {
        Object object = this._valueDeserializer.supportsUpdate(deserializationContext.getConfig());
        if (((Boolean)object).equals(Boolean.FALSE) || this._valueTypeDeserializer != null) {
            object = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(jsonParser, deserializationContext) : this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        } else {
            object = this.getReferenced(t2);
            if (object == null) {
                object = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(jsonParser, deserializationContext) : this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
                return this.referenceValue(object);
            }
            object = this._valueDeserializer.deserialize(jsonParser, deserializationContext, object);
        }
        return this.updateReference(t2, object);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return ((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        if (this._valueTypeDeserializer == null) {
            return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
        }
        ReferenceTypeDeserializer referenceTypeDeserializer = this;
        return referenceTypeDeserializer.referenceValue(referenceTypeDeserializer._valueTypeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext));
    }
}

