/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.Collection;

public class StdDelegatingDeserializer<T>
extends StdDeserializer<T>
implements ContextualDeserializer,
ResolvableDeserializer {
    protected final Converter<Object, T> _converter;
    protected final JavaType _delegateType;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public StdDelegatingDeserializer(Converter<?, T> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateDeserializer = null;
    }

    public StdDelegatingDeserializer(Converter<Object, T> converter, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        super(javaType);
        this._converter = converter;
        this._delegateType = javaType;
        this._delegateDeserializer = jsonDeserializer;
    }

    protected StdDelegatingDeserializer(StdDelegatingDeserializer<T> stdDelegatingDeserializer) {
        super(stdDelegatingDeserializer);
        this._converter = stdDelegatingDeserializer._converter;
        this._delegateType = stdDelegatingDeserializer._delegateType;
        this._delegateDeserializer = stdDelegatingDeserializer._delegateDeserializer;
    }

    protected StdDelegatingDeserializer<T> withDelegate(Converter<Object, T> converter, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        ClassUtil.verifyMustOverride(StdDelegatingDeserializer.class, this, "withDelegate");
        return new StdDelegatingDeserializer<T>(converter, javaType, jsonDeserializer);
    }

    @Override
    public JsonDeserializer<T> unwrappingDeserializer(NameTransformer nameTransformer) {
        ClassUtil.verifyMustOverride(StdDelegatingDeserializer.class, this, "unwrappingDeserializer");
        StdDelegatingDeserializer stdDelegatingDeserializer = this;
        return ((JsonDeserializer)stdDelegatingDeserializer).replaceDelegatee(stdDelegatingDeserializer._delegateDeserializer.unwrappingDeserializer(nameTransformer));
    }

    @Override
    public JsonDeserializer<T> replaceDelegatee(JsonDeserializer<?> jsonDeserializer) {
        ClassUtil.verifyMustOverride(StdDelegatingDeserializer.class, this, "replaceDelegatee");
        if (jsonDeserializer == this._delegateDeserializer) {
            return this;
        }
        return new StdDelegatingDeserializer<T>(this._converter, this._delegateType, jsonDeserializer);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) {
        if (this._delegateDeserializer != null && this._delegateDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)this._delegateDeserializer)).resolve(deserializationContext);
        }
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        if (this._delegateDeserializer != null) {
            JsonDeserializer<?> jsonDeserializer = deserializationContext.handleSecondaryContextualization(this._delegateDeserializer, beanProperty, this._delegateType);
            if (jsonDeserializer != this._delegateDeserializer) {
                StdDelegatingDeserializer stdDelegatingDeserializer = this;
                return stdDelegatingDeserializer.withDelegate(stdDelegatingDeserializer._converter, this._delegateType, jsonDeserializer);
            }
            return this;
        }
        JavaType javaType = this._converter.getInputType(((DatabindContext)deserializationContext).getTypeFactory());
        StdDelegatingDeserializer stdDelegatingDeserializer = this;
        return stdDelegatingDeserializer.withDelegate(stdDelegatingDeserializer._converter, javaType, deserializationContext.findContextualValueDeserializer(javaType, beanProperty));
    }

    @Override
    public T deserialize(JsonParser object, DeserializationContext deserializationContext) {
        if ((object = this._delegateDeserializer.deserialize((JsonParser)object, deserializationContext)) == null) {
            return null;
        }
        return this.convertValue(object);
    }

    @Override
    public Object deserializeWithType(JsonParser object, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        if ((object = this._delegateDeserializer.deserialize((JsonParser)object, deserializationContext)) == null) {
            return null;
        }
        return this.convertValue(object);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        if (((ResolvedType)this._delegateType).getRawClass().isAssignableFrom(object.getClass())) {
            return (T)this._delegateDeserializer.deserialize(jsonParser, deserializationContext, object);
        }
        return (T)this._handleIncompatibleUpdateValue(jsonParser, deserializationContext, object);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer, T t2) {
        if (!((ResolvedType)this._delegateType).getRawClass().isAssignableFrom(t2.getClass())) {
            return this._handleIncompatibleUpdateValue(jsonParser, deserializationContext, t2);
        }
        return this._delegateDeserializer.deserialize(jsonParser, deserializationContext, t2);
    }

    protected Object _handleIncompatibleUpdateValue(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        throw new UnsupportedOperationException(String.format("Cannot update object of type %s (using deserializer for type %s)" + object.getClass().getName(), this._delegateType));
    }

    @Override
    public Class<?> handledType() {
        return this._delegateDeserializer.handledType();
    }

    @Override
    public LogicalType logicalType() {
        return this._delegateDeserializer.logicalType();
    }

    @Override
    public boolean isCachable() {
        return this._delegateDeserializer != null && this._delegateDeserializer.isCachable();
    }

    @Override
    public JsonDeserializer<?> getDelegatee() {
        return this._delegateDeserializer;
    }

    @Override
    public Collection<Object> getKnownPropertyNames() {
        return this._delegateDeserializer.getKnownPropertyNames();
    }

    @Override
    public T getNullValue(DeserializationContext deserializationContext) {
        StdDelegatingDeserializer stdDelegatingDeserializer = this;
        return stdDelegatingDeserializer._convertIfNonNull(stdDelegatingDeserializer._delegateDeserializer.getNullValue(deserializationContext));
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return this._delegateDeserializer.getNullAccessPattern();
    }

    @Override
    public Object getAbsentValue(DeserializationContext deserializationContext) {
        StdDelegatingDeserializer stdDelegatingDeserializer = this;
        return stdDelegatingDeserializer._convertIfNonNull(stdDelegatingDeserializer._delegateDeserializer.getAbsentValue(deserializationContext));
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        StdDelegatingDeserializer stdDelegatingDeserializer = this;
        return stdDelegatingDeserializer._convertIfNonNull(stdDelegatingDeserializer._delegateDeserializer.getEmptyValue(deserializationContext));
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return this._delegateDeserializer.getEmptyAccessPattern();
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._delegateDeserializer.supportsUpdate(deserializationConfig);
    }

    protected T convertValue(Object object) {
        return this._converter.convert(object);
    }

    protected T _convertIfNonNull(Object object) {
        if (object == null) {
            return null;
        }
        return this._converter.convert(object);
    }
}

