/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.NullsAsEmptyProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsFailProvider;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.util.Date;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements ValueInstantiator.Gettable,
Serializable {
    protected static final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    @Deprecated
    protected static final int F_MASK_ACCEPT_ARRAYS = DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS.getMask() | DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT.getMask();
    protected final Class<?> _valueClass;
    protected final JavaType _valueType;

    protected StdDeserializer(Class<?> clazz) {
        this._valueClass = clazz;
        this._valueType = null;
    }

    protected StdDeserializer(JavaType javaType) {
        this._valueClass = javaType == null ? Object.class : ((ResolvedType)javaType).getRawClass();
        this._valueType = javaType;
    }

    protected StdDeserializer(StdDeserializer<?> stdDeserializer) {
        this._valueClass = stdDeserializer._valueClass;
        this._valueType = stdDeserializer._valueType;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return this._valueType;
    }

    public JavaType getValueType(DeserializationContext deserializationContext) {
        if (this._valueType != null) {
            return this._valueType;
        }
        return deserializationContext.constructType(this._valueClass);
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> jsonDeserializer) {
        return ClassUtil.isJacksonStdImpl(jsonDeserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeserializer) {
        return ClassUtil.isJacksonStdImpl(keyDeserializer);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected T _deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        CoercionAction coercionAction = this._findCoercionFromEmptyArray(deserializationContext);
        boolean bl2 = deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (bl2 || coercionAction != CoercionAction.Fail) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                switch (coercionAction) {
                    case AsEmpty: {
                        return (T)this.getEmptyValue(deserializationContext);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return this.getNullValue(deserializationContext);
                    }
                }
            } else if (bl2) {
                coercionAction = this._deserializeWrappedValue(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return (T)((Object)coercionAction);
            }
        }
        return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
    }

    @Deprecated
    protected T _deserializeFromEmpty(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.START_ARRAY) && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
        }
        return (T)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    protected T _deserializeFromString(JsonParser jsonParser, DeserializationContext deserializationContext) {
        ValueInstantiator valueInstantiator = this.getValueInstantiator();
        Class<?> clazz = ((JsonDeserializer)this).handledType();
        String string = jsonParser.getValueAsString();
        if (valueInstantiator != null && valueInstantiator.canCreateFromString()) {
            return (T)valueInstantiator.createFromString(deserializationContext, string);
        }
        if (string.isEmpty()) {
            CoercionAction coercionAction = deserializationContext.findCoercionAction(this.logicalType(), clazz, CoercionInputShape.EmptyString);
            return (T)this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction, clazz, "empty String (\"\")");
        }
        if (StdDeserializer._isBlank(string)) {
            CoercionAction coercionAction = deserializationContext.findCoercionFromBlankString(this.logicalType(), clazz, CoercionAction.Fail);
            return (T)this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction, clazz, "blank String (all whitespace)");
        }
        if (valueInstantiator != null) {
            string = string.trim();
            if (valueInstantiator.canCreateFromInt() && deserializationContext.findCoercionAction(LogicalType.Integer, Integer.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                return (T)valueInstantiator.createFromInt(deserializationContext, this._parseIntPrimitive(deserializationContext, string));
            }
            if (valueInstantiator.canCreateFromLong() && deserializationContext.findCoercionAction(LogicalType.Integer, Long.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                return (T)valueInstantiator.createFromLong(deserializationContext, this._parseLongPrimitive(deserializationContext, string));
            }
            if (valueInstantiator.canCreateFromBoolean() && deserializationContext.findCoercionAction(LogicalType.Boolean, Boolean.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                String string2 = string.trim();
                if ("true".equals(string2)) {
                    return (T)valueInstantiator.createFromBoolean(deserializationContext, true);
                }
                if ("false".equals(string2)) {
                    return (T)valueInstantiator.createFromBoolean(deserializationContext, false);
                }
            }
        }
        return (T)deserializationContext.handleMissingInstantiator(clazz, valueInstantiator, deserializationContext.getParser(), "no String-argument constructor/factory method to deserialize from String value ('%s')", string);
    }

    protected Object _deserializeFromEmptyString(JsonParser jsonParser, DeserializationContext deserializationContext, CoercionAction coercionAction, Class<?> clazz, String string) {
        switch (coercionAction) {
            case AsEmpty: {
                return this.getEmptyValue(deserializationContext);
            }
            case Fail: {
                this._checkCoercionFail(deserializationContext, coercionAction, clazz, "", "empty String (\"\")");
            }
        }
        return null;
    }

    protected T _deserializeWrappedValue(JsonParser object, DeserializationContext deserializationContext) {
        if (((JsonParser)object).hasToken(JsonToken.START_ARRAY)) {
            object = this.handleNestedArrayForSingle((JsonParser)object, deserializationContext);
            return (T)object;
        }
        return this.deserialize((JsonParser)object, deserializationContext);
    }

    @Deprecated
    protected final boolean _parseBooleanPrimitive(DeserializationContext deserializationContext, JsonParser jsonParser, Class<?> clazz) {
        return this._parseBooleanPrimitive(jsonParser, deserializationContext);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser object, DeserializationContext deserializationContext) {
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 7: {
                return Boolean.TRUE.equals(this._coerceBooleanFromInt((JsonParser)object, deserializationContext, Boolean.TYPE));
            }
            case 9: {
                return true;
            }
            case 10: {
                return false;
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return false;
            }
            case 1: {
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, Boolean.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (((JsonParser)object).nextToken() == JsonToken.START_ARRAY) {
                        return (Boolean)this.handleNestedArrayForSingle((JsonParser)object, deserializationContext);
                    }
                    boolean bl2 = this._parseBooleanPrimitive((JsonParser)object, deserializationContext);
                    this._verifyEndArrayForSingle((JsonParser)object, deserializationContext);
                    return bl2;
                }
            }
            default: {
                return (Boolean)deserializationContext.handleUnexpectedToken(Boolean.TYPE, (JsonParser)object);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Boolean, Boolean.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return false;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return false;
        }
        int n2 = ((String)(object = ((String)object).trim())).length();
        if (n2 == 4) {
            if (this._isTrue((String)object)) {
                return true;
            }
        } else if (n2 == 5 && this._isFalse((String)object)) {
            return false;
        }
        if (this._hasTextualNull((String)object)) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, (String)object);
            return false;
        }
        object = (Boolean)deserializationContext.handleWeirdStringValue(Boolean.TYPE, (String)object, "only \"true\"/\"True\"/\"TRUE\" or \"false\"/\"False\"/\"FALSE\" recognized", new Object[0]);
        return Boolean.TRUE.equals(object);
    }

    protected boolean _isTrue(String string) {
        char c2 = string.charAt(0);
        if (c2 == 't') {
            return "true".equals(string);
        }
        if (c2 == 'T') {
            return "TRUE".equals(string) || "True".equals(string);
        }
        return false;
    }

    protected boolean _isFalse(String string) {
        char c2 = string.charAt(0);
        if (c2 == 'f') {
            return "false".equals(string);
        }
        if (c2 == 'F') {
            return "FALSE".equals(string) || "False".equals(string);
        }
        return false;
    }

    protected final Boolean _parseBoolean(JsonParser object, DeserializationContext deserializationContext, Class<?> clazz) {
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 7: {
                return this._coerceBooleanFromInt((JsonParser)object, deserializationContext, clazz);
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
            case 1: {
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, clazz);
                break;
            }
            case 3: {
                return (Boolean)this._deserializeFromArray((JsonParser)object, deserializationContext);
            }
            default: {
                return (Boolean)deserializationContext.handleUnexpectedToken(clazz, (JsonParser)object);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Boolean, clazz);
        if (coercionAction == CoercionAction.AsNull) {
            return null;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return Boolean.FALSE;
        }
        int n2 = ((String)(object = ((String)object).trim())).length();
        if (n2 == 4) {
            if (this._isTrue((String)object)) {
                return Boolean.TRUE;
            }
        } else if (n2 == 5 && this._isFalse((String)object)) {
            return Boolean.FALSE;
        }
        if (this._checkTextualNull(deserializationContext, (String)object)) {
            return null;
        }
        return (Boolean)deserializationContext.handleWeirdStringValue(clazz, (String)object, "only \"true\" or \"false\" recognized", new Object[0]);
    }

    protected final byte _parseBytePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        int n2;
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, Byte.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0;
                }
                return jsonParser.getByteValue();
            }
            case 7: {
                return jsonParser.getByteValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Byte.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return (Byte)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                    }
                    byte by = this._parseBytePrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return by;
                }
            }
            default: {
                DeserializationContext deserializationContext2 = deserializationContext;
                return (Byte)deserializationContext2.handleUnexpectedToken(deserializationContext2.constructType(Byte.TYPE), jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Byte.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return 0;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0;
        }
        jsonParser.streamReadConstraints().validateIntegerLength(string.length());
        try {
            n2 = NumberInput.parseInt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid `byte` value", new Object[0]);
        }
        if (this._byteOverflow(n2)) {
            return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "overflow, value cannot be represented as 8-bit value", new Object[0]);
        }
        return (byte)n2;
    }

    protected final short _parseShortPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        int n2;
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, Short.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0;
                }
                return jsonParser.getShortValue();
            }
            case 7: {
                return jsonParser.getShortValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Short.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return (Short)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                    }
                    short s2 = this._parseShortPrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return s2;
                }
            }
            default: {
                DeserializationContext deserializationContext2 = deserializationContext;
                return (Short)deserializationContext2.handleUnexpectedToken(deserializationContext2.constructType(Short.TYPE), jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Short.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return 0;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0;
        }
        jsonParser.streamReadConstraints().validateIntegerLength(string.length());
        try {
            n2 = NumberInput.parseInt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Short)deserializationContext.handleWeirdStringValue(Short.TYPE, string, "not a valid `short` value", new Object[0]);
        }
        if (this._shortOverflow(n2)) {
            return (Short)deserializationContext.handleWeirdStringValue(Short.TYPE, string, "overflow, value cannot be represented as 16-bit value", new Object[0]);
        }
        return (short)n2;
    }

    protected final int _parseIntPrimitive(JsonParser object, DeserializationContext deserializationContext) {
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, Integer.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0;
                }
                return ((JsonParser)object).getValueAsInt();
            }
            case 7: {
                return ((JsonParser)object).getIntValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0;
            }
            case 1: {
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, Integer.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (((JsonParser)object).nextToken() == JsonToken.START_ARRAY) {
                        return (Integer)this.handleNestedArrayForSingle((JsonParser)object, deserializationContext);
                    }
                    int n2 = this._parseIntPrimitive((JsonParser)object, deserializationContext);
                    this._verifyEndArrayForSingle((JsonParser)object, deserializationContext);
                    return n2;
                }
            }
            default: {
                return ((Number)deserializationContext.handleUnexpectedToken(Integer.TYPE, (JsonParser)object)).intValue();
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Integer, Integer.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return 0;
        }
        if (this._hasTextualNull((String)(object = ((String)object).trim()))) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, (String)object);
            return 0;
        }
        return this._parseIntPrimitive(deserializationContext, (String)object);
    }

    protected final int _parseIntPrimitive(DeserializationContext deserializationContext, String string) {
        block3: {
            long l2;
            block4: {
                try {
                    if (string.length() <= 9) break block3;
                    deserializationContext.getParser().streamReadConstraints().validateIntegerLength(string.length());
                    l2 = NumberInput.parseLong(string);
                    if (!this._intOverflow(l2)) break block4;
                    Number number = (Number)deserializationContext.handleWeirdStringValue(Integer.TYPE, string, "Overflow: numeric value (%s) out of range of int (%d -%d)", string, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    return this._nonNullNumber(number).intValue();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Number number = (Number)deserializationContext.handleWeirdStringValue(Integer.TYPE, string, "not a valid `int` value", new Object[0]);
                    return this._nonNullNumber(number).intValue();
                }
            }
            return (int)l2;
        }
        return NumberInput.parseInt(string);
    }

    protected final Integer _parseInteger(JsonParser object, DeserializationContext deserializationContext, Class<?> object2) {
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 8: {
                object2 = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, (Class<?>)object2);
                if (object2 == CoercionAction.AsNull) {
                    return (Integer)this.getNullValue(deserializationContext);
                }
                if (object2 == CoercionAction.AsEmpty) {
                    return (Integer)this.getEmptyValue(deserializationContext);
                }
                return ((JsonParser)object).getValueAsInt();
            }
            case 7: {
                return ((JsonParser)object).getIntValue();
            }
            case 11: {
                return (Integer)this.getNullValue(deserializationContext);
            }
            case 1: {
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, (Class<?>)object2);
                break;
            }
            case 3: {
                return (Integer)this._deserializeFromArray((JsonParser)object, deserializationContext);
            }
            default: {
                return (Integer)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
            }
        }
        object2 = this._checkFromStringCoercion(deserializationContext, (String)object);
        if (object2 == CoercionAction.AsNull) {
            return (Integer)this.getNullValue(deserializationContext);
        }
        if (object2 == CoercionAction.AsEmpty) {
            return (Integer)this.getEmptyValue(deserializationContext);
        }
        if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
            return (Integer)this.getNullValue(deserializationContext);
        }
        return this._parseInteger(deserializationContext, (String)object);
    }

    protected final Integer _parseInteger(DeserializationContext deserializationContext, String string) {
        try {
            if (string.length() > 9) {
                deserializationContext.getParser().streamReadConstraints().validateIntegerLength(string.length());
                long l2 = NumberInput.parseLong(string);
                if (this._intOverflow(l2)) {
                    return (Integer)deserializationContext.handleWeirdStringValue(Integer.class, string, "Overflow: numeric value (%s) out of range of `java.lang.Integer` (%d -%d)", string, Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
                return (int)l2;
            }
            return NumberInput.parseInt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Integer)deserializationContext.handleWeirdStringValue(Integer.class, string, "not a valid `java.lang.Integer` value", new Object[0]);
        }
    }

    protected final long _parseLongPrimitive(JsonParser object, DeserializationContext deserializationContext) {
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, Long.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0L;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0L;
                }
                return ((JsonParser)object).getValueAsLong();
            }
            case 7: {
                return ((JsonParser)object).getLongValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0L;
            }
            case 1: {
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, Long.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (((JsonParser)object).nextToken() == JsonToken.START_ARRAY) {
                        return (Long)this.handleNestedArrayForSingle((JsonParser)object, deserializationContext);
                    }
                    long l2 = this._parseLongPrimitive((JsonParser)object, deserializationContext);
                    this._verifyEndArrayForSingle((JsonParser)object, deserializationContext);
                    return l2;
                }
            }
            default: {
                return ((Number)deserializationContext.handleUnexpectedToken(Long.TYPE, (JsonParser)object)).longValue();
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object, LogicalType.Integer, Long.TYPE);
        if (coercionAction == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0L;
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return 0L;
        }
        if (this._hasTextualNull((String)(object = ((String)object).trim()))) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, (String)object);
            return 0L;
        }
        return this._parseLongPrimitive(deserializationContext, (String)object);
    }

    protected final long _parseLongPrimitive(DeserializationContext serializable, String string) {
        serializable.getParser().streamReadConstraints().validateIntegerLength(string.length());
        try {
            return NumberInput.parseLong(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            serializable = (Number)serializable.handleWeirdStringValue(Long.TYPE, string, "not a valid `long` value", new Object[0]);
            return this._nonNullNumber((Number)serializable).longValue();
        }
    }

    protected final Long _parseLong(JsonParser object, DeserializationContext deserializationContext, Class<?> object2) {
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 8: {
                object2 = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, (Class<?>)object2);
                if (object2 == CoercionAction.AsNull) {
                    return (Long)this.getNullValue(deserializationContext);
                }
                if (object2 == CoercionAction.AsEmpty) {
                    return (Long)this.getEmptyValue(deserializationContext);
                }
                return ((JsonParser)object).getValueAsLong();
            }
            case 11: {
                return (Long)this.getNullValue(deserializationContext);
            }
            case 7: {
                return ((JsonParser)object).getLongValue();
            }
            case 1: {
                object = deserializationContext.extractScalarFromObject((JsonParser)object, this, (Class<?>)object2);
                break;
            }
            case 3: {
                return (Long)this._deserializeFromArray((JsonParser)object, deserializationContext);
            }
            default: {
                return (Long)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
            }
        }
        object2 = this._checkFromStringCoercion(deserializationContext, (String)object);
        if (object2 == CoercionAction.AsNull) {
            return (Long)this.getNullValue(deserializationContext);
        }
        if (object2 == CoercionAction.AsEmpty) {
            return (Long)this.getEmptyValue(deserializationContext);
        }
        if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
            return (Long)this.getNullValue(deserializationContext);
        }
        return this._parseLong(deserializationContext, (String)object);
    }

    protected final Long _parseLong(DeserializationContext deserializationContext, String string) {
        deserializationContext.getParser().streamReadConstraints().validateIntegerLength(string.length());
        try {
            return NumberInput.parseLong(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Long)deserializationContext.handleWeirdStringValue(Long.class, string, "not a valid `java.lang.Long` value", new Object[0]);
        }
    }

    protected final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 7: {
                CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, Float.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0.0f;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0.0f;
                }
            }
            case 8: {
                return jsonParser.getFloatValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0.0f;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Float.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return ((Float)this.handleNestedArrayForSingle(jsonParser, deserializationContext)).floatValue();
                    }
                    float f2 = this._parseFloatPrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return f2;
                }
            }
            default: {
                return ((Number)deserializationContext.handleUnexpectedToken(Float.TYPE, jsonParser)).floatValue();
            }
        }
        Object object = this._checkFloatSpecialValue(string);
        if (object != null) {
            return object.floatValue();
        }
        object = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Float.TYPE);
        if (object == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0.0f;
        }
        if (object == CoercionAction.AsEmpty) {
            return 0.0f;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0.0f;
        }
        return this._parseFloatPrimitive(jsonParser, deserializationContext, string);
    }

    @Deprecated
    protected final float _parseFloatPrimitive(DeserializationContext serializable, String string) {
        if (NumberInput.looksLikeValidNumber(string)) {
            serializable.getParser().streamReadConstraints().validateFPLength(string.length());
            try {
                return NumberInput.parseFloat(string, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        serializable = (Number)serializable.handleWeirdStringValue(Float.TYPE, string, "not a valid `float` value", new Object[0]);
        return this._nonNullNumber((Number)serializable).floatValue();
    }

    protected final float _parseFloatPrimitive(JsonParser object, DeserializationContext deserializationContext, String string) {
        if (NumberInput.looksLikeValidNumber(string)) {
            deserializationContext.getParser().streamReadConstraints().validateFPLength(string.length());
            try {
                return NumberInput.parseFloat(string, ((JsonParser)object).isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        object = (Number)deserializationContext.handleWeirdStringValue(Float.TYPE, string, "not a valid `float` value", new Object[0]);
        return this._nonNullNumber((Number)object).floatValue();
    }

    protected Float _checkFloatSpecialValue(String string) {
        if (!string.isEmpty()) {
            switch (string.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(string)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!this._isNaN(string)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!this._isNegInf(string)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
        }
        return null;
    }

    protected final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 7: {
                CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, Double.TYPE);
                if (coercionAction == CoercionAction.AsNull) {
                    return 0.0;
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return 0.0;
                }
            }
            case 8: {
                return jsonParser.getDoubleValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0.0;
            }
            case 1: {
                string = deserializationContext.extractScalarFromObject(jsonParser, this, Double.TYPE);
                break;
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    if (jsonParser.nextToken() == JsonToken.START_ARRAY) {
                        return (Double)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                    }
                    double d2 = this._parseDoublePrimitive(jsonParser, deserializationContext);
                    this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                    return d2;
                }
            }
            default: {
                return ((Number)deserializationContext.handleUnexpectedToken(Double.TYPE, jsonParser)).doubleValue();
            }
        }
        Object object = this._checkDoubleSpecialValue(string);
        if (object != null) {
            return object;
        }
        object = this._checkFromStringCoercion(deserializationContext, string, LogicalType.Integer, Double.TYPE);
        if (object == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(deserializationContext);
            return 0.0;
        }
        if (object == CoercionAction.AsEmpty) {
            return 0.0;
        }
        if (this._hasTextualNull(string = string.trim())) {
            this._verifyNullForPrimitiveCoercion(deserializationContext, string);
            return 0.0;
        }
        return this._parseDoublePrimitive(jsonParser, deserializationContext, string);
    }

    protected final double _parseDoublePrimitive(DeserializationContext serializable, String string) {
        try {
            return StdDeserializer._parseDouble(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            serializable = (Number)serializable.handleWeirdStringValue(Double.TYPE, string, "not a valid `double` value (as String to convert)", new Object[0]);
            return this._nonNullNumber((Number)serializable).doubleValue();
        }
    }

    protected final double _parseDoublePrimitive(JsonParser object, DeserializationContext deserializationContext, String string) {
        try {
            return StdDeserializer._parseDouble(string, ((JsonParser)object).isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = (Number)deserializationContext.handleWeirdStringValue(Double.TYPE, string, "not a valid `double` value (as String to convert)", new Object[0]);
            return this._nonNullNumber((Number)object).doubleValue();
        }
    }

    protected static final double _parseDouble(String string) {
        return StdDeserializer._parseDouble(string, false);
    }

    protected static final double _parseDouble(String string, boolean bl2) {
        return NumberInput.parseDouble(string, bl2);
    }

    protected Double _checkDoubleSpecialValue(String string) {
        if (!string.isEmpty()) {
            switch (string.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
        }
        return null;
    }

    protected Date _parseDate(JsonParser object, DeserializationContext deserializationContext) {
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 7: {
                long l2;
                try {
                    l2 = ((JsonParser)object).getLongValue();
                }
                catch (StreamReadException streamReadException) {
                    object = (Number)deserializationContext.handleWeirdNumberValue(this._valueClass, ((JsonParser)object).getNumberValue(), "not a valid 64-bit `long` for creating `java.util.Date`", new Object[0]);
                    l2 = ((Number)object).longValue();
                }
                return new Date(l2);
            }
            case 11: {
                return (Date)this.getNullValue(deserializationContext);
            }
            case 1: {
                StdDeserializer stdDeserializer = this;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, stdDeserializer, stdDeserializer._valueClass);
                break;
            }
            case 3: {
                return this._parseDateFromArray((JsonParser)object, deserializationContext);
            }
            default: {
                return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, (JsonParser)object);
            }
        }
        return this._parseDate(((String)object).trim(), deserializationContext);
    }

    protected Date _parseDateFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object = this._findCoercionFromEmptyArray(deserializationContext);
        boolean bl2 = deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (bl2 || object != CoercionAction.Fail) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                switch (object) {
                    case AsEmpty: {
                        return (Date)this.getEmptyValue(deserializationContext);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return (Date)this.getNullValue(deserializationContext);
                    }
                }
            } else if (bl2) {
                if (jsonToken == JsonToken.START_ARRAY) {
                    return (Date)this.handleNestedArrayForSingle(jsonParser, deserializationContext);
                }
                object = this._parseDate(jsonParser, deserializationContext);
                this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                return object;
            }
        }
        return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, JsonToken.START_ARRAY, jsonParser, null, new Object[0]);
    }

    protected Date _parseDate(String string, DeserializationContext deserializationContext) {
        block7: {
            try {
                if (!string.isEmpty()) break block7;
                CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
                switch (coercionAction) {
                    case AsEmpty: {
                        return new Date(0L);
                    }
                }
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Date)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation (error: %s)", ClassUtil.exceptionMessage(illegalArgumentException));
            }
        }
        if (this._hasTextualNull(string)) {
            return null;
        }
        return deserializationContext.parseDate(string);
    }

    @Deprecated
    protected final String _parseString(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this._parseString(jsonParser, deserializationContext, NullsConstantProvider.nuller());
    }

    protected final String _parseString(JsonParser jsonParser, DeserializationContext deserializationContext, NullValueProvider object) {
        CoercionAction coercionAction = CoercionAction.TryConvert;
        Class<String> clazz = String.class;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                return jsonParser.getText();
            }
            case 12: {
                object = jsonParser.getEmbeddedObject();
                if (object instanceof byte[]) {
                    return deserializationContext.getBase64Variant().encode((byte[])object, false);
                }
                if (object == null) {
                    return null;
                }
                return object.toString();
            }
            case 1: {
                return deserializationContext.extractScalarFromObject(jsonParser, this, clazz);
            }
            case 7: {
                coercionAction = this._checkIntToStringCoercion(jsonParser, deserializationContext, clazz);
                break;
            }
            case 8: {
                coercionAction = this._checkFloatToStringCoercion(jsonParser, deserializationContext, clazz);
                break;
            }
            case 9: 
            case 10: {
                coercionAction = this._checkBooleanToStringCoercion(jsonParser, deserializationContext, clazz);
            }
        }
        if (coercionAction == CoercionAction.AsNull) {
            return (String)object.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return "";
        }
        if (jsonParser.currentToken().isScalarValue() && (object = jsonParser.getValueAsString()) != null) {
            return object;
        }
        return (String)deserializationContext.handleUnexpectedToken(clazz, jsonParser);
    }

    protected boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    protected final boolean _isNegInf(String string) {
        return "-Infinity".equals(string) || "-INF".equals(string);
    }

    protected final boolean _isPosInf(String string) {
        return "Infinity".equals(string) || "INF".equals(string);
    }

    protected final boolean _isNaN(String string) {
        return "NaN".equals(string);
    }

    protected static final boolean _isBlank(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) <= ' ') continue;
            return false;
        }
        return true;
    }

    protected CoercionAction _checkFromStringCoercion(DeserializationContext deserializationContext, String string) {
        return this._checkFromStringCoercion(deserializationContext, string, this.logicalType(), ((JsonDeserializer)this).handledType());
    }

    protected CoercionAction _checkFromStringCoercion(DeserializationContext deserializationContext, String string, LogicalType enum_, Class<?> clazz) {
        if (string.isEmpty()) {
            enum_ = deserializationContext.findCoercionAction((LogicalType)enum_, clazz, CoercionInputShape.EmptyString);
            return this._checkCoercionFail(deserializationContext, (CoercionAction)enum_, clazz, string, "empty String (\"\")");
        }
        if (StdDeserializer._isBlank(string)) {
            enum_ = deserializationContext.findCoercionFromBlankString((LogicalType)enum_, clazz, CoercionAction.Fail);
            return this._checkCoercionFail(deserializationContext, (CoercionAction)enum_, clazz, string, "blank String (all whitespace)");
        }
        if (deserializationContext.isEnabled(StreamReadCapability.UNTYPED_SCALARS)) {
            return CoercionAction.TryConvert;
        }
        if ((enum_ = deserializationContext.findCoercionAction((LogicalType)enum_, clazz, CoercionInputShape.String)) == CoercionAction.Fail) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce String value (\"%s\") to %s (but might if coercion using `CoercionConfig` was enabled)", string, this._coercedTypeDesc());
        }
        return enum_;
    }

    protected CoercionAction _checkFloatToIntCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Integer, clazz, CoercionInputShape.Float);
        if (coercionAction == CoercionAction.Fail) {
            return this._checkCoercionFail(deserializationContext, coercionAction, clazz, jsonParser.getNumberValue(), "Floating-point value (" + jsonParser.getText() + ")");
        }
        return coercionAction;
    }

    protected CoercionAction _checkIntToStringCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) {
        return this._checkToStringCoercion(jsonParser, deserializationContext, clazz, jsonParser.getNumberValue(), CoercionInputShape.Integer);
    }

    protected CoercionAction _checkFloatToStringCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) {
        return this._checkToStringCoercion(jsonParser, deserializationContext, clazz, jsonParser.getNumberValue(), CoercionInputShape.Float);
    }

    protected CoercionAction _checkBooleanToStringCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) {
        return this._checkToStringCoercion(jsonParser, deserializationContext, clazz, jsonParser.getBooleanValue(), CoercionInputShape.Boolean);
    }

    protected CoercionAction _checkToStringCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz, Object object, CoercionInputShape coercionInputShape) {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Textual, clazz, coercionInputShape);
        if (coercionAction == CoercionAction.Fail) {
            return this._checkCoercionFail(deserializationContext, coercionAction, clazz, object, coercionInputShape.name() + " value (" + jsonParser.getText() + ")");
        }
        return coercionAction;
    }

    protected CoercionAction _checkIntToFloatCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Float, clazz, CoercionInputShape.Integer);
        if (coercionAction == CoercionAction.Fail) {
            return this._checkCoercionFail(deserializationContext, coercionAction, clazz, jsonParser.getNumberValue(), "Integer value (" + jsonParser.getText() + ")");
        }
        return coercionAction;
    }

    protected Boolean _coerceBooleanFromInt(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(LogicalType.Boolean, clazz, CoercionInputShape.Integer);
        switch (coercionAction) {
            case Fail: {
                this._checkCoercionFail(deserializationContext, coercionAction, clazz, jsonParser.getNumberValue(), "Integer value (" + jsonParser.getText() + ")");
                return Boolean.FALSE;
            }
            case AsNull: {
                return null;
            }
            case AsEmpty: {
                return Boolean.FALSE;
            }
        }
        if (jsonParser.getNumberType() == JsonParser.NumberType.INT) {
            return jsonParser.getIntValue() != 0;
        }
        return !"0".equals(jsonParser.getText());
    }

    protected CoercionAction _checkCoercionFail(DeserializationContext deserializationContext, CoercionAction coercionAction, Class<?> clazz, Object object, String string) {
        if (coercionAction == CoercionAction.Fail) {
            deserializationContext.reportBadCoercion(this, clazz, object, "Cannot coerce %s to %s (but could if coercion was enabled using `CoercionConfig`)", string, this._coercedTypeDesc(clazz));
        }
        return coercionAction;
    }

    protected boolean _checkTextualNull(DeserializationContext deserializationContext, String string) {
        if (this._hasTextualNull(string)) {
            if (!((DatabindContext)deserializationContext).isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
                this._reportFailedNullCoerce(deserializationContext, true, MapperFeature.ALLOW_COERCION_OF_SCALARS, "String \"null\"");
            }
            return true;
        }
        return false;
    }

    protected Object _coerceIntegral(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
            return jsonParser.getBigIntegerValue();
        }
        if (deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS)) {
            return jsonParser.getLongValue();
        }
        return jsonParser.getNumberValue();
    }

    protected final void _verifyNullForPrimitive(DeserializationContext deserializationContext) {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce `null` to %s (disable `DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES` to allow)", this._coercedTypeDesc());
        }
    }

    protected final void _verifyNullForPrimitiveCoercion(DeserializationContext deserializationContext, String string) {
        boolean bl2;
        Enum enum_;
        if (!((DatabindContext)deserializationContext).isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            enum_ = MapperFeature.ALLOW_COERCION_OF_SCALARS;
            bl2 = true;
        } else if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            enum_ = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES;
            bl2 = false;
        } else {
            return;
        }
        string = string.isEmpty() ? "empty String (\"\")" : String.format("String \"%s\"", string);
        this._reportFailedNullCoerce(deserializationContext, bl2, enum_, string);
    }

    protected void _reportFailedNullCoerce(DeserializationContext deserializationContext, boolean bl2, Enum<?> enum_, String string) {
        String string2 = bl2 ? "enable" : "disable";
        deserializationContext.reportInputMismatch(this, "Cannot coerce %s to Null value as %s (%s `%s.%s` to allow)", string, this._coercedTypeDesc(), string2, enum_.getDeclaringClass().getSimpleName(), enum_.name());
    }

    protected String _coercedTypeDesc() {
        boolean bl2;
        Object object = this.getValueType();
        if (object != null && !((ResolvedType)object).isPrimitive()) {
            bl2 = ((ResolvedType)object).isContainerType() || ((ResolvedType)object).isReferenceType();
            object = ClassUtil.getTypeDescription((JavaType)object);
        } else {
            object = ((JsonDeserializer)this).handledType();
            bl2 = ClassUtil.isCollectionMapOrArray(object);
            object = ClassUtil.getClassDescription(object);
        }
        if (bl2) {
            return "element of " + (String)object;
        }
        return (String)object + " value";
    }

    protected String _coercedTypeDesc(Class<?> clazz) {
        String string = ClassUtil.getClassDescription(clazz);
        if (ClassUtil.isCollectionMapOrArray(clazz)) {
            return "element of " + string;
        }
        return string + " value";
    }

    @Deprecated
    protected boolean _parseBooleanFromInt(JsonParser jsonParser, DeserializationContext deserializationContext) {
        this._verifyNumberForScalarCoercion(deserializationContext, jsonParser);
        return !"0".equals(jsonParser.getText());
    }

    @Deprecated
    protected void _verifyStringForScalarCoercion(DeserializationContext deserializationContext, String string) {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!((DatabindContext)deserializationContext).isEnabled(mapperFeature)) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce String \"%s\" to %s (enable `%s.%s` to allow)", string, this._coercedTypeDesc(), mapperFeature.getDeclaringClass().getSimpleName(), mapperFeature.name());
        }
    }

    @Deprecated
    protected Object _coerceEmptyString(DeserializationContext deserializationContext, boolean bl2) {
        boolean bl3;
        Enum enum_;
        if (!((DatabindContext)deserializationContext).isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            enum_ = MapperFeature.ALLOW_COERCION_OF_SCALARS;
            bl3 = true;
        } else if (bl2 && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            enum_ = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES;
            bl3 = false;
        } else {
            return this.getNullValue(deserializationContext);
        }
        this._reportFailedNullCoerce(deserializationContext, bl3, enum_, "empty String (\"\")");
        return null;
    }

    @Deprecated
    protected void _failDoubleToIntCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, String string) {
        deserializationContext.reportInputMismatch(((JsonDeserializer)this).handledType(), "Cannot coerce a floating-point value ('%s') into %s (enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow)", jsonParser.getValueAsString(), string);
    }

    @Deprecated
    protected final void _verifyNullForScalarCoercion(DeserializationContext deserializationContext, String string) {
        if (!((DatabindContext)deserializationContext).isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            string = string.isEmpty() ? "empty String (\"\")" : String.format("String \"%s\"", string);
            this._reportFailedNullCoerce(deserializationContext, true, MapperFeature.ALLOW_COERCION_OF_SCALARS, string);
        }
    }

    @Deprecated
    protected void _verifyNumberForScalarCoercion(DeserializationContext deserializationContext, JsonParser object) {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!((DatabindContext)deserializationContext).isEnabled(mapperFeature)) {
            object = ((JsonParser)object).getText();
            deserializationContext.reportInputMismatch(this, "Cannot coerce Number (%s) to %s (enable `%s.%s` to allow)", object, this._coercedTypeDesc(), mapperFeature.getDeclaringClass().getSimpleName(), mapperFeature.name());
        }
    }

    @Deprecated
    protected Object _coerceNullToken(DeserializationContext deserializationContext, boolean bl2) {
        if (bl2) {
            this._verifyNullForPrimitive(deserializationContext);
        }
        return this.getNullValue(deserializationContext);
    }

    @Deprecated
    protected Object _coerceTextualNull(DeserializationContext deserializationContext, boolean bl2) {
        if (!((DatabindContext)deserializationContext).isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            this._reportFailedNullCoerce(deserializationContext, true, MapperFeature.ALLOW_COERCION_OF_SCALARS, "String \"null\"");
        }
        return this.getNullValue(deserializationContext);
    }

    @Deprecated
    protected boolean _isEmptyOrTextualNull(String string) {
        return string.isEmpty() || "null".equals(string);
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanProperty beanProperty) {
        return deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
    }

    protected final boolean _isIntNumber(String string) {
        int n2 = string.length();
        if (n2 > 0) {
            int n3 = string.charAt(0);
            if (n3 == 45 || n3 == 43) {
                if (n2 == 1) {
                    return false;
                }
                n3 = 1;
            } else {
                n3 = 0;
            }
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                if (c2 > '9' || c2 < '0') {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) {
        Serializable serializable;
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (StdDeserializer._neitherNull(object, beanProperty) && (serializable = beanProperty.getMember()) != null && (object = ((AnnotationIntrospector)object).findDeserializationContentConverter((AnnotatedMember)serializable)) != null) {
            object = deserializationContext.converterInstance(beanProperty.getMember(), object);
            serializable = object.getInputType(((DatabindContext)deserializationContext).getTypeFactory());
            if (jsonDeserializer == null) {
                jsonDeserializer = deserializationContext.findContextualValueDeserializer((JavaType)serializable, beanProperty);
            }
            return new StdDelegatingDeserializer<Object>((Converter<Object, Object>)object, (JavaType)serializable, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected JsonFormat.Value findFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyFormat(deserializationContext.getConfig(), clazz);
        }
        return ((DatabindContext)deserializationContext).getDefaultPropertyFormat(clazz);
    }

    protected Boolean findFormatFeature(DeserializationContext serializable, BeanProperty beanProperty, Class<?> clazz, JsonFormat.Feature feature) {
        if ((serializable = this.findFormatOverrides((DeserializationContext)serializable, beanProperty, clazz)) != null) {
            return ((JsonFormat.Value)serializable).getFeature(feature);
        }
        return null;
    }

    protected final NullValueProvider findValueNullProvider(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty, PropertyMetadata propertyMetadata) {
        if (settableBeanProperty != null) {
            return this._findNullProvider(deserializationContext, settableBeanProperty, propertyMetadata.getValueNulls(), settableBeanProperty.getValueDeserializer());
        }
        return null;
    }

    protected NullValueProvider findContentNullProvider(DeserializationContext object, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) {
        Nulls nulls = this.findContentNullStyle((DeserializationContext)object, beanProperty);
        if (nulls == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        if (nulls == Nulls.FAIL) {
            if (beanProperty == null) {
                if (((ResolvedType)(object = ((DeserializationContext)object).constructType(jsonDeserializer.handledType()))).isContainerType()) {
                    object = ((JavaType)object).getContentType();
                }
                return NullsFailProvider.constructForRootValue((JavaType)object);
            }
            BeanProperty beanProperty2 = beanProperty;
            return NullsFailProvider.constructForProperty(beanProperty2, beanProperty2.getType().getContentType());
        }
        if ((object = this._findNullProvider((DeserializationContext)object, beanProperty, nulls, jsonDeserializer)) != null) {
            return object;
        }
        return jsonDeserializer;
    }

    protected Nulls findContentNullStyle(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        if (beanProperty != null) {
            return beanProperty.getMetadata().getContentNulls();
        }
        return ((MapperConfig)deserializationContext.getConfig()).getDefaultSetterInfo().getContentNulls();
    }

    protected final NullValueProvider _findNullProvider(DeserializationContext deserializationContext, BeanProperty object, Nulls object2, JsonDeserializer<?> jsonDeserializer) {
        if (object2 == Nulls.FAIL) {
            if (object == null) {
                object2 = jsonDeserializer == null ? Object.class : jsonDeserializer.handledType();
                return NullsFailProvider.constructForRootValue(deserializationContext.constructType((Class<?>)object2));
            }
            return NullsFailProvider.constructForProperty((BeanProperty)object);
        }
        if (object2 == Nulls.AS_EMPTY) {
            ValueInstantiator valueInstantiator;
            if (jsonDeserializer == null) {
                return null;
            }
            if (jsonDeserializer instanceof BeanDeserializerBase && !(valueInstantiator = ((StdDeserializer)(object2 = (BeanDeserializerBase)jsonDeserializer)).getValueInstantiator()).canCreateUsingDefault()) {
                object = object == null ? ((StdDeserializer)object2).getValueType() : object.getType();
                return (NullValueProvider)((DatabindContext)deserializationContext).reportBadDefinition((JavaType)object, String.format("Cannot create empty instance of %s, no default Creator", object));
            }
            object2 = jsonDeserializer.getEmptyAccessPattern();
            if (object2 == AccessPattern.ALWAYS_NULL) {
                return NullsConstantProvider.nuller();
            }
            if (object2 == AccessPattern.CONSTANT) {
                return NullsConstantProvider.forValue(jsonDeserializer.getEmptyValue(deserializationContext));
            }
            return new NullsAsEmptyProvider(jsonDeserializer);
        }
        if (object2 == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        return null;
    }

    protected CoercionAction _findCoercionFromEmptyString(DeserializationContext deserializationContext) {
        return deserializationContext.findCoercionAction(this.logicalType(), ((JsonDeserializer)this).handledType(), CoercionInputShape.EmptyString);
    }

    protected CoercionAction _findCoercionFromEmptyArray(DeserializationContext deserializationContext) {
        return deserializationContext.findCoercionAction(this.logicalType(), ((JsonDeserializer)this).handledType(), CoercionInputShape.EmptyArray);
    }

    protected CoercionAction _findCoercionFromBlankString(DeserializationContext deserializationContext) {
        return deserializationContext.findCoercionFromBlankString(this.logicalType(), ((JsonDeserializer)this).handledType(), CoercionAction.Fail);
    }

    protected void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object clazz, String string) {
        if (clazz == null) {
            clazz = ((JsonDeserializer)this).handledType();
        }
        if (deserializationContext.handleUnknownProperty(jsonParser, this, clazz, string)) {
            return;
        }
        jsonParser.skipChildren();
    }

    protected void handleMissingEndArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) {
        deserializationContext.reportWrongTokenException(this, JsonToken.END_ARRAY, "Attempted to unwrap '%s' value from an array (with `DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS`) but it contains more than one value", ((JsonDeserializer)this).handledType().getName());
    }

    protected Object handleNestedArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) {
        String string = String.format("Cannot deserialize instance of %s out of %s token: nested Arrays not allowed with %s", new Object[]{ClassUtil.nameOf(this._valueClass), JsonToken.START_ARRAY, "DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS"});
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser.currentToken(), jsonParser, string, new Object[0]);
    }

    protected void _verifyEndArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != JsonToken.END_ARRAY) {
            this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
        }
    }

    protected static final boolean _neitherNull(Object object, Object object2) {
        return object != null && object2 != null;
    }

    protected final boolean _byteOverflow(int n2) {
        return n2 < -128 || n2 > 255;
    }

    protected final boolean _shortOverflow(int n2) {
        return n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE;
    }

    protected final boolean _intOverflow(long l2) {
        return l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE;
    }

    protected Number _nonNullNumber(Number number) {
        if (number == null) {
            number = 0;
        }
        return number;
    }
}

