/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedAndMetadata;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new StdKeyDeserializer.b(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod annotatedMethod) {
        return new StdKeyDeserializer.b(enumResolver, annotatedMethod);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, EnumResolver enumResolver2, EnumResolver enumResolver3, EnumResolver enumResolver4) {
        return new StdKeyDeserializer.b(enumResolver, null, enumResolver2, enumResolver3, enumResolver4);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod annotatedMethod, EnumResolver enumResolver2, EnumResolver enumResolver3, EnumResolver enumResolver4) {
        return new StdKeyDeserializer.b(enumResolver, annotatedMethod, enumResolver2, enumResolver3, enumResolver4);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        return new StdKeyDeserializer.a(((ResolvedType)javaType).getRawClass(), jsonDeserializer);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig serializable, JavaType list) {
        AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> annotatedAndMetadata2;
        AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> annotatedAndMetadata3;
        block7: {
            list = ((DeserializationConfig)serializable).introspectForCreation((JavaType)((Object)list));
            BeanDescription object22 = list;
            for (AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> annotatedAndMetadata4 : ((BeanDescription)((Object)list)).getConstructorsWithMode()) {
                Object object2 = (AnnotatedConstructor)annotatedAndMetadata4.annotated;
                if (((AnnotatedWithParams)object2).getParameterCount() != 1 || String.class != ((AnnotatedWithParams)object2).getRawParameterType(0)) continue;
                annotatedAndMetadata3 = annotatedAndMetadata4;
                break block7;
            }
            annotatedAndMetadata3 = annotatedAndMetadata2 = null;
        }
        if (annotatedAndMetadata3 != null && annotatedAndMetadata2.metadata != null) {
            return StdKeyDeserializers.a((DeserializationConfig)serializable, (AnnotatedMember)annotatedAndMetadata2.annotated);
        }
        list = ((BeanDescription)((Object)list)).getFactoryMethodsWithMode();
        list.removeIf(annotatedAndMetadata -> ((AnnotatedWithParams)((AnnotatedMethod)annotatedAndMetadata.annotated)).getParameterCount() != 1 || ((AnnotatedWithParams)((AnnotatedMethod)annotatedAndMetadata.annotated)).getRawParameterType(0) != String.class || annotatedAndMetadata.metadata == JsonCreator.Mode.PROPERTIES);
        List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> list2 = list;
        Object object = null;
        for (Object object2 : list2) {
            if (((AnnotatedAndMetadata)object2).metadata == null) continue;
            if (object == null) {
                object = (AnnotatedMethod)((AnnotatedAndMetadata)object2).annotated;
                continue;
            }
            serializable = ((AnnotatedMember)((AnnotatedMethod)((AnnotatedAndMetadata)object2).annotated)).getDeclaringClass();
            throw new IllegalArgumentException("Multiple suitable annotated Creator factory methods to be used as the Key deserializer for type " + ClassUtil.nameOf(serializable));
        }
        Object object3 = object;
        if (object3 != null) {
            return StdKeyDeserializers.a((DeserializationConfig)serializable, object3);
        }
        if (annotatedAndMetadata2 != null) {
            return StdKeyDeserializers.a((DeserializationConfig)serializable, (AnnotatedMember)annotatedAndMetadata2.annotated);
        }
        if (!list.isEmpty()) {
            return StdKeyDeserializers.a((DeserializationConfig)serializable, (AnnotatedMember)list.get((int)0).annotated);
        }
        return null;
    }

    private static StdKeyDeserializer a(DeserializationConfig deserializationConfig, AnnotatedMember object) {
        if (object instanceof AnnotatedConstructor) {
            object = ((AnnotatedConstructor)object).getAnnotated();
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess((Member)object, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.c((Constructor<?>)object);
        }
        object = ((AnnotatedMethod)object).getAnnotated();
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess((Member)object, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new StdKeyDeserializer.d((Method)object);
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        if (((Class)(type = ((ResolvedType)((Object)type)).getRawClass())).isPrimitive()) {
            type = ClassUtil.wrapperType(type);
        }
        return StdKeyDeserializer.forType(type);
    }
}

