/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.Arrays;

public class ThrowableDeserializer
extends BeanDeserializer {
    protected static final String PROP_NAME_MESSAGE = "message";
    protected static final String PROP_NAME_SUPPRESSED = "suppressed";
    protected static final String PROP_NAME_LOCALIZED_MESSAGE = "localizedMessage";

    protected ThrowableDeserializer(BeanDeserializer beanDeserializer, NameTransformer nameTransformer) {
        super((BeanDeserializerBase)beanDeserializer, nameTransformer);
        this._vanillaProcessing = false;
    }

    @Deprecated
    public ThrowableDeserializer(BeanDeserializer beanDeserializer) {
        this(beanDeserializer, null);
    }

    public static ThrowableDeserializer construct(DeserializationContext deserializationContext, BeanDeserializer beanDeserializer) {
        return new ThrowableDeserializer(beanDeserializer, null);
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        if (this.getClass() != ThrowableDeserializer.class) {
            return this;
        }
        return new ThrowableDeserializer(this, nameTransformer);
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (((ResolvedType)this._beanType).isAbstract()) {
            return deserializationContext.handleMissingInstantiator(((JsonDeserializer)this).handledType(), ((StdDeserializer)this).getValueInstantiator(), jsonParser, "abstract type (need to add/enable type information?)", new Object[0]);
        }
        boolean bl2 = this._valueInstantiator.canCreateFromString();
        boolean bl3 = this._valueInstantiator.canCreateUsingDefault();
        if (!bl2 && !bl3) {
            return deserializationContext.handleMissingInstantiator(((JsonDeserializer)this).handledType(), ((StdDeserializer)this).getValueInstantiator(), jsonParser, "Throwable needs a default constructor, a single-String-arg constructor; or explicit @JsonCreator", new Object[0]);
        }
        Throwable throwable = null;
        Object[] objectArray = null;
        Throwable[] throwableArray = null;
        int n2 = 0;
        while (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
            String string = jsonParser.currentName();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            jsonParser.nextToken();
            if (settableBeanProperty != null) {
                if (!"cause".equals(settableBeanProperty.getName()) || !jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    if (throwable != null) {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, throwable);
                    } else {
                        if (objectArray == null) {
                            int n3 = this._beanProperties.size();
                            objectArray = new Object[n3 + n3];
                        } else if (n2 == objectArray.length) {
                            objectArray = Arrays.copyOf(objectArray, n2 + 16);
                        }
                        objectArray[n2++] = settableBeanProperty;
                        objectArray[n2++] = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                    }
                }
            } else if (PROP_NAME_MESSAGE.equalsIgnoreCase(string)) {
                throwable = this.a(deserializationContext, bl2, jsonParser.getValueAsString());
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                jsonParser.skipChildren();
            } else if (PROP_NAME_SUPPRESSED.equalsIgnoreCase(string)) {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    throwableArray = null;
                } else {
                    DeserializationContext deserializationContext2 = deserializationContext;
                    JsonDeserializer<Object> jsonDeserializer = deserializationContext2.findRootValueDeserializer(deserializationContext2.constructType(Throwable[].class));
                    throwableArray = (Throwable[])jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
            } else if (PROP_NAME_LOCALIZED_MESSAGE.equalsIgnoreCase(string)) {
                jsonParser.skipChildren();
            } else if (this._anySetter != null) {
                if (throwable == null) {
                    throwable = this.a(deserializationContext, bl2, null);
                }
                this._anySetter.deserializeAndSet(jsonParser, deserializationContext, throwable, string);
            } else if (PROP_NAME_MESSAGE.equalsIgnoreCase(string)) {
                jsonParser.skipChildren();
            } else {
                this.handleUnknownProperty(jsonParser, deserializationContext, throwable, string);
            }
            jsonParser.nextToken();
        }
        if (throwable == null) {
            throwable = this.a(deserializationContext, bl2, null);
        }
        if (objectArray != null) {
            int n4 = n2;
            for (int i2 = 0; i2 < n4; i2 += 2) {
                SettableBeanProperty settableBeanProperty = (SettableBeanProperty)objectArray[i2];
                settableBeanProperty.set(throwable, objectArray[i2 + 1]);
            }
        }
        if (throwableArray != null) {
            Throwable[] throwableArray2 = throwableArray;
            int n5 = throwableArray.length;
            for (int i3 = 0; i3 < n5; ++i3) {
                jsonParser = throwableArray2[i3];
                if (jsonParser == null) continue;
                throwable.addSuppressed((Throwable)((Object)jsonParser));
            }
        }
        return throwable;
    }

    private Throwable a(DeserializationContext deserializationContext, boolean bl2, String string) {
        if (bl2) {
            if (string != null) {
                return (Throwable)this._valueInstantiator.createFromString(deserializationContext, string);
            }
            return (Throwable)this._valueInstantiator.createFromString(deserializationContext, null);
        }
        return (Throwable)this._valueInstantiator.createUsingDefault(deserializationContext);
    }
}

