/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.Arrays;
import java.util.UUID;

public class UUIDDeserializer
extends FromStringDeserializer<UUID> {
    private static int[] a;

    public UUIDDeserializer() {
        super(UUID.class);
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return new UUID(0L, 0L);
    }

    @Override
    protected UUID _deserialize(String string, DeserializationContext deserializationContext) {
        if (string.length() != 36) {
            if (string.length() == 24) {
                string = string.replace('-', '+').replace('_', '/');
                byte[] byArray = Base64Variants.getDefaultVariant().decode(string);
                return this.a(byArray, deserializationContext);
            }
            if (string.length() == 22) {
                string = string.replace('+', '-').replace('/', '_');
                byte[] byArray = Base64Variants.MODIFIED_FOR_URL.decode(string);
                return this.a(byArray, deserializationContext);
            }
            return this.a(string, deserializationContext);
        }
        if (string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
            this.a(string, deserializationContext);
        }
        long l2 = this.a(string, 0, deserializationContext);
        long l3 = (long)this.b(string, 9, deserializationContext) << 16;
        long l4 = (l2 <<= 32) + (l3 |= (long)this.b(string, 14, deserializationContext));
        int n2 = this.b(string, 19, deserializationContext) << 16 | this.b(string, 24, deserializationContext);
        long l5 = n2;
        l3 = this.a(string, 28, deserializationContext);
        l3 = l3 << 32 >>> 32;
        long l6 = (l5 <<= 32) | l3;
        return new UUID(l4, l6);
    }

    @Override
    protected UUID _deserializeEmbedded(Object object, DeserializationContext deserializationContext) {
        if (object instanceof byte[]) {
            return this.a((byte[])object, deserializationContext);
        }
        return (UUID)super._deserializeEmbedded(object, deserializationContext);
    }

    private UUID a(String string, DeserializationContext deserializationContext) {
        return (UUID)deserializationContext.handleWeirdStringValue(((JsonDeserializer)this).handledType(), string, "UUID has to be represented by standard 36-char representation", new Object[0]);
    }

    private int a(String string, int n2, DeserializationContext deserializationContext) {
        return (this.c(string, n2, deserializationContext) << 24) + (this.c(string, n2 + 2, deserializationContext) << 16) + (this.c(string, n2 + 4, deserializationContext) << 8) + this.c(string, n2 + 6, deserializationContext);
    }

    private int b(String string, int n2, DeserializationContext deserializationContext) {
        return (this.c(string, n2, deserializationContext) << 8) + this.c(string, n2 + 2, deserializationContext);
    }

    private int c(String string, int n2, DeserializationContext deserializationContext) {
        int n3;
        char c2 = string.charAt(n2);
        n2 = string.charAt(n2 + 1);
        if (c2 <= '\u007f' && n2 <= 127 && (n3 = a[c2] << 4 | a[n2]) >= 0) {
            return n3;
        }
        if (c2 > '\u007f' || a[c2] < 0) {
            return this.a(string, deserializationContext, c2);
        }
        return this.a(string, deserializationContext, (char)n2);
    }

    private int a(String string, DeserializationContext deserializationContext, char c2) {
        throw deserializationContext.weirdStringException(string, ((JsonDeserializer)this).handledType(), String.format("Non-hex character '%c' (value 0x%s), not valid for UUID String", Character.valueOf(c2), Integer.toHexString(c2)));
    }

    private UUID a(byte[] byArray, DeserializationContext deserializationContext) {
        if (byArray.length != 16) {
            throw InvalidFormatException.from(deserializationContext.getParser(), "Can only construct UUIDs from byte[16]; got " + byArray.length + " bytes", byArray, ((JsonDeserializer)this).handledType());
        }
        return new UUID(UUIDDeserializer.a(byArray, 0), UUIDDeserializer.a(byArray, 8));
    }

    private static long a(byte[] byArray, int n2) {
        long l2 = (long)UUIDDeserializer.b(byArray, n2) << 32;
        long l3 = UUIDDeserializer.b(byArray, n2 + 4);
        l3 = l3 << 32 >>> 32;
        return l2 | l3;
    }

    private static int b(byte[] byArray, int n2) {
        return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static {
        int n2;
        a = new int[127];
        Arrays.fill(a, -1);
        for (n2 = 0; n2 < 10; ++n2) {
            UUIDDeserializer.a[n2 + 48] = n2;
        }
        for (n2 = 0; n2 < 6; ++n2) {
            UUIDDeserializer.a[n2 + 97] = n2 + 10;
            UUIDDeserializer.a[n2 + 65] = n2 + 10;
        }
    }
}

