/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.c;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JacksonStdImpl
public class UntypedObjectDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer,
ResolvableDeserializer {
    protected static final Object[] NO_OBJECTS = new Object[0];
    protected JsonDeserializer<Object> _mapDeserializer;
    protected JsonDeserializer<Object> _listDeserializer;
    protected JsonDeserializer<Object> _stringDeserializer;
    protected JsonDeserializer<Object> _numberDeserializer;
    protected JavaType _listType;
    protected JavaType _mapType;
    protected final boolean _nonMerging;

    @Deprecated
    public UntypedObjectDeserializer() {
        this(null, null);
    }

    public UntypedObjectDeserializer(JavaType javaType, JavaType javaType2) {
        super(Object.class);
        this._listType = javaType;
        this._mapType = javaType2;
        this._nonMerging = false;
    }

    public UntypedObjectDeserializer(UntypedObjectDeserializer untypedObjectDeserializer, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, JsonDeserializer<?> jsonDeserializer3, JsonDeserializer<?> jsonDeserializer4) {
        super(Object.class);
        this._mapDeserializer = jsonDeserializer;
        this._listDeserializer = jsonDeserializer2;
        this._stringDeserializer = jsonDeserializer3;
        this._numberDeserializer = jsonDeserializer4;
        this._listType = untypedObjectDeserializer._listType;
        this._mapType = untypedObjectDeserializer._mapType;
        this._nonMerging = untypedObjectDeserializer._nonMerging;
    }

    protected UntypedObjectDeserializer(UntypedObjectDeserializer untypedObjectDeserializer, boolean bl2) {
        super(Object.class);
        this._mapDeserializer = untypedObjectDeserializer._mapDeserializer;
        this._listDeserializer = untypedObjectDeserializer._listDeserializer;
        this._stringDeserializer = untypedObjectDeserializer._stringDeserializer;
        this._numberDeserializer = untypedObjectDeserializer._numberDeserializer;
        this._listType = untypedObjectDeserializer._listType;
        this._mapType = untypedObjectDeserializer._mapType;
        this._nonMerging = bl2;
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) {
        JavaType javaType = deserializationContext.constructType(Object.class);
        JavaType javaType2 = deserializationContext.constructType(String.class);
        TypeFactory typeFactory = ((DatabindContext)deserializationContext).getTypeFactory();
        this._listDeserializer = this._listType == null ? this._clearIfStdImpl(this._findCustomDeser(deserializationContext, typeFactory.constructCollectionType(List.class, javaType))) : this._findCustomDeser(deserializationContext, this._listType);
        this._mapDeserializer = this._mapType == null ? this._clearIfStdImpl(this._findCustomDeser(deserializationContext, typeFactory.constructMapType(Map.class, javaType2, javaType))) : this._findCustomDeser(deserializationContext, this._mapType);
        this._stringDeserializer = this._clearIfStdImpl(this._findCustomDeser(deserializationContext, javaType2));
        this._numberDeserializer = this._clearIfStdImpl(this._findCustomDeser(deserializationContext, typeFactory.constructType((Type)((Object)Number.class))));
        javaType = TypeFactory.unknownType();
        this._mapDeserializer = deserializationContext.handleSecondaryContextualization(this._mapDeserializer, null, javaType);
        this._listDeserializer = deserializationContext.handleSecondaryContextualization(this._listDeserializer, null, javaType);
        this._stringDeserializer = deserializationContext.handleSecondaryContextualization(this._stringDeserializer, null, javaType);
        this._numberDeserializer = deserializationContext.handleSecondaryContextualization(this._numberDeserializer, null, javaType);
    }

    protected JsonDeserializer<Object> _findCustomDeser(DeserializationContext deserializationContext, JavaType javaType) {
        return deserializationContext.findNonContextualValueDeserializer(javaType);
    }

    protected JsonDeserializer<Object> _clearIfStdImpl(JsonDeserializer<Object> jsonDeserializer) {
        if (ClassUtil.isJacksonStdImpl(jsonDeserializer)) {
            return null;
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        boolean bl2;
        boolean bl3 = bl2 = beanProperty == null && Boolean.FALSE.equals(((MapperConfig)deserializationContext.getConfig()).getDefaultMergeable(Object.class));
        if (this._stringDeserializer == null && this._numberDeserializer == null && this._mapDeserializer == null && this._listDeserializer == null && this.getClass() == UntypedObjectDeserializer.class) {
            return c.a(bl2);
        }
        if (bl2 != this._nonMerging) {
            return new UntypedObjectDeserializer(this, bl2);
        }
        return this;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return null;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                if (this._mapDeserializer != null) {
                    return this._mapDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this.mapObject(jsonParser, deserializationContext);
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return this.mapArrayToArray(jsonParser, deserializationContext);
                }
                if (this._listDeserializer != null) {
                    return this._listDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this.mapArray(jsonParser, deserializationContext);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this._deserializeFP(jsonParser, deserializationContext);
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 3: 
            case 5: {
                return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this._deserializeFP(jsonParser, deserializationContext);
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        if (this._nonMerging) {
            return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
        }
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                if (this._mapDeserializer != null) {
                    return this._mapDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (object instanceof Map) {
                    return this.mapObject(jsonParser, deserializationContext, (Map)object);
                }
                return this.mapObject(jsonParser, deserializationContext);
            }
            case 3: {
                if (this._listDeserializer != null) {
                    return this._listDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (object instanceof Collection) {
                    return this.mapArray(jsonParser, deserializationContext, (Collection)object);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return this.mapArrayToArray(jsonParser, deserializationContext);
                }
                return this.mapArray(jsonParser, deserializationContext);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                return jsonParser.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext, object);
                }
                return this._deserializeFP(jsonParser, deserializationContext);
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
    }

    protected Object mapArray(JsonParser object, DeserializationContext deserializationContext) {
        if (((JsonParser)object).nextToken() == JsonToken.END_ARRAY) {
            return new ArrayList(2);
        }
        Object t2 = ((JsonDeserializer)this).deserialize((JsonParser)object, deserializationContext);
        if (((JsonParser)object).nextToken() == JsonToken.END_ARRAY) {
            ArrayList arrayList = new ArrayList(2);
            arrayList.add(t2);
            return arrayList;
        }
        Object t3 = ((JsonDeserializer)this).deserialize((JsonParser)object, deserializationContext);
        if (((JsonParser)object).nextToken() == JsonToken.END_ARRAY) {
            ArrayList arrayList = new ArrayList(2);
            arrayList.add(t2);
            arrayList.add(t3);
            return arrayList;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        ++n2;
        objectArray[0] = t2;
        ++n2;
        objectArray[1] = t3;
        int n3 = 2;
        do {
            t2 = ((JsonDeserializer)this).deserialize((JsonParser)object, deserializationContext);
            ++n3;
            if (n2 >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n2 = 0;
            }
            objectArray[n2++] = t2;
        } while (((JsonParser)object).nextToken() != JsonToken.END_ARRAY);
        object = new ArrayList(n3);
        objectBuffer.completeAndClearBuffer(objectArray, n2, (List<Object>)object);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    protected Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            collection.add(((JsonDeserializer)this).deserialize(jsonParser, deserializationContext));
        }
        return collection;
    }

    protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object = jsonParser.currentToken();
        if (object == JsonToken.START_OBJECT) {
            object = jsonParser.nextFieldName();
        } else if (object == JsonToken.FIELD_NAME) {
            object = jsonParser.currentName();
        } else {
            if (object != JsonToken.END_OBJECT) {
                return deserializationContext.handleUnexpectedToken(((JsonDeserializer)this).handledType(), jsonParser);
            }
            object = null;
        }
        if (object == null) {
            return new LinkedHashMap(2);
        }
        jsonParser.nextToken();
        Object object2 = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
        String string = jsonParser.nextFieldName();
        if (string == null) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(2);
            linkedHashMap.put((JsonToken)((Object)object), object2);
            return linkedHashMap;
        }
        jsonParser.nextToken();
        Object t2 = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
        String string2 = jsonParser.nextFieldName();
        if (string2 == null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(4);
            linkedHashMap.put((String)object, object2);
            if (linkedHashMap.put(string, t2) != null) {
                return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, (String)object, object2, t2, string2);
            }
            return linkedHashMap;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put((String)object, object2);
        if (linkedHashMap.put(string, t2) != null) {
            return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, (String)object, object2, t2, string2);
        }
        do {
            jsonParser.nextToken();
            object = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            object2 = linkedHashMap.put(string2, object);
            if (object2 == null) continue;
            return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, string2, object2, object, jsonParser.nextFieldName());
        } while ((string2 = jsonParser.nextFieldName()) != null);
        return linkedHashMap;
    }

    protected Object _mapObjectWithDups(JsonParser jsonParser, DeserializationContext deserializationContext, Map<String, Object> map, String string, Object object, Object object2, String string2) {
        boolean bl2 = deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES);
        if (bl2) {
            UntypedObjectDeserializer.a(map, string, object, object2);
        }
        while (string2 != null) {
            jsonParser.nextToken();
            object2 = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            object = map.put(string2, object2);
            if (object != null && bl2) {
                UntypedObjectDeserializer.a(map, string, object, object2);
            }
            string2 = jsonParser.nextFieldName();
        }
        return map;
    }

    private static void a(Map<String, Object> map, String string, Object object, Object object2) {
        if (object instanceof List) {
            ((List)object).add(object2);
            map.put(string, object);
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        map.put(string, arrayList);
    }

    protected Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return NO_OBJECTS;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        do {
            object = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            if (n2 >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n2 = 0;
            }
            objectArray[n2++] = object;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        object = objectBuffer.completeAndClearBuffer(objectArray, n2);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) {
        Object object = jsonParser.currentToken();
        if (object == JsonToken.START_OBJECT) {
            object = jsonParser.nextToken();
        }
        if (object == JsonToken.END_OBJECT) {
            return map;
        }
        object = jsonParser.currentName();
        do {
            jsonParser.nextToken();
            Object object2 = map.get(object);
            Object object3 = object2 != null ? ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext, object2) : ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            if (object3 == object2) continue;
            map.put(object, object3);
        } while ((object = jsonParser.nextFieldName()) != null);
        return map;
    }

    protected Object _deserializeFP(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonParser.NumberTypeFP numberTypeFP = jsonParser.getNumberTypeFP();
        if (numberTypeFP == JsonParser.NumberTypeFP.BIG_DECIMAL) {
            return jsonParser.getDecimalValue();
        }
        if (!jsonParser.isNaN() && deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            return jsonParser.getDecimalValue();
        }
        if (numberTypeFP == JsonParser.NumberTypeFP.FLOAT32) {
            return Float.valueOf(jsonParser.getFloatValue());
        }
        return jsonParser.getDoubleValue();
    }

    @JacksonStdImpl
    @Deprecated
    public static class Vanilla
    extends StdDeserializer<Object> {
        public static final Vanilla std = new Vanilla();
        protected final boolean _nonMerging;

        public Vanilla() {
            this(false);
        }

        protected Vanilla(boolean bl2) {
            super(Object.class);
            this._nonMerging = bl2;
        }

        public static Vanilla instance(boolean bl2) {
            if (bl2) {
                return new Vanilla(true);
            }
            return std;
        }

        @Override
        public LogicalType logicalType() {
            return LogicalType.Untyped;
        }

        @Override
        public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
            if (this._nonMerging) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            switch (jsonParser.currentTokenId()) {
                case 1: {
                    JsonToken jsonToken = jsonParser.nextToken();
                    if (jsonToken == JsonToken.END_OBJECT) {
                        return new LinkedHashMap(2);
                    }
                }
                case 5: {
                    return this.mapObject(jsonParser, deserializationContext);
                }
                case 3: {
                    JsonToken jsonToken = jsonParser.nextToken();
                    if (jsonToken == JsonToken.END_ARRAY) {
                        if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                            return NO_OBJECTS;
                        }
                        return new ArrayList(2);
                    }
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                        return this.mapArrayToArray(jsonParser, deserializationContext);
                    }
                    return this.mapArray(jsonParser, deserializationContext);
                }
                case 12: {
                    return jsonParser.getEmbeddedObject();
                }
                case 6: {
                    return jsonParser.getText();
                }
                case 7: {
                    if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                        return this._coerceIntegral(jsonParser, deserializationContext);
                    }
                    return jsonParser.getNumberValue();
                }
                case 8: {
                    return this._deserializeFP(jsonParser, deserializationContext);
                }
                case 9: {
                    return Boolean.TRUE;
                }
                case 10: {
                    return Boolean.FALSE;
                }
                case 2: {
                    return new LinkedHashMap(2);
                }
                case 11: {
                    return null;
                }
            }
            return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
        }

        @Override
        public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
            switch (jsonParser.currentTokenId()) {
                case 1: 
                case 3: 
                case 5: {
                    return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
                }
                case 6: {
                    return jsonParser.getText();
                }
                case 7: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                        return jsonParser.getBigIntegerValue();
                    }
                    return jsonParser.getNumberValue();
                }
                case 8: {
                    return this._deserializeFP(jsonParser, deserializationContext);
                }
                case 9: {
                    return Boolean.TRUE;
                }
                case 10: {
                    return Boolean.FALSE;
                }
                case 12: {
                    return jsonParser.getEmbeddedObject();
                }
                case 11: {
                    return null;
                }
            }
            return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
            if (this._nonMerging) {
                return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            }
            switch (jsonParser.currentTokenId()) {
                case 2: 
                case 4: {
                    return object;
                }
                case 1: {
                    Object object2 = jsonParser.nextToken();
                    if (object2 == JsonToken.END_OBJECT) {
                        return object;
                    }
                }
                case 5: {
                    if (!(object instanceof Map)) break;
                    Object object2 = (Map)object;
                    String string = jsonParser.currentName();
                    do {
                        jsonParser.nextToken();
                        Object v2 = object2.get(string);
                        Object object3 = v2 != null ? ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext, v2) : ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
                        if (object3 == v2) continue;
                        object2.put(string, object3);
                    } while ((string = jsonParser.nextFieldName()) != null);
                    return object;
                }
                case 3: {
                    Object object4 = jsonParser.nextToken();
                    if (object4 == JsonToken.END_ARRAY) {
                        return object;
                    }
                    if (!(object instanceof Collection)) break;
                    object4 = (Collection)object;
                    do {
                        object4.add(((JsonDeserializer)this).deserialize(jsonParser, deserializationContext));
                    } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
                    return object;
                }
            }
            return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
        }

        protected Object _deserializeFP(JsonParser jsonParser, DeserializationContext deserializationContext) {
            JsonParser.NumberTypeFP numberTypeFP = jsonParser.getNumberTypeFP();
            if (numberTypeFP == JsonParser.NumberTypeFP.BIG_DECIMAL) {
                return jsonParser.getDecimalValue();
            }
            if (!jsonParser.isNaN() && deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                return jsonParser.getDecimalValue();
            }
            if (numberTypeFP == JsonParser.NumberTypeFP.FLOAT32) {
                return Float.valueOf(jsonParser.getFloatValue());
            }
            return jsonParser.getDoubleValue();
        }

        protected Object mapArray(JsonParser object, DeserializationContext deserializationContext) {
            Object t2 = ((JsonDeserializer)this).deserialize((JsonParser)object, deserializationContext);
            if (((JsonParser)object).nextToken() == JsonToken.END_ARRAY) {
                ArrayList arrayList = new ArrayList(2);
                arrayList.add(t2);
                return arrayList;
            }
            ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
            Object[] objectArray = objectBuffer.resetAndStart();
            int n2 = 0;
            ++n2;
            objectArray[0] = t2;
            int n3 = 1;
            do {
                t2 = ((JsonDeserializer)this).deserialize((JsonParser)object, deserializationContext);
                ++n3;
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = t2;
            } while (((JsonParser)object).nextToken() != JsonToken.END_ARRAY);
            object = new ArrayList(n3);
            objectBuffer.completeAndClearBuffer(objectArray, n2, (List<Object>)object);
            deserializationContext.returnObjectBuffer(objectBuffer);
            return object;
        }

        protected Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
            Object object;
            ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
            Object[] objectArray = objectBuffer.resetAndStart();
            int n2 = 0;
            do {
                object = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = object;
            } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
            object = objectBuffer.completeAndClearBuffer(objectArray, n2);
            deserializationContext.returnObjectBuffer(objectBuffer);
            return object;
        }

        protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
            String string = jsonParser.currentName();
            jsonParser.nextToken();
            Object object = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            String string2 = jsonParser.nextFieldName();
            if (string2 == null) {
                LinkedHashMap linkedHashMap = new LinkedHashMap(2);
                linkedHashMap.put(string, object);
                return linkedHashMap;
            }
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put(string, object);
            do {
                jsonParser.nextToken();
                string = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
                object = linkedHashMap.put(string2, string);
                if (object == null) continue;
                return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, string2, object, string, jsonParser.nextFieldName());
            } while ((string2 = jsonParser.nextFieldName()) != null);
            return linkedHashMap;
        }

        protected Object _mapObjectWithDups(JsonParser jsonParser, DeserializationContext deserializationContext, Map<String, Object> map, String string, Object object, Object object2, String string2) {
            boolean bl2 = deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES);
            if (bl2) {
                Vanilla.a(map, string, object, object2);
            }
            while (string2 != null) {
                jsonParser.nextToken();
                object2 = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
                object = map.put(string2, object2);
                if (object != null && bl2) {
                    Vanilla.a(map, string2, object, object2);
                }
                string2 = jsonParser.nextFieldName();
            }
            return map;
        }

        private static void a(Map<String, Object> map, String string, Object object, Object object2) {
            if (object instanceof List) {
                ((List)object).add(object2);
                map.put(string, object);
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            arrayList.add(object2);
            map.put(string, arrayList);
        }
    }
}

