/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.RawValue;
import java.math.BigDecimal;
import java.util.Arrays;

abstract class a<T extends JsonNode>
extends StdDeserializer<T>
implements ContextualDeserializer {
    protected final Boolean _supportsUpdates;
    protected final boolean _mergeArrays;
    protected final boolean _mergeObjects;

    public a(Class<T> clazz, Boolean bl2) {
        super(clazz);
        this._supportsUpdates = bl2;
        this._mergeArrays = true;
        this._mergeObjects = true;
    }

    protected a(a<?> a2, boolean bl2, boolean bl3) {
        super(a2);
        this._supportsUpdates = a2._supportsUpdates;
        this._mergeArrays = bl2;
        this._mergeObjects = bl3;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._supportsUpdates;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext serializable, BeanProperty object) {
        serializable = ((DeserializationContext)serializable).getConfig();
        object = ((MapperConfig)serializable).getDefaultMergeable(ArrayNode.class);
        Boolean bl2 = ((MapperConfig)serializable).getDefaultMergeable(ObjectNode.class);
        serializable = ((MapperConfig)serializable).getDefaultMergeable(JsonNode.class);
        boolean bl3 = a.a((Boolean)object, (Boolean)serializable);
        boolean bl4 = a.a(bl2, (Boolean)serializable);
        if (bl3 != this._mergeArrays || bl4 != this._mergeObjects) {
            return this._createWithMerge(bl3, bl4);
        }
        return this;
    }

    private static boolean a(Boolean bl2, Boolean bl3) {
        if (bl2 != null) {
            return bl2;
        }
        if (bl3 != null) {
            return bl3;
        }
        return true;
    }

    protected abstract JsonDeserializer<?> _createWithMerge(boolean var1, boolean var2);

    protected void _handleDuplicateField(JsonParser object, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, String string, ObjectNode objectNode, JsonNode jsonNode, JsonNode jsonNode2) {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            deserializationContext.reportInputMismatch(JsonNode.class, "Duplicate field '%s' for `ObjectNode`: not allowed when `DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY` enabled", string);
        }
        if (deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES)) {
            if (jsonNode.isArray()) {
                ((ArrayNode)jsonNode).add(jsonNode2);
                objectNode.replace(string, jsonNode);
                return;
            }
            object = jsonNodeFactory.arrayNode();
            ((ArrayNode)object).add(jsonNode);
            ((ArrayNode)object).add(jsonNode2);
            objectNode.replace(string, (JsonNode)object);
        }
    }

    protected final ObjectNode _deserializeObjectAtName(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, a a2) {
        ObjectNode objectNode = jsonNodeFactory.objectNode();
        String string = jsonParser.currentName();
        while (string != null) {
            Object object = jsonParser.nextToken();
            if (object == null) {
                object = JsonToken.NOT_AVAILABLE;
            }
            switch (object.id()) {
                case 1: {
                    object = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, a2, jsonNodeFactory.objectNode());
                    break;
                }
                case 3: {
                    object = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, a2, jsonNodeFactory.arrayNode());
                    break;
                }
                default: {
                    object = this._deserializeAnyScalar(jsonParser, deserializationContext);
                }
            }
            JsonNode jsonNode = objectNode.replace(string, (JsonNode)object);
            if (jsonNode != null) {
                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, string, objectNode, jsonNode, (JsonNode)object);
            }
            string = jsonParser.nextFieldName();
        }
        return objectNode;
    }

    protected final JsonNode updateObject(JsonParser jsonParser, DeserializationContext deserializationContext, ObjectNode objectNode, a a2) {
        String string;
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            if (!jsonParser.hasToken(JsonToken.FIELD_NAME)) {
                return (JsonNode)this.deserialize(jsonParser, deserializationContext);
            }
            string = jsonParser.currentName();
        }
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        while (string != null) {
            block18: {
                Object object;
                block16: {
                    JsonNode jsonNode;
                    block17: {
                        object = jsonParser.nextToken();
                        jsonNode = ((JsonNode)objectNode).get(string);
                        if (jsonNode == null) break block16;
                        if (!(jsonNode instanceof ObjectNode)) break block17;
                        if (object != JsonToken.START_OBJECT || !this._mergeObjects) break block16;
                        object = this.updateObject(jsonParser, deserializationContext, (ObjectNode)jsonNode, a2);
                        if (object != jsonNode) {
                            objectNode.set(string, (JsonNode)object);
                        }
                        break block18;
                    }
                    if (!(jsonNode instanceof ArrayNode) || object != JsonToken.START_ARRAY || !this._mergeArrays) break block16;
                    this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, a2, (ArrayNode)jsonNode);
                    break block18;
                }
                if (object == null) {
                    object = JsonToken.NOT_AVAILABLE;
                }
                switch (object.id()) {
                    case 1: {
                        object = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, a2, jsonNodeFactory.objectNode());
                        break;
                    }
                    case 3: {
                        object = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, a2, jsonNodeFactory.arrayNode());
                        break;
                    }
                    case 6: {
                        object = jsonNodeFactory.textNode(jsonParser.getText());
                        break;
                    }
                    case 7: {
                        object = this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
                        break;
                    }
                    case 9: {
                        object = jsonNodeFactory.booleanNode(true);
                        break;
                    }
                    case 10: {
                        object = jsonNodeFactory.booleanNode(false);
                        break;
                    }
                    case 11: {
                        if (((DatabindContext)deserializationContext).isEnabled(JsonNodeFeature.READ_NULL_PROPERTIES)) {
                            object = jsonNodeFactory.nullNode();
                            break;
                        }
                        break block18;
                    }
                    default: {
                        object = this._deserializeRareScalar(jsonParser, deserializationContext);
                    }
                }
                objectNode.set(string, (JsonNode)object);
            }
            string = jsonParser.nextFieldName();
        }
        return objectNode;
    }

    protected final ContainerNode<?> _deserializeContainerNoRecursion(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, a a2, ContainerNode<?> containerNode) {
        ContainerNode containerNode2 = containerNode;
        int n2 = deserializationContext.getDeserializationFeatures() & F_MASK_INT_COERCIONS;
        block21: do {
            block32: {
                Object object;
                ContainerNode containerNode3;
                block30: {
                    if (!(containerNode2 instanceof ObjectNode)) break block30;
                    containerNode3 = (ObjectNode)containerNode2;
                    object = jsonParser.nextFieldName();
                    while (object != null) {
                        block31: {
                            JsonNode jsonNode;
                            Object object2 = jsonParser.nextToken();
                            if (object2 == null) {
                                object2 = JsonToken.NOT_AVAILABLE;
                            }
                            switch (object2.id()) {
                                case 1: {
                                    jsonNode = jsonNodeFactory.objectNode();
                                    object2 = ((ObjectNode)containerNode3).replace((String)object, jsonNode);
                                    if (object2 != null) {
                                        this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, (JsonNode)object2, jsonNode);
                                    }
                                    a2.a(containerNode2);
                                    containerNode2 = containerNode3 = jsonNode;
                                    break block31;
                                }
                                case 3: {
                                    jsonNode = jsonNodeFactory.arrayNode();
                                    object2 = ((ObjectNode)containerNode3).replace((String)object, jsonNode);
                                    if (object2 != null) {
                                        this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, (JsonNode)object2, jsonNode);
                                    }
                                    a2.a(containerNode2);
                                    containerNode2 = jsonNode;
                                    continue block21;
                                }
                                case 6: {
                                    object2 = jsonNodeFactory.textNode(jsonParser.getText());
                                    break;
                                }
                                case 7: {
                                    object2 = this._fromInt(jsonParser, n2, jsonNodeFactory);
                                    break;
                                }
                                case 8: {
                                    object2 = this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
                                    break;
                                }
                                case 9: {
                                    object2 = jsonNodeFactory.booleanNode(true);
                                    break;
                                }
                                case 10: {
                                    object2 = jsonNodeFactory.booleanNode(false);
                                    break;
                                }
                                case 11: {
                                    if (((DatabindContext)deserializationContext).isEnabled(JsonNodeFeature.READ_NULL_PROPERTIES)) {
                                        object2 = jsonNodeFactory.nullNode();
                                        break;
                                    }
                                    break block31;
                                }
                                default: {
                                    object2 = this._deserializeRareScalar(jsonParser, deserializationContext);
                                }
                            }
                            jsonNode = ((ObjectNode)containerNode3).replace((String)object, (JsonNode)object2);
                            if (jsonNode != null) {
                                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, jsonNode, (JsonNode)object2);
                            }
                        }
                        object = jsonParser.nextFieldName();
                    }
                    break block32;
                }
                containerNode3 = (ArrayNode)containerNode2;
                block23: while (true) {
                    if ((object = jsonParser.nextToken()) == null) {
                        object = JsonToken.NOT_AVAILABLE;
                    }
                    switch (((JsonToken)((Object)object)).id()) {
                        case 1: {
                            a2.a(containerNode2);
                            containerNode2 = jsonNodeFactory.objectNode();
                            ((ArrayNode)containerNode3).add(containerNode2);
                            continue block21;
                        }
                        case 3: {
                            a2.a(containerNode2);
                            containerNode2 = jsonNodeFactory.arrayNode();
                            ((ArrayNode)containerNode3).add(containerNode2);
                            continue block21;
                        }
                        case 4: {
                            break block23;
                        }
                        case 6: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.textNode(jsonParser.getText()));
                            continue block23;
                        }
                        case 7: {
                            ((ArrayNode)containerNode3).add(this._fromInt(jsonParser, n2, jsonNodeFactory));
                            continue block23;
                        }
                        case 8: {
                            ((ArrayNode)containerNode3).add(this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory));
                            continue block23;
                        }
                        case 9: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.booleanNode(true));
                            continue block23;
                        }
                        case 10: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.booleanNode(false));
                            continue block23;
                        }
                        case 11: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.nullNode());
                            continue block23;
                        }
                        default: {
                            ((ArrayNode)containerNode3).add(this._deserializeRareScalar(jsonParser, deserializationContext));
                            continue block23;
                        }
                    }
                    break;
                }
            }
            containerNode2 = a2.a();
        } while (containerNode2 != null);
        return containerNode;
    }

    protected final JsonNode _deserializeAnyScalar(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        switch (jsonParser.currentTokenId()) {
            case 2: {
                return jsonNodeFactory.objectNode();
            }
            case 6: {
                return jsonNodeFactory.textNode(jsonParser.getText());
            }
            case 7: {
                return this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 8: {
                return this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 9: {
                return jsonNodeFactory.booleanNode(true);
            }
            case 10: {
                return jsonNodeFactory.booleanNode(false);
            }
            case 11: {
                return jsonNodeFactory.nullNode();
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext);
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(((JsonDeserializer)this).handledType(), jsonParser);
    }

    protected final JsonNode _deserializeRareScalar(JsonParser jsonParser, DeserializationContext deserializationContext) {
        switch (jsonParser.currentTokenId()) {
            case 2: {
                return deserializationContext.getNodeFactory().objectNode();
            }
            case 8: {
                DeserializationContext deserializationContext2 = deserializationContext;
                return this._fromFloat(jsonParser, deserializationContext2, deserializationContext2.getNodeFactory());
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext);
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(((JsonDeserializer)this).handledType(), jsonParser);
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, int n2, JsonNodeFactory jsonNodeFactory) {
        if (n2 != 0) {
            if (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2)) {
                return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
            }
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        JsonParser.NumberType numberType = jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) {
        int n2 = deserializationContext.getDeserializationFeatures();
        JsonParser.NumberType numberType = (n2 & F_MASK_INT_COERCIONS) != 0 ? (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2) ? JsonParser.NumberType.BIG_INTEGER : (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(n2) ? JsonParser.NumberType.LONG : jsonParser.getNumberType())) : jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromFloat(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) {
        JsonParser.NumberTypeFP numberTypeFP = jsonParser.getNumberTypeFP();
        if (numberTypeFP == JsonParser.NumberTypeFP.BIG_DECIMAL) {
            return this._fromBigDecimal(deserializationContext, jsonNodeFactory, jsonParser.getDecimalValue());
        }
        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            if (jsonParser.isNaN()) {
                if (((DatabindContext)deserializationContext).isEnabled(JsonNodeFeature.FAIL_ON_NAN_TO_BIG_DECIMAL_COERCION)) {
                    return (JsonNode)deserializationContext.handleWeirdNumberValue(((JsonDeserializer)this).handledType(), jsonParser.getDoubleValue(), "Cannot convert NaN into BigDecimal", new Object[0]);
                }
                return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
            }
            return this._fromBigDecimal(deserializationContext, jsonNodeFactory, jsonParser.getDecimalValue());
        }
        if (numberTypeFP == JsonParser.NumberTypeFP.FLOAT32) {
            return jsonNodeFactory.numberNode(jsonParser.getFloatValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
    }

    protected final JsonNode _fromBigDecimal(DeserializationContext serializable, JsonNodeFactory jsonNodeFactory, BigDecimal bigDecimal) {
        boolean bl2 = ((DatatypeFeatures)(serializable = ((DatabindContext)((Object)serializable)).getDatatypeFeatures())).isExplicitlySet(JsonNodeFeature.STRIP_TRAILING_BIGDECIMAL_ZEROES) ? ((DatatypeFeatures)serializable).isEnabled(JsonNodeFeature.STRIP_TRAILING_BIGDECIMAL_ZEROES) : jsonNodeFactory.willStripTrailingBigDecimalZeroes();
        if (bl2) {
            try {
                bigDecimal = bigDecimal.stripTrailingZeros();
            }
            catch (ArithmeticException arithmeticException) {}
        }
        return jsonNodeFactory.numberNode(bigDecimal);
    }

    protected final JsonNode _fromEmbedded(JsonParser object, DeserializationContext serializable) {
        serializable = ((DeserializationContext)serializable).getNodeFactory();
        if ((object = ((JsonParser)object).getEmbeddedObject()) == null) {
            return ((JsonNodeFactory)serializable).nullNode();
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            return ((JsonNodeFactory)serializable).binaryNode((byte[])object);
        }
        if (object instanceof RawValue) {
            return ((JsonNodeFactory)serializable).rawValueNode((RawValue)object);
        }
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        return ((JsonNodeFactory)serializable).pojoNode(object);
    }

    static final class a {
        private ContainerNode[] a;
        private int b;
        private int c;

        public final void a(ContainerNode containerNode) {
            if (this.b < this.c) {
                this.a[this.b++] = containerNode;
                return;
            }
            if (this.a == null) {
                this.c = 10;
                this.a = new ContainerNode[this.c];
            } else {
                this.c += Math.min(4000, Math.max(20, this.c >> 1));
                this.a = Arrays.copyOf(this.a, this.c);
            }
            this.a[this.b++] = containerNode;
        }

        public final ContainerNode a() {
            if (this.b == 0) {
                return null;
            }
            return this.a[--this.b];
        }
    }
}

