/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.exc;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class PropertyBindingException
extends MismatchedInputException {
    protected final Class<?> _referringClass;
    protected final String _propertyName;
    protected final Collection<Object> _propertyIds;
    protected transient String _propertiesAsString;

    protected PropertyBindingException(JsonParser jsonParser, String string, JsonLocation jsonLocation, Class<?> clazz, String string2, Collection<Object> collection) {
        super(jsonParser, string, jsonLocation);
        this._referringClass = clazz;
        this._propertyName = string2;
        this._propertyIds = collection;
    }

    @Deprecated
    protected PropertyBindingException(String string, JsonLocation jsonLocation, Class<?> clazz, String string2, Collection<Object> collection) {
        this(null, string, jsonLocation, clazz, string2, collection);
    }

    @Override
    public String getMessageSuffix() {
        CharSequence charSequence = this._propertiesAsString;
        if (charSequence == null && this._propertyIds != null) {
            charSequence = new StringBuilder(100);
            int n2 = this._propertyIds.size();
            if (n2 == 1) {
                ((StringBuilder)charSequence).append(" (one known property: \"");
                ((StringBuilder)charSequence).append(String.valueOf(this._propertyIds.iterator().next()));
                ((StringBuilder)charSequence).append('\"');
            } else {
                ((StringBuilder)charSequence).append(" (").append(n2).append(" known properties: ");
                Iterator<Object> iterator = this._propertyIds.iterator();
                while (iterator.hasNext()) {
                    ((StringBuilder)charSequence).append('\"');
                    ((StringBuilder)charSequence).append(String.valueOf(iterator.next()));
                    ((StringBuilder)charSequence).append('\"');
                    if (((StringBuilder)charSequence).length() > 1000) {
                        ((StringBuilder)charSequence).append(" [truncated]");
                        break;
                    }
                    if (!iterator.hasNext()) continue;
                    ((StringBuilder)charSequence).append(", ");
                }
            }
            ((StringBuilder)charSequence).append("])");
            charSequence = ((StringBuilder)charSequence).toString();
            this._propertiesAsString = charSequence;
        }
        return charSequence;
    }

    public Class<?> getReferringClass() {
        return this._referringClass;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Collection<Object> getKnownPropertyIds() {
        if (this._propertyIds == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this._propertyIds);
    }
}

