/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CoreXMLDeserializers
extends Deserializers.Base {
    protected static final QName EMPTY_QNAME = QName.valueOf("");
    static final DatatypeFactory a;
    protected static final int TYPE_DURATION = 1;
    protected static final int TYPE_G_CALENDAR = 2;
    protected static final int TYPE_QNAME = 3;

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        if ((type = ((ResolvedType)((Object)type)).getRawClass()) == QName.class) {
            return new Std((Class<?>)type, 3);
        }
        if (type == XMLGregorianCalendar.class) {
            return new Std((Class<?>)type, 2);
        }
        if (type == Duration.class) {
            return new Std((Class<?>)type, 1);
        }
        return null;
    }

    @Override
    public boolean hasDeserializerFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return clazz == QName.class || clazz == XMLGregorianCalendar.class || clazz == Duration.class;
    }

    static {
        try {
            a = DatatypeFactory.newInstance();
            return;
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException);
        }
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        protected final int _kind;

        public Std(Class<?> clazz, int n2) {
            super(clazz);
            this._kind = n2;
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            if (this._kind == 2 && jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return this._gregorianFromDate(deserializationContext, this._parseDate(jsonParser, deserializationContext));
            }
            return super.deserialize(jsonParser, deserializationContext);
        }

        @Override
        protected Object _deserialize(String string, DeserializationContext deserializationContext) {
            switch (this._kind) {
                case 1: {
                    return a.newDuration(string);
                }
                case 3: {
                    return QName.valueOf(string);
                }
                case 2: {
                    Date date;
                    try {
                        date = this._parseDate(string, deserializationContext);
                    }
                    catch (JsonMappingException jsonMappingException) {
                        return a.newXMLGregorianCalendar(string);
                    }
                    return this._gregorianFromDate(deserializationContext, date);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        protected Object _deserializeFromEmptyString(DeserializationContext deserializationContext) {
            if (this._kind == 3) {
                return EMPTY_QNAME;
            }
            return super._deserializeFromEmptyString(deserializationContext);
        }

        protected XMLGregorianCalendar _gregorianFromDate(DeserializationContext serializable, Date date) {
            if (date == null) {
                return null;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            serializable = ((DatabindContext)((Object)serializable)).getTimeZone();
            if (serializable != null) {
                gregorianCalendar.setTimeZone((TimeZone)serializable);
            }
            return a.newXMLGregorianCalendar(gregorianCalendar);
        }
    }
}

