/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.Calendar;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CoreXMLSerializers
extends Serializers.Base {
    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig serializable, JavaType javaType, BeanDescription beanDescription) {
        serializable = ((ResolvedType)javaType).getRawClass();
        if (Duration.class.isAssignableFrom((Class<?>)serializable) || QName.class.isAssignableFrom((Class<?>)serializable)) {
            return ToStringSerializer.instance;
        }
        if (XMLGregorianCalendar.class.isAssignableFrom((Class<?>)serializable)) {
            return XMLGregorianCalendarSerializer.a;
        }
        return null;
    }

    public static class XMLGregorianCalendarSerializer
    extends StdSerializer<XMLGregorianCalendar>
    implements ContextualSerializer {
        static final XMLGregorianCalendarSerializer a = new XMLGregorianCalendarSerializer();
        private JsonSerializer<Object> b;

        public XMLGregorianCalendarSerializer() {
            this(CalendarSerializer.instance);
        }

        protected XMLGregorianCalendarSerializer(JsonSerializer<?> jsonSerializer) {
            super(XMLGregorianCalendar.class);
            this.b = jsonSerializer;
        }

        @Override
        public JsonSerializer<?> getDelegatee() {
            return this.b;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, XMLGregorianCalendar xMLGregorianCalendar) {
            return this.b.isEmpty(serializerProvider, this._convert(xMLGregorianCalendar));
        }

        @Override
        public void serialize(XMLGregorianCalendar xMLGregorianCalendar, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            this.b.serialize(this._convert(xMLGregorianCalendar), jsonGenerator, serializerProvider);
        }

        @Override
        public void serializeWithType(XMLGregorianCalendar xMLGregorianCalendar, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
            WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId((Object)xMLGregorianCalendar, XMLGregorianCalendar.class, JsonToken.VALUE_STRING));
            this.serialize(xMLGregorianCalendar, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            this.b.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, null);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
            if ((object = ((SerializerProvider)object).handlePrimaryContextualization(this.b, beanProperty)) != this.b) {
                return new XMLGregorianCalendarSerializer((JsonSerializer<?>)object);
            }
            return this;
        }

        protected Calendar _convert(XMLGregorianCalendar xMLGregorianCalendar) {
            if (xMLGregorianCalendar == null) {
                return null;
            }
            return xMLGregorianCalendar.toGregorianCalendar();
        }
    }
}

