/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class DOMDeserializer<T>
extends FromStringDeserializer<T> {
    private static final DocumentBuilderFactory a;

    protected DOMDeserializer(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public abstract T _deserialize(String var1, DeserializationContext var2);

    protected final Document parse(String string) {
        try {
            return this.documentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to parse JSON String as XML: " + exception.getMessage(), exception);
        }
    }

    protected DocumentBuilder documentBuilder() {
        return a.newDocumentBuilder();
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception exception) {}
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception exception) {}
        a = documentBuilderFactory;
    }

    public static class DocumentDeserializer
    extends DOMDeserializer<Document> {
        public DocumentDeserializer() {
            super(Document.class);
        }

        @Override
        public Document _deserialize(String string, DeserializationContext deserializationContext) {
            return this.parse(string);
        }
    }

    public static class NodeDeserializer
    extends DOMDeserializer<Node> {
        public NodeDeserializer() {
            super(Node.class);
        }

        @Override
        public Node _deserialize(String string, DeserializationContext deserializationContext) {
            return this.parse(string);
        }
    }
}

