/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.ext.Java7Handlers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.ExceptionUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OptionalHandlerFactory
implements Serializable {
    private static final Class<?> a;
    private static final Class<?> b;
    private static final Java7Handlers c;
    public static final OptionalHandlerFactory instance;
    private final Map<String, String> d = new HashMap<String, String>();
    private final Map<String, Object> e;

    protected OptionalHandlerFactory() {
        this.d.put("java.sql.Date", "com.fasterxml.jackson.databind.deser.std.DateDeserializers$SqlDateDeserializer");
        this.d.put("java.sql.Timestamp", "com.fasterxml.jackson.databind.deser.std.DateDeserializers$TimestampDeserializer");
        this.e = new HashMap<String, Object>();
        this.e.put("java.sql.Timestamp", DateSerializer.instance);
        this.e.put("java.sql.Date", "com.fasterxml.jackson.databind.ser.std.SqlDateSerializer");
        this.e.put("java.sql.Time", "com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer");
        this.e.put("java.sql.Blob", "com.fasterxml.jackson.databind.ext.SqlBlobSerializer");
        this.e.put("javax.sql.rowset.serial.SerialBlob", "com.fasterxml.jackson.databind.ext.SqlBlobSerializer");
    }

    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Object object;
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        if (OptionalHandlerFactory.a(clazz, a)) {
            return (JsonSerializer)this.a("com.fasterxml.jackson.databind.ext.DOMSerializer", javaType);
        }
        if (c != null && (object = c.getSerializerForJavaNioFilePath(clazz)) != null) {
            return object;
        }
        object = clazz.getName();
        Object object2 = this.e.get(object);
        if (object2 != null) {
            if (object2 instanceof JsonSerializer) {
                return (JsonSerializer)object2;
            }
            return (JsonSerializer)this.a((String)object2, javaType);
        }
        if (!((String)object).startsWith("javax.xml.") && !OptionalHandlerFactory.a(clazz, "javax.xml.")) {
            return null;
        }
        clazz = "com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
        clazz = this.a((String)((Object)clazz), javaType);
        if (clazz == null) {
            return null;
        }
        return ((Serializers)((Object)clazz)).findSerializer(serializationConfig, javaType, beanDescription);
    }

    public JsonDeserializer<?> findDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Object object;
        Object object2 = ((ResolvedType)javaType).getRawClass();
        if (c != null && (object = c.getDeserializerForJavaNioFilePath((Class<?>)object2)) != null) {
            return object;
        }
        if (OptionalHandlerFactory.a(object2, a)) {
            return (JsonDeserializer)this.a("com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer", javaType);
        }
        if (OptionalHandlerFactory.a(object2, b)) {
            return (JsonDeserializer)this.a("com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer", javaType);
        }
        object = ((Class)object2).getName();
        String string = this.d.get(object);
        if (string != null) {
            return (JsonDeserializer)this.a(string, javaType);
        }
        if (!((String)object).startsWith("javax.xml.") && !OptionalHandlerFactory.a(object2, "javax.xml.")) {
            return null;
        }
        object2 = "com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
        object2 = this.a((String)object2, javaType);
        if (object2 == null) {
            return null;
        }
        return ((Deserializers)object2).findBeanDeserializer(javaType, deserializationConfig, beanDescription);
    }

    public boolean hasDeserializerFor(Class<?> clazz) {
        if (OptionalHandlerFactory.a(clazz, a)) {
            return true;
        }
        if (OptionalHandlerFactory.a(clazz, b)) {
            return true;
        }
        String string = clazz.getName();
        if (string.startsWith("javax.xml.") || OptionalHandlerFactory.a(clazz, "javax.xml.")) {
            return true;
        }
        return this.d.containsKey(string);
    }

    private static boolean a(Class<?> clazz, Class<?> clazz2) {
        return clazz2 != null && clazz2.isAssignableFrom(clazz);
    }

    private Object a(String string, JavaType javaType) {
        try {
            return OptionalHandlerFactory.a(Class.forName(string), javaType);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            ExceptionUtil.rethrowIfFatal(throwable);
            throw new IllegalStateException("Failed to find class `" + string + "` for handling values of type " + ClassUtil.getTypeDescription(javaType) + ", problem: (" + throwable2.getClass().getName() + ") " + throwable2.getMessage());
        }
    }

    private static Object a(Class<?> clazz, JavaType javaType) {
        try {
            return ClassUtil.createInstance(clazz, false);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            ExceptionUtil.rethrowIfFatal(throwable);
            throw new IllegalStateException("Failed to create instance of `" + clazz.getName() + "` for handling values of type " + ClassUtil.getTypeDescription(javaType) + ", problem: (" + throwable2.getClass().getName() + ") " + throwable2.getMessage());
        }
    }

    private static boolean a(Class<?> clazz, String string) {
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz == Object.class) {
                return false;
            }
            if (!clazz.getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    static {
        Object object = null;
        Object object2 = null;
        try {
            object2 = Node.class;
            object = Document.class;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            ExceptionUtil.rethrowIfFatal(throwable);
        }
        a = object2;
        b = object;
        object = null;
        try {
            object = Java7Handlers.instance();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            ExceptionUtil.rethrowIfFatal(throwable);
        }
        c = object;
        instance = new OptionalHandlerFactory();
    }
}

