/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedFieldCollector;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethodCollector;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethodMap;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.introspect.a;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public final class AnnotatedClass
extends Annotated
implements TypeResolutionContext {
    private static final Creators a = new Creators(null, Collections.emptyList(), Collections.emptyList());
    protected final JavaType _type;
    protected final Class<?> _class;
    protected final TypeBindings _bindings;
    protected final List<JavaType> _superTypes;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final TypeFactory _typeFactory;
    protected final ClassIntrospector.MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected final boolean _collectAnnotations;
    protected final Annotations _classAnnotations;
    protected Creators _creators;
    protected AnnotatedMethodMap _memberMethods;
    protected List<AnnotatedField> _fields;
    protected transient Boolean _nonStaticInnerClass;

    AnnotatedClass(JavaType javaType, Class<?> clazz, List<JavaType> list, Class<?> clazz2, Annotations annotations, TypeBindings typeBindings, AnnotationIntrospector annotationIntrospector, ClassIntrospector.MixInResolver mixInResolver, TypeFactory typeFactory, boolean bl2) {
        this._type = javaType;
        this._class = clazz;
        this._superTypes = list;
        this._primaryMixIn = clazz2;
        this._classAnnotations = annotations;
        this._bindings = typeBindings;
        this._annotationIntrospector = annotationIntrospector;
        this._mixInResolver = mixInResolver;
        this._typeFactory = typeFactory;
        this._collectAnnotations = bl2;
    }

    AnnotatedClass(Class<?> clazz) {
        this._type = null;
        this._class = clazz;
        this._superTypes = Collections.emptyList();
        this._primaryMixIn = null;
        this._classAnnotations = AnnotationCollector.emptyAnnotations();
        this._bindings = TypeBindings.emptyBindings();
        this._annotationIntrospector = null;
        this._mixInResolver = null;
        this._typeFactory = null;
        this._collectAnnotations = false;
    }

    @Deprecated
    public static AnnotatedClass construct(JavaType javaType, MapperConfig<?> mapperConfig) {
        MapperConfig<?> mapperConfig2 = mapperConfig;
        return AnnotatedClass.construct(javaType, mapperConfig2, mapperConfig2);
    }

    @Deprecated
    public static AnnotatedClass construct(JavaType javaType, MapperConfig<?> mapperConfig, ClassIntrospector.MixInResolver mixInResolver) {
        return AnnotatedClassResolver.resolve(mapperConfig, javaType, mixInResolver);
    }

    @Deprecated
    public static AnnotatedClass constructWithoutSuperTypes(Class<?> clazz, MapperConfig<?> mapperConfig) {
        MapperConfig<?> mapperConfig2 = mapperConfig;
        return AnnotatedClass.constructWithoutSuperTypes(clazz, mapperConfig2, mapperConfig2);
    }

    @Deprecated
    public static AnnotatedClass constructWithoutSuperTypes(Class<?> clazz, MapperConfig<?> mapperConfig, ClassIntrospector.MixInResolver mixInResolver) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, clazz, mixInResolver);
    }

    @Override
    public final JavaType resolveType(Type type) {
        return this._typeFactory.resolveMemberType(type, this._bindings);
    }

    @Override
    public final Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public final int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public final String getName() {
        return this._class.getName();
    }

    @Override
    public final <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this._classAnnotations.get(clazz);
    }

    @Override
    public final boolean hasAnnotation(Class<?> clazz) {
        return this._classAnnotations.has(clazz);
    }

    @Override
    public final boolean hasOneOf(Class<? extends Annotation>[] classArray) {
        return this._classAnnotations.hasOneOf(classArray);
    }

    @Override
    public final Class<?> getRawType() {
        return this._class;
    }

    @Override
    @Deprecated
    public final Iterable<Annotation> annotations() {
        if (this._classAnnotations instanceof AnnotationMap) {
            return ((AnnotationMap)this._classAnnotations).annotations();
        }
        if (this._classAnnotations instanceof AnnotationCollector.OneAnnotation || this._classAnnotations instanceof AnnotationCollector.TwoAnnotations) {
            throw new UnsupportedOperationException("please use getAnnotations/ hasAnnotation to check for Annotations");
        }
        return Collections.emptyList();
    }

    @Override
    public final JavaType getType() {
        return this._type;
    }

    public final Annotations getAnnotations() {
        return this._classAnnotations;
    }

    public final boolean hasAnnotations() {
        return this._classAnnotations.size() > 0;
    }

    public final AnnotatedConstructor getDefaultConstructor() {
        return this.c().defaultConstructor;
    }

    public final List<AnnotatedConstructor> getConstructors() {
        return this.c().constructors;
    }

    public final List<AnnotatedMethod> getFactoryMethods() {
        return this.c().creatorMethods;
    }

    @Deprecated
    public final List<AnnotatedMethod> getStaticMethods() {
        return this.getFactoryMethods();
    }

    public final Iterable<AnnotatedMethod> memberMethods() {
        return this.b();
    }

    public final int getMemberMethodCount() {
        return this.b().size();
    }

    public final AnnotatedMethod findMethod(String string, Class<?>[] classArray) {
        return this.b().find(string, classArray);
    }

    public final int getFieldCount() {
        return this.a().size();
    }

    public final Iterable<AnnotatedField> fields() {
        return this.a();
    }

    public final boolean isNonStaticInnerClass() {
        Boolean bl2 = this._nonStaticInnerClass;
        if (bl2 == null) {
            this._nonStaticInnerClass = bl2 = Boolean.valueOf(ClassUtil.isNonStaticInnerClass(this._class));
        }
        return bl2;
    }

    private final List<AnnotatedField> a() {
        List<AnnotatedField> list = this._fields;
        if (list == null) {
            if (this._type == null) {
                list = Collections.emptyList();
            } else {
                AnnotatedClass annotatedClass = this;
                list = AnnotatedFieldCollector.collectFields(this._annotationIntrospector, annotatedClass, annotatedClass._mixInResolver, this._typeFactory, this._type, this._collectAnnotations);
            }
            this._fields = list;
        }
        return list;
    }

    private final AnnotatedMethodMap b() {
        AnnotatedMethodMap annotatedMethodMap = this._memberMethods;
        if (annotatedMethodMap == null) {
            if (this._type == null) {
                annotatedMethodMap = new AnnotatedMethodMap();
            } else {
                AnnotatedClass annotatedClass = this;
                annotatedMethodMap = AnnotatedMethodCollector.collectMethods(this._annotationIntrospector, annotatedClass, annotatedClass._mixInResolver, this._typeFactory, this._type, this._superTypes, this._primaryMixIn, this._collectAnnotations);
            }
            this._memberMethods = annotatedMethodMap;
        }
        return annotatedMethodMap;
    }

    private final Creators c() {
        Creators creators = this._creators;
        if (creators == null) {
            if (this._type == null) {
                creators = a;
            } else {
                AnnotatedClass annotatedClass = this;
                creators = com.fasterxml.jackson.databind.introspect.a.a(this._annotationIntrospector, this._typeFactory, annotatedClass, annotatedClass._type, this._primaryMixIn, this._collectAnnotations);
            }
            this._creators = creators;
        }
        return creators;
    }

    @Override
    public final String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }

    @Override
    public final int hashCode() {
        return this._class.hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        return ((AnnotatedClass)object)._class == this._class;
    }

    public static final class Creators {
        public final AnnotatedConstructor defaultConstructor;
        public final List<AnnotatedConstructor> constructors;
        public final List<AnnotatedMethod> creatorMethods;

        public Creators(AnnotatedConstructor annotatedConstructor, List<AnnotatedConstructor> list, List<AnnotatedMethod> list2) {
            this.defaultConstructor = annotatedConstructor;
            this.constructors = list;
            this.creatorMethods = list2;
        }
    }
}

