/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Objects;

public final class AnnotatedConstructor
extends AnnotatedWithParams {
    protected final Constructor<?> _constructor;
    protected a _serialization;

    public AnnotatedConstructor(TypeResolutionContext typeResolutionContext, Constructor<?> constructor, AnnotationMap annotationMap, AnnotationMap[] annotationMapArray) {
        super(typeResolutionContext, annotationMap, annotationMapArray);
        this._constructor = Objects.requireNonNull(constructor);
    }

    protected AnnotatedConstructor(a a2) {
        super(null, null, null);
        this._constructor = null;
        this._serialization = a2;
    }

    @Override
    public final AnnotatedConstructor withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedConstructor(this._typeContext, this._constructor, annotationMap, this._paramAnnotations);
    }

    @Override
    public final Constructor<?> getAnnotated() {
        return this._constructor;
    }

    @Override
    public final int getModifiers() {
        return this._constructor.getModifiers();
    }

    @Override
    public final String getName() {
        return this._constructor.getName();
    }

    @Override
    public final JavaType getType() {
        return this._typeContext.resolveType(((Annotated)this).getRawType());
    }

    @Override
    public final Class<?> getRawType() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public final int getParameterCount() {
        return this._constructor.getParameterCount();
    }

    @Override
    public final Class<?> getRawParameterType(int n2) {
        Class<?>[] classArray = this._constructor.getParameterTypes();
        if (n2 >= classArray.length) {
            return null;
        }
        return classArray[n2];
    }

    @Override
    public final JavaType getParameterType(int n2) {
        Type[] typeArray = this._constructor.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return this._typeContext.resolveType(typeArray[n2]);
    }

    @Override
    @Deprecated
    public final Type getGenericParameterType(int n2) {
        Type[] typeArray = this._constructor.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return typeArray[n2];
    }

    @Override
    public final Object call() {
        return this._constructor.newInstance(null);
    }

    @Override
    public final Object call(Object[] objectArray) {
        return this._constructor.newInstance(objectArray);
    }

    @Override
    public final Object call1(Object object) {
        return this._constructor.newInstance(object);
    }

    @Override
    public final Class<?> getDeclaringClass() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public final Member getMember() {
        return this._constructor;
    }

    @Override
    public final void setValue(Object object, Object object2) {
        throw new UnsupportedOperationException("Cannot call setValue() on constructor of " + ((AnnotatedMember)this).getDeclaringClass().getName());
    }

    @Override
    public final Object getValue(Object object) {
        throw new UnsupportedOperationException("Cannot call getValue() on constructor of " + ((AnnotatedMember)this).getDeclaringClass().getName());
    }

    @Override
    public final String toString() {
        int n2 = this._constructor.getParameterCount();
        return String.format("[constructor for %s (%d arg%s), annotations: %s", ClassUtil.nameOf(this._constructor.getDeclaringClass()), n2, n2 == 1 ? "" : "s", this._annotations);
    }

    @Override
    public final int hashCode() {
        return Objects.hashCode(this._constructor);
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        object = (AnnotatedConstructor)object;
        return Objects.equals(this._constructor, ((AnnotatedConstructor)object)._constructor);
    }

    private static final class a
    implements Serializable {
    }
}

