/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Objects;

public final class AnnotatedField
extends AnnotatedMember
implements Serializable {
    protected final transient Field _field;
    protected a _serialization;

    public AnnotatedField(TypeResolutionContext typeResolutionContext, Field field, AnnotationMap annotationMap) {
        super(typeResolutionContext, annotationMap);
        this._field = Objects.requireNonNull(field);
    }

    @Override
    public final AnnotatedField withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedField(this._typeContext, this._field, annotationMap);
    }

    protected AnnotatedField(a a2) {
        super(null, null);
        this._field = null;
        this._serialization = a2;
    }

    @Override
    public final Field getAnnotated() {
        return this._field;
    }

    @Override
    public final int getModifiers() {
        return this._field.getModifiers();
    }

    @Override
    public final String getName() {
        return this._field.getName();
    }

    @Override
    public final Class<?> getRawType() {
        return this._field.getType();
    }

    @Override
    public final JavaType getType() {
        return this._typeContext.resolveType(this._field.getGenericType());
    }

    @Override
    public final Class<?> getDeclaringClass() {
        return this._field.getDeclaringClass();
    }

    @Override
    public final Member getMember() {
        return this._field;
    }

    @Override
    public final void setValue(Object object, Object object2) {
        try {
            this._field.set(object, object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to setValue() for field " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    @Override
    public final Object getValue(Object object) {
        try {
            return this._field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to getValue() for field " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    public final int getAnnotationCount() {
        return this._annotations.size();
    }

    public final boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    @Override
    public final int hashCode() {
        return Objects.hashCode(this._field);
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        object = (AnnotatedField)object;
        return Objects.equals(this._field, ((AnnotatedField)object)._field);
    }

    @Override
    public final String toString() {
        return "[field " + this.getFullName() + "]";
    }

    private static final class a
    implements Serializable {
    }
}

