/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collections;

public abstract class AnnotatedMember
extends Annotated
implements Serializable {
    protected final transient TypeResolutionContext _typeContext;
    protected final transient AnnotationMap _annotations;

    protected AnnotatedMember(TypeResolutionContext typeResolutionContext, AnnotationMap annotationMap) {
        this._typeContext = typeResolutionContext;
        this._annotations = annotationMap;
    }

    protected AnnotatedMember(AnnotatedMember annotatedMember) {
        this._typeContext = annotatedMember._typeContext;
        this._annotations = annotatedMember._annotations;
    }

    public abstract Annotated withAnnotations(AnnotationMap var1);

    public abstract Class<?> getDeclaringClass();

    public abstract Member getMember();

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName();
    }

    @Deprecated
    public TypeResolutionContext getTypeContext() {
        return this._typeContext;
    }

    @Override
    public final <A extends Annotation> A getAnnotation(Class<A> clazz) {
        if (this._annotations == null) {
            return null;
        }
        return this._annotations.get(clazz);
    }

    @Override
    public final boolean hasAnnotation(Class<?> clazz) {
        if (this._annotations == null) {
            return false;
        }
        return this._annotations.has(clazz);
    }

    @Override
    public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
        if (this._annotations == null) {
            return false;
        }
        return this._annotations.hasOneOf(classArray);
    }

    @Override
    @Deprecated
    public Iterable<Annotation> annotations() {
        if (this._annotations == null) {
            return Collections.emptyList();
        }
        return this._annotations.annotations();
    }

    public AnnotationMap getAllAnnotations() {
        return this._annotations;
    }

    public final void fixAccess(boolean bl2) {
        Member member = this.getMember();
        if (member != null) {
            ClassUtil.checkAndFixAccess(member, bl2);
        }
    }

    public abstract void setValue(Object var1, Object var2);

    public abstract Object getValue(Object var1);
}

