/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.util.Annotations;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public abstract class AnnotationCollector {
    protected static final Annotations NO_ANNOTATIONS = new NoAnnotations();
    protected final Object _data;

    protected AnnotationCollector(Object object) {
        this._data = object;
    }

    public static Annotations emptyAnnotations() {
        return NO_ANNOTATIONS;
    }

    public static AnnotationCollector emptyCollector() {
        return a.a;
    }

    public static AnnotationCollector emptyCollector(Object object) {
        return new a(object);
    }

    public abstract Annotations asAnnotations();

    public abstract AnnotationMap asAnnotationMap();

    public Object getData() {
        return this._data;
    }

    public abstract boolean isPresent(Annotation var1);

    public abstract AnnotationCollector addOrOverride(Annotation var1);

    public static class TwoAnnotations
    implements Annotations,
    Serializable {
        private final Class<?> a;
        private final Class<?> b;
        private final Annotation c;
        private final Annotation d;

        public TwoAnnotations(Class<?> clazz, Annotation annotation, Class<?> clazz2, Annotation annotation2) {
            this.a = clazz;
            this.c = annotation;
            this.b = clazz2;
            this.d = annotation2;
        }

        @Override
        public <A extends Annotation> A get(Class<A> clazz) {
            if (this.a == clazz) {
                return (A)this.c;
            }
            if (this.b == clazz) {
                return (A)this.d;
            }
            return null;
        }

        @Override
        public boolean has(Class<?> clazz) {
            return this.a == clazz || this.b == clazz;
        }

        @Override
        public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
            for (Class<? extends Annotation> clazz : classArray) {
                if (clazz != this.a && clazz != this.b) continue;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 2;
        }
    }

    public static class OneAnnotation
    implements Annotations,
    Serializable {
        private final Class<?> a;
        private final Annotation b;

        public OneAnnotation(Class<?> clazz, Annotation annotation) {
            this.a = clazz;
            this.b = annotation;
        }

        @Override
        public <A extends Annotation> A get(Class<A> clazz) {
            if (this.a == clazz) {
                return (A)this.b;
            }
            return null;
        }

        @Override
        public boolean has(Class<?> clazz) {
            return this.a == clazz;
        }

        @Override
        public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
            for (Class<? extends Annotation> clazz : classArray) {
                if (clazz != this.a) continue;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static class NoAnnotations
    implements Annotations,
    Serializable {
        NoAnnotations() {
        }

        @Override
        public <A extends Annotation> A get(Class<A> clazz) {
            return null;
        }

        @Override
        public boolean has(Class<?> clazz) {
            return false;
        }

        @Override
        public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class b
    extends AnnotationCollector {
        private HashMap<Class<?>, Annotation> a = new HashMap();

        public b(Object object, Class<?> clazz, Annotation annotation, Class<?> clazz2, Annotation annotation2) {
            super(object);
            this.a.put(clazz, annotation);
            this.a.put(clazz2, annotation2);
        }

        @Override
        public final Annotations asAnnotations() {
            if (this.a.size() == 2) {
                Object object = this.a.entrySet().iterator();
                Map.Entry<Class<?>, Annotation> entry = object.next();
                object = object.next();
                return new TwoAnnotations(entry.getKey(), entry.getValue(), (Class)object.getKey(), (Annotation)object.getValue());
            }
            return new AnnotationMap(this.a);
        }

        @Override
        public final AnnotationMap asAnnotationMap() {
            AnnotationMap annotationMap = new AnnotationMap();
            for (Annotation annotation : this.a.values()) {
                annotationMap.add(annotation);
            }
            return annotationMap;
        }

        @Override
        public final boolean isPresent(Annotation annotation) {
            return this.a.containsKey(annotation.annotationType());
        }

        @Override
        public final AnnotationCollector addOrOverride(Annotation annotation) {
            this.a.put(annotation.annotationType(), annotation);
            return this;
        }
    }

    static final class c
    extends AnnotationCollector {
        private Class<?> a;
        private Annotation b;

        public c(Object object, Class<?> clazz, Annotation annotation) {
            super(object);
            this.a = clazz;
            this.b = annotation;
        }

        @Override
        public final Annotations asAnnotations() {
            return new OneAnnotation(this.a, this.b);
        }

        @Override
        public final AnnotationMap asAnnotationMap() {
            return AnnotationMap.of(this.a, this.b);
        }

        @Override
        public final boolean isPresent(Annotation annotation) {
            return annotation.annotationType() == this.a;
        }

        @Override
        public final AnnotationCollector addOrOverride(Annotation annotation) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            if (this.a == clazz) {
                this.b = annotation;
                return this;
            }
            return new b(this._data, this.a, this.b, clazz, annotation);
        }
    }

    static final class a
    extends AnnotationCollector {
        public static final a a = new a(null);

        a(Object object) {
            super(object);
        }

        @Override
        public final Annotations asAnnotations() {
            return NO_ANNOTATIONS;
        }

        @Override
        public final AnnotationMap asAnnotationMap() {
            return new AnnotationMap();
        }

        @Override
        public final boolean isPresent(Annotation annotation) {
            return false;
        }

        @Override
        public final AnnotationCollector addOrOverride(Annotation annotation) {
            return new c(this._data, annotation.annotationType(), annotation);
        }
    }
}

